/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.process;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.workflow.activity.transfer.replacement.domain.Replacement;
import com.suncode.pwfl.workflow.activity.transfer.replacement.domain.ReplacementType;
import com.suncode.pwfl.workflow.activity.transfer.replacement.domain.UserInfoType;
import com.suncode.pwfl.workflow.activity.transfer.replacement.dto.NewReplacementDto;
import com.suncode.pwfl.workflow.activity.transfer.replacement.dto.ReadReplacementDto;
import com.suncode.pwfl.workflow.activity.transfer.replacement.dto.ReplacementTypeDto;
import com.suncode.pwfl.workflow.activity.transfer.replacement.dto.UserInfoTypeDto;
import com.suncode.pwfl.workflow.activity.transfer.replacement.exception.ReplacementNotFoundException;
import com.suncode.pwfl.workflow.activity.transfer.replacement.process.dto.VariableDto;
import com.suncode.pwfl.workflow.activity.transfer.replacement.service.ReplacementService;
import com.suncode.pwfl.workflow.process.ProcessDataService;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.exception.ProcessDefinitionNotFoundException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/processes/definition/{processDefId}"})
public class ReplacementController {
    private static final Logger log = LoggerFactory.getLogger(ReplacementController.class);
    private final ReplacementService replacementService;
    private final ProcessDataService processDataService;
    private final ProcessService processService;
    private final ExportService exportService;
    private final MessageHelperBean messageHelper;
    private final AuthorizationHelper authorizationHelper;

    @RequestMapping(value={"/replacement/variables"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ReadReplacementDto> getReplacementVariables(@PathVariable String processDefId, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false, defaultValue="variableName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List replacementVariables = this.replacementService.getReplacementVariables(processDefId, start, limit, sortBy, sortDirection);
        long count = this.replacementService.getReplacementVariablesCount(processDefId);
        return new CountedResult(count, replacementVariables);
    }

    @RequestMapping(value={"/replacement/variables"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public RestResult createReplacementVariable(HttpServletRequest request, @PathVariable String processDefId, @RequestBody NewReplacementDto replacementDto) {
        replacementDto.setProcessDefId(processDefId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_REPLACEMENT_VARIABLE).params(this.createAddReplacementVarAuditParams(replacementDto));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.replacementService.saveReplacement(replacementDto);
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @RequestMapping(value={"/replacement/variables"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteReplacementVariable(HttpServletRequest request, @PathVariable String processDefId, @RequestParam long id) {
        Map<String, Object> auditParams = this.initDeleteReplacementVarAuditParams(processDefId, id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_REPLACEMENT_VARIABLE).params(auditParams);
        Replacement replacement = (Replacement)this.replacementService.get((Serializable)Long.valueOf(id));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (replacement == null) {
            auditBuilder.buildFailure(request);
            throw new ReplacementNotFoundException(this.messageHelper.getMessage("changeuser.replacement.deleting.error.notfound"));
        }
        auditBuilder.params(this.updateDeleteReplacementVarAuditParams(auditParams, replacement));
        if (!replacement.getProcessDefId().equals(processDefId)) {
            auditBuilder.buildFailure(request);
            throw new IllegalArgumentException(this.messageHelper.getMessage("Nieprawidlowa_definicja_procesu"));
        }
        try {
            this.replacementService.delete((Object)replacement);
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @RequestMapping(value={"/replacement/type"}, method={RequestMethod.GET})
    @ResponseBody
    public ReplacementTypeDto getProcessReplacementType(@PathVariable String processDefId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        if (this.processService.getProcessDefinition(processDefId) == null) {
            throw new ProcessDefinitionNotFoundException(this.messageHelper.getMessage("changeuser.replacement.error.procDefNotFound"));
        }
        ReplacementTypeDto replacementTypeDto = this.replacementService.getReplacementType(processDefId);
        return this.translateReplacementType(replacementTypeDto);
    }

    @RequestMapping(value={"/replacement/type/change"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResult changeProcessReplacementVarType(HttpServletRequest request, @PathVariable String processDefId, @RequestParam ReplacementType type) {
        Map<String, Object> auditParams = this.initChangeReplacementVarTypeAuditParams(processDefId, type);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CHANGE_REPLACEMENT_VAR_TYPE).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (this.processService.getProcessDefinition(processDefId) == null) {
            auditBuilder.buildFailure(request);
            throw new ProcessDefinitionNotFoundException(this.messageHelper.getMessage("changeuser.replacement.error.procDefNotFound"));
        }
        ReplacementTypeDto oldReplacementTypeDto = this.replacementService.getReplacementType(processDefId);
        auditBuilder.params(this.updateChangeReplacementVarTypeAuditParams(auditParams, oldReplacementTypeDto.getValue()));
        try {
            this.replacementService.deleteReplacementVariables(processDefId);
            this.processDataService.saveProcessData(processDefId, "", "processReplacementVarType", type.name().toLowerCase());
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @RequestMapping(value={"/replacement/variables/export/{extension}"}, method={RequestMethod.GET})
    public void export(HttpServletResponse response, @PathVariable String processDefId, @PathVariable String extension, @RequestParam(required=false, defaultValue="variableName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List replacementVariables = this.replacementService.getReplacementVariables(processDefId, sortBy, sortDirection);
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Zmienna")).data(replacementVariables).by(ReadReplacementDto::getVariableName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Typ_informacji")).data(replacementVariables).by(ReadReplacementDto::getType).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Przypisanie_zmiennych_do_informacji_o_uzytkowniku")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/variables"}, method={RequestMethod.GET})
    @ResponseBody
    public List<VariableDto> getVariablesForProcess(@PathVariable String processDefId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.replacementService.getVariables(processDefId);
    }

    @RequestMapping(value={"/replacement/variables/types"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UserInfoTypeDto> getUserInfoTypes() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return Arrays.stream(UserInfoType.values()).map(UserInfoTypeDto::from).map(this::translateUserInfoType).collect(Collectors.toList());
    }

    @RequestMapping(value={"/replacement/types"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ReplacementTypeDto> getReplacementTypes() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return Arrays.stream(ReplacementType.values()).map(ReplacementTypeDto::from).map(this::translateReplacementType).collect(Collectors.toList());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleIllegalArgumentException(IllegalArgumentException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={ReplacementNotFoundException.class, ProcessDefinitionNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFoundException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    private UserInfoTypeDto translateUserInfoType(UserInfoTypeDto userInfoTypeDto) {
        userInfoTypeDto.setText(this.messageHelper.getMessage("changeuser.replacement.type." + userInfoTypeDto.getValue().toLowerCase()));
        return userInfoTypeDto;
    }

    private ReplacementTypeDto translateReplacementType(ReplacementTypeDto replacementTypeDto) {
        replacementTypeDto.setText(this.messageHelper.getMessage("changeuser.replacement.type." + replacementTypeDto.getValue().toLowerCase()));
        return replacementTypeDto;
    }

    private Map<String, Object> createAddReplacementVarAuditParams(NewReplacementDto replacementDto) {
        return ImmutableMap.builder().put((Object)"processDefId", (Object)StringUtils.defaultString((String)replacementDto.getProcessDefId())).put((Object)"variableName", (Object)StringUtils.defaultString((String)replacementDto.getVariableId())).put((Object)"userInfoType", (Object)StringUtils.defaultString((String)replacementDto.getType())).build();
    }

    private Map<String, Object> initDeleteReplacementVarAuditParams(String processDefId, long replacementVarId) {
        return ImmutableMap.builder().put((Object)"processDefId", (Object)StringUtils.defaultString((String)processDefId)).put((Object)"replacementVarId", (Object)StringUtils.defaultString((String)String.valueOf(replacementVarId))).build();
    }

    private Map<String, Object> updateDeleteReplacementVarAuditParams(Map<String, Object> auditParams, Replacement replacement) {
        return ImmutableMap.builder().putAll(auditParams).put((Object)"variableName", (Object)StringUtils.defaultString((String)replacement.getVariableId())).put((Object)"userInfoType", (Object)StringUtils.defaultString((String)replacement.getType().toString())).build();
    }

    private Map<String, Object> initChangeReplacementVarTypeAuditParams(String processDefId, ReplacementType replacementType) {
        return ImmutableMap.builder().put((Object)"processDefId", (Object)StringUtils.defaultString((String)processDefId)).put((Object)"replacementType", (Object)StringUtils.defaultString((String)String.valueOf(replacementType.getValue()))).build();
    }

    private Map<String, Object> updateChangeReplacementVarTypeAuditParams(Map<String, Object> auditParams, String oldReplacementType) {
        return ImmutableMap.builder().putAll(auditParams).put((Object)"oldReplacementType", (Object)oldReplacementType).build();
    }

    @ConstructorProperties(value={"replacementService", "processDataService", "processService", "exportService", "messageHelper", "authorizationHelper"})
    @Autowired
    public ReplacementController(ReplacementService replacementService, ProcessDataService processDataService, ProcessService processService, ExportService exportService, MessageHelperBean messageHelper, AuthorizationHelper authorizationHelper) {
        this.replacementService = replacementService;
        this.processDataService = processDataService;
        this.processService = processService;
        this.exportService = exportService;
        this.messageHelper = messageHelper;
        this.authorizationHelper = authorizationHelper;
    }
}

