/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.IndexPattern;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.DocumentClassIndexDto;
import com.suncode.pwfl.web.dto.archive.search.IndexModelDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.DocumentClassIndexMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"documents"})
@Api(tags={"document classes"})
public class DocumentClassIndexController {
    private static final Logger log = LoggerFactory.getLogger(DocumentClassIndexController.class);
    @Autowired
    private DocumentClassIndexFinder documentClassIndexFinder;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentClassIndexMapper documentClassIndexMapper;
    @Autowired
    private ExportService exportService;
    @Autowired
    private MessageHelperBean messageHelper;
    @Autowired
    private AuthorizationHelper authorizationHelper;

    @ResponseBody
    @GetMapping(value={"indexes/{documentClassId}", "classes/{documentClassId}/indexes"})
    @ApiOperation(value="(Admin) Downloading document class indices", notes="Retrieves a list of document class indices")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    public List<DocumentClassIndex> getDocumentClassesIndexes(@ApiParam(value="Id of document class (parameter passed in servlet path)", required=true) @PathVariable Long documentClassId) {
        return this.getDocumentClassIndices(documentClassId);
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"search/classes/{documentClassId}/indexes"})
    public List<IndexModelDto> getDocumentClassesSearchIndexes(@PathVariable Long documentClassId) {
        List<DocumentClassIndex> documentClassIndices = this.getDocumentClassIndices(documentClassId);
        return documentClassIndices.stream().map(IndexModelDto::fromDocumentClassIndexEntity).toList();
    }

    @NotNull
    private List<DocumentClassIndex> getDocumentClassIndices(Long documentClassId) {
        this.authorizationHelper.assertFullOrPartRights(RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClassId).build(), () -> {});
        List docClassIndexes = this.documentClassIndexFinder.findByDocumentClass(documentClassId);
        return docClassIndexes.stream().map(dci -> {
            TranslatedDocumentClassIndex tdci = new TranslatedDocumentClassIndex();
            BeanUtils.copyProperties((Object)dci, (Object)((Object)tdci));
            String tName = this.documentClassService.getDocumentClassIndexTranslation(dci.getId(), TranslatedFieldType.NAME);
            tdci.setNameTranslated(tName);
            tdci.setTranslatedName(tName);
            String tDesc = this.documentClassService.getDocumentClassIndexTranslation(dci.getId(), TranslatedFieldType.DESCRIPTION);
            tdci.setDescriptionTranslated(tDesc);
            tdci.setTranslatedDescription(tDesc);
            return tdci;
        }).collect(Collectors.toList());
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"classes/{documentClassId}/indices"})
    @ResponseBody
    public CountedResult<DocumentClassIndexDto> getDocumentClassIndices(@PathVariable Long documentClassId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="orderId") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullOrPartRights(RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClassId).build(), () -> {});
        CountedResult docClassIndexes = this.documentClassIndexFinder.findByDocumentClass(documentClassId, start, limit, sortBy, sortDirection);
        List result = docClassIndexes.getData().stream().map(this.documentClassIndexMapper::toDocumentClassIndexDto).collect(Collectors.toList());
        return new CountedResult(docClassIndexes.getTotal(), result);
    }

    @ApiOperation(value="(Partial rights to document class) Downloading document class index", notes="Retrieves document class index with specified id")
    @GetMapping(value={"classes/{documentClassId}/indices/{documentClassIndexId}"})
    @ResponseBody
    public DocumentClassIndexDto getDocumentClassIndex(@ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId, @ApiParam(value="Document class index id", required=true) @PathVariable Long documentClassIndexId) {
        this.authorizationHelper.assertFullOrPartRights(RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClassId).build(), () -> {});
        DocumentClassIndex documentClassIndex = (DocumentClassIndex)this.documentClassIndexFinder.get((Serializable)documentClassIndexId);
        if (documentClassIndex == null) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Nie_znaleziono_indeksu_klasy_dokumentow", new Object[]{documentClassIndexId}));
        }
        return this.documentClassIndexMapper.toDocumentClassIndexDto(documentClassIndex);
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"classes/{documentClassId}/indices/{documentClassIndexId}/canBeEdited"})
    @ResponseBody
    public RestResult canDocumentClassIndexBeEdited(@PathVariable Long documentClassId, @PathVariable Long documentClassIndexId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        DocumentClassIndex documentClassIndex = (DocumentClassIndex)this.documentClassIndexFinder.get((Serializable)documentClassIndexId);
        if (documentClassIndex == null) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Nie_znaleziono_indeksu_klasy_dokumentow", new Object[]{documentClassIndexId}));
        }
        try {
            this.documentClassService.validateDocumentClassIndexCanBeEdited(documentClassIndex);
        }
        catch (ServiceException e) {
            return new RestResult(false, e.getMessage());
        }
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Downloading document class indices types", notes="Retrieves a list of available document class indices types")
    @GetMapping(value={"classes/{documentClassId}/indices/types"})
    @ResponseBody
    public List<String> getIndexTypes(@ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId) {
        return Arrays.asList(IndexType.values()).stream().map(IndexType::toString).collect(Collectors.toList());
    }

    @ApiOperation(value="(Admin) Adding document class index", notes="The query contains a JSON object containing index parameters. The definition should include the following field \n- **name** - name of the index\n- **descripton** - description of the index\n- **type** - type of the index\n- **indexPatterns** - list of objects described below (for type 'String')\n  - pattern - pattern of replacement\n  - replace - value of replacement\n  - isRegex - is pattern regular expression")
    @ResponseBody
    @PostMapping(value={"classes/{documentClassId}/indexes/add", "classes/{documentClassId}/indices/add"})
    public ResponseEntity<RestResult> addDocumentClassIndex(HttpServletRequest request, @ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId, @ApiParam(value="The query contains a JSON object containing logging parameters", required=true) @RequestBody DocumentClassIndexDto docClassIndexDto) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("docclassId", StringUtils.defaultIfEmpty((CharSequence)documentClassId.toString(), (CharSequence)""));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_DOC_CLASS_INDEX).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            DocumentClassIndex documentClassIndex = this.documentClassIndexMapper.toEntity(docClassIndexDto);
            auditParams.putAll(this.createAddIndexAuditParams(documentClassIndex));
            auditBuilder.params(auditParams);
            this.documentClassService.addIndexToDocumentClass(documentClassId, documentClassIndex);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((Object)new RestResult(true), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw ex;
        }
    }

    @ApiOperation(value="(Admin) Updating document class index", notes="Updates document class indiex with given id")
    @ResponseBody
    @PostMapping(value={"classes/{documentClassId}/indexes/update", "classes/{documentClassId}/indices/update"})
    public ResponseEntity<?> updateDocumentClassIndex(HttpServletRequest request, @ApiParam(value="The query contains a JSON object containing index parameters. The definition should include the following field \n- **name** - name of the index\n- **descripton** - description of the index\n- **type** - type of the index\n- **indexPatterns** - list of objects described below (for type 'String')\n  - pattern - pattern of replacement\n  - replace - value of replacement\n  - isRegex - is pattern regular expression", required=true) @RequestBody DocumentClassIndexDto docClassIndexDto, @ApiParam(value="Document class id", required=true) @PathVariable(value="documentClassId") Long documentClassId) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("docclassId", StringUtils.defaultIfEmpty((CharSequence)documentClassId.toString(), (CharSequence)""));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_DOC_CLASS_INDEX).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (this.documentClassIndexFinder.get((Serializable)docClassIndexDto.getId()) == null) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Indeks_klasy_dokumentu_nie_istnieje", new Object[]{docClassIndexDto.getId()}));
        }
        try {
            DocumentClassIndex documentClassIndex = this.documentClassIndexMapper.toEntity(docClassIndexDto);
            auditParams.putAll(this.createUpdateIndexAuditParams(documentClassIndex));
            auditBuilder.params(auditParams);
            DocumentClassIndex updatedIndex = this.documentClassService.updateIndexInDocumentClass(documentClassId, documentClassIndex);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((Object)this.documentClassIndexMapper.toDocumentClassIndexDto(updatedIndex), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw ex;
        }
    }

    @ApiOperation(value="(Admin) Deleting document class index", notes="Deletes document class index")
    @DeleteMapping(value={"classes/{documentClassId}/indexes/{documentClassIndexId}", "classes/{documentClassId}/indices/{documentClassIndexId}"})
    @ResponseBody
    public RestResult deleteDocumentClassIndex(HttpServletRequest request, @ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId, @ApiParam(value="Document class index id", required=true) @PathVariable Long documentClassIndexId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DOC_CLASS_INDEX).params((Map)ImmutableMap.of((Object)"docclassId", (Object)documentClassId, (Object)"indexId", (Object)documentClassIndexId));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        this.documentClassService.deleteDocumentClassIndex(documentClassIndexId);
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Moving up document class index", notes="Moves up document class index")
    @GetMapping(value={"classes/{documentClassId}/indexes/{documentClassIndexId}/moveUp", "classes/{documentClassId}/indices/{documentClassIndexId}/moveUp"})
    @ResponseBody
    public void moveUpDocumentClassIndex(@ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId, @ApiParam(value="Document class index id", required=true) @PathVariable Long documentClassIndexId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.documentClassService.moveUpDocumentClassIndex(documentClassIndexId);
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"classes/{documentClassId}/indices/export/{extension}"})
    @ResponseBody
    public void exportDocumentClassIndices(HttpServletResponse response, @PathVariable Long documentClassId, @PathVariable String extension, @RequestParam(required=false, defaultValue="orderId") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List docClassIndexes = this.documentClassIndexFinder.findByDocumentClass(documentClassId, null, null, sortBy, sortDirection).getData().stream().map(this.documentClassIndexMapper::toDocumentClassIndexDto).map(docClassIndex -> {
            docClassIndex.setType(this.messageHelper.getMessage("IndexType_" + docClassIndex.getType()));
            return docClassIndex;
        }).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_indeksu")).data(docClassIndexes).by(DocumentClassIndexDto::getTranslatedName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis_indeksu")).data(docClassIndexes).by(DocumentClassIndexDto::getTranslatedDescription).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Typ_indeksu")).data(docClassIndexes).by(DocumentClassIndexDto::getType).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Indeksy")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private Map<String, Object> createAddIndexAuditParams(DocumentClassIndex index) {
        return ImmutableMap.builder().put((Object)"indexName", (Object)StringUtils.defaultIfEmpty((CharSequence)index.getName(), (CharSequence)"")).put((Object)"indexDescription", (Object)StringUtils.defaultIfEmpty((CharSequence)index.getDescription(), (CharSequence)"")).put((Object)"indexType", (Object)StringUtils.defaultIfEmpty((CharSequence)index.getType().toString(), (CharSequence)"")).put((Object)"indexValue", (Object)StringUtils.defaultIfEmpty((CharSequence)index.getValues(), (CharSequence)"")).put((Object)"indexPattern", (Object)this.buildIndexPatternAuditParam(index.getPatterns())).build();
    }

    private String buildIndexPatternAuditParam(List<IndexPattern> patterns) {
        return patterns.stream().map(pattern -> pattern.getPattern() + "->" + pattern.getReplacement() + "(regex=" + pattern.getIsRegex() + ")").collect(Collectors.joining("; "));
    }

    private Map<String, Object> createUpdateIndexAuditParams(DocumentClassIndex index) {
        DocumentClassIndex oldIndex = this.documentClassIndexFinder.findById(index.getId());
        return ImmutableMap.builder().put((Object)"indexName", (Object)this.buildIndexAuditParam(oldIndex.getName(), index.getName())).put((Object)"indexDescription", (Object)this.buildIndexAuditParam(oldIndex.getDescription(), index.getDescription())).put((Object)"indexType", (Object)(String.valueOf(oldIndex.getType()) + ";" + String.valueOf(index.getType()))).put((Object)"indexValue", (Object)this.buildIndexAuditParamChange(oldIndex.getValues(), index.getValues())).put((Object)"indexPattern", (Object)this.buildIndexAuditParamChange(this.buildIndexPatternAuditParam(oldIndex.getPatterns()), this.buildIndexPatternAuditParam(index.getPatterns()))).build();
    }

    private String buildIndexAuditParam(String oldValue, String newValue) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)oldValue, (CharSequence)"") + ";" + (String)StringUtils.defaultIfEmpty((CharSequence)newValue, (CharSequence)"");
    }

    private String buildIndexAuditParamChange(String oldValue, String newValue) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)oldValue, (CharSequence)"") + " > " + (String)StringUtils.defaultIfEmpty((CharSequence)newValue, (CharSequence)"");
    }

    @ExceptionHandler(value={IllegalArgumentException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequests(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class, NoRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(Exception e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    private class TranslatedDocumentClassIndex
    extends DocumentClassIndex {
        private String nameTranslated;
        private String descriptionTranslated;

        private TranslatedDocumentClassIndex() {
        }

        public String getNameTranslated() {
            return this.nameTranslated;
        }

        public String getDescriptionTranslated() {
            return this.descriptionTranslated;
        }

        public void setNameTranslated(String nameTranslated) {
            this.nameTranslated = nameTranslated;
        }

        public void setDescriptionTranslated(String descriptionTranslated) {
            this.descriptionTranslated = descriptionTranslated;
        }
    }
}

