/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.activity;

import com.plusmpm.database.workflow.activities.ActivityStatusManagerExtended;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.ShaKey;
import com.suncode.pwfl.workflow.activity.ActivityStatusType;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"activities/finished"})
public class FinishedActivityController {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private ShaKey shaEncoder;
    @Autowired
    private ExportService exportService;

    @ResponseBody
    @RequestMapping(value={"all"})
    public CountedResult<FinishedActivityDto> getAllFinishedActivities(@RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        return this.getFinishedActivities(null, start, limit, sortBy, sortDirection);
    }

    @ResponseBody
    @RequestMapping(value={"all/export/{extension}"})
    public void exportAllFinishedActivities(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        CountedResult<FinishedActivityDto> finishedActivities = this.getFinishedActivities(null, 0, Integer.MAX_VALUE, sortBy, sortDirection);
        this.exportActivities(finishedActivities.getData(), extension, response);
    }

    @ResponseBody
    @RequestMapping(value={"failed"})
    public CountedResult<FinishedActivityDto> getFailedFinishedActivities(@RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        return this.getFinishedActivities(ActivityStatusType.FAILED, start, limit, sortBy, sortDirection);
    }

    @ResponseBody
    @RequestMapping(value={"failed/export/{extension}"})
    public void exportFailedFinishedActivities(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        CountedResult<FinishedActivityDto> finishedActivities = this.getFinishedActivities(ActivityStatusType.FAILED, 0, Integer.MAX_VALUE, sortBy, sortDirection);
        this.exportActivities(finishedActivities.getData(), extension, response);
    }

    @ResponseBody
    @RequestMapping(value={"successful"})
    public CountedResult<FinishedActivityDto> getSuccessfulFinishedActivities(@RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        return this.getFinishedActivities(ActivityStatusType.SUCCESSFUL, start, limit, sortBy, sortDirection);
    }

    @ResponseBody
    @RequestMapping(value={"successful/export/{extension}"})
    public void exportSuccessfulFinishedActivities(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        CountedResult<FinishedActivityDto> finishedActivities = this.getFinishedActivities(ActivityStatusType.SUCCESSFUL, 0, Integer.MAX_VALUE, sortBy, sortDirection);
        this.exportActivities(finishedActivities.getData(), extension, response);
    }

    @ResponseBody
    @RequestMapping(value={"processing"})
    public CountedResult<FinishedActivityDto> getProcessingFinishedActivities(@RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        return this.getFinishedActivities(ActivityStatusType.PROCESSING, start, limit, sortBy, sortDirection);
    }

    @ResponseBody
    @RequestMapping(value={"processing/export/{extension}"})
    public void exportProcessingFinishedActivities(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        CountedResult<FinishedActivityDto> finishedActivities = this.getFinishedActivities(ActivityStatusType.PROCESSING, 0, Integer.MAX_VALUE, sortBy, sortDirection);
        this.exportActivities(finishedActivities.getData(), extension, response);
    }

    private CountedResult<FinishedActivityDto> getFinishedActivities(ActivityStatusType statusType, Integer start, Integer limit, String sortBy, SortDirection sortDirection) {
        Long count;
        List activities;
        String userName = UserContext.current().getUser().getUserName();
        if (statusType == null) {
            activities = ActivityStatusManagerExtended.getAllActivitiesCurrentStatusWithNames((String)userName, (int)start, (int)limit, (String)sortBy, (sortDirection == SortDirection.ASC ? 1 : 0) != 0);
            count = ActivityStatusManagerExtended.countAllActivitiesCurrentStatus((String)userName);
        } else {
            ActivityStatusType[] activityStatusTypes = new ActivityStatusType[]{statusType};
            activities = ActivityStatusManagerExtended.getActivitiesCurrentStatusWithNames((String)userName, (ActivityStatusType[])activityStatusTypes, (int)start, (int)limit, (String)sortBy, (sortDirection == SortDirection.ASC ? 1 : 0) != 0);
            count = ActivityStatusManagerExtended.countActivitiesCurrentStatus((String)userName, (ActivityStatusType[])activityStatusTypes);
        }
        List activitiesDto = activities.stream().map(activity -> FinishedActivityDto.builder().activityId(activity.getActivityId()).processId(activity.getProcessId()).activityName(activity.getActivityName()).processName(activity.getProcessName()).createdTime(activity.getCreateDate()).status(activity.getTypeAsEnum()).key(this.shaEncoder.get(activity.getProcessId())).build()).collect(Collectors.toList());
        return new CountedResult(count.longValue(), activitiesDto);
    }

    private void exportActivities(List<FinishedActivityDto> activities, String extension, HttpServletResponse response) throws IOException {
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Nazwa_procesu")).data(activities).by(FinishedActivityDto::getProcessName).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Nazwa_zadania")).data(activities).by(FinishedActivityDto::getActivityName).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Status_zadania")).data(activities).by(finishedActivityDto -> finishedActivityDto.getStatus().toString()).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Data")).data(activities).by(finishedActivityDto -> dateFormat.format(finishedActivityDto.getCreatedTime())).build());
        ExportModel model = ExportModel.builder().title(MessageHelper.getMessage((String)"Zadania_wykonane")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private static class FinishedActivityDto {
        private String processId;
        private String activityId;
        private String processName;
        private String activityName;
        private Date createdTime;
        private ActivityStatusType status;
        private String key;

        public static FinishedActivityDtoBuilder builder() {
            return new FinishedActivityDtoBuilder();
        }

        public String getProcessId() {
            return this.processId;
        }

        public String getActivityId() {
            return this.activityId;
        }

        public String getProcessName() {
            return this.processName;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public Date getCreatedTime() {
            return this.createdTime;
        }

        public ActivityStatusType getStatus() {
            return this.status;
        }

        public String getKey() {
            return this.key;
        }

        public void setProcessId(String processId) {
            this.processId = processId;
        }

        public void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public void setProcessName(String processName) {
            this.processName = processName;
        }

        public void setActivityName(String activityName) {
            this.activityName = activityName;
        }

        public void setCreatedTime(Date createdTime) {
            this.createdTime = createdTime;
        }

        public void setStatus(ActivityStatusType status) {
            this.status = status;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @ConstructorProperties(value={"processId", "activityId", "processName", "activityName", "createdTime", "status", "key"})
        public FinishedActivityDto(String processId, String activityId, String processName, String activityName, Date createdTime, ActivityStatusType status, String key) {
            this.processId = processId;
            this.activityId = activityId;
            this.processName = processName;
            this.activityName = activityName;
            this.createdTime = createdTime;
            this.status = status;
            this.key = key;
        }

        public static class FinishedActivityDtoBuilder {
            private String processId;
            private String activityId;
            private String processName;
            private String activityName;
            private Date createdTime;
            private ActivityStatusType status;
            private String key;

            FinishedActivityDtoBuilder() {
            }

            public FinishedActivityDtoBuilder processId(String processId) {
                this.processId = processId;
                return this;
            }

            public FinishedActivityDtoBuilder activityId(String activityId) {
                this.activityId = activityId;
                return this;
            }

            public FinishedActivityDtoBuilder processName(String processName) {
                this.processName = processName;
                return this;
            }

            public FinishedActivityDtoBuilder activityName(String activityName) {
                this.activityName = activityName;
                return this;
            }

            public FinishedActivityDtoBuilder createdTime(Date createdTime) {
                this.createdTime = createdTime;
                return this;
            }

            public FinishedActivityDtoBuilder status(ActivityStatusType status) {
                this.status = status;
                return this;
            }

            public FinishedActivityDtoBuilder key(String key) {
                this.key = key;
                return this;
            }

            public FinishedActivityDto build() {
                return new FinishedActivityDto(this.processId, this.activityId, this.processName, this.activityName, this.createdTime, this.status, this.key);
            }

            public String toString() {
                return "FinishedActivityController.FinishedActivityDto.FinishedActivityDtoBuilder(processId=" + this.processId + ", activityId=" + this.activityId + ", processName=" + this.processName + ", activityName=" + this.activityName + ", createdTime=" + String.valueOf(this.createdTime) + ", status=" + String.valueOf(this.status) + ", key=" + this.key + ")";
            }
        }
    }
}

