/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.experimental;

import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.exception.FeatureNotFoundException;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"experimental/features"})
public class ExperimentalFeatureController {
    private static final Logger log = LoggerFactory.getLogger(ExperimentalFeatureController.class);
    @Autowired
    private Experimental experimental;
    @Autowired
    private AuthorizationHelper authorizationHelper;

    @RequestMapping(value={"flag/{featureId}"})
    @ResponseBody
    public Boolean getFlag(@PathVariable String featureId) {
        return this.experimental.hasFeature(featureId);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @PutMapping(value={"flag/{featureId}"})
    public void setFlag(@PathVariable String featureId, @RequestParam boolean value) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.experimental.setFeatureValue(featureId, value);
    }

    @ExceptionHandler(value={FeatureNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleFeatureNotFoundException(FeatureNotFoundException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }
}

