/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.processes.documentViews;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.database.documentViews.DocumentViewsTable;
import com.plusmpm.database.documentViews.dto.AddDocumentViewsTableDto;
import com.plusmpm.database.documentViews.dto.DocumentViewsTaskDto;
import com.plusmpm.database.documentViews.dto.ReadDocumentViewsTableDto;
import com.plusmpm.database.documentViews.exception.DocumentViewNotFoundException;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.DocumentViewsService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.controller.api.administration.processes.documentViews.DocumentViewsAuditHelper;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.web.support.DocumentViewsMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.workflow.activity.ActivityTranslationService;
import com.suncode.pwfl.workflow.process.ProcessService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/processes/definition/{procDefId}/document/views"})
@Api(tags={"process definitions"})
public class DocumentViewsController {
    private static final Logger log = LoggerFactory.getLogger(DocumentViewsController.class);
    @Autowired
    private DocumentViewsService documentViewsService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityTranslationService activityTranslationService;
    @Autowired
    private DocumentViewsMapper documentViewsMapper;
    @Autowired
    private DocumentViewsAuditHelper auditHelper;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private MessageHelperBean messageHelper;
    private final String rightsPath = RightTreeBuilder.builder().system().admin().build();
    private final XpdlPackageManager xpdlPackageManager = XpdlPackageManager.getInstance();

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    @ApiOperation(value="(Admin) Adding process document view", notes="Adds document view. The executed query saves document view for logged-in user. The query is a JSON object with the following fields: \n- **documentViewName** - view name (required) \n- **documentViewDesc** - view description \n- **procDefId** - process definition id of the process \n- **taskDefId** - task definition id (requires process definition id) \n- **docClassId** - document class id \n- **descending** - show documents in descending order \n- **amount** - amount of documents (required) \n- **regex** - regex \n- **showOn** - display on form, history, all(SHOW_FORM, SHOW_HISTORY, SHOW_ALL) \n- **displayByOffice365** - determines whether to display the document using Office 365")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public RestResult addDocumentView(HttpServletRequest request, @RequestBody AddDocumentViewsTableDto addDocumentViewsTableDto, @ApiParam(value="Process definition id", required=true) @PathVariable String procDefId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_DOCUMENT_VIEW);
        Map<String, Object> addDocumentViewAuditParams = this.auditHelper.createAddDocumentViewAuditParams(addDocumentViewsTableDto);
        auditBuilder.params(addDocumentViewAuditParams);
        this.authorizationHelper.assertFullOrPartRights(this.rightsPath, () -> auditBuilder.buildFailure(request));
        try {
            DocumentViewsTable viewsTable = this.documentViewsMapper.toEntity(addDocumentViewsTableDto);
            viewsTable.setProc_def_id(procDefId);
            long documentViewId = this.documentViewsService.addDocumentView(viewsTable);
            addDocumentViewAuditParams.put("documentViewId", StringUtils.defaultString((String)String.valueOf(documentViewId)));
            auditBuilder.params(addDocumentViewAuditParams);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @GetMapping
    @ResponseBody
    @ApiOperation(value="(Admin) Downloading process definition document views", notes="Retrieves a list of process definicion document views")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public CountedResult<ReadDocumentViewsTableDto> getDocumentViewsByProcessDefId(@ApiParam(value="Process definition id", required=true) @PathVariable String procDefId, @ApiParam(value="Result number from which results are to be returned", defaultValue="0") @RequestParam(required=false, defaultValue="0") Integer start, @ApiParam(value="Number of returned results", defaultValue="20") @RequestParam(required=false, defaultValue="20") Integer limit, @ApiParam(value="Sort by", defaultValue="documentViewName") @RequestParam(required=false, defaultValue="documentViewName") String sortBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullOrPartRights(this.rightsPath, () -> {});
        List documentViews = this.documentViewsService.getDocumentViewsByProcessDefId(procDefId).stream().map(this.documentViewsMapper::toDto).sorted((Comparator<ReadDocumentViewsTableDto>)DtoComparator.of(ReadDocumentViewsTableDto.class, (String)sortBy, (SortDirection)sortDirection)).collect(Collectors.toList());
        return Paginator.forAll(documentViews).viewPageByOffset(start, limit);
    }

    @PatchMapping(value={"/{id}"})
    @ResponseBody
    @ApiOperation(value="(Admin) Editing document view", notes="Edits document view. The executed query edits document view for logged-in user. The query is a JSON object with the following fields: \n- **documentViewName** - view name (required) \n- **documentViewDesc** - view description \n- **procDefId** - process definition id of the process \n- **taskDefId** - task definition id (requires process definition id) \n- **docClassId** - document class id \n- **descending** - show documents in descending order \n- **amount** - amount of documents (required) \n- **regex** - regex \n- **showOn** - display on form, history, all(SHOW_FORM, SHOW_HISTORY, SHOW_ALL) \n- **displayByOffice365** - determines whether to display the document using Office 365")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public RestResult changeDocumentView(HttpServletRequest request, @ApiParam(value="Process definition id", required=true) @PathVariable String procDefId, @RequestBody AddDocumentViewsTableDto addDocumentViewsTableDto, @ApiParam(value="Id of the document view", required=true) @PathVariable Long id) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_DOCUMENT_VIEW);
        DocumentViewsTable documentView = (DocumentViewsTable)this.documentViewsService.get((Serializable)id);
        if (Objects.isNull(documentView)) {
            throw new DocumentViewNotFoundException(this.messageHelper.getMessage("Widok_o_podanym_id_nie_istnieje"));
        }
        auditBuilder.params(this.auditHelper.createEditDocumentViewAuditParams(addDocumentViewsTableDto, documentView));
        this.authorizationHelper.assertFullOrPartRights(this.rightsPath, () -> auditBuilder.buildFailure(request));
        try {
            addDocumentViewsTableDto.setProcDefId(procDefId);
            DocumentViewsTable documentViewsTable = this.documentViewsMapper.toEntity(addDocumentViewsTableDto);
            documentViewsTable.setId(id);
            this.documentViewsService.changeDocumentView(documentViewsTable);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @DeleteMapping
    @ResponseBody
    @ApiOperation(value="(Admin) Deleting process document view", notes="Deletes document view with given id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public RestResult deleteDocumentViewById(HttpServletRequest request, @ApiParam(value="Process definition id", required=true) @PathVariable String procDefId, @ApiParam(value="Id of the document view", required=true) @RequestParam Long id) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DOCUMENT_VIEW);
        auditBuilder.params(this.auditHelper.createDeleteDocumentViewAuditParams(id, procDefId));
        this.authorizationHelper.assertFullOrPartRights(this.rightsPath, () -> auditBuilder.buildFailure(request));
        try {
            this.documentViewsService.deleteDocumentViewById(id, procDefId);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"export/{extension}"})
    public void export(HttpServletResponse response, @PathVariable String procDefId, @PathVariable String extension, @RequestParam Boolean isUserDocumentViews, @RequestParam(required=false, defaultValue="documentViewName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        if (!isUserDocumentViews.booleanValue()) {
            this.authorizationHelper.assertFullOrPartRights(this.rightsPath, () -> {});
        }
        List documentViewsTables = isUserDocumentViews != false ? this.documentViewsService.getDocumentViewsByUsername(UserContext.current().getUser().getUserName()) : this.documentViewsService.getDocumentViewsByProcessDefId(procDefId);
        List<ReadDocumentViewsTableDto> readDocumentViewsTableDtos = documentViewsTables.stream().map(this.documentViewsMapper::toDto).sorted((Comparator<ReadDocumentViewsTableDto>)DtoComparator.of(ReadDocumentViewsTableDto.class, (String)sortBy, (SortDirection)sortDirection)).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn("Nazwa", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getDocumentViewName), this.buildExportColumn("Opis", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getDocumentViewDesc), this.buildExportColumn("Proces", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getProcName), this.buildExportColumn("Zadanie", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getTaskName), this.buildExportColumn("Uzytkownik", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getUserName), this.buildExportColumn("Klasa_dokumentow", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getDocClassName), this.buildExportColumn("Wyswietl_Na", readDocumentViewsTableDtos, readDocumentViewsTableDto -> this.messageHelper.getMessage(readDocumentViewsTableDto.getShowOn())), this.buildExportColumn("Najnowsze", readDocumentViewsTableDtos, readDocumentViewsTableDto -> this.messageHelper.getMessage(readDocumentViewsTableDto.getIsDescending())), this.buildExportColumn("Ilosc", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getAmount), this.buildExportColumn("Wyrazenie_regularne", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getRegex));
        this.buildExportColumn("Wyswietl_dokumenty_office365", readDocumentViewsTableDtos, readDocumentViewsTableDto -> this.messageHelper.getMessage(readDocumentViewsTableDto.getDisplayByOffice365()));
        this.buildExportColumn("Wyswietl_dokumenty_google_docs", readDocumentViewsTableDtos, readDocumentViewsTableDto -> this.messageHelper.getMessage(readDocumentViewsTableDto.getDisplayByGoogleDocs()));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Widoki_dokumentow")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private ExportColumn buildExportColumn(String name, List<ReadDocumentViewsTableDto> data, Function<ReadDocumentViewsTableDto, String> supplier) {
        return ExportColumnBuilder.create().name(this.messageHelper.getMessage(name)).data(data).by(supplier).build();
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"tasks"})
    @ResponseBody
    public List<DocumentViewsTaskDto> getTasksForProcess(@PathVariable String procDefId) {
        String packId = this.xpdlPackageManager.getPackageIdByProcessDefinitionId(procDefId);
        return this.processService.getActivityTypes(procDefId).stream().map(activity -> new DocumentViewsTaskDto(activity.getActivityDefId(), this.activityTranslationService.getActivityTranslationTableByDefinitionIdAndLocale(packId, procDefId, activity.getActivityDefId(), LocaleContextHolder.getLocale().getLanguage()).getName())).sorted(Comparator.comparing(activity -> activity.getText().toLowerCase())).collect(Collectors.toList());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleIllegalArgumentException(IllegalArgumentException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={DocumentViewNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFoundException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NoRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNoRightsException(NoRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }
}

