/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.email;

import com.suncode.pwfl.administration.email.oauth.OAuth2Service;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2Client;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2ClientService;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@RequestMapping(value={"/oauth"})
public class OAuth2Controller {
    private static final Logger log = LoggerFactory.getLogger(OAuth2Controller.class);
    @Autowired
    private OAuth2Service oAuth2Service;
    @Autowired
    private OAuth2ClientService oAuth2ClientService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    private SecureRandom random = new SecureRandom();

    @Transactional
    @RequestMapping(value={"redirect"}, method={RequestMethod.GET})
    public RedirectView redirect(@RequestParam String code, @CookieValue(value="oauth_client_name") String clientName, @CookieValue(value="oauth_connection_name") String connectionName, @CookieValue(value="update") boolean update, HttpServletRequest request, HttpSession httpSession) {
        AuditParamsBuilder auditParamsBuilder;
        AuditBuilder auditBuilder;
        block11: {
            auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_OAUTH2_REDIRECT);
            auditParamsBuilder = new AuditParamsBuilder().param("OAUTH2_REDIRECT_CLIENT_NAME", (Object)Objects.toString(clientName, "")).param("OAUTH2_REDIRECT_CONNECTION_NAME", (Object)Objects.toString(connectionName, "")).param("OAUTH2_REDIRECT_UPDATE", (Object)update);
            try {
                this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure()));
            }
            catch (NotFullRightsException ignored) {
                Optional optionalClient = this.oAuth2ClientService.findByName(clientName);
                if (optionalClient.isEmpty()) {
                    throw new HttpClientErrorException((HttpStatusCode)HttpStatus.FORBIDDEN, "OAuth client not found: " + clientName);
                }
                boolean allowed = ((OAuth2Client)optionalClient.get()).getAllowedGroupsList().stream().anyMatch(group -> UserContext.current().getUser().getGroups().stream().anyMatch(g -> g.getName().equals(group)));
                if (allowed) break block11;
                request.setAttribute("audit", (Object)auditBuilder.buildFailure());
                throw new HttpClientErrorException((HttpStatusCode)HttpStatus.FORBIDDEN, "User not allowed for this OAuth client");
            }
        }
        UriComponentsBuilder redirectUriBuilder = ServletUriComponentsBuilder.fromCurrentContextPath().path("/Admin.do").queryParam("tab", new Object[]{"configuration"}).queryParam("clientName", new Object[]{clientName}).fragment("authenticationManagement");
        try {
            String codeVerifier = (String)httpSession.getAttribute("code_verifier");
            if (update) {
                this.oAuth2Service.updateConnection(clientName, connectionName, code, codeVerifier);
            } else {
                this.oAuth2Service.createNewConnection(clientName, connectionName, code, codeVerifier);
            }
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            redirectUriBuilder.queryParam("message", new Object[]{update ? "oauth_connection_refreshed" : "oauth_added_new_connection"});
            return new RedirectView(redirectUriBuilder.toUriString());
        }
        catch (Exception e) {
            log.error("Error during redirect", (Throwable)e);
            if (e instanceof IllegalArgumentException) {
                redirectUriBuilder.queryParam("error", new Object[]{e.getMessage()});
            } else if (e instanceof HttpClientErrorException) {
                redirectUriBuilder.queryParam("error", new Object[]{"oauth_exchange_error"});
            } else {
                redirectUriBuilder.queryParam("error", new Object[]{"oauth_redirect_error"});
            }
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            return new RedirectView(redirectUriBuilder.toUriString());
        }
    }

    @Transactional
    @RequestMapping(value={"auth/{clientName}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getAuthorizationUrl(@PathVariable String clientName, HttpSession httpSession) {
        OAuth2Client client;
        block4: {
            Optional optionalClient = this.oAuth2ClientService.findByName(clientName);
            if (optionalClient.isEmpty()) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            client = (OAuth2Client)optionalClient.get();
            try {
                this.authorizationHelper.assertFullAdministrationRights(() -> {});
            }
            catch (NotFullRightsException ignored) {
                boolean allowed = client.getAllowedGroupsList().stream().anyMatch(group -> UserContext.current().getUser().getGroups().stream().anyMatch(g -> g.getName().equals(group)));
                if (allowed) break block4;
                log.error("User not allowed for this OAuth client");
                return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
            }
        }
        UriComponentsBuilder authUrlBuilder = UriComponentsBuilder.fromHttpUrl((String)client.getAuthorizationUrl()).queryParam("client_id", new Object[]{client.getClientId()}).queryParam("response_type", new Object[]{"code"}).queryParam("redirect_uri", new Object[]{this.getRedirectUrl(client)}).queryParam("scope", new Object[]{client.getScope()});
        if (client.isPkce()) {
            String codeVerifier = this.generateCodeVerifier();
            String codeChallenge = this.generateCodeChallenge(codeVerifier);
            httpSession.setAttribute("code_verifier", (Object)codeVerifier);
            authUrlBuilder.queryParam("code_challenge", new Object[]{codeChallenge}).queryParam("code_challenge_method", new Object[]{"S256"});
        }
        return new ResponseEntity((Object)authUrlBuilder.toUriString(), (HttpStatusCode)HttpStatus.OK);
    }

    private String getRedirectUrl(OAuth2Client client) {
        if (StringUtils.isNotBlank((CharSequence)client.getRedirectUrl())) {
            return client.getRedirectUrl();
        }
        return ServletUriComponentsBuilder.fromCurrentContextPath().path("/api/oauth/redirect").build().toUriString();
    }

    public String generateCodeVerifier() {
        byte[] randomBytes = new byte[32];
        this.random.nextBytes(randomBytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(randomBytes);
    }

    public String generateCodeChallenge(String codeVerifier) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(codeVerifier.getBytes(StandardCharsets.US_ASCII));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(hash);
        }
        catch (Exception e) {
            throw new RuntimeException("B\u0142\u0105d podczas generowania hashu", e);
        }
    }
}

