/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web;

import com.suncode.pwfl.web.CsrfTokenDto;
import com.suncode.pwfl.web.CsrfTokenService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.DeferredCsrfToken;
import org.springframework.stereotype.Component;

@Component
public class CsrfTokenServiceImpl
implements CsrfTokenService {
    @Autowired
    private CsrfTokenRepository csrfTokenRepository;
    @Autowired
    private CsrfTokenRequestHandler csrfTokenRequestHandler;

    public Optional<CsrfTokenDto> getMaskedCsrfToken(HttpServletRequest request) {
        return Optional.ofNullable(request.getSession(false)).map(session -> (CsrfToken)request.getAttribute("_csrf")).map(this::toDto);
    }

    public CsrfTokenDto invalidateMaskedCsrfToken(HttpServletRequest request, HttpServletResponse response) {
        this.csrfTokenRepository.saveToken(null, request, response);
        DeferredCsrfToken newRawDeferredCsrfToken = this.csrfTokenRepository.loadDeferredToken(request, response);
        this.csrfTokenRequestHandler.handle(request, response, () -> ((DeferredCsrfToken)newRawDeferredCsrfToken).get());
        CsrfToken newMaskedCsrfToken = (CsrfToken)request.getAttribute("_csrf");
        return this.toDto(newMaskedCsrfToken);
    }

    private CsrfTokenDto toDto(CsrfToken csrfToken) {
        return new CsrfTokenDto(csrfToken.getToken(), csrfToken.getHeaderName(), csrfToken.getParameterName());
    }
}

