/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util;

import com.plusmpm.struts.form.SearchUserForm;
import com.plusmpm.util.UserInfo;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.search.SimpleHibernateUserFilter;
import com.suncode.pwfl.administration.user.search.UserPropertyFilter;
import com.suncode.pwfl.administration.user.search.UserSortProperty;
import com.suncode.pwfl.administration.user.search.UserSorter;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.LogicOperator;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.hibernate.GroupHibernateFilter;
import com.suncode.pwfl.search.hibernate.HibernateFilter;
import com.suncode.pwfl.util.FinderFactory;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.util.ParamEncoder;
import org.springframework.web.util.HtmlUtils;

public class UsersDisplayTagUtils {
    public static Boolean isDisplayTagExport(HttpServletRequest request) {
        String exportTypeParameterName = new ParamEncoder("group").encodeParameterName("e");
        String exportParameter = request.getParameter(exportTypeParameterName);
        return StringUtils.isNotEmpty((CharSequence)exportParameter);
    }

    public static Integer getPageNumber(HttpServletRequest request) {
        String pageNumberParametername = new ParamEncoder("group").encodeParameterName("p");
        String pageNumber = request.getParameter(pageNumberParametername);
        if (StringUtils.isEmpty((CharSequence)pageNumber)) {
            return 0;
        }
        return Integer.parseInt(pageNumber);
    }

    public static Integer getSortColumnNumber(HttpServletRequest request) {
        String sortColumnNumberParameterName = new ParamEncoder("group").encodeParameterName("s");
        String sortColumnNumberParameter = request.getParameter(sortColumnNumberParameterName);
        if (StringUtils.isNotEmpty((CharSequence)sortColumnNumberParameter)) {
            return Integer.parseInt(sortColumnNumberParameter);
        }
        return 0;
    }

    public static Boolean isOrderDesc(HttpServletRequest request) {
        String orderDescParamName = new ParamEncoder("group").encodeParameterName("o");
        String orderDescParam = request.getParameter(orderDescParamName);
        if (StringUtils.isNotEmpty((CharSequence)orderDescParam)) {
            return !orderDescParam.equals("2");
        }
        return false;
    }

    private static List<HibernateFilter> prepareFilters(Map<String, String> mapFilters) {
        List<HibernateFilter> filters = new ArrayList<HibernateFilter>();
        if (mapFilters != null && !mapFilters.isEmpty()) {
            String userName = mapFilters.get("userId");
            String firstName = mapFilters.get("firstname");
            String lastName = mapFilters.get("lastname");
            String email = mapFilters.get("email");
            String number = mapFilters.get("number");
            String groupName = mapFilters.get("group");
            String positionName = mapFilters.get("positionname");
            String positionSymbol = mapFilters.get("positionsymbol");
            Boolean active = Boolean.valueOf(mapFilters.get("active"));
            filters = UsersDisplayTagUtils.addFilter(filters, UserPropertyFilter.USERNAME, userName);
            filters = UsersDisplayTagUtils.addFilter(filters, UserPropertyFilter.FIRSTNAME, firstName);
            filters = UsersDisplayTagUtils.addFilter(filters, UserPropertyFilter.LASTNAME, lastName);
            filters = UsersDisplayTagUtils.addFilter(filters, UserPropertyFilter.GROUP_NAME, groupName);
            filters = UsersDisplayTagUtils.addFilter(filters, UserPropertyFilter.POSITION_NAME, positionName);
            filters = UsersDisplayTagUtils.addFilter(filters, UserPropertyFilter.POSITION_SYMBOL, positionSymbol);
            filters = UsersDisplayTagUtils.addFilter(filters, UserPropertyFilter.EMAIL, email);
            filters = UsersDisplayTagUtils.addFilter(filters, UserPropertyFilter.NUMBER, number);
            filters = UsersDisplayTagUtils.addFilter(filters, UserPropertyFilter.ACTIVE, active);
        }
        return filters;
    }

    private static List<HibernateFilter> addFilter(List<HibernateFilter> filters, UserPropertyFilter property, Object value) {
        if (value instanceof String) {
            String sValue = (String)value;
            if (StringUtils.isNotBlank((CharSequence)sValue)) {
                if (DBUtils.isExactQuery((String)sValue)) {
                    filters.add((HibernateFilter)new SimpleHibernateUserFilter(property, (Object)DBUtils.getExactQueryValue((String)sValue), FilterOperator.EQ));
                } else if (DBUtils.isConjunctionSearch((String)sValue)) {
                    GroupHibernateFilter conjunctionFilter = new GroupHibernateFilter(LogicOperator.AND);
                    List searchValues = DBUtils.searchCriteriaForConjunctionLike((List)DBUtils.conjunctionValuesForLike((String)sValue));
                    List searchFilters = searchValues.stream().map(filterValue -> new SimpleHibernateUserFilter(property, filterValue, FilterOperator.ILIKE)).collect(Collectors.toList());
                    conjunctionFilter.setFilters(searchFilters);
                    filters.add((HibernateFilter)conjunctionFilter);
                } else {
                    filters.add((HibernateFilter)new SimpleHibernateUserFilter(property, (Object)DBUtils.searchCriteriaForLike((String)sValue), FilterOperator.ILIKE));
                }
            }
        } else {
            filters.add((HibernateFilter)new SimpleHibernateUserFilter(property, value, FilterOperator.EQ));
        }
        return filters;
    }

    public static UserSorter getSorter(boolean bDesc, UserSortProperty sSortKey) {
        UserSorter sorter = new UserSorter();
        sorter.setProperty(sSortKey);
        if (bDesc) {
            sorter.setDirection(SortDirection.DESC);
        } else {
            sorter.setDirection(SortDirection.ASC);
        }
        return sorter;
    }

    public static UserSortProperty getSortKey(int columnNumber) {
        switch (columnNumber) {
            case 0: {
                return UserSortProperty.USERNAME;
            }
            case 1: {
                return UserSortProperty.FIRSTNAME;
            }
            case 2: {
                return UserSortProperty.LASTNAME;
            }
            case 3: {
                return UserSortProperty.NUMBER;
            }
            case 4: {
                return UserSortProperty.EMAIL;
            }
        }
        return UserSortProperty.USERNAME;
    }

    public static CountedResult<UserInfo> getUserList(HttpServletRequest request, Integer pageSize) {
        HttpSession session = request.getSession(false);
        Integer pageNumber = UsersDisplayTagUtils.getPageNumber(request);
        Boolean isDisplayTagExport = UsersDisplayTagUtils.isDisplayTagExport(request);
        Map<String, String> mapFilters = UsersDisplayTagUtils.getMapFilters(session);
        Integer sortColumnNumber = UsersDisplayTagUtils.getSortColumnNumber(request);
        Boolean orderDesc = UsersDisplayTagUtils.isOrderDesc(request);
        Integer offset = (pageNumber - 1) * pageSize;
        if (offset < 0) {
            offset = 0;
        }
        if (isDisplayTagExport.booleanValue()) {
            pageSize = offset = Integer.valueOf(0);
        }
        UserFinder userFinder = FinderFactory.getUserFinder();
        CountedResult users = userFinder.findByFilters(UsersDisplayTagUtils.prepareFilters(mapFilters), UsersDisplayTagUtils.getSorter(orderDesc, UsersDisplayTagUtils.getSortKey(sortColumnNumber)), offset.intValue(), pageSize.intValue());
        List usersInfoList = users.getData().stream().map(user -> {
            UserInfo info = new UserInfo();
            String sUserName = user.getUserName();
            String sHTMLUSerName = HtmlUtils.htmlEscape((String)sUserName);
            info.setM_sUserName(sHTMLUSerName);
            info.setM_sUserFirstName(user.getFirstName());
            info.setM_sUserLastName(user.getLastName());
            info.setM_sUserNumber(user.getNumber());
            info.setM_sUserEmail(user.getEmail());
            info.setM_sUserGroups(UsersDisplayTagUtils.getUserGroups(user));
            info.setM_sUserPosition(UsersDisplayTagUtils.getUserPositions(user));
            info.setActive(user.isActive().booleanValue());
            return info;
        }).collect(Collectors.toList());
        return new CountedResult(users.getTotal(), usersInfoList);
    }

    private static Map<String, String> getMapFilters(HttpSession session) {
        HashMap<String, String> map = new HashMap<String, String>();
        SearchUserForm searchUserForm = (SearchUserForm)session.getAttribute("searchUserForm");
        if (searchUserForm != null) {
            map.put("userId", searchUserForm.getSearchUserName());
            map.put("firstname", searchUserForm.getSearchUserFirstName());
            map.put("lastname", searchUserForm.getSearchUserLastName());
            map.put("email", searchUserForm.getSearchUserEmail());
            map.put("number", searchUserForm.getSearchUserNumber());
            map.put("group", searchUserForm.getSearchUserGroupName());
            map.put("positionname", searchUserForm.getSearchUserPosition());
            map.put("positionsymbol", searchUserForm.getSearchUserPositionSymbol());
            map.put("active", Boolean.toString(!searchUserForm.isOnlyInactive()));
            return map;
        }
        return map;
    }

    private static String getUserGroups(User user) {
        ArrayList<String> groups = new ArrayList<String>();
        for (UserGroup group : user.getGroups()) {
            groups.add(group.getName());
        }
        return StringUtils.join(groups, (String)", ");
    }

    private static String getUserPositions(User user) {
        ArrayList<CallSite> positions = new ArrayList<CallSite>();
        for (Position position : user.getPositions()) {
            positions.add((CallSite)((Object)(position.getSymbol() + " - " + position.getName())));
        }
        return StringUtils.join(positions, (String)", ");
    }
}

