/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util;

import com.plusmpm.util.ActivityVariable;
import com.plusmpm.util.ActivityVariableComp;
import com.plusmpm.util.SharkFunctions;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataType;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class ProcessVariableHelper {
    public static Logger log = Logger.getLogger(ProcessVariableHelper.class);

    public ArrayList<ActivityVariable> getVariablesForProcess(String sProcDefId) {
        WorkflowProcess wp = SharkFunctions.getWorkflowProcessByDefId((String)sProcDefId);
        if (wp == null) {
            return new ArrayList<ActivityVariable>();
        }
        int iVarSetLength = wp.getAllVariables().size();
        ArrayList<ActivityVariable> list = new ArrayList<ActivityVariable>();
        for (int y = 0; y < iVarSetLength; ++y) {
            ExtendedAttribute ea;
            String sVariableName = (String)wp.getAllVariables().keySet().toArray()[y];
            DataField dataField = wp.getDataField(sVariableName);
            if (dataField == null) continue;
            ExtendedAttributes variableExtendedAttributes = dataField.getExtendedAttributes();
            DataType dtType = dataField.getDataType();
            String sType = dtType.getDataTypes().getBasicType().getType().toString();
            ActivityVariable actVar = new ActivityVariable(sVariableName, dataField.getName(), "");
            actVar.m_sVariableType = sType;
            if (variableExtendedAttributes.containsElement("SUBTYPE")) {
                ea = variableExtendedAttributes.getFirstExtendedAttributeForName("SUBTYPE");
                actVar.m_sSubType = ea.getVValue();
            }
            if (variableExtendedAttributes.containsElement("VALUES")) {
                ea = variableExtendedAttributes.getFirstExtendedAttributeForName("VALUES");
                String sValues = ea.getVValue();
                actVar.m_sValueList = sValues.replaceAll("'", "\\\\'").split("\n");
                actVar.m_bIsList = true;
                if (sValues.indexOf(60) == 0 && sValues.indexOf(62) == sValues.length() - 1) {
                    actVar.m_bIsList = false;
                    actVar.m_sSubType = "";
                }
            }
            if (variableExtendedAttributes.containsElement("ID")) {
                ea = variableExtendedAttributes.getFirstExtendedAttributeForName("ID");
                String sValue = ea.getVValue();
                actVar.iID = new Integer(sValue);
            }
            actVar.setProcDefId(sProcDefId);
            list.add(actVar);
        }
        ActivityVariableComp avc = new ActivityVariableComp();
        list.sort((Comparator<ActivityVariable>)avc);
        return list;
    }
}

