/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DomainTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.i18n.I18N;
import com.plusmpm.struts.form.DomainForm;
import com.plusmpm.util.Authorization;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class AddDomainAction
extends Action {
    I18N oMessage;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.oMessage = new I18N(request);
        HttpSession session = request.getSession(false);
        String userName = (String)session.getAttribute("username");
        int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)userName, (boolean)false, (boolean)false);
        if (rights == 0) {
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("disconnect");
            }
            String message = "";
            String messageType = "";
            DBManagement dbm = new DBManagement();
            try {
                DomainForm domainForm = (DomainForm)form;
                if (domainForm.validateSelectedFields()) {
                    DomainTable domainTable = new DomainTable(domainForm.getDomainName(), domainForm.getDomainServer(), new Long(domainForm.getDomainServerPort()), domainForm.getDomainUser(), domainForm.getDomainUserPassword(), domainForm.getDomainBaseSearch(), domainForm.getUsernameTemplate(), domainForm.getDomainSpnego());
                    domainTable.setUsernameMapping(domainForm.getUsernameMapping());
                    domainTable.setFirstnameMapping(domainForm.getFirstnameMapping());
                    domainTable.setLastnameMapping(domainForm.getLastnameMapping());
                    domainTable.setEmailMapping(domainForm.getEmailMapping());
                    domainTable.setMemberMapping(domainForm.getMemberMapping());
                    domainTable.setMemberOfMapping(domainForm.getMemberOfMapping());
                    domainTable.setUserAttributeMapping(domainForm.getUserAttributeMapping());
                    domainTable.setGroupAttributeMapping(domainForm.getGroupAttributeMapping());
                    domainTable.setNumberMapping(domainForm.getNumberMapping());
                    domainTable.setLdapOverSsl(domainForm.getLdapOverSsl());
                    domainTable.setStartTLS(domainForm.getStartTLS());
                    long lId = dbm.addDomain(domainTable);
                    message = this.oMessage.getString("Dodano_serwer_domenowy");
                    messageType = "success";
                    request.setAttribute("auditSuccess", (Object)true);
                    request.setAttribute("auditExtraParam", (Object)("domainId=" + lId));
                    request.setAttribute("continueAdd", (Object)request.getParameter("continueAdd"));
                } else {
                    message = this.oMessage.getString("Wystapil_blad_podczas_dodawania_serwera_domenowego");
                    messageType = "error";
                }
            }
            catch (Exception e) {
                message = this.oMessage.getString("Wystapil_blad_podczas_dodawania_serwera_domenowego");
                messageType = "error";
            }
            request.setAttribute("message", (Object)message);
            request.setAttribute("messageType", (Object)messageType);
            ArrayList alDomains = dbm.GetAllDomains();
            request.setAttribute("alDomains", (Object)alDomains);
            return mapping.findForward("showNewDomains");
        }
        return mapping.findForward("welcome");
    }
}

