/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.plugin;

import com.suncode.org.apache.struts.tiles.ComponentDefinition;
import com.suncode.org.apache.struts.tiles.DefinitionsFactoryConfig;
import com.suncode.org.apache.struts.tiles.DefinitionsUtil;
import com.suncode.plugin.framework.web.support.decorator.ViewDecorator;
import com.suncode.plugin.framework.web.support.decorator.ViewDecoratorResolver;
import com.suncode.pwfl.web.support.plugin.TilesDecorator;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="decoratorResolver")
public class TilesViewDecoratorResolver
implements ViewDecoratorResolver {
    public static final String DECORATOR_PARAMETER_NAME = "decorator";
    public static final String DEFAULT_DECORATOR_NAME = "system";
    public static final String NONE_DECORATOR_NAME = "none";
    private final Logger logger = Logger.getLogger(this.getClass());
    private ServletContext servletContext;

    @Autowired
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        DefinitionsFactoryConfig conf = new DefinitionsFactoryConfig();
        conf.setDefinitionConfigFiles("/WEB-INF/tiles-defs.xml");
        conf.setParserValidate(false);
        DefinitionsUtil.createDefinitionsFactory((ServletContext)servletContext, (DefinitionsFactoryConfig)conf);
    }

    public ViewDecorator getDecorator(HttpServletRequest request) {
        String decoratorName = this.resolveDecoratorName(request);
        if (NONE_DECORATOR_NAME.equals(decoratorName)) {
            return null;
        }
        if (decoratorName == null) {
            if ("XMLHttpRequest".equals(request.getHeader("X-Requested-With"))) {
                return null;
            }
            decoratorName = DEFAULT_DECORATOR_NAME;
        }
        try {
            ComponentDefinition baseDefinition = DefinitionsUtil.getDefinitionsFactory((ServletContext)this.servletContext).getDefinition(decoratorName, (ServletRequest)request, this.servletContext);
            ComponentDefinition definition = new ComponentDefinition(baseDefinition);
            return new TilesDecorator(definition);
        }
        catch (Exception e) {
            this.logger.error((Object)("Nie uda\u0142o si\u0119 udekorowa\u0107 widoku dekoratorem [" + decoratorName + "]"), (Throwable)e);
            return null;
        }
    }

    public String resolveDecoratorName(HttpServletRequest request) {
        String decoratorName = request.getParameter(DECORATOR_PARAMETER_NAME);
        if (decoratorName == null) {
            decoratorName = (String)request.getAttribute(DECORATOR_PARAMETER_NAME);
        }
        return decoratorName;
    }
}

