/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.documents;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.exception.DocumentClassNotFoundException;
import com.suncode.pwfl.archive.exception.DocumentNotFoundException;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"documents/indexes"})
@Api(hidden=true)
public class DocumentIndexesController {
    private final AuthorizationHelper authorizationHelper;
    private final Experimental experimental;
    private final FileService fileService;
    private final DocumentService documentService;
    private final MessageHelperBean messageHelper;

    @GetMapping(value={"{documentClassId}/{documentId}"})
    public List<IndexInfo> getDocumentIndexes(@PathVariable Long documentClassId, @PathVariable Long documentId) {
        String rightsPath = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClassId).modify().build();
        this.authorizationHelper.assertFullRights(rightsPath, () -> {});
        WfDocument document = Optional.ofNullable(this.documentService.getDocument(documentId, documentClassId)).orElseThrow(() -> new DocumentNotFoundException(this.messageHelper.getMessage("Dokument_nie_istnieje")));
        if (!document.getDocumentClassId().equals(documentClassId)) {
            throw new DocumentClassNotFoundException(this.messageHelper.getMessage("Podano_nieprawdlowe_id_klasy_dokumentow"));
        }
        return document.getIndexes();
    }

    @PostMapping(value={"{fileId}"})
    public RestResult changeDocumentIndexes(HttpServletRequest request, @PathVariable Long fileId, @RequestBody List<IndexInfo> indexes) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("fileId", (Object)fileId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_DOCUMENT_INDEXES).params(auditParamsBuilder.build());
        try {
            HashMap indexInfoMap = new HashMap();
            indexes.forEach(index -> indexInfoMap.put(index.getId(), index.getValue()));
            this.authorizationHelper.ensureFileModifyAccess(fileId, () -> {
                this.fileService.changeFileIndexes(fileId, indexInfoMap);
                return null;
            });
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @ConstructorProperties(value={"authorizationHelper", "experimental", "fileService", "documentService", "messageHelper"})
    @Autowired
    public DocumentIndexesController(AuthorizationHelper authorizationHelper, Experimental experimental, FileService fileService, DocumentService documentService, MessageHelperBean messageHelper) {
        this.authorizationHelper = authorizationHelper;
        this.experimental = experimental;
        this.fileService = fileService;
        this.documentService = documentService;
        this.messageHelper = messageHelper;
    }
}

