/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.detail;

import com.suncode.pwfl.audit.AuditParam;
import com.suncode.pwfl.audit.form.AuditDetailsHandler;
import com.suncode.pwfl.audit.formatter.AcceptActivityFormatter;
import com.suncode.pwfl.audit.formatter.AcceptManyActivitiesFormatter;
import com.suncode.pwfl.audit.formatter.ActivateTrialLicenseFormatter;
import com.suncode.pwfl.audit.formatter.ActivityDetailsFormatter;
import com.suncode.pwfl.audit.formatter.ActivityStateChangeFormatter;
import com.suncode.pwfl.audit.formatter.AddAndDeleteOrgUnitFormatter;
import com.suncode.pwfl.audit.formatter.AddAndDeleteRolesFromPositionFormatter;
import com.suncode.pwfl.audit.formatter.AddCommentToActivityFormatter;
import com.suncode.pwfl.audit.formatter.AddDeleteModuleRightFormatter;
import com.suncode.pwfl.audit.formatter.AddDocClassFormatter;
import com.suncode.pwfl.audit.formatter.AddDocClassProtectionConditionFormatter;
import com.suncode.pwfl.audit.formatter.AddDocumentClassAssociationFormatter;
import com.suncode.pwfl.audit.formatter.AddDocumentTemplateFormatter;
import com.suncode.pwfl.audit.formatter.AddEmailConfigurationFormatter;
import com.suncode.pwfl.audit.formatter.AddLinkConnectionFormatter;
import com.suncode.pwfl.audit.formatter.AddMultipleVariableDistinguishFormatter;
import com.suncode.pwfl.audit.formatter.AddOrDeleteDelegationFormatter;
import com.suncode.pwfl.audit.formatter.AddPositionFormatter;
import com.suncode.pwfl.audit.formatter.AddReplacementVariableFormatter;
import com.suncode.pwfl.audit.formatter.AddScheduledTaskFormatter;
import com.suncode.pwfl.audit.formatter.AddSystemProtectionFormatter;
import com.suncode.pwfl.audit.formatter.AddUserFormatter;
import com.suncode.pwfl.audit.formatter.AddViewProtectionFormatter;
import com.suncode.pwfl.audit.formatter.AddViewSqlReportFormatter;
import com.suncode.pwfl.audit.formatter.BaseLinkFormatter;
import com.suncode.pwfl.audit.formatter.BasicAuthenticationConfigurationFormatter;
import com.suncode.pwfl.audit.formatter.BasicAuthenticationConfigurationUpdateFormatter;
import com.suncode.pwfl.audit.formatter.CalendarResourceFormatter;
import com.suncode.pwfl.audit.formatter.CalendarResourceGroupFormatter;
import com.suncode.pwfl.audit.formatter.CalendarResourceShareFormatter;
import com.suncode.pwfl.audit.formatter.CalendarShareFormatter;
import com.suncode.pwfl.audit.formatter.CancelUserCalendarEventsFormatter;
import com.suncode.pwfl.audit.formatter.ChangeDomainFormatter;
import com.suncode.pwfl.audit.formatter.ChangeOrgUnitFormatter;
import com.suncode.pwfl.audit.formatter.ChangePositionFormatter;
import com.suncode.pwfl.audit.formatter.ChangeReplacementVariableTypeFormatter;
import com.suncode.pwfl.audit.formatter.ChangeSystemParameterFormatter;
import com.suncode.pwfl.audit.formatter.ChangeViewProtectionFormatter;
import com.suncode.pwfl.audit.formatter.CheckInDocumentFormatter;
import com.suncode.pwfl.audit.formatter.CheckoutFileFromProcessFormatter;
import com.suncode.pwfl.audit.formatter.CreateProcessFormatter;
import com.suncode.pwfl.audit.formatter.CreateSystemParameterFormatter;
import com.suncode.pwfl.audit.formatter.DataSourceFormatter;
import com.suncode.pwfl.audit.formatter.DataSourceImportFormatter;
import com.suncode.pwfl.audit.formatter.DeactivateUserFormatter;
import com.suncode.pwfl.audit.formatter.DefaultProcessFieldsFormatter;
import com.suncode.pwfl.audit.formatter.DeleteAllVariableDistinguishFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocClassActionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocClassIndexFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocClassProtectionConditionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocClassProtectionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocumentClassAssociationFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocumentFromProcessFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocumentTemplateFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocumentViewFormatter;
import com.suncode.pwfl.audit.formatter.DeleteLinkConnectionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteLinkIndexFormatter;
import com.suncode.pwfl.audit.formatter.DeleteLinkProtectionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteOrAbortProcessFormatter;
import com.suncode.pwfl.audit.formatter.DeletePanelParameterFormatter;
import com.suncode.pwfl.audit.formatter.DeletePositionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteProcessProtectionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteReplacementVariableFormatter;
import com.suncode.pwfl.audit.formatter.DeleteSearchedDocumentsFormatter;
import com.suncode.pwfl.audit.formatter.DeleteSystemProtectionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteVariableDistinguishFormatter;
import com.suncode.pwfl.audit.formatter.DeleteViewFormatter;
import com.suncode.pwfl.audit.formatter.DeleteViewProtectionFormatter;
import com.suncode.pwfl.audit.formatter.DeviceFormatter;
import com.suncode.pwfl.audit.formatter.DirectoryFormatter;
import com.suncode.pwfl.audit.formatter.EditDeactivatedUserFormatter;
import com.suncode.pwfl.audit.formatter.EditDocumentIndexesFormatter;
import com.suncode.pwfl.audit.formatter.EditDocumentTemplateFormatter;
import com.suncode.pwfl.audit.formatter.EditScheduledTaskFormatter;
import com.suncode.pwfl.audit.formatter.EditUserNotificationsFormatter;
import com.suncode.pwfl.audit.formatter.ExternalCalendarFormatter;
import com.suncode.pwfl.audit.formatter.FavouriteElementFormatter;
import com.suncode.pwfl.audit.formatter.FileActionsFormatter;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.formatter.GoogleApiAuthenticationFormatter;
import com.suncode.pwfl.audit.formatter.ImportTranslationsFormatter;
import com.suncode.pwfl.audit.formatter.InstallModuleFormatter;
import com.suncode.pwfl.audit.formatter.ManageScheduledTaskFormatter;
import com.suncode.pwfl.audit.formatter.ManageUserPositionFormatter;
import com.suncode.pwfl.audit.formatter.MappingFormatter;
import com.suncode.pwfl.audit.formatter.MicrosoftGraphApiAuthenticationFormatter;
import com.suncode.pwfl.audit.formatter.OneDriveApplicationFormatter;
import com.suncode.pwfl.audit.formatter.OpenActivitiesFormatter;
import com.suncode.pwfl.audit.formatter.OpenActivityFormatter;
import com.suncode.pwfl.audit.formatter.PasswordPolicyUpdateFormatter;
import com.suncode.pwfl.audit.formatter.PasswordProfileAssignedFormatter;
import com.suncode.pwfl.audit.formatter.PermissionsFormatter;
import com.suncode.pwfl.audit.formatter.PluginUpdateFormatter;
import com.suncode.pwfl.audit.formatter.PlusProxyApplicationFormatter;
import com.suncode.pwfl.audit.formatter.ProcessCalendarFormatter;
import com.suncode.pwfl.audit.formatter.ProcessCalendarShareFormatter;
import com.suncode.pwfl.audit.formatter.ProcessDetailsFormatter;
import com.suncode.pwfl.audit.formatter.RemoveSystemParameterFormatter;
import com.suncode.pwfl.audit.formatter.RunViewFormatter;
import com.suncode.pwfl.audit.formatter.SaveActivityFormatter;
import com.suncode.pwfl.audit.formatter.SaveProcessSettingsFormatter;
import com.suncode.pwfl.audit.formatter.SaveViewFormatter;
import com.suncode.pwfl.audit.formatter.SearchDocClassFormatter;
import com.suncode.pwfl.audit.formatter.SearchFormatter;
import com.suncode.pwfl.audit.formatter.SearchLinkFormatter;
import com.suncode.pwfl.audit.formatter.SearchOrgUnitFormatter;
import com.suncode.pwfl.audit.formatter.SearchPositionFormatter;
import com.suncode.pwfl.audit.formatter.SendEmailFormatter;
import com.suncode.pwfl.audit.formatter.StatsFormatter;
import com.suncode.pwfl.audit.formatter.UpdateDocClassFormatter;
import com.suncode.pwfl.audit.formatter.UpdateDocumentClassAssociationFormatter;
import com.suncode.pwfl.audit.formatter.UpdateEmailConfigurationFormatter;
import com.suncode.pwfl.audit.formatter.UpdateOAuth2ClientFormatter;
import com.suncode.pwfl.audit.formatter.UpdateUserPanelFormatter;
import com.suncode.pwfl.audit.formatter.UpdateUserSettingsFormatter;
import com.suncode.pwfl.audit.formatter.UpdateUserViewFormatter;
import com.suncode.pwfl.audit.formatter.UploadFileFromArchiveFormatter;
import com.suncode.pwfl.audit.formatter.UploadFileFromProcessFormatter;
import com.suncode.pwfl.audit.formatter.UpsertDocClassActionFormatter;
import com.suncode.pwfl.audit.formatter.UpsertDocClassIndexFormatter;
import com.suncode.pwfl.audit.formatter.UpsertDocClassProtectionFormatter;
import com.suncode.pwfl.audit.formatter.UpsertDocumentViewFormatter;
import com.suncode.pwfl.audit.formatter.UpsertLinkIndexFormatter;
import com.suncode.pwfl.audit.formatter.UpsertLinkProtectionFormatter;
import com.suncode.pwfl.audit.formatter.UpsertNotificationFormatter;
import com.suncode.pwfl.audit.formatter.UpsertPanelParameterFormatter;
import com.suncode.pwfl.audit.formatter.UpsertProcessProtectionFormatter;
import com.suncode.pwfl.audit.formatter.UpsertVariableDistinguishFormatter;
import com.suncode.pwfl.audit.formatter.UserCalendarEventFormatter;
import com.suncode.pwfl.audit.formatter.UserCalendarEventInvitationFormatter;
import com.suncode.pwfl.audit.formatter.UserCalendarFormatter;
import com.suncode.pwfl.audit.formatter.UserCalendarShareFormatter;
import com.suncode.pwfl.audit.formatter.UserSearchFormatter;
import com.suncode.pwfl.audit.formatter.ValidateActivityFormatter;
import com.suncode.pwfl.audit.formatter.ViewCalendarFormatter;
import com.suncode.pwfl.audit.formatter.ViewCalendarShareFormatter;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.audit.util.AuditTypes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AuditDetails
implements AuditDetailsHandler {
    private final AuditTypes auditType;

    public AuditDetails(AuditTypes auditType) {
        this.auditType = auditType;
    }

    @Override
    public List<AuditParam> decompose(String auditParams) {
        String[] tab;
        ArrayList<AuditParam> decomposition = new ArrayList<AuditParam>();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String key : tab = StringUtils.defaultString((String)auditParams).split("@AUDIT_PARAM@")) {
            String[] equalSplit = key.split("=", -1);
            map.put(equalSplit[0], AuditTools.joinTabValue(equalSplit, "="));
        }
        LinkedHashMap<String, String> formattedMap = switch (this.auditType) {
            case AuditTypes.AUDIT_OPEN_ACTIVITY -> {
                Formatter formatter = new OpenActivityFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SAVE_ACTIVITY -> {
                Formatter formatter = new SaveActivityFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ACCEPT_ACTIVITY -> {
                Formatter formatter = new AcceptActivityFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_VALIDATE_ACTIVITY -> {
                Formatter formatter = new ValidateActivityFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SEARCH_DOCCLASS -> {
                Formatter formatter = new SearchDocClassFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SEARCH_LINK -> {
                Formatter formatter = new SearchLinkFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_SYSTEM_PROTECTION -> {
                Formatter formatter = new AddSystemProtectionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_SYSTEM_PROTECTION -> {
                Formatter formatter = new DeleteSystemProtectionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_DELEGATION, AuditTypes.AUDIT_DELETE_DELEGATION, AuditTypes.AUDIT_ADD_DELEGATION_BY_USER, AuditTypes.AUDIT_DELETE_DELEGATION_BY_USER, AuditTypes.AUDIT_UPDATE_DELEGATION, AuditTypes.AUDIT_UPDATE_DELEGATION_BY_USER, AuditTypes.AUDIT_SEARCH_SUBSTITUTIONS -> {
                Formatter formatter = new AddOrDeleteDelegationFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_STATS -> {
                Formatter formatter = new StatsFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPLOAD_FILE_FROM_PROCESS -> {
                Formatter formatter = new UploadFileFromProcessFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPLOAD_FILE_FROM_ARCHIVE -> {
                Formatter formatter = new UploadFileFromArchiveFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CHECKOUT_FILE_FROM_ARCHIVE, AuditTypes.AUDIT_UNDO_CHECKOUT_FILE_FROM_ARCHIVE, AuditTypes.AUDIT_DELETE_DOCUMENT_FROM_ARCHIVE -> {
                Formatter formatter = new FileActionsFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CHECKOUT_FILE_FROM_PROCESS -> {
                Formatter formatter = new CheckoutFileFromProcessFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_PROCESS -> {
                Formatter formatter = new CreateProcessFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_DOCCLASS -> {
                Formatter formatter = new AddDocClassFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_ROLE_TO_POSITION, AuditTypes.AUDIT_DELETE_ROLE_FROM_POSITION -> {
                Formatter formatter = new AddAndDeleteRolesFromPositionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_NOTIFICATION, AuditTypes.AUDIT_EDIT_NOTIFICATION -> {
                Formatter formatter = new UpsertNotificationFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_DOCUMENT_TEMPLATE -> {
                Formatter formatter = new AddDocumentTemplateFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_EDIT_DOCUMENT_TEMPLATE -> {
                Formatter formatter = new EditDocumentTemplateFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_DOCUMENT_TEMPLATE -> {
                Formatter formatter = new DeleteDocumentTemplateFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_DOC_CLASS_INDEX, AuditTypes.AUDIT_UPDATE_DOC_CLASS_INDEX -> {
                Formatter formatter = new UpsertDocClassIndexFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_DOC_CLASS_INDEX -> {
                Formatter formatter = new DeleteDocClassIndexFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_DOC_CLASS_ACTION, AuditTypes.AUDIT_EDIT_DOC_CLASS_ACTION -> {
                Formatter formatter = new UpsertDocClassActionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_DOC_CLASS_ACTION -> {
                Formatter formatter = new DeleteDocClassActionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_PROCESS_PROTECTION, AuditTypes.AUDIT_EDIT_PROCESS_PROTECTION -> {
                Formatter formatter = new UpsertProcessProtectionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_PROCESS_PROTECTION -> {
                Formatter formatter = new DeleteProcessProtectionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_INSTALL_MODULE -> {
                Formatter formatter = new InstallModuleFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_COMMENT_TO_ACTIVITY -> {
                Formatter formatter = new AddCommentToActivityFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_DOCUMENT_FROM_PROCESS -> {
                Formatter formatter = new DeleteDocumentFromProcessFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_PROCESS_DETAILS -> {
                Formatter formatter = new ProcessDetailsFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ACTIVITY_DETAILS -> {
                Formatter formatter = new ActivityDetailsFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CHECK_IN_DOCUMENT_FROM_ACTIVITY, AuditTypes.AUDIT_CHECK_IN_DOCUMENT_FROM_ARCHIVE -> {
                Formatter formatter = new CheckInDocumentFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_EDIT_DOCUMENT_INDEXES -> {
                Formatter formatter = new EditDocumentIndexesFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SUSPEND_ACTIVITY, AuditTypes.AUDIT_ABORT_ACTIVITY, AuditTypes.AUDIT_RESUME_ACTIVITY, AuditTypes.AUDIT_RESUME_ACTIVITIES, AuditTypes.AUDIT_SUSPEND_ACTIVITIES -> {
                Formatter formatter = new ActivityStateChangeFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SAVE_VIEW -> {
                Formatter formatter = new SaveViewFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_VIEW -> {
                Formatter formatter = new DeleteViewFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ACCEPT_MANY_ACTIVITIES -> {
                Formatter formatter = new AcceptManyActivitiesFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_DOCUMENT_VIEW, AuditTypes.AUDIT_EDIT_DOCUMENT_VIEW -> {
                Formatter formatter = new UpsertDocumentViewFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_DOCUMENT_VIEW -> {
                Formatter formatter = new DeleteDocumentViewFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SAVE_PROCESS_SETTINGS -> {
                Formatter formatter = new SaveProcessSettingsFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_DOC_CLASS_PROTECTION, AuditTypes.AUDIT_EDIT_DOC_CLASS_PROTECTION -> {
                Formatter formatter = new UpsertDocClassProtectionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_DOC_CLASS_PROTECTION -> {
                Formatter formatter = new DeleteDocClassProtectionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_DOC_CLASS_PROTECTION_CONDITION -> {
                Formatter formatter = new AddDocClassProtectionConditionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_DOC_CLASS_PROTECTION_CONDITION -> {
                Formatter formatter = new DeleteDocClassProtectionConditionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_LINK_INDEX, AuditTypes.AUDIT_EDIT_LINK_INDEX -> {
                Formatter formatter = new UpsertLinkIndexFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_LINK_INDEX -> {
                Formatter formatter = new DeleteLinkIndexFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_LINK_CONNECTION, AuditTypes.AUDIT_EDIT_LINK_CONNECTION -> {
                Formatter formatter = new AddLinkConnectionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_LINK_CONNECTION -> {
                Formatter formatter = new DeleteLinkConnectionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_LINK_PROTECTION, AuditTypes.AUDIT_EDIT_LINK_PROTECTION -> {
                Formatter formatter = new UpsertLinkProtectionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_LINK_PROTECTION -> {
                Formatter formatter = new DeleteLinkProtectionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_EDIT_USER_NOTIFICATIONS -> {
                Formatter formatter = new EditUserNotificationsFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_VIEW_REPORT, AuditTypes.AUDIT_ADD_SQL_QUERY_REPORT -> {
                Formatter formatter = new AddViewSqlReportFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_MODULE_RIGHT, AuditTypes.AUDIT_DELETE_MODULE_RIGHT -> {
                Formatter formatter = new AddDeleteModuleRightFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_SCHEDULED_TASK -> {
                Formatter formatter = new AddScheduledTaskFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPDATE_SCHEDULED_TASK -> {
                Formatter formatter = new EditScheduledTaskFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_SCHEDULED_TASK, AuditTypes.AUDIT_RUN_SCHEDULED_TASK, AuditTypes.AUDIT_MANUAL_RUN_SCHEDULED_TASK, AuditTypes.AUDIT_STOP_SCHEDULED_TASK -> {
                Formatter formatter = new ManageScheduledTaskFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_SEARCHED_DOCUMENTS -> {
                Formatter formatter = new DeleteSearchedDocumentsFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DEACTIVATE_USER -> {
                Formatter formatter = new DeactivateUserFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_EDIT_DEACTIVATED_USER -> {
                Formatter formatter = new EditDeactivatedUserFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SYSTEM_PARAMETER_CREATED -> {
                Formatter formatter = new CreateSystemParameterFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SYSTEM_PARAMETER_CHANGED -> {
                Formatter formatter = new ChangeSystemParameterFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SYSTEM_PARAMETER_REMOVED -> {
                Formatter formatter = new RemoveSystemParameterFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SEND_EMAIL -> {
                Formatter formatter = new SendEmailFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_PROCESSES, AuditTypes.AUDIT_DELETE_PROCESS, AuditTypes.AUDIT_ABORT_PROCESSES, AuditTypes.AUDIT_ABORT_PROCESS -> {
                Formatter formatter = new DeleteOrAbortProcessFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPDATE_PLUGIN -> {
                Formatter formatter = new PluginUpdateFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPDATE_DOCCLASS -> {
                Formatter formatter = new UpdateDocClassFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_PASSWORD_PROFILE_CHANGED, AuditTypes.AUDIT_PASSWORD_PROFILE_CREATED -> {
                Formatter formatter = new PasswordPolicyUpdateFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADMIN_ADD_DOC_CLASS_ASSOCIATION -> {
                Formatter formatter = new AddDocumentClassAssociationFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADMIN_UPDATE_DOC_CLASS_ASSOCIATION -> {
                Formatter formatter = new UpdateDocumentClassAssociationFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADMIN_DELETE_DOC_CLASS_ASSOCIATION -> {
                Formatter formatter = new DeleteDocumentClassAssociationFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPDATE_POSITION -> {
                Formatter formatter = new ChangePositionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_POSITION -> {
                Formatter formatter = new AddPositionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_POSITION -> {
                Formatter formatter = new DeletePositionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SEARCH_POSITION -> {
                Formatter formatter = new SearchPositionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPDATE_ORG_UNIT -> {
                Formatter formatter = new ChangeOrgUnitFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_ORG_UNIT, AuditTypes.AUDIT_ADD_ORG_UNIT -> {
                Formatter formatter = new AddAndDeleteOrgUnitFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SEARCH_ORG_UNIT -> {
                Formatter formatter = new SearchOrgUnitFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_USER -> {
                Formatter formatter = new AddUserFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ASSIGN_POSITION_TO_USER, AuditTypes.AUDIT_DETACH_POSITION -> {
                Formatter formatter = new ManageUserPositionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPDATE_LINK, AuditTypes.AUDIT_ADD_LINK, AuditTypes.AUDIT_DELETE_LINK -> {
                Formatter formatter = new BaseLinkFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_PASSWORD_PROFILES_ASSIGNED -> {
                Formatter formatter = new PasswordProfileAssignedFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPDATE_LDAP_SERVER -> {
                Formatter formatter = new ChangeDomainFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_REPLACEMENT_VARIABLE -> {
                Formatter formatter = new AddReplacementVariableFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_REPLACEMENT_VARIABLE -> {
                Formatter formatter = new DeleteReplacementVariableFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CHANGE_REPLACEMENT_VAR_TYPE -> {
                Formatter formatter = new ChangeReplacementVariableTypeFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_EMAIL_CONFIGURATION -> {
                Formatter formatter = new AddEmailConfigurationFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPDATE_EMAIL_CONFIGURATION -> {
                Formatter formatter = new UpdateEmailConfigurationFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPDATE_OAUTH2_CLIENT -> {
                Formatter formatter = new UpdateOAuth2ClientFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_PANEL_PARAMETER, AuditTypes.AUDIT_UPDATE_PANEL_PARAMETER -> {
                Formatter formatter = new UpsertPanelParameterFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_PANEL_PARAMETER -> {
                Formatter formatter = new DeletePanelParameterFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPDATE_PANEL -> {
                Formatter formatter = new UpdateUserPanelFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPDATE_VIEW -> {
                Formatter formatter = new UpdateUserViewFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_VIEW_PROTECTION -> {
                Formatter formatter = new AddViewProtectionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_EDIT_VIEW_PROTECTION -> {
                Formatter formatter = new ChangeViewProtectionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_VIEW_PROTECTION -> {
                Formatter formatter = new DeleteViewProtectionFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_VARIABLE_DISTINGUISH -> {
                Formatter formatter = new DeleteVariableDistinguishFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_VARIABLE_DISTINGUISH, AuditTypes.AUDIT_UPDATE_VARIABLE_DISTINGUISH -> {
                Formatter formatter = new UpsertVariableDistinguishFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_MULTIPLE_VARIABLE_DISTINGUISH -> {
                Formatter formatter = new AddMultipleVariableDistinguishFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_ALL_VARIABLE_DISTINGUISH -> {
                Formatter formatter = new DeleteAllVariableDistinguishFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_DELETE_DEVICE, AuditTypes.AUDIT_ADD_DEVICE, AuditTypes.AUDIT_UPDATE_DEVICE -> {
                Formatter formatter = new DeviceFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_DIRECTORY, AuditTypes.AUDIT_DELETE_DIRECTORY, AuditTypes.AUDIT_UPDATE_DIRECTORY -> {
                Formatter formatter = new DirectoryFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_CALENDAR_SHARE, AuditTypes.AUDIT_DELETE_CALENDAR_SHARE -> {
                Formatter formatter = new CalendarShareFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SEARCH_PROCESSES_OR_ACTIVITIES -> {
                Formatter formatter = new SearchFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SEARCH_USERS -> {
                Formatter formatter = new UserSearchFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_SEARCH_MAPPINGS -> {
                Formatter formatter = new MappingFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_RUN_VIEW -> {
                Formatter formatter = new RunViewFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_OPEN_USER_ACTIVITIES, AuditTypes.AUDIT_OPEN_USER_FINISHED_ACTIVITIES -> {
                Formatter formatter = new OpenActivitiesFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPDATE_USER_SETTINGS, AuditTypes.AUDIT_UPDATE_USER_SETTINGS_GLOBAL -> {
                Formatter formatter = new UpdateUserSettingsFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ACTIVATE_TRIAL_LICENSE -> {
                Formatter formatter = new ActivateTrialLicenseFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_IMPORT_TRANSLATIONS -> {
                Formatter formatter = new ImportTranslationsFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_FAVOURITE_ELEMENT, AuditTypes.AUDIT_UPDATE_FAVOURITE_ELEMENT -> {
                Formatter formatter = new FavouriteElementFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CHANGE_SELECTED_TASK_FIELDS, AuditTypes.AUDIT_CHANGE_SELECTED_PROCESS_FIELDS, AuditTypes.AUDIT_CHANGE_SELECTED_PROCESS_HEADER_FIELDS -> {
                Formatter formatter = new DefaultProcessFieldsFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_BASIC_AUTHENTICATION_CONFIGURATION, AuditTypes.AUDIT_DELETE_BASIC_AUTHENTICATION_CONFIGURATION -> {
                Formatter formatter = new BasicAuthenticationConfigurationFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_UPDATE_BASIC_AUTHENTICATION_CONFIGURATION -> {
                Formatter formatter = new BasicAuthenticationConfigurationUpdateFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_MICROSOFT_GRAPH_API_AUTHENTICATION, AuditTypes.AUDIT_UPDATE_MICROSOFT_GRAPH_API_AUTHENTICATION, AuditTypes.AUDIT_DELETE_MICROSOFT_GRAPH_API_AUTHENTICATION -> {
                Formatter formatter = new MicrosoftGraphApiAuthenticationFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_GOOGLE_API_AUTHENTICATION, AuditTypes.AUDIT_UPDATE_GOOGLE_API_AUTHENTICATION, AuditTypes.AUDIT_DELETE_GOOGLE_API_AUTHENTICATION -> {
                Formatter formatter = new GoogleApiAuthenticationFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_ONE_DRIVE_APPLICATION, AuditTypes.AUDIT_UPDATE_ONE_DRIVE_APPLICATION, AuditTypes.AUDIT_DELETE_ONE_DRIVE_APPLICATION -> {
                Formatter formatter = new OneDriveApplicationFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_CALENDAR_RESOURCE, AuditTypes.AUDIT_DELETE_CALENDAR_RESOURCE, AuditTypes.AUDIT_UPDATE_CALENDAR_RESOURCE -> {
                Formatter formatter = new CalendarResourceFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_CALENDAR_RESOURCE_GROUP, AuditTypes.AUDIT_DELETE_CALENDAR_RESOURCE_GROUP, AuditTypes.AUDIT_UPDATE_CALENDAR_RESOURCE_GROUP -> {
                Formatter formatter = new CalendarResourceGroupFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_CALENDAR_RESOURCE_SHARE, AuditTypes.AUDIT_CREATE_CALENDAR_RESOURCE_GROUP_SHARE, AuditTypes.AUDIT_DELETE_CALENDAR_RESOURCE_SHARE, AuditTypes.AUDIT_DELETE_CALENDAR_RESOURCE_GROUP_SHARE -> {
                Formatter formatter = new CalendarResourceShareFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_EXTERNAL_CALENDAR, AuditTypes.AUDIT_UPDATE_EXTERNAL_CALENDAR, AuditTypes.AUDIT_DELETE_EXTERNAL_CALENDAR, AuditTypes.AUDIT_SYNC_EXTERNAL_CALENDAR -> {
                Formatter formatter = new ExternalCalendarFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_USER_CALENDAR, AuditTypes.AUDIT_UPDATE_USER_CALENDAR, AuditTypes.AUDIT_DELETE_USER_CALENDAR, AuditTypes.AUDIT_GENERATE_USER_CALENDAR_SHARE_LINK, AuditTypes.AUDIT_DELETE_USER_CALENDAR_SHARE_LINK -> {
                Formatter formatter = new UserCalendarFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_USER_CALENDAR_EVENT, AuditTypes.AUDIT_UPDATE_USER_CALENDAR_EVENT, AuditTypes.AUDIT_DELETE_USER_CALENDAR_EVENT, AuditTypes.AUDIT_HIDE_USER_CALENDAR_EVENT -> {
                Formatter formatter = new UserCalendarEventFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ACCEPT_USER_CALENDAR_EVENT_INVITATION, AuditTypes.AUDIT_DECLINE_USER_CALENDAR_EVENT_INVITATION -> {
                Formatter formatter = new UserCalendarEventInvitationFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CANCEL_USER_CALENDAR_EVENTS_BY_RESOURCE -> {
                Formatter formatter = new CancelUserCalendarEventsFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_USER_CALENDAR_SHARE, AuditTypes.AUDIT_DELETE_USER_CALENDAR_SHARE -> {
                Formatter formatter = new UserCalendarShareFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_VIEW_CALENDAR, AuditTypes.AUDIT_UPDATE_VIEW_CALENDAR, AuditTypes.AUDIT_DELETE_VIEW_CALENDAR, AuditTypes.AUDIT_GENERATE_VIEW_CALENDAR_SHARE_LINK, AuditTypes.AUDIT_DELETE_VIEW_CALENDAR_SHARE_LINK -> {
                Formatter formatter = new ViewCalendarFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_VIEW_CALENDAR_SHARE, AuditTypes.AUDIT_DELETE_VIEW_CALENDAR_SHARE -> {
                Formatter formatter = new ViewCalendarShareFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_PROCESS_CALENDAR, AuditTypes.AUDIT_UPDATE_PROCESS_CALENDAR, AuditTypes.AUDIT_DELETE_PROCESS_CALENDAR, AuditTypes.AUDIT_GENERATE_PROCESS_CALENDAR_SHARE_LINK, AuditTypes.AUDIT_DELETE_PROCESS_CALENDAR_SHARE_LINK -> {
                Formatter formatter = new ProcessCalendarFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_PROCESS_CALENDAR_SHARE, AuditTypes.AUDIT_DELETE_PROCESS_CALENDAR_SHARE -> {
                Formatter formatter = new ProcessCalendarShareFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_ADD_PERMISSIONS, AuditTypes.AUDIT_EDIT_PERMISSIONS, AuditTypes.AUDIT_DELETE_PERMISSIONS -> {
                Formatter formatter = new PermissionsFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_PLUS_PROXY_APPLICATION, AuditTypes.AUDIT_UPDATE_PLUS_PROXY_APPLICATION, AuditTypes.AUDIT_DELETE_PLUS_PROXY_APPLICATION -> {
                Formatter formatter = new PlusProxyApplicationFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_CREATE_DATASOURCE, AuditTypes.AUDIT_UPDATE_DATASOURCE, AuditTypes.AUDIT_DELETE_DATASOURCE -> {
                Formatter formatter = new DataSourceFormatter();
                yield formatter.format(map);
            }
            case AuditTypes.AUDIT_IMPORT_DATASOURCE -> {
                Formatter formatter = new DataSourceImportFormatter();
                yield formatter.format(map);
            }
            default -> {
                Formatter formatter = new Formatter();
                map = formatter.format(map);
                yield new LinkedHashMap<String, String>(map);
            }
        };
        for (String key : formattedMap.keySet()) {
            AuditParam param = new AuditParam();
            param.setParamName(key);
            param.setParamNameToTranslate("AUDIT_PARAM_".concat(key.toUpperCase()));
            param.setParamValue(formattedMap.get(key));
            decomposition.add(param);
        }
        return decomposition;
    }
}

