/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.listener;

import com.google.common.base.Preconditions;
import com.plusmpm.database.DataBaseValidator;
import com.plusmpm.util.PlusWorkflow;
import com.plusmpm.util.SessionManager;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.framework.core.OsgiPluginFramework;
import com.suncode.pwfl.SystemContext;
import com.suncode.pwfl.SystemVersion;
import com.suncode.pwfl.administration.configuration.Category;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameterFinder;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.config.Config;
import com.suncode.pwfl.config.Environment;
import com.suncode.pwfl.config.database.DatabaseConfig;
import com.suncode.pwfl.config.home.HomeDirectory;
import com.suncode.pwfl.config.home.HomeDirectoryResult;
import com.suncode.pwfl.config.home.UnsupportedHomeDirectoryException;
import com.suncode.pwfl.config.logging.Log4jConfigurationSource;
import com.suncode.pwfl.config.logging.Log4jConfigurer;
import com.suncode.pwfl.core.PlusworkflowPostStartupHook;
import com.suncode.pwfl.core.PlusworkflowStartupHook;
import com.suncode.pwfl.dashboard.internal.gadget.SystemGadgetsGenerator;
import com.suncode.pwfl.database.ConnectionPoolFactory;
import com.suncode.pwfl.database.DataSourceFactory;
import com.suncode.pwfl.database.LockMasterDataSourceFactory;
import com.suncode.pwfl.database.PluginDataSourceFactory;
import com.suncode.pwfl.database.XpdlDataSourceFactory;
import com.suncode.pwfl.database.dods.SharkDataSourceConfig;
import com.suncode.pwfl.database.embedded.EmbeddedDatabase;
import com.suncode.pwfl.database.shark.SharkDatabaseProperties;
import com.suncode.pwfl.elastic.service.ElasticQueueService;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.ExperimentalConfiguration;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.hook.HookRegistry;
import com.suncode.pwfl.maintenance.MaintenanceMode;
import com.suncode.pwfl.upgrade.SystemUpgrader;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.security.PlusWorkflowCookieProcessor;
import com.suncode.pwfl.webapp.maintenance.StartupProxy;
import com.suncode.pwfl.webapp.tomcat.proxy.ProxyRegistration;
import com.suncode.pwfl.workflow.form.documentview.actions.SystemDocumentViewActionsGenerator;
import com.zaxxer.hikari.HikariDataSource;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javax.annotation.Nullable;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.catalina.Context;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.tomcat.util.http.CookieProcessor;
import org.enhydra.shark.Shark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.NativeDetector;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class PlusWorkflowListener
implements ServletContextListener,
HttpSessionListener {
    private static final Logger log = LoggerFactory.getLogger(PlusWorkflowListener.class);
    public static Optional<EmbeddedDatabase> embeddedDatabase = Optional.empty();
    private final PlusWorkflowContextLoader contextLoader = new PlusWorkflowContextLoader();
    @Nullable
    private ProxyRegistration startupProxy;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        try {
            Date startDate = this.getJvmStartDate();
            SystemContext.init((ServletContext)servletContext);
            this.overwriteDefaultParameterNameDiscoverer();
            HomeDirectoryResult homeDirectoryResult = HomeDirectory.resolve((ServletContext)servletContext);
            HomeDirectory homeDirectory = homeDirectoryResult.homeDirectory();
            if (!homeDirectory.isExplicitlySet()) {
                throw new UnsupportedHomeDirectoryException("Home directory must be explicitly set - legacy working mode is not supported.");
            }
            Config config = Config.read((HomeDirectory)homeDirectory);
            Environment.setupEnvironment((Config)config);
            Log4jConfigurationSource log4jSource = Log4jConfigurer.configure((HomeDirectory)homeDirectory);
            log.info("Resolved home directory to [{}] using {} strategy", (Object)homeDirectoryResult.getPath(), (Object)homeDirectoryResult.getStrategy());
            switch (log4jSource) {
                case HOME_DIRECTORY: {
                    log.info("Configured Log4j using file in Home Directory [{}]", (Object)homeDirectory.getLocation());
                    break;
                }
                case DEFAULT_XML: {
                    log.info("Configured Log4j using default log4j2.xml file");
                }
            }
            ExperimentalConfiguration.initialize();
            this.configureStartupProxy(servletContext);
            this.overwriteStrutsConfigLoad();
            this.overwriteDocx4jAlpha();
            this.setCookieProcessor(servletContext);
            Properties sharkConfig = this.setupHomeDir(servletContext, config);
            new DataBaseValidator().validateDatabase();
            SystemUpgrader.setSharkConf((Properties)sharkConfig);
            SystemUpgrader upgrader = new SystemUpgrader();
            upgrader.upgradePreInitialize();
            Shark.configure((Properties)sharkConfig);
            XpdlPackageManager.getInstance().getXmlInterface().resolveAndCachePackagesFileNames();
            this.contextLoader.init(config, servletContext);
            Log4jConfigurer.loadSavedLoggersConfiguration();
            PlusWorkflow.configure((ServletContext)event.getServletContext(), (Config)config);
            this.overwriteSharkProperties();
            HookRegistry hookRehistry = (HookRegistry)SpringContext.getBean(HookRegistry.class);
            ((PlusworkflowStartupHook)hookRehistry.invoke(PlusworkflowStartupHook.class)).startup();
            ((SystemGadgetsGenerator)SpringContext.getBean(SystemGadgetsGenerator.class)).generate();
            ((ElasticQueueService)SpringContext.getBean(ElasticQueueService.class)).onSystemConfigured();
            ((OsgiPluginFramework)SpringContext.getBean(OsgiPluginFramework.class)).startOsgiContainer();
            upgrader.upgradePostInitialize();
            ((SystemDocumentViewActionsGenerator)SpringContext.getBean(SystemDocumentViewActionsGenerator.class)).generate();
            ((PlusworkflowPostStartupHook)hookRehistry.invoke(PlusworkflowPostStartupHook.class)).postStartup();
            ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_SYSTEM_STARTED).success(true).started(startDate).stopped(new Date()).params(Map.of("version", SystemVersion.getVersionIdentifier(), "maintenance", MaintenanceMode.isActive())).build().log();
        }
        catch (Throwable e) {
            log.error("PlusWorkflow failed to start", e);
            throw e;
        }
    }

    private void configureStartupProxy(ServletContext servletContext) {
        if (ExperimentalConfiguration.getExperimentalInstance().hasFeature(ExperimentalFeature.MAINTENANCE_MODE)) {
            this.startupProxy = StartupProxy.attach(servletContext).orElse(null);
        } else {
            log.info("Startup proxy disabled via {} experimental feature", (Object)ExperimentalFeature.MAINTENANCE_MODE.name());
        }
    }

    private Date getJvmStartDate() {
        Long currentDateInMillis = new Date().getTime();
        Long jvmStartDateInMillis = ManagementFactory.getRuntimeMXBean().getStartTime();
        if (jvmStartDateInMillis <= currentDateInMillis) {
            return new Date(jvmStartDateInMillis);
        }
        return new Date(currentDateInMillis);
    }

    private void overwriteDocx4jAlpha() {
        ClassPool classPool = ClassPool.getDefault();
        ClassClassPath classPath = new ClassClassPath(this.getClass());
        classPool.insertClassPath((ClassPath)classPath);
        classPool.importPackage("java.awt.image");
        classPool.importPackage("org.apache.xmlgraphics.image");
        classPool.importPackage("org.apache.fop.pdf");
        CtClass imageRenderedAdapter = classPool.get("org.apache.fop.render.pdf.ImageRenderedAdapter");
        CtMethod setSetUpMethod = imageRenderedAdapter.getDeclaredMethod("setup");
        setSetUpMethod.setBody("{RenderedImage ri = getImage().getRenderedImage(); super.setup($1); ColorModel orgcm = ri.getColorModel(); if (orgcm.hasAlpha() && orgcm.getTransparency() == ColorModel.TRANSLUCENT) { $1.getProfile().verifyTransparencyAllowed(image.getInfo().getOriginalURI()); Raster raster = GraphicsUtil.getAlphaRaster(ri); if (raster != null) { AlphaRasterImage alphaImage = new AlphaRasterImage(\"Mask:\" + getKey(), raster); this.softMask = $1.addImage(null, alphaImage).makeReference(); } }}");
        imageRenderedAdapter.toClass();
    }

    private void overwriteStrutsConfigLoad() {
        ClassPool classPool = ClassPool.getDefault();
        ClassClassPath classPath = new ClassClassPath(this.getClass());
        classPool.insertClassPath((ClassPath)classPath);
        CtClass formPropertyConfigClass = classPool.get("org.apache.struts.config.FormPropertyConfig");
        CtMethod setSizeMethod = formPropertyConfigClass.getDeclaredMethod("setSize");
        setSizeMethod.insertBefore("if( $1 == -1){ $1 = com.suncode.pwfl.administration.configuration.SystemProperties.getLong( com.suncode.pwfl.administration.configuration.DefinedSystemParameter.STRUTS_FORM_SIZE ).intValue(); }");
        formPropertyConfigClass.toClass();
    }

    private void overwriteDefaultParameterNameDiscoverer() {
        if (NativeDetector.inNativeImage()) {
            return;
        }
        ClassPool classPool = ClassPool.getDefault();
        ClassClassPath classPath = new ClassClassPath(this.getClass());
        classPool.insertClassPath((ClassPath)classPath);
        CtClass defaultParameterNameDiscovererClass = classPool.get("org.springframework.core.DefaultParameterNameDiscoverer");
        CtConstructor constructor = defaultParameterNameDiscovererClass.getConstructor("()V");
        constructor.insertAfter("this.addDiscoverer(new com.plusmpm.listener.util.LocalVariableTableParameterNameDiscoverer());");
        defaultParameterNameDiscovererClass.toClass();
    }

    private void setCookieProcessor(ServletContext servletContext) {
        Context context = ((StandardRoot)servletContext.getAttribute("org.apache.catalina.resources")).getContext();
        context.setCookieProcessor((CookieProcessor)new PlusWorkflowCookieProcessor());
    }

    private Properties setupHomeDir(ServletContext servletContext, Config config) {
        Preconditions.checkState((servletContext.getInitParameter("Shark_Conf") == null ? 1 : 0) != 0, (Object)"Init parameter [Shark_Conf] defined in web.xml should be removed when using home-directory based configuration");
        Preconditions.checkState((!this.getLegacyDataSource().isPresent() ? 1 : 0) != 0, (Object)"Resource [PlusWorkflowResource] defined in context.xml and web.xml should be removed when using home-directory based configuration");
        DatabaseConfig dbConfig = this.getDatabaseConfig(config);
        this.logDatabaseHomeConfigConnectionInfo(dbConfig);
        DataSource systemDataSource = ConnectionPoolFactory.createSystemDataSource((DatabaseConfig)dbConfig);
        DataSourceFactory.bindDataSource((DataSource)systemDataSource);
        DataSource pluginDataSource = ConnectionPoolFactory.createPluginDataSource((DatabaseConfig)dbConfig);
        PluginDataSourceFactory.bindDataSource((DataSource)pluginDataSource);
        DataSource xpdlDataSource = ConnectionPoolFactory.createXpdlDataSource((DatabaseConfig)dbConfig);
        XpdlDataSourceFactory.bindDataSource((DataSource)xpdlDataSource);
        DataSource lockMasterDataSource = ConnectionPoolFactory.createLockMasterDataSource((DatabaseConfig)dbConfig);
        LockMasterDataSourceFactory.bindDataSource((DataSource)lockMasterDataSource);
        SharkDataSourceConfig.bindDatabaseConfig((DatabaseConfig)dbConfig);
        Properties sharkConf = PropertiesLoaderUtils.loadAllProperties((String)"config-defaults/PlusWorkflow.conf");
        Path plusworkflowConf = config.getHomeDirectory().path("config/PlusWorkflow.conf");
        if (Files.exists(plusworkflowConf, new LinkOption[0])) {
            log.info("Found [config/PlusWorkflow.conf] - overwriting shark properties");
            PropertiesLoaderUtils.fillProperties((Properties)sharkConf, (Resource)new FileSystemResource(plusworkflowConf.toFile()));
        }
        SharkDatabaseProperties.init((Properties)sharkConf, (DatabaseConfig)dbConfig);
        sharkConf.replaceAll((BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(key, value) -> SystemPropertyUtils.resolvePlaceholders((String)((String)value))));
        this.overwriteSharkRootDirProp(plusworkflowConf.toFile(), sharkConf);
        Experimental experimental = ExperimentalConfiguration.getExperimentalInstance();
        if (experimental.hasFeature(ExperimentalFeature.DISTRIBUTED_XML_INTERFACE)) {
            log.info("Selecting xml interface implementation: DistributedXmlInterface");
            sharkConf.put("XmlInterfaceClassName", "com.suncode.pwfl.xpdl.DistributedXmlInterface");
        } else {
            log.info("Selecting xml interface implementation: LocalXmlInterface");
        }
        return sharkConf;
    }

    private void logDatabaseHomeConfigConnectionInfo(DatabaseConfig config) {
        DatabaseConfig.Connection connection = config.connection();
        log.info("Database driverClassName: {}", (Object)connection.getType().driverClassName());
        log.info("Database url: {}", (Object)connection.getConnectionUrl());
        log.info("Database username: {}", (Object)connection.getUsername());
    }

    private void overwriteSharkRootDirProp(File sharkConf, Properties sharkProperties) {
        try {
            sharkProperties.put("RootDirectoryPath", sharkConf.getParentFile().getCanonicalPath());
        }
        catch (Exception ex) {
            sharkProperties.put("RootDirectoryPath", sharkConf.getParentFile().getAbsolutePath());
        }
    }

    private DatabaseConfig getDatabaseConfig(Config config) {
        DatabaseConfig databaseConfig = config.getDatabaseProperties().getDatabaseConfig();
        if (databaseConfig.getEmbedded().isEnabled() && databaseConfig.connection().getName() == null) {
            EmbeddedDatabase embedded = new EmbeddedDatabase(config.getHomeDirectory());
            embeddedDatabase = Optional.of(embedded);
            return databaseConfig.withConnection(embedded.start());
        }
        return databaseConfig;
    }

    private Optional<DataSource> getLegacyDataSource() throws NamingException {
        try {
            InitialContext initialContext = new InitialContext();
            return Optional.of((DataSource)initialContext.lookup("java:comp/env/PlusWorkflowResource"));
        }
        catch (NameNotFoundException e) {
            return Optional.empty();
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_SYSTEM_STOPPED).success(true).build().log();
        }
        catch (Exception ex) {
            log.error("Cannot log system stopped audit: " + ex.getMessage());
        }
        PlusWorkflow.shutdown();
        this.contextLoader.closeWebApplicationContext(event.getServletContext());
        DataSourceFactory.findDataSource().ifPresent(this::closeDataSource);
        PluginDataSourceFactory.findDataSource().ifPresent(this::closeDataSource);
        XpdlDataSourceFactory.findDataSource().ifPresent(this::closeDataSource);
        LockMasterDataSourceFactory.findDataSource().ifPresent(this::closeDataSource);
        embeddedDatabase.ifPresent(EmbeddedDatabase::stop);
        if (this.startupProxy != null) {
            this.startupProxy.remove();
        }
    }

    private void closeDataSource(DataSource dataSource) {
        if (dataSource instanceof HikariDataSource) {
            HikariDataSource hikariDataSource = (HikariDataSource)dataSource;
            hikariDataSource.close();
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        SessionManager.onCreate((HttpSessionEvent)event);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        SessionManager.onDestroy((HttpSessionEvent)event);
    }

    private void overwriteSharkProperties() throws Exception {
        Properties configuredProperties = this.getSharkProperties();
        SystemParameterFinder finder = FinderFactory.getSystemParameterFinder();
        List categories = finder.getAllCategories(new String[]{"systemParameters"});
        for (Category category : categories) {
            for (SystemParameter parameter : category.getSystemParameters()) {
                Object value = parameter.getValue();
                if (value == null) continue;
                configuredProperties.replace(parameter.getKey(), value.toString());
            }
        }
        String supportedLanguages = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.SUPPORTED_LANGUAGES);
        configuredProperties.put(DefinedSystemParameter.SUPPORTED_LANGUAGES.getKey(), supportedLanguages);
        String adminPassword = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.ADMIN_PASSWORD);
        configuredProperties.put("DEFAULT_ADMINISTRATOR_PASSWORD", adminPassword);
        configuredProperties.put("SchedulerToolAgent.sharkPassword", adminPassword);
    }

    private Properties getSharkProperties() throws NoSuchFieldException, IllegalAccessException {
        Shark shark = Shark.getInstance();
        Field properties = shark.getClass().getDeclaredField("properties");
        properties.setAccessible(true);
        return (Properties)properties.get(shark);
    }

    private static class PlusWorkflowContextLoader
    extends ContextLoader {
        Config config;

        private PlusWorkflowContextLoader() {
        }

        WebApplicationContext init(Config config, ServletContext servletContext) {
            this.config = config;
            return this.initWebApplicationContext(servletContext);
        }

        protected WebApplicationContext createWebApplicationContext(ServletContext sc) {
            XmlWebApplicationContext applicationContext = new XmlWebApplicationContext(){

                protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws BeansException, IOException {
                    super.loadBeanDefinitions(beanFactory);
                    beanFactory.registerSingleton("plusworkflowConfig", (Object)config);
                    beanFactory.registerResolvableDependency(HomeDirectory.class, (Object)config.getHomeDirectory());
                }
            };
            return applicationContext;
        }
    }
}

