/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.simulation.duplicated.context.form;

import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.ShaKey;
import com.suncode.pwfl.workflow.form.FormBuilderService;
import com.suncode.pwfl.workflow.form.action.ActionUIFragment;
import com.suncode.pwfl.workflow.simulation.duplicated.Simulation;
import com.suncode.pwfl.workflow.simulation.duplicated.SimulationUtils;
import com.suncode.pwfl.workflow.simulation.duplicated.context.activity.SimulationActivityService;
import com.suncode.pwfl.workflow.simulation.duplicated.context.form.SimulationFormService;
import com.suncode.pwfl.workflow.simulation.duplicated.exception.SimulationException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.enhydra.shark.xpdl.elements.Package;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;

public class SimulationFormServiceImpl
implements SimulationFormService {
    @Autowired
    private ShaKey processKeyGenerator;
    @Autowired
    private SimulationActivityService activityService;
    @Autowired
    private TransactionWrapper transactionWrapper;
    @Autowired
    private FormBuilderService formBuilderService;
    @Autowired
    private SharkTransactionManager sharkTransactionManager;
    @Autowired
    private SimpMessagingTemplate messagingTemplate;

    public void decorateRequestWithForm(HttpServletRequest request, String processId, String activityId) {
        try {
            HttpSession session = request.getSession(false);
            this.transactionWrapper.doInSneakySharkTransaction(sharkTx -> {
                Package pack = XpdlPackageManager.getInstance().getPackageByProcessId(sharkTx, processId);
                String packageId = pack.getId();
                AdminMisc adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
                String processDefId = adminMisc.getProcessDefinitionId(sharkTx, processId);
                String activityDefId = adminMisc.getActivityDefinitionId(sharkTx, processId, activityId);
                WfProcess wfProcess = SharkFunctions.getWfProcess((SharkTransaction)sharkTx, (String)processId);
                this.activityService.claimActivity(processId, activityId);
                request.setAttribute("simulationId", (Object)Simulation.getInstance().getId());
                request.setAttribute("realusername", (Object)"Administrator PlusWorkflow");
                request.setAttribute("taskusername", (Object)"admin");
                request.setAttribute("originaltaskusername", (Object)"admin");
                request.setAttribute("message", (Object)"");
                request.setAttribute("processId", (Object)processId);
                request.setAttribute("activityId", (Object)activityId);
                String processRightKey = this.processKeyGenerator.get(processId);
                request.setAttribute("processRightKey", (Object)processRightKey);
                String rawProcessName = wfProcess.name(sharkTx);
                String processName = PackageTranslationHelper.getProcessName((String)packageId, (String)processDefId, (String)rawProcessName);
                String activityName = PackageTranslationHelper.getActivityName((String)packageId, (String)processDefId, (String)activityDefId);
                request.setAttribute("processDefId", (Object)processDefId);
                request.setAttribute("activityDefId", (Object)activityDefId);
                request.setAttribute("processName", (Object)processName);
                request.setAttribute("activityName", (Object)activityName);
                request.setAttribute("packageId", (Object)packageId);
                request.setAttribute("packageVersion", (Object)pack.getInternalVersion());
                String suncodeForm = this.formBuilderService.build(processId, activityId, "admin", session.getId(), ActionUIFragment.FORM, processRightKey, null, null);
                request.setAttribute("suncodeForm", (Object)suncodeForm);
                request.setAttribute("devMode", (Object)Boolean.valueOf(request.getParameter("devMode")));
                request.setAttribute("redirect", (Object)StringUtils.defaultString((String)request.getParameter("redirect")));
                request.setAttribute("activeTab", (Object)"ShowWorkListAction.do");
                request.setAttribute("systemParameters", (Object)"[]");
                request.setAttribute("systemContext", null);
                request.setAttribute("activityDelegations", (Object)"[]");
                FormEnterPayload formEnterPayload = new FormEnterPayload(activityDefId, activityId);
                this.messagingTemplate.convertAndSend((Object)"/topic/simulation/onActivityDefEnter", (Object)formEnterPayload);
            });
        }
        catch (Exception e) {
            throw new SimulationException("Failed to display simulation activity form", (Throwable)e);
        }
    }

    public void decorateRequestWithActivityDetails(HttpServletRequest request, String processId, String activityId) {
        try {
            HttpSession session = request.getSession(false);
            this.transactionWrapper.doInSneakySharkTransaction(sharkTx -> {
                Package pack = XpdlPackageManager.getInstance().getPackageByProcessId(sharkTx, processId);
                String packageId = pack.getId();
                AdminMisc adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
                String processDefId = adminMisc.getProcessDefinitionId(sharkTx, processId);
                String activityDefId = adminMisc.getActivityDefinitionId(sharkTx, processId, activityId);
                WfProcess wfProcess = SharkFunctions.getWfProcess((SharkTransaction)sharkTx, (String)processId);
                request.setAttribute("simulationId", (Object)Simulation.getInstance().getId());
                request.setAttribute("realusername", (Object)"Administrator PlusWorkflow");
                request.setAttribute("taskusername", (Object)"admin");
                request.setAttribute("originaltaskusername", (Object)"admin");
                request.setAttribute("message", (Object)"");
                request.setAttribute("processId", (Object)processId);
                request.setAttribute("activityId", (Object)activityId);
                String processRightKey = this.processKeyGenerator.get(processId);
                request.setAttribute("processRightKey", (Object)processRightKey);
                String rawProcessName = wfProcess.name(sharkTx);
                String processName = PackageTranslationHelper.getProcessName((String)packageId, (String)processDefId, (String)rawProcessName);
                String activityName = PackageTranslationHelper.getActivityName((String)packageId, (String)processDefId, (String)activityDefId);
                request.setAttribute("processDefId", (Object)processDefId);
                request.setAttribute("activityDefId", (Object)activityDefId);
                request.setAttribute("processName", (Object)processName);
                request.setAttribute("activityName", (Object)activityName);
                request.setAttribute("packageId", (Object)packageId);
                request.setAttribute("packageVersion", (Object)pack.getInternalVersion());
                String suncodeForm = this.formBuilderService.build(processId, activityId, "admin", session.getId(), ActionUIFragment.HISTORY, processRightKey, null, null);
                request.setAttribute("suncodeForm", (Object)suncodeForm);
                request.setAttribute("devMode", (Object)Boolean.valueOf(request.getParameter("devMode")));
                request.setAttribute("activeTab", (Object)"ShowWorkListAction.do");
                request.setAttribute("systemParameters", (Object)"[]");
                request.setAttribute("systemContext", null);
                request.setAttribute("activityDelegations", (Object)"[]");
                request.setAttribute("allowPlusNextEdit", (Object)false);
            });
        }
        catch (Exception e) {
            throw new SimulationException("Failed to display simulation activity details", (Throwable)e);
        }
    }

    public void decorateRequestWithProcessHistory(HttpServletRequest request, String processId) {
        try {
            HttpSession session = request.getSession(false);
            this.transactionWrapper.doInSneakySharkTransaction(sharkTx -> {
                Package pack = XpdlPackageManager.getInstance().getPackageByProcessId(sharkTx, processId);
                String packageId = pack.getId();
                AdminMisc adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
                String processDefId = adminMisc.getProcessDefinitionId(sharkTx, processId);
                WfProcess wfProcess = SharkFunctions.getWfProcess((SharkTransaction)sharkTx, (String)processId);
                request.setAttribute("simulationId", (Object)Simulation.getInstance().getId());
                request.setAttribute("processId", (Object)processId);
                String processRightKey = this.processKeyGenerator.get(processId);
                request.setAttribute("key", (Object)processRightKey);
                String rawProcessName = wfProcess.name(sharkTx);
                String processName = PackageTranslationHelper.getProcessName((String)packageId, (String)processDefId, (String)rawProcessName);
                request.setAttribute("processDefId", (Object)processDefId);
                request.setAttribute("processName", (Object)processName);
                session.setAttribute("procName", (Object)processName);
                request.setAttribute("devMode", (Object)Boolean.valueOf(request.getParameter("devMode")));
                request.setAttribute("activeTab", (Object)"ShowWorkListAction.do");
                request.setAttribute("simulationAvailable", (Object)false);
            });
        }
        catch (Exception e) {
            throw new SimulationException("Failed to display simulation activity details", (Throwable)e);
        }
    }

    static {
        SimulationUtils.assertIsInSimulation();
    }

    public record FormEnterPayload(String activityDefId, String activityId) {
    }
}

