/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.tomcat.proxy;

import com.suncode.pwfl.webapp.tomcat.proxy.RequestContext;
import com.suncode.pwfl.webapp.tomcat.proxy.RequestHandler;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import lombok.NonNull;
import org.apache.catalina.Context;
import org.apache.catalina.WebResource;
import org.apache.catalina.connector.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StaticResourceHandler
implements RequestHandler {
    private static final Logger log = LoggerFactory.getLogger(StaticResourceHandler.class);
    @NonNull
    private final Context appContext;

    @Override
    public void handle(RequestContext requestContext) throws IOException {
        Response response = requestContext.response();
        String uri = requestContext.requestUriWithinApplication();
        WebResource resource = this.appContext.getResources().getResource(uri);
        if (!resource.exists()) {
            log.debug("Resource not found: {}", (Object)uri);
            response.setStatus(404);
            return;
        }
        if (!resource.isFile()) {
            log.debug("Resource is not a file: {}", (Object)uri);
            response.setStatus(403);
            return;
        }
        this.setHeaders(response, resource);
        StaticResourceHandler.serve(response, resource);
    }

    private static void serve(Response response, WebResource resource) throws IOException {
        resource.getInputStream().transferTo((OutputStream)response.getOutputStream());
        response.getOutputStream().flush();
    }

    private void setHeaders(Response response, WebResource resource) {
        String contentType = resource.getMimeType();
        if (contentType == null) {
            contentType = this.appContext.getServletContext().getMimeType(resource.getName());
            resource.setMimeType(contentType);
        }
        response.setContentLengthLong(resource.getContentLength());
        response.setHeader("ETag", resource.getETag());
        response.setHeader("Last-Modified", resource.getLastModifiedHttp());
        response.setHeader("Cache-Control", "max-age=600, must-revalidate");
    }

    public String toString() {
        return "static-resources-handler@%s" + String.valueOf(this.appContext);
    }

    @ConstructorProperties(value={"appContext"})
    public StaticResourceHandler(@NonNull Context appContext) {
        if (appContext == null) {
            throw new NullPointerException("appContext is marked non-null but is null");
        }
        this.appContext = appContext;
    }
}

