/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.maintenance;

import com.plusmpm.util.PlusWorkflow;
import com.suncode.pwfl.translation.PropertiesTranslator;
import com.suncode.pwfl.webapp.maintenance.MaintenanceStatus;
import com.suncode.pwfl.webapp.maintenance.Templates;
import com.suncode.pwfl.webapp.tomcat.proxy.ProxyRegistration;
import com.suncode.pwfl.webapp.tomcat.proxy.ProxyValve;
import com.suncode.pwfl.webapp.tomcat.proxy.RequestContext;
import com.suncode.pwfl.webapp.tomcat.proxy.RequestHandler;
import com.suncode.pwfl.webapp.tomcat.proxy.RoutingContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;
import org.apache.catalina.LifecycleState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

public class StartupProxy {
    private static final Logger log = LoggerFactory.getLogger(StartupProxy.class);

    public static Optional<ProxyRegistration> attach(ServletContext servletContext) {
        Templates templates = Templates.getInstance(servletContext);
        log.debug("Attaching startup proxy");
        return StartupProxy.proxy(templates).attach(servletContext);
    }

    private static ProxyValve.ProxyBuilder proxy(Templates templates) {
        return ProxyValve.builder().proxyIf(StartupProxy.webApplicationIsStarting()).resources("/resources/**").resources("/style/**").GET("/**", templates.maintenancePage(), 503, StartupProxy.statusSupplier()).otherwise(RequestHandler.sendStatus(503));
    }

    @NonNull
    private static Predicate<RoutingContext> webApplicationIsStarting() {
        return routingContext -> switch (routingContext.appContext().getState()) {
            case LifecycleState.INITIALIZING, LifecycleState.STARTING_PREP, LifecycleState.STARTING -> true;
            default -> !PlusWorkflow.isSystemConfigured();
        };
    }

    @NonNull
    private static Function<RequestContext, MaintenanceStatus> statusSupplier() {
        AcceptHeaderLocaleResolver localeResolver = new AcceptHeaderLocaleResolver();
        PropertiesTranslator translator = StartupProxy.defaultTranslator();
        return requestContext -> new MaintenanceStatus(translator.getMessage("system_starting", localeResolver.resolveLocale((HttpServletRequest)requestContext.request())));
    }

    @NonNull
    private static PropertiesTranslator defaultTranslator() {
        PropertiesTranslator translator = new PropertiesTranslator();
        translator.setBasenames(new String[]{"classpath:com/plusmpm/i18n/messages"});
        translator.setResourceLoader((ResourceLoader)new DefaultResourceLoader(StartupProxy.class.getClassLoader()));
        return translator;
    }

    private StartupProxy() {
    }
}

