/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.filter;

import com.suncode.pwfl.util.Exceptions;
import com.suncode.pwfl.web.filter.urllist.UrlListItem;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class UrlSecurityFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(UrlSecurityFilter.class);
    private static final List<String> REDIRECT_KEYS = new ArrayList<String>(Arrays.asList("redirect", "redirectUrl"));
    private static final List<UrlListItem> WHITELIST = new ArrayList<UrlListItem>(){
        {
            this.add(new UrlListItem("/com.plusmpm.servlet.notifications.NotificationConfigurationGridServlet.customServlet", Arrays.asList("records"), new ArrayList<HttpMethod>()));
            this.add(new UrlListItem("/com.plusmpm.servlet.authorization.UserAuthorizationServlet.customServlet", Arrays.asList("password"), new ArrayList<HttpMethod>()));
            this.add(new UrlListItem("/Login.do", Arrays.asList("password"), new ArrayList<HttpMethod>()));
            this.add(new UrlListItem("/api/datasources/*", new ArrayList<String>(), Arrays.asList(HttpMethod.POST, HttpMethod.PUT)));
        }
    };

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean correctUrl = true;
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            Map<String, List<String>> parameters = this.decodeParameters(request.getParameterMap());
            if (MapUtils.isNotEmpty(parameters)) {
                if (!this.areRequestParamsAcceptable((HttpServletRequest)request, parameters)) {
                    correctUrl = false;
                } else {
                    List<String> redirectUrls = this.getRedirects(parameters);
                    if (this.unacceptableCharactersExists(redirectUrls)) {
                        correctUrl = false;
                    } else if (CollectionUtils.isNotEmpty(redirectUrls = this.getRedirectsWithProtocol(redirectUrls))) {
                        String domain = req.getServerName().replace("www.", "");
                        boolean bl = correctUrl = !this.unacceptableRedirectsExists(redirectUrls, domain);
                    }
                }
            }
        }
        if (!correctUrl) {
            ((HttpServletResponse)response).setStatus(400);
            response.getWriter().write("Access Denied ");
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean areRequestParamsAcceptable(HttpServletRequest request, Map<String, List<String>> parameters) {
        String requestPath = this.getRequestPath(request);
        UrlListItem urlListItem = this.getWhiteListItem(requestPath);
        List<String> whiteListAllowedParameters = urlListItem != null && this.isHttpMethodOnWhiteList(request.getMethod(), urlListItem.getMethods()) ? urlListItem.getParameters() : null;
        return !this.unacceptableCharactersExistsInParameters(parameters, whiteListAllowedParameters);
    }

    private String getRequestPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        return servletPath.equals("/api") ? servletPath + request.getPathInfo() : servletPath;
    }

    private List<String> getRedirects(Map<String, List<String>> parameters) {
        ArrayList<String> redirects = new ArrayList<String>();
        for (String redirectKey : REDIRECT_KEYS) {
            List<String> redirectsInParam = parameters.get(redirectKey);
            if (redirectsInParam == null) continue;
            redirects.addAll(redirectsInParam);
        }
        return redirects;
    }

    private List<String> getRedirectsWithProtocol(List<String> redirectUrls) {
        if (CollectionUtils.isNotEmpty(redirectUrls)) {
            redirectUrls = redirectUrls.stream().filter(param -> param.contains("//") || param.contains(":") || param.contains("/\\")).collect(Collectors.toList());
        }
        return redirectUrls;
    }

    private boolean unacceptableCharactersExists(List<String> redirectUrls) {
        return redirectUrls.stream().anyMatch(r -> r.matches(".*['].*"));
    }

    private boolean unacceptableRedirectsExists(List<String> redirectUrls, String serverDomain) throws MalformedURLException {
        boolean unacceptableRedExists = false;
        for (String redirect : redirectUrls) {
            if (this.itsHttpOrHttpsProtocol(redirect).booleanValue()) {
                String redirectDomain = new URL(redirect).getHost().replaceAll("^[Ww]{3}\\.", "");
                if (serverDomain.equalsIgnoreCase(redirectDomain)) continue;
                unacceptableRedExists = true;
                break;
            }
            unacceptableRedExists = true;
            break;
        }
        return unacceptableRedExists;
    }

    private Boolean itsHttpOrHttpsProtocol(String redirectUrl) {
        URL url;
        try {
            url = new URL(redirectUrl);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return StringUtils.containsIgnoreCase((CharSequence)url.getProtocol(), (CharSequence)"http") || StringUtils.containsIgnoreCase((CharSequence)url.getProtocol(), (CharSequence)"https");
    }

    private Map<String, List<String>> decodeParameters(Map<String, String[]> parameterMap) throws UnsupportedEncodingException {
        HashMap<String, List<String>> decodeParams = new HashMap<String, List<String>>();
        for (Map.Entry<String, String[]> param : parameterMap.entrySet()) {
            decodeParams.put(param.getKey(), new ArrayList());
            for (String val : param.getValue()) {
                String decodeParam = (String)Exceptions.silent(() -> StringEscapeUtils.escapeJava((String)URLDecoder.decode(val, "UTF-8").replace("\\", "/")), () -> val);
                ((List)decodeParams.get(param.getKey())).add(decodeParam);
            }
        }
        return decodeParams;
    }

    private UrlListItem getWhiteListItem(String url) {
        return WHITELIST.stream().filter(item -> this.isUrlOnWhitelist(item.getUrl(), url)).findFirst().orElse(null);
    }

    private boolean isUrlOnWhitelist(String whitelistUrl, String url) {
        return whitelistUrl.endsWith("*") ? url.contains(whitelistUrl.substring(0, whitelistUrl.length() - 1)) : url.equals(whitelistUrl);
    }

    private boolean isHttpMethodOnWhiteList(String method, List<HttpMethod> whiteListMethods) {
        return whiteListMethods.isEmpty() || whiteListMethods.contains(HttpMethod.valueOf((String)method));
    }

    private boolean unacceptableCharactersExistsInParameters(Map<String, List<String>> parameters, List<String> whiteListAllowedParameters) {
        boolean unacceptableCharsExists = false;
        for (Map.Entry<String, List<String>> param : parameters.entrySet()) {
            if (this.isParameterOnWhiteList(param.getKey(), whiteListAllowedParameters) || !param.getValue().stream().anyMatch(p -> p.contains("${"))) continue;
            unacceptableCharsExists = true;
            break;
        }
        return unacceptableCharsExists;
    }

    private boolean isParameterOnWhiteList(String param, List<String> whiteListAllowedParameters) {
        return whiteListAllowedParameters != null && (whiteListAllowedParameters.contains(param) || whiteListAllowedParameters.isEmpty());
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

