/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.xpdl;

import com.plusmpm.i18n.I18N;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.workflow.xpdl.XpdlDifferences;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"xpdlDifference"})
public class XpdlDifferencesController {
    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseBody
    public void downloadDifferences(@RequestParam String packageId, @RequestParam String basePackageVersion, @RequestParam(required=false) String newPackageVersion, HttpServletResponse response) throws IOException {
        I18N oMessage = new I18N(LocaleContextHolder.getLocale());
        XpdlDifferences diff = new XpdlDifferences(oMessage);
        String differences = diff.getAllXpdlDifferences(packageId, basePackageVersion, this.getNewPackageVersion(packageId, newPackageVersion));
        response.setContentType("text/plain");
        response.setHeader("Content-Disposition", "attachment; filename=\"changes.txt\"");
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)response.getOutputStream());){
            outputStreamWriter.write(differences);
        }
    }

    private String getNewPackageVersion(String packageId, String newPackageVersion) {
        if (StringUtils.isNotBlank((CharSequence)newPackageVersion)) {
            return newPackageVersion;
        }
        return XpdlPackageManager.getInstance().getPackage(packageId).getInternalVersion();
    }
}

