/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginControl;
import com.suncode.plugin.framework.PluginFramework;
import com.suncode.plugin.framework.PluginKeyConflictException;
import com.suncode.plugin.framework.PluginUnresolvedDependenciesException;
import com.suncode.plugin.framework.admin.Analyzer;
import com.suncode.plugin.framework.config.InvalidPluginException;
import com.suncode.plugin.framework.config.PluginDescriptorReader;
import com.suncode.plugin.framework.license.LicenseService;
import com.suncode.plugin.framework.license.PluginLicense;
import com.suncode.plugin.framework.license.trial.TrialLicenseService;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.controller.api.plugin.LicenseInstallationResult;
import com.suncode.pwfl.web.controller.api.plugin.PluginInstallationResult;
import com.suncode.pwfl.web.controller.api.plugin.ValidationView;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.EntityRestResult;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.plugin.PluginInformation;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.glowroot.agent.api.Glowroot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/plugins"}, produces={"application/json"})
public class PluginController {
    private static final Logger log = LoggerFactory.getLogger(PluginController.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final PluginFramework framework;
    private final PluginControl pluginControl;
    private final LicenseService licenseService;
    private final TrialLicenseService trialLicenseService;
    private final PluginDescriptorReader pluginDescriptorReader;
    private final Analyzer analyzer;
    private final MessageHelperBean messageHelper;
    private final AuthorizationHelper authorizationHelper;

    @RequestMapping(value={"/install"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String installPluginOrLicense(@RequestParam MultipartFile file) throws IOException, InvalidPluginException {
        String fileType;
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        switch (fileType = FilenameUtils.getExtension((String)file.getOriginalFilename())) {
            case "jar": {
                return this.installPlugin(file);
            }
            case "lic": {
                return this.installLicense(file);
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String installPlugin(MultipartFile file) throws IOException, InvalidPluginException {
        File temp = File.createTempFile(file.getOriginalFilename(), ".tmp");
        try {
            file.transferTo(temp);
            String pluginKey = this.pluginDescriptorReader.readDescriptor(temp).getKey();
            Plugin plugin = this.framework.getPlugin(pluginKey);
            Boolean alreadyInstalled = plugin != null;
            if (alreadyInstalled.booleanValue()) {
                log.info("Plugin {} is already installed", (Object)pluginKey);
            } else {
                plugin = this.framework.installPlugin(temp);
            }
            this.installPluginAudit(true, (Map<String, Object>)ImmutableMap.of((Object)"pluginId", (Object)plugin.getKey()));
            PluginInstallationResult result = new PluginInstallationResult(true);
            result.setEntity(PluginInformation.convertFrom(plugin, this.licenseService, this.trialLicenseService));
            result.setAlreadyInstalled(alreadyInstalled);
            String string = this.mapper.writeValueAsString((Object)result);
            return string;
        }
        catch (Exception ex) {
            this.installPluginAudit(false, new HashMap<String, Object>());
            log.error(ex.getMessage(), (Throwable)ex);
            EntityRestResult result = new EntityRestResult(false);
            result.setMessage(this.errorMessage(this.rootCause(ex)));
            String string = this.mapper.writeValueAsString((Object)result);
            return string;
        }
        finally {
            FileUtils.deleteQuietly((File)temp);
        }
    }

    private void installPluginAudit(boolean success, Map<String, Object> params) {
        RequestAttributes request = RequestContextHolder.getRequestAttributes();
        request.setAttribute("audit", (Object)AuditBuilder.getInstance().type(AuditTypes.AUDIT_INSTALL_PLUGIN).success(success).params(params).build(), 0);
    }

    private String installLicense(MultipartFile file) throws IOException {
        try {
            List pluginLicenses = this.licenseService.uploadLicense(file.getInputStream());
            this.successLicenseAudit(pluginLicenses);
            return this.mapper.writeValueAsString((Object)EntityRestResult.success((Object)new LicenseInstallationResult()));
        }
        catch (Exception ex) {
            this.failureLicenseAudit(file.getOriginalFilename());
            log.error(ex.getMessage(), (Throwable)ex);
            return this.mapper.writeValueAsString((Object)EntityRestResult.failure((Object)new LicenseInstallationResult(), (String)this.errorMessage(this.rootCause(ex))));
        }
    }

    private void successLicenseAudit(List<PluginLicense> pluginLicenses) {
        ArrayList audits = new ArrayList();
        pluginLicenses.forEach(license -> audits.add(AuditBuilder.getInstance().type(AuditTypes.AUDIT_INSTALL_PLUGIN_LICENSE).success(true).params(this.auditLicenseParameters((PluginLicense)license)).build()));
        RequestAttributes request = RequestContextHolder.getRequestAttributes();
        request.setAttribute("audits", audits, 0);
    }

    private void failureLicenseAudit(String fileName) {
        RequestAttributes request = RequestContextHolder.getRequestAttributes();
        request.setAttribute("audit", (Object)AuditBuilder.getInstance().type(AuditTypes.AUDIT_INSTALL_PLUGIN_LICENSE).success(false).params((Map)ImmutableMap.of((Object)"fileName", (Object)fileName)).build(), 0);
    }

    private Map<String, Object> auditLicenseParameters(PluginLicense license) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("pluginId", license.getPluginId());
        parameters.put("macAddress", this.valueString(license.getMacAddress()));
        parameters.put("expiredDate", this.valueDate(license.getExpiredDate()));
        return parameters;
    }

    private String valueString(Optional<String> value) {
        return value.isPresent() ? value.get() : "";
    }

    private String valueDate(Optional<LocalDate> value) {
        return value.isPresent() ? value.get().toString() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{key}/update"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> updatePlugin(@PathVariable String key, @RequestParam MultipartFile file, @RequestParam(required=false) boolean force) throws IOException, InvalidPluginException {
        EntityRestResult result;
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Plugin plugin = this.framework.getPlugin(key);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        if (plugin == null) {
            this.buildAudit(AuditTypes.AUDIT_UPDATE_PLUGIN, key, false, null);
            return new ResponseEntity((Object)this.mapper.writeValueAsString((Object)new EntityRestResult(false)), (HttpStatusCode)HttpStatus.OK);
        }
        auditParams.put("OLD_VERSION", plugin.getVersion());
        auditParams.put("UPDATE_TYPE", "manual");
        File temp = File.createTempFile(file.getOriginalFilename(), ".tmp");
        try {
            file.transferTo(temp);
            PluginControl.Operation update = this.pluginControl.update(key, temp);
            if (!force) {
                PluginControl.Validation validation = update.validate();
                if (!validation.isValid()) {
                    ResponseEntity responseEntity = new ResponseEntity((Object)this.mapper.writeValueAsString((Object)new ValidationView(validation)), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
                    return responseEntity;
                }
                update.start();
            } else {
                update.force();
            }
            auditParams.put("NEW_VERSION", plugin.getVersion());
            this.buildAudit(AuditTypes.AUDIT_UPDATE_PLUGIN, key, true, auditParams);
            result = new EntityRestResult(true);
            result.setEntity((Object)PluginInformation.convertFrom(plugin, this.licenseService, this.trialLicenseService));
            ResponseEntity responseEntity = new ResponseEntity((Object)this.mapper.writeValueAsString((Object)result), (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            result = new EntityRestResult(false);
            result.setMessage(this.errorMessage(this.rootCause(ex)));
            ResponseEntity responseEntity = new ResponseEntity((Object)this.mapper.writeValueAsString((Object)result), (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        finally {
            FileUtils.deleteQuietly((File)temp);
        }
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<PluginInformation> getPlugins() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        ArrayList<PluginInformation> result = new ArrayList<PluginInformation>();
        Collection plugins = this.framework.getPlugins();
        for (Plugin plugin : plugins) {
            result.add(PluginInformation.convertFrom(plugin, this.licenseService, this.trialLicenseService));
        }
        return result;
    }

    @RequestMapping(value={"/{key}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<PluginInformation> getPlugin(@PathVariable String key) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Plugin plugin = this.framework.getPlugin(key);
        if (plugin == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)PluginInformation.convertFrom(plugin, this.licenseService, this.trialLicenseService), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{key}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity deletePlugin(@PathVariable String key, @RequestParam(required=false) boolean force) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        try {
            ResponseEntity responseEntity = this.performOperation(force, () -> this.pluginControl.uninstall(key));
            this.buildAudit(AuditTypes.AUDIT_DELETE_PLUGIN, key, true, null);
            return responseEntity;
        }
        catch (Exception e) {
            this.buildAudit(AuditTypes.AUDIT_DELETE_PLUGIN, key, false, null);
            RestResult result = new RestResult();
            result.setSuccess(false);
            result.setMessage(this.errorMessage(this.rootCause(e)));
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
    }

    @RequestMapping(value={"/{key}/start"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity startPlugin(@PathVariable String key, @RequestParam(required=false) boolean force) {
        Glowroot.setTransactionType((String)"Plugin framework");
        Glowroot.setTransactionName((String)String.format("Manual plugin start [%s]", key));
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        try {
            ResponseEntity responseEntity = this.performOperation(force, () -> this.pluginControl.start(key));
            this.buildAudit(AuditTypes.AUDIT_START_PLUGIN, key, true, null);
            return responseEntity;
        }
        catch (Exception e) {
            this.buildAudit(AuditTypes.AUDIT_START_PLUGIN, key, false, null);
            RestResult result = new RestResult();
            result.setSuccess(false);
            result.setMessage(this.errorMessage(this.rootCause(e)));
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/debug"}, method={RequestMethod.GET})
    public ResponseEntity debug(@RequestParam(required=false) String plugin) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return new ResponseEntity(plugin == null || plugin.equalsIgnoreCase("host") ? this.analyzer.hostCapabilities() : this.analyzer.analyzeRequirements(Analyzer.include((String)plugin)), (HttpStatusCode)HttpStatus.OK);
    }

    private String errorMessage(Throwable exception) {
        return exception.getLocalizedMessage();
    }

    private Throwable rootCause(Throwable sourceException) {
        Throwable rootException = sourceException;
        while (rootException.getCause() != null) {
            rootException = rootException.getCause();
        }
        return rootException;
    }

    @RequestMapping(value={"/{key}/stop"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity stopPlugin(@PathVariable String key, @RequestParam(required=false) boolean force) {
        Glowroot.setTransactionType((String)"Plugin framework");
        Glowroot.setTransactionName((String)String.format("Manual plugin stop [%s]", key));
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        ResponseEntity responseEntity = this.performOperation(force, () -> this.pluginControl.stop(key));
        boolean success = responseEntity.getStatusCode() == HttpStatus.OK;
        this.buildAudit(AuditTypes.AUDIT_STOP_PLUGIN, key, success, null);
        return responseEntity;
    }

    private ResponseEntity performOperation(boolean force, Callable<PluginControl.Operation> operation) {
        RestResult result = new RestResult();
        PluginControl.Operation stop = operation.call();
        PluginControl.Validation validation = stop.validate();
        if (!validation.isLicenseResolved()) {
            return new ResponseEntity((Object)new ValidationView(validation), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        if (!force) {
            if (!validation.isValid()) {
                return new ResponseEntity((Object)new ValidationView(validation), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
            }
            stop.start();
        } else {
            stop.force();
        }
        result.setSuccess(true);
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }

    private void buildAudit(AuditTypes type, String pluginId, boolean success, Map<String, Object> extraParams) {
        RequestAttributes request = RequestContextHolder.getRequestAttributes();
        LinkedHashMap<String, Object> auditParams = new LinkedHashMap<String, Object>();
        auditParams.put("PLUGINID", pluginId);
        if (extraParams != null) {
            auditParams.putAll(extraParams);
        }
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(type);
        auditBuilder.params(auditParams);
        AuditWrapper auditWrapper = success ? auditBuilder.buildSuccess() : auditBuilder.buildFailure();
        request.setAttribute("audit", (Object)auditWrapper, 0);
    }

    @ExceptionHandler(value={PluginUnresolvedDependenciesException.class})
    @ResponseBody
    private RestResult handleConstraintException(PluginUnresolvedDependenciesException e) {
        log.info("Plugin has unresolved dependencies", (Throwable)e);
        return new RestResult(false, this.messageHelper.getMessage("plugin.error.unresolved"));
    }

    @ExceptionHandler(value={PluginKeyConflictException.class})
    @ResponseBody
    private RestResult handlePluginKeyException(PluginKeyConflictException e) {
        log.info("", (Throwable)e);
        return new RestResult(false, this.messageHelper.getMessage("plugin.error.keyconflict", new Object[]{e.getKey(), e.getConflictKey()}));
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public RestResult handleUnauthorizedRequests(NotFullRightsException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ConstructorProperties(value={"framework", "pluginControl", "licenseService", "trialLicenseService", "pluginDescriptorReader", "analyzer", "messageHelper", "authorizationHelper"})
    @Autowired
    public PluginController(PluginFramework framework, PluginControl pluginControl, LicenseService licenseService, TrialLicenseService trialLicenseService, PluginDescriptorReader pluginDescriptorReader, Analyzer analyzer, MessageHelperBean messageHelper, AuthorizationHelper authorizationHelper) {
        this.framework = framework;
        this.pluginControl = pluginControl;
        this.licenseService = licenseService;
        this.trialLicenseService = trialLicenseService;
        this.pluginDescriptorReader = pluginDescriptorReader;
        this.analyzer = analyzer;
        this.messageHelper = messageHelper;
        this.authorizationHelper = authorizationHelper;
    }
}

