/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.favourites;

import com.google.common.collect.ImmutableMap;
import com.suncode.plugin.dashboard.web.support.DynamicListResult;
import com.suncode.plugin.dashboard.web.support.RestResult;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.favourites.FavouriteElement;
import com.suncode.pwfl.favourites.FavouritesDefinitionCache;
import com.suncode.pwfl.favourites.FavouritesRegistry;
import com.suncode.pwfl.favourites.FavouritesService;
import com.suncode.pwfl.favourites.FavouritesSet;
import com.suncode.pwfl.favourites.exception.FavouritesUnauthorizedException;
import com.suncode.pwfl.favourites.support.UserHelper;
import com.suncode.pwfl.favourites.support.model.FavouriteModel;
import com.suncode.pwfl.favourites.support.model.FavouritesSetModel;
import com.suncode.pwfl.favourites.support.model.UpdateFavouriteModel;
import com.suncode.pwfl.favourites.support.model.UpdateFavouritesSetModel;
import com.suncode.pwfl.favourites.util.ModelConvertUtils;
import com.suncode.pwfl.favourites.view.Definition;
import com.suncode.pwfl.favourites.view.support.DefinitionsTreeNode;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.favourites.FavouritesPositionDto;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/favourites/rest"}, produces={"application/json"})
public class RestController {
    private static final Logger log = LoggerFactory.getLogger(RestController.class);
    @Autowired
    private UserHelper userHelper;
    @Autowired
    private FavouritesService favouritesService;
    @Autowired
    private FavouritesRegistry favouritesRegistry;
    @Autowired
    private FavouritesDefinitionCache favouritesDefinitionCache;

    @ResponseBody
    @RequestMapping(value={"/sets"}, method={RequestMethod.GET})
    public List<FavouritesSetModel> getUserSets() {
        this.favouritesDefinitionCache.invalidateAll();
        Collection sets = this.favouritesService.getUserFavourites(this.userHelper.getUser());
        return ModelConvertUtils.convertSet((Collection)sets, (FavouritesRegistry)this.favouritesRegistry);
    }

    @ResponseBody
    @RequestMapping(value={"/sets/simple"}, method={RequestMethod.GET})
    public DynamicListResult getSimpleSets() {
        DynamicListResult result = new DynamicListResult();
        User user = this.userHelper.getUser();
        for (FavouritesSet sets : this.favouritesService.getUserFavourites(user)) {
            DynamicListResult.DynamicListEntry set = new DynamicListResult.DynamicListEntry(sets.getName(), (Object)sets.getId());
            result.addEntry(set);
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/sets"}, method={RequestMethod.POST})
    public FavouritesSetModel createNewSet(@RequestBody FavouritesSetModel model) {
        String name = Jsoup.clean((String)model.getName().trim(), (Safelist)Safelist.basic());
        String description = Jsoup.clean((String)model.getDescription().trim(), (Safelist)Safelist.basic());
        FavouritesSet set = this.favouritesService.createFavouritesSet(name, description);
        return ModelConvertUtils.convertSet((FavouritesSet)set, (FavouritesRegistry)this.favouritesRegistry);
    }

    @ResponseBody
    @RequestMapping(value={"/sets/{id}"}, method={RequestMethod.PUT})
    public FavouritesSetModel updateSet(@RequestBody UpdateFavouritesSetModel model, @PathVariable Long id) {
        User user = this.userHelper.getUser();
        String name = Jsoup.clean((String)model.getName().trim(), (Safelist)Safelist.basic());
        String description = Jsoup.clean((String)model.getDescription().trim(), (Safelist)Safelist.basic());
        FavouritesSet set = new FavouritesSet(name, description, user);
        set.setId(id);
        for (UpdateFavouriteModel favourite : model.getFavourites()) {
            FavouriteElement element = ModelConvertUtils.convert((UpdateFavouriteModel)favourite);
            element.setSet(set);
            set.getElements().add(element);
        }
        this.favouritesService.updateFavourites(set);
        return ModelConvertUtils.convertSet((FavouritesSet)set, (FavouritesRegistry)this.favouritesRegistry);
    }

    @RequestMapping(value={"/sets/{id}/element"}, method={RequestMethod.POST})
    public ResponseEntity<?> addElement(@RequestBody UpdateFavouriteModel model, @PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_FAVOURITE_ELEMENT);
        LinkedHashMap<String, Object> auditParams = new LinkedHashMap<String, Object>();
        auditParams.put("FAVOURITE_SET_ID", id);
        try {
            FavouriteElement element = ModelConvertUtils.convert((UpdateFavouriteModel)model);
            this.fillElementAuditParams(element, auditParams);
            FavouritesSet favouritesSet = this.favouritesService.getFavourites(id);
            this.checkOwner(favouritesSet);
            Integer newPosition = favouritesSet.getElements().stream().mapToInt(FavouriteElement::getPosition).max().orElse(0) + 1;
            element.setPosition(newPosition);
            element.setSet(favouritesSet);
            favouritesSet.getElements().add(element);
            this.favouritesService.updateFavourites(favouritesSet);
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(value={"/sets/element"}, method={RequestMethod.PUT})
    public ResponseEntity<?> updateElement(@RequestBody UpdateFavouriteModel model, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_FAVOURITE_ELEMENT);
        LinkedHashMap<String, Object> auditParams = new LinkedHashMap<String, Object>();
        auditParams.put("FAVOURITE_SET_ID", model.getSet());
        try {
            FavouritesSet favouritesSet = this.favouritesService.getFavourites(model.getSet());
            this.checkOwner(favouritesSet);
            favouritesSet.getElements().removeIf(favouriteElement -> favouriteElement.getId().equals(model.getId()));
            FavouriteElement element = ModelConvertUtils.convert((UpdateFavouriteModel)model);
            element.setSet(favouritesSet);
            this.fillElementAuditParams(element, auditParams);
            favouritesSet.getElements().add(element);
            this.favouritesService.updateFavourites(favouritesSet);
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(value={"/sets/{setId}/element/{elementId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteElement(@PathVariable Long elementId, @PathVariable Long setId, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_FAVOURITE_ELEMENT);
        auditBuilder.params((Map)ImmutableMap.of((Object)"FAVOURITE_SET_ID", (Object)setId, (Object)"FAVOURITE_ELEMENT_ID", (Object)elementId));
        try {
            FavouritesSet favouritesSet = this.favouritesService.getFavourites(setId);
            this.checkOwner(favouritesSet);
            favouritesSet.getElements().removeIf(favouriteElement -> favouriteElement.getId().equals(elementId));
            this.favouritesService.updateFavourites(favouritesSet);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/sets/{id}"}, method={RequestMethod.DELETE})
    public void destroySet(@PathVariable Long id) {
        this.favouritesService.deleteFavourites(id);
    }

    @ResponseBody
    @RequestMapping(value={"/sets/{id}/favourites"}, method={RequestMethod.GET})
    public List<FavouriteModel> getSetFavourites(@PathVariable Long id) {
        this.favouritesDefinitionCache.invalidateAll();
        FavouritesSet set = this.favouritesService.getFavourites(id);
        Assert.notNull((Object)set, (String)("Could not find favourites set with id [" + id + "]"));
        return ModelConvertUtils.convert((Collection)set.getElements(), (FavouritesRegistry)this.favouritesRegistry);
    }

    @ResponseBody
    @RequestMapping(value={"/definitions"}, method={RequestMethod.GET})
    public List<Definition> getFavouriteDefinitions() {
        this.favouritesDefinitionCache.invalidateAll();
        return this.favouritesRegistry.getDefinitions();
    }

    @ResponseBody
    @RequestMapping(value={"/definition"}, method={RequestMethod.GET})
    public Definition getFavouriteDefinition(@RequestParam String type, @RequestParam(required=false) String parameter) {
        this.favouritesDefinitionCache.invalidateAll();
        return this.favouritesRegistry.getDefinition(type, parameter);
    }

    @ResponseBody
    @RequestMapping(value={"/definitions/tree"}, method={RequestMethod.GET})
    public List<DefinitionsTreeNode> getFavouriteDefinitionsTree() {
        this.favouritesDefinitionCache.invalidateAll();
        return this.favouritesRegistry.getDefinitionsTree();
    }

    @ResponseBody
    @RequestMapping(value={"/set/{setId}/positions"}, method={RequestMethod.POST})
    public void updatePositions(@PathVariable Long setId, @RequestBody List<FavouritesPositionDto> positions) {
        FavouritesSet set = this.favouritesService.getFavourites(setId);
        this.checkOwner(set);
        set.getElements().forEach(favouriteElement -> {
            Optional<FavouritesPositionDto> position = positions.stream().filter(favouritesPositionDto -> favouritesPositionDto.getId().equals(favouriteElement.getId())).findFirst();
            position.ifPresent(favouritesPositionDto -> favouriteElement.setPosition(favouritesPositionDto.getPosition()));
        });
        this.favouritesService.updateFavourites(set);
    }

    private void fillElementAuditParams(FavouriteElement element, Map<String, Object> auditParams) {
        auditParams.put("FAVOURITE_ELEMENT_ID", Objects.toString(element.getId(), ""));
        auditParams.put("FAVOURITE_ELEMENT_NAME", element.getName());
        auditParams.put("FAVOURITE_ELEMENT_TYPE", element.getType());
        auditParams.put("FAVOURITE_ELEMENT_PARAMETER", element.getParameter());
        auditParams.put("FAVOURITE_ELEMENT_COUNTED", element.isCounted());
    }

    private void checkOwner(FavouritesSet favouritesSet) {
        String userName = UserContext.current().getUser().getUserName();
        if (!favouritesSet.getUser().getUserName().equals(userName)) {
            throw new FavouritesUnauthorizedException();
        }
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={FavouritesUnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public RestResult handleFavouritesUnauthorizedException(FavouritesUnauthorizedException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }
}

