/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar.exception;

import com.suncode.pwfl.calendar.api.CalendarFacade;
import com.suncode.pwfl.calendar.exception.CalendarRuntimeException;
import com.suncode.pwfl.i18n.MessageHelperBean;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class CalendarExceptionMessageHelper {
    private static final String MESSAGE_FORMAT = "%s (%s \"%s\")";
    private final CalendarFacade calendarFacade;
    private final MessageHelperBean messageHelper;

    public CalendarExceptionMessageHelper(CalendarFacade calendarFacade, MessageHelperBean messageHelper) {
        this.calendarFacade = calendarFacade;
        this.messageHelper = messageHelper;
    }

    public String getCalendarExceptionMessage(CalendarRuntimeException calendarRuntimeException) {
        String translatedCalendarName = this.calendarFacade.getTranslatedCalendarName(calendarRuntimeException.getCalendar(), LocaleContextHolder.getLocale());
        return MESSAGE_FORMAT.formatted(calendarRuntimeException.getMessage(), this.messageHelper.getMessage("Kalendarz"), translatedCalendarName);
    }
}

