/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.maintenance;

import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.maintenance.MaintenanceMode;
import com.suncode.pwfl.util.JacksonFormats;
import com.suncode.pwfl.web.controller.api.administration.maintenance.MaintenanceStatusDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;

@RestController
@RequestMapping(value={"/maintenance"})
@Api(hidden=true)
public class MaintenanceController {
    private static final Logger log = LoggerFactory.getLogger(MaintenanceController.class);
    private final MaintenanceMode maintenanceMode;
    private final AuthorizationHelper authorizationHelper;

    @GetMapping(value={"/status"})
    public MaintenanceStatusDto status() {
        return new MaintenanceStatusDto(this.maintenanceMode.enabled(), this.maintenanceMode.scheduled().orElse(null));
    }

    @PostMapping(value={"/enable"})
    public MaintenanceStatusDto enable(@RequestBody EnableRequest request) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        if (request.time() != null) {
            this.audit(AuditTypes.AUDIT_MAINTENANCE_SCHEDULE, Map.of("time", request.time()));
            this.maintenanceMode.schedule(request.time(), request.message());
        } else {
            this.audit(AuditTypes.AUDIT_MAINTENANCE_ENABLE);
            this.maintenanceMode.enable(request.message());
        }
        return this.status();
    }

    @PostMapping(value={"/disable"})
    public MaintenanceStatusDto disable() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.audit(AuditTypes.AUDIT_MAINTENANCE_DISABLE);
        this.maintenanceMode.disable();
        return this.status();
    }

    @PostMapping(value={"/cancel"})
    public MaintenanceStatusDto cancel() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.audit(AuditTypes.AUDIT_MAINTENANCE_CANCEL_SCHEDULE);
        this.maintenanceMode.cancel();
        return this.status();
    }

    private void audit(AuditTypes type) {
        this.audit(type, Map.of());
    }

    private void audit(AuditTypes type, Map<String, Object> params) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(type).params(params);
        Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).setAttribute("audit", (Object)auditBuilder.buildSuccess(), 0);
    }

    @ConstructorProperties(value={"maintenanceMode", "authorizationHelper"})
    public MaintenanceController(MaintenanceMode maintenanceMode, AuthorizationHelper authorizationHelper) {
        this.maintenanceMode = maintenanceMode;
        this.authorizationHelper = authorizationHelper;
    }

    public record EnableRequest(@Nullable String message, @JacksonFormats.InstantAsIso @Nullable Instant time) {
    }
}

