/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.form.web.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.plusmpm.util.documents.handlers.DocumentHandlerTypes;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassAction;
import com.suncode.pwfl.archive.DocumentClassActionFinder;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentSearchCache;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.DocumentUploadSource;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.PlusWorkflowTempFileCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.cache.TempFileStream;
import com.suncode.pwfl.cache.config.TempFileCacheConfig;
import com.suncode.pwfl.form.component.button.DocumentViewAction;
import com.suncode.pwfl.form.dto.documents.ArchiveDocumentDto;
import com.suncode.pwfl.form.dto.documents.DocumentAttachedToProcessDto;
import com.suncode.pwfl.form.dto.documents.DocumentClassDto;
import com.suncode.pwfl.form.dto.documents.DocumentTemplateDto;
import com.suncode.pwfl.form.dto.documents.TableDocumentDto;
import com.suncode.pwfl.form.exception.NoFilesToExportException;
import com.suncode.pwfl.form.exception.UploadDocumentException;
import com.suncode.pwfl.form.language.FormTranslator;
import com.suncode.pwfl.form.service.DocumentsService;
import com.suncode.pwfl.form.service.support.DocumentsUploadSummary;
import com.suncode.pwfl.form.util.FormUtils;
import com.suncode.pwfl.form.util.enumeration.DocumentClassRight;
import com.suncode.pwfl.form.util.object.IndexSync;
import com.suncode.pwfl.form.util.object.PagingInfo;
import com.suncode.pwfl.form.util.object.SortInfo;
import com.suncode.pwfl.form.util.object.builder.IndexesSyncBuilder;
import com.suncode.pwfl.form.web.controller.internal.FileMetaData;
import com.suncode.pwfl.form.web.controller.internal.FilesToCheck;
import com.suncode.pwfl.form.web.form.CheckInDocumentForm;
import com.suncode.pwfl.form.web.form.DocumentsUploadForm;
import com.suncode.pwfl.form.web.form.SearchDocumentsInArchiveForm;
import com.suncode.pwfl.form.web.form.SearchDocumentsInArchiveWindowForm;
import com.suncode.pwfl.form.web.result.DataSubmitResult;
import com.suncode.pwfl.form.web.result.JsonSubmitResult;
import com.suncode.pwfl.form.web.result.PreviewLinkResponse;
import com.suncode.pwfl.form.web.result.RefreshDocumentsViewResult;
import com.suncode.pwfl.form.web.result.SubmitResult;
import com.suncode.pwfl.google.drive.GoogleDriveInternalService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.microsoft.graph.onedrive.service.OneDriveInternalService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.io.DownloadResource;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.form.action.ActionUIFragment;
import com.suncode.pwfl.workflow.form.documentview.actions.DocumentViewDto;
import com.suncode.pwfl.workflow.process.exception.ProcessNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.naming.NoPermissionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.HttpServerErrorException;

@Controller
@RequestMapping(value={"/form/documents"})
public class DocumentsController {
    private static final Logger log = LoggerFactory.getLogger(DocumentsController.class);
    private final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private DocumentsService documentsService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private FormTranslator formTranslator;
    @Autowired
    private DocumentClassActionFinder documentActionFinder;
    @Autowired
    private IndexesSyncBuilder indexesSyncBuilder;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassActionService documentClassActionService;
    @Autowired
    private FileService fileService;
    @Autowired
    private DocumentSearchCache documentSearchCache;
    @Autowired
    private OneDriveInternalService oneDriveInternalService;
    @Autowired
    private GoogleDriveInternalService googleDriveInternalService;
    @Autowired
    private CacheFactory cacheFactory;
    private PlusWorkflowTempFileCache exportCache;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @PostConstruct
    private void initialize() {
        this.exportCache = this.cacheFactory.createTempFileCache(SystemCacheId.DOCUMENTS_CONTROLLER_EXPORT_CACHE, TempFileCacheConfig.builder().build());
    }

    @RequestMapping(value={"/checkSize"}, method={RequestMethod.POST})
    @ResponseBody
    public JsonSubmitResult checkFilesSize(@RequestBody FilesToCheck data) {
        JsonSubmitResult result = new JsonSubmitResult();
        result.setSuccess(true);
        DocumentClass documentClass = (DocumentClass)this.documentClassService.get((Serializable)data.getDocumentClassId());
        Long maxSize = documentClass.getMaxFileSize();
        if (maxSize == null) {
            return result;
        }
        List<FileMetaData> files = data.getFiles();
        for (FileMetaData file : files) {
            if (file.getSize() <= maxSize) continue;
            result.setSuccess(false);
            result.setMessage(MessageHelper.getMessage((String)"Plik_jest_za_duzy_maksymalny_rozmiar_to", (Object[])new Object[]{file.getName(), documentClass.getMaxFileSize() / 1024L}));
            break;
        }
        return result;
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String upload(HttpServletRequest request, DocumentsUploadForm form) throws JsonProcessingException {
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        boolean success = true;
        Object message = "";
        try {
            DocumentsUploadSummary summary = this.documentsService.upload(form.getProcessId(), form.getActivityId(), userId, form.getFiles(), form.getDocumentClassId(), form.getDescription(), form.getIndexes(), form.isSaveAsNewVersion());
            if (summary.hasMessages()) {
                success = false;
                for (String msg : summary.getMessages()) {
                    message = (String)message + msg;
                }
            }
        }
        catch (UploadDocumentException e) {
            success = false;
            message = MessageHelper.getMessage((String)"Wystapil_blad_podczas_przesylania_dokumentow");
        }
        request.setAttribute("audit", (Object)DocumentsController.buildUploadAudit(success, form));
        return this.mapper.writeValueAsString((Object)new RestResult(success, (String)message));
    }

    @RequestMapping(value={"/upload/json"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String uploadJson(HttpServletRequest request, DocumentsUploadForm form) throws UploadDocumentException, JsonProcessingException {
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        DocumentsUploadSummary summary = this.documentsService.uploadWithResult(form.getProcessId(), form.getActivityId(), userId, form.getFiles(), form.getDocumentClassId(), form.getDescription(), form.getIndexes(), form.isSaveAsNewVersion());
        request.setAttribute("auditSuccess", (Object)true);
        ArrayList<WfFile> files = new ArrayList<WfFile>();
        for (WfDocument document : summary.getDocuments()) {
            WfFile file = document.getFile();
            file.setActivityDocuments(null);
            file.setVersion(null);
            file.setDocumentClass(null);
            files.add(file);
        }
        return this.mapper.writeValueAsString(files);
    }

    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TableDocumentDto> get(@RequestParam(value="processId") String processId, @RequestParam(value="activityId") String activityId, @RequestParam(value="isHistory") boolean isHistory) {
        return this.documentsService.getAll(processId, activityId, isHistory);
    }

    @RequestMapping(value={"/exportToZip"}, method={RequestMethod.POST})
    @ResponseBody
    public String exportToZip(HttpServletRequest request, @RequestParam(value="processId") String processId, @RequestParam(value="activityId", required=false) String activityId, @RequestParam(value="processKey") String processKey) {
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        InputStream inputStream = this.documentsService.exportToZip(processId, activityId, userId, processKey);
        UUID id = this.exportCache.put("eksport.zip", inputStream);
        return id.toString();
    }

    @RequestMapping(value={"download/{uuid}"}, method={RequestMethod.GET})
    @ResponseBody
    public DownloadResource download(@PathVariable String uuid) throws IOException {
        UUID id = UUID.fromString(uuid);
        TempFileStream tempFileStream = (TempFileStream)this.exportCache.getValueStream(id, true).orElseThrow(() -> new HttpServerErrorException((HttpStatusCode)HttpStatus.NOT_FOUND));
        return new DownloadResource(tempFileStream);
    }

    @RequestMapping(value={"/refreshView"}, method={RequestMethod.POST})
    @ResponseBody
    public RefreshDocumentsViewResult refreshView(HttpServletRequest request, @RequestParam(value="processDefId") String processDefId, @RequestParam(value="activityDefId") String activityDefId, @RequestParam(value="activityId") String activityId, @RequestParam(value="uiFragment") String uiFragment, @RequestParam(value="processRightKey") String processRightKey) {
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        List documentViewPanels = this.documentsService.getViewJsonsForActivity(processDefId, activityDefId, activityId, userId, ActionUIFragment.valueOf((String)uiFragment), processRightKey);
        RefreshDocumentsViewResult result = new RefreshDocumentsViewResult();
        result.setDocumentViewPanels(documentViewPanels);
        result.setSuccess(true);
        return result;
    }

    @RequestMapping(value={"/shouldRefreshDocumentFromOneDrive"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean shouldRefreshDocumentFromOneDrive(HttpServletRequest request, @RequestParam(value="fileId") Long fileId, @RequestParam(value="wasModifiedNoMoreThanSecondsAgo") Long wasModifiedNoMoreThanSecondsAgo) {
        WfFile file = this.fileService.getFile(fileId, new String[0]);
        return file.getOneDriveItemId() == null ? false : this.oneDriveInternalService.shouldRefreshDocumentFromOneDrive(file, wasModifiedNoMoreThanSecondsAgo.longValue());
    }

    @RequestMapping(value={"/showDocumentActionsMenu"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonSubmitResult showDocumentActionsMenu(HttpServletRequest request, @RequestParam(value="fileId") Long fileId, @RequestParam(value="activityId") String activityId, @RequestParam(value="processId") String processId) {
        Locale locale = LocaleContextHolder.getLocale();
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        String json = this.documentsService.getDocumentsTableActionsMenuJson(fileId, userId, locale, processId, activityId);
        return this.buildJsonSubmitResult(json);
    }

    @RequestMapping(value={"/showSendFromDiscForm"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonSubmitResult showSendFromDiscForm(HttpServletRequest request, @RequestParam(value="fileId") Long fileId, @RequestParam(value="activityId") String activityId, @RequestParam(value="processId") String processId) {
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        Locale locale = LocaleContextHolder.getLocale();
        String json = this.documentsService.getSendDocumentsFromDiscFormJson(fileId, processId, activityId, userId, locale);
        return this.buildJsonSubmitResult(json);
    }

    @RequestMapping(value={"/getDocumentClasses"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DocumentClassDto> getDocumentClasses(HttpServletRequest request, @RequestParam(value="documentClassRight") String documentClassRight, @RequestParam(required=false, defaultValue="ALL") DocumentUploadSource uploadSource, @RequestParam(value="processDefId") String processDefId, @RequestParam(required=false, value="query") String query) {
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        List documentClasses = DocumentClassRight.getByName((String)documentClassRight) == DocumentClassRight.ADD ? (uploadSource == DocumentUploadSource.PROCESS ? this.documentsService.getDocumentClassesForUserAndProcess(userId, processDefId) : this.documentsService.getDocumentClassesForUser(userId, uploadSource)) : (uploadSource == DocumentUploadSource.PROCESS ? this.documentsService.getDocumentClassesForUserAndProcess(userId, documentClassRight, processDefId) : this.documentsService.getDocumentClassesForUser(userId, documentClassRight));
        return StringUtils.isNotBlank((CharSequence)query) ? documentClasses.stream().filter(documentClass -> documentClass.getName().toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList()) : documentClasses;
    }

    @ResponseBody
    @RequestMapping(value={"/getIndexes"}, method={RequestMethod.GET})
    public String getIndexes(@RequestParam(value="documentClassId") Long documentClassId) {
        Locale locale = LocaleContextHolder.getLocale();
        Gson gson = new Gson();
        return gson.toJson((Object)this.documentsService.getDocumentClassIndexes(documentClassId, locale));
    }

    @ResponseBody
    @RequestMapping(value={"/getDocumentClassIndexesForDocumentClassName"}, method={RequestMethod.GET})
    public String getDocumentClassIndexesForDocumentClassName(@RequestParam(value="documentClassName") String documentClassName) {
        Long docClassId = this.documentClassService.getDocumentClass(documentClassName, new String[0]).getId();
        return this.getIndexes(docClassId);
    }

    private List<IndexSync> getIndexSyncs(String processDefId, String source, String type, Long id) {
        DetachedCriteria criteria = DetachedCriteria.forClass(DocumentClassAction.class);
        criteria.add((Criterion)Restrictions.eq((String)"documentClass.id", (Object)id));
        criteria.add((Criterion)Restrictions.eq((String)"source", (Object)source));
        criteria.add((Criterion)Restrictions.eq((String)"type", (Object)type));
        criteria.add((Criterion)Restrictions.eq((String)"value", (Object)processDefId));
        DocumentClassAction action = (DocumentClassAction)this.documentActionFinder.findOne(criteria);
        return this.buildIndexesSync(action);
    }

    @ResponseBody
    @RequestMapping(value={"/indexes"}, method={RequestMethod.GET})
    public List<IndexSync> getIndexes(@RequestParam(value="processDefId") String processDefId, @RequestParam(value="documentClassId") Long documentClassId, @RequestParam(value="source", required=false, defaultValue="newDocumentInProcess") String source, @RequestParam(value="type", required=false, defaultValue="rewriteIdxFromProcessToDoc") String type) {
        return this.getIndexSyncs(processDefId, source, type, documentClassId);
    }

    @ResponseBody
    @RequestMapping(value={"/indexesForProcessId"}, method={RequestMethod.GET})
    public List<IndexSync> getIndexesForProcessId(@RequestParam(value="processId") String processId, @RequestParam(value="documentClassId") Long documentClassId, @RequestParam(value="source", required=false, defaultValue="newDocumentInProcess") String source, @RequestParam(value="type", required=false, defaultValue="rewriteIdxFromProcessToDoc") String type) {
        String processDefId = SharkFunctions.getProcessDefId((String)processId);
        return this.getIndexSyncs(processDefId, source, type, documentClassId);
    }

    @ResponseBody
    @RequestMapping(value={"/indexesForClassName"}, method={RequestMethod.GET})
    public List<IndexSync> getIndexesForClassName(@RequestParam(value="processDefId") String processDefId, @RequestParam(value="documentClassName") String documentClassName, @RequestParam(value="source", required=false, defaultValue="newDocumentInProcess") String source, @RequestParam(value="type", required=false, defaultValue="rewriteIdxFromProcessToDoc") String type) {
        Long documentClassId = this.documentClassService.getDocumentClass(documentClassName, new String[0]).getId();
        return this.getIndexSyncs(processDefId, source, type, documentClassId);
    }

    private List<IndexSync> buildIndexesSync(DocumentClassAction documentAction) {
        if (documentAction != null) {
            String[] syncChain = documentAction.getValue2().split("&");
            return Arrays.asList(syncChain).stream().map(syncConfig -> this.indexesSyncBuilder.build(syncConfig)).collect(Collectors.toList());
        }
        return new LinkedList<IndexSync>();
    }

    @RequestMapping(value={"/showSearchInArchiveWindow"}, method={RequestMethod.POST})
    @ResponseBody
    public JsonSubmitResult showSearchInArchiveWindow(HttpServletRequest request, SearchDocumentsInArchiveWindowForm form) {
        Locale locale = LocaleContextHolder.getLocale();
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        String json = this.documentsService.getSearchDocumentsInArchiveWindowJson(form.getProcessId(), form.getActivityId(), form.getDocumentClassId(), form.getIndexes(), userId, locale);
        return this.buildJsonSubmitResult(json);
    }

    @RequestMapping(value={"/showSearchInArchiveExtendedWindow"}, method={RequestMethod.POST})
    @ResponseBody
    public JsonSubmitResult showSearchInArchiveExtendedWindow(HttpServletRequest request, SearchDocumentsInArchiveWindowForm form) {
        Locale locale = LocaleContextHolder.getLocale();
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        String json = this.documentsService.getSearchDocumentsInArchiveExtendedWindowJson(form.getProcessId(), form.getActivityId(), form.getDocumentClassId(), form.getIndexes(), form.getSortBy(), form.getSortDirection(), form.getDisplayedIndexNames(), userId, locale);
        return this.buildJsonSubmitResult(json);
    }

    @RequestMapping(value={"/searchInArchive"}, method={RequestMethod.GET})
    @ResponseBody
    public DataSubmitResult<ArchiveDocumentDto> searchInArchive(SearchDocumentsInArchiveForm form, PagingInfo pagingInfo, SortInfo sortInfo, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="displayedIndexIds", required=false) List<Long> displayedIndexIds) {
        CountedResult<ArchiveDocumentDto> countedResult;
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            CountedResult documents = this.documentsService.getWfDocumentsByIndexes(form.getDocumentClassId(), form.getIndexes(), sortInfo, searchText, displayedIndexIds);
            countedResult = this.convertToArchiveDocumentDtoResult((CountedResult<WfDocument>)documents);
            countedResult.setData(countedResult.getData().subList(pagingInfo.getStart(), Math.min(pagingInfo.getStart() + pagingInfo.getLimit(), countedResult.getData().size())));
        } else {
            countedResult = this.documentsService.searchInArchive(form.getDocumentClassId(), form.getIndexes(), pagingInfo, sortInfo);
        }
        DataSubmitResult<ArchiveDocumentDto> result = new DataSubmitResult<ArchiveDocumentDto>();
        result.setData(countedResult.getData());
        result.setTotal(countedResult.getTotal());
        result.setSuccess(true);
        return result;
    }

    @RequestMapping(value={"/showArchiveDocumentActionsMenu"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonSubmitResult showArchiveDocumentActionsMenu(HttpServletRequest request) {
        Locale locale = LocaleContextHolder.getLocale();
        String json = this.documentsService.getArchiveDocumentsTableActionsMenuJson(locale);
        return this.buildJsonSubmitResult(json);
    }

    @RequestMapping(value={"/getDocumentTemplates"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DocumentTemplateDto> getDocumentTemplates(HttpServletRequest request, @RequestParam(value="processDefId") String processDefId) {
        return this.documentsService.getDocumentTemplatesForProcess(processDefId);
    }

    @RequestMapping(value={"/checkOut"}, method={RequestMethod.GET})
    @ResponseBody
    public SubmitResult checkOut(HttpServletRequest request, @RequestParam(value="fileId") Long fileId) {
        Locale locale = LocaleContextHolder.getLocale();
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        this.documentsService.checkOut(userId, fileId);
        SubmitResult result = new SubmitResult();
        result.setMessage(this.formTranslator.translateMessage(locale, "Pobrano_dokument_do_zmiany"));
        result.setSuccess(true);
        request.setAttribute("auditSuccess", (Object)true);
        return result;
    }

    @Deprecated
    @RequestMapping(value={"/undoCheckOut"}, method={RequestMethod.GET})
    @ResponseBody
    public SubmitResult undoCheckOut(HttpServletRequest request, @RequestParam(value="fileId") Long fileId) {
        Locale locale = LocaleContextHolder.getLocale();
        this.documentsService.undoCheckOut(fileId);
        SubmitResult result = new SubmitResult();
        result.setMessage(this.formTranslator.translateMessage(locale, "Anulowano_zmiany"));
        result.setSuccess(true);
        return result;
    }

    @RequestMapping(value={"/checkIn"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String checkIn(HttpServletRequest request, CheckInDocumentForm form) throws JsonProcessingException {
        boolean success = true;
        Object message = "";
        try {
            String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
            WfFile file = this.fileService.getFile(form.getParentFileId(), new String[0]);
            if (file.getVersion().getState().equals(WfFileVersion.State.STATE_EDIT.toString()) && file.getVersion().getCheckOutUserName().equals(userId)) {
                DocumentsUploadSummary summary = this.documentsService.checkIn(userId, form.getFile(), form.getParentFileId(), form.getDescription(), form.getComment(), form.getProcessId(), form.getActivityId());
                if (summary.hasMessages()) {
                    for (String msg : summary.getMessages()) {
                        message = (String)message + msg;
                    }
                }
            } else {
                log.error("User does not have permission to checkIn this file");
                success = false;
                message = MessageHelper.getMessage((String)"Wystapil_blad_podczas_przesylania_dokumentow");
            }
        }
        catch (UploadDocumentException e) {
            success = false;
            message = MessageHelper.getMessage((String)"Wystapil_blad_podczas_przesylania_dokumentow");
        }
        request.setAttribute("audit", (Object)DocumentsController.buildCheckInAudit(success, form));
        return this.mapper.writeValueAsString((Object)new RestResult(success, (String)message));
    }

    @RequestMapping(value={"/showAddFromDiscForm"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonSubmitResult showAddFromDiscForm(HttpServletRequest request, @RequestParam(value="processId") String processId, @RequestParam(value="activityId") String activityId) {
        Locale locale = LocaleContextHolder.getLocale();
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        String json = this.documentsService.getAddDocumentsFromDiscFormJson(processId, activityId, userId, locale);
        return this.buildJsonSubmitResult(json);
    }

    @RequestMapping(value={"/showAddFromArchiveForm"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonSubmitResult showAddFromArchiveForm(HttpServletRequest request, @RequestParam(value="processId") String processId, @RequestParam(value="activityId") String activityId) {
        Locale locale = LocaleContextHolder.getLocale();
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        String json = this.documentsService.getAddDocumentsFromArchiveFormJson(processId, activityId, userId, locale);
        return this.buildJsonSubmitResult(json);
    }

    @RequestMapping(value={"/showAddFromTemplateForm"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonSubmitResult showAddFromTemplateForm(HttpServletRequest request, @RequestParam(value="processId") String processId, @RequestParam(value="activityId") String activityId) {
        Locale locale = LocaleContextHolder.getLocale();
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        String json = this.documentsService.getAddDocumentsFromTemplateFormJson(processId, activityId, userId, locale);
        return this.buildJsonSubmitResult(json);
    }

    @ResponseBody
    @RequestMapping(value={"attachFromArchive"}, method={RequestMethod.POST})
    public ResponseEntity<?> needsReloadAfterAddFromArchive(HttpSession session, @RequestParam(value="fileId") Long fileId, @RequestParam(value="processId") String processId, @RequestParam(value="activityId") String activityId) {
        String username = (String)session.getAttribute("username");
        boolean hasRights = Authorization.hasRightsToReadFile((String)username, (Long)fileId);
        if (hasRights) {
            WfDocument document = this.documentService.getDocument(fileId);
            Boolean shouldReload = this.shouldReload(document.getDocumentClassId());
            this.documentService.attachDocumentToProcess(document, username, processId, activityId);
            this.documentClassActionService.executeProcessActions(document, DocumentEventTypes.ADD_DOCUMENT_TO_PROCESS, processId, activityId);
            return new ResponseEntity((Object)ImmutableMap.of((Object)"reload", (Object)shouldReload), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    @RequestMapping(value={"/attachedToProcess"})
    @ResponseBody
    public List<DocumentAttachedToProcessDto> getDocumentsAttachedToProcess(@RequestParam String processId) {
        return this.documentsService.getDocumentsAttachedToProcess(processId, SessionUtils.getLoggedUserName());
    }

    @RequestMapping(value={"/viewaction/js/"}, method={RequestMethod.GET})
    @ResponseBody
    public String getViewActionJS(@RequestParam(value="buttonSource") String buttonSource, @RequestParam(value="actionId") String actionId) throws IOException {
        return this.documentsService.getDocumentViewActionJS(buttonSource, actionId);
    }

    @RequestMapping(value={"/documentViewActions"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DocumentViewAction> getDocumentViewActions(@RequestParam(value="fileId") Long fileId, @RequestParam(required=false, value="processId") String processId, @RequestParam(required=false, value="activityId") String activityId) {
        WfFile file = this.fileService.getFile(fileId, new String[]{"documentClass"});
        DocumentViewDto document = DocumentViewDto.builder().fileId(Long.valueOf(file.getId())).fileName(file.getFileName()).documentClassId(file.getDocumentClass().getId()).build();
        String procDefId = SharkFunctions.getProcessDefId((String)processId);
        String actDefId = SharkFunctions.getActivityDefId((String)processId, (String)activityId);
        return this.documentsService.getAllDocumentViewActions(procDefId, actDefId, document);
    }

    @RequestMapping(value={"/generatePreviewInOneDriveLink"}, method={RequestMethod.GET})
    @ResponseBody
    public PreviewLinkResponse generatePreviewInOneDriveLink(@RequestParam(value="fileId") Long fileId, @RequestParam(required=false, value="processRightKey") String processRightKey) {
        WfFile file = this.fileService.getFile(fileId, new String[]{"documentClass", "version"});
        if (this.documentsService.isMSOfficeDocument(file.getFileName())) {
            if (this.userNameHasRightsToFile(file, processRightKey)) {
                try {
                    String link = this.oneDriveInternalService.generateLinkToOneDriveFilePreview(file);
                    if (StringUtils.isNotBlank((CharSequence)link)) {
                        return new PreviewLinkResponse(link, null);
                    }
                    log.warn("Link generated from One Drive for file id {} is empty", (Object)file.getId());
                }
                catch (Exception e) {
                    log.warn(String.format("Cannot generate One Drive preview link for file (fileid = %s). Preview unavailable.", fileId), (Throwable)e);
                }
            }
        } else {
            log.warn("Document " + file.getFileName() + " is not MS Office document");
        }
        return new PreviewLinkResponse(null, MessageHelper.getMessage((String)"Wystapil_blad_podczas_odswiezania_podgladu_dokumentow") + ". " + MessageHelper.getMessage((String)"Skontaktuj_sie_z_administratorem_systemu"));
    }

    @RequestMapping(value={"/generateOneDriveLink"}, method={RequestMethod.GET})
    @ResponseBody
    public String generateOneDriveLink(@RequestParam(value="fileId") Long fileId) throws NoPermissionException {
        String userName = SessionUtils.getLoggedUserName();
        WfFile file = this.fileService.getFile(fileId, new String[]{"documentClass"});
        if (!this.documentsService.isMSOfficeDocument(file.getFileName())) {
            log.warn("Invalid file format to generate One Drive Link - " + file.getFileName());
            throw new ServiceException(MessageHelper.getMessage((String)"Niepoprawny_format"));
        }
        try {
            return this.oneDriveInternalService.generateLinkToOneDriveFile(file, userName);
        }
        catch (Exception e) {
            throw new ServiceException(String.format("Cannot generate Microsoft Graph Api preview link for file (fileid = %s). Preview unavailable.", fileId), (Throwable)e);
        }
    }

    @RequestMapping(value={"/generatePreviewInGoogleDocsLink"}, method={RequestMethod.GET})
    @ResponseBody
    public PreviewLinkResponse generatePreviewInGoogleDocsLink(@RequestParam(value="fileId") Long fileId, @RequestParam(required=false, value="processRightKey") String processRightKey) {
        WfFile file = this.fileService.getFile(fileId, new String[]{"documentClass", "version"});
        if (this.documentsService.isMSOfficeDocument(file.getFileName())) {
            if (this.userNameHasRightsToFile(file, processRightKey)) {
                try {
                    String link = this.googleDriveInternalService.generateGoogleDriveFileLink(file);
                    if (StringUtils.isNotBlank((CharSequence)link)) {
                        return new PreviewLinkResponse(link, null);
                    }
                    log.warn("Link generated from Google Drive for file id {} is empty", (Object)file.getId());
                }
                catch (Exception e) {
                    log.warn(String.format("Cannot generate Google Docs preview link for file (fileid = %s). Preview unavailable.", fileId), (Throwable)e);
                }
            }
        } else {
            log.warn("Document " + file.getFileName() + " is not MS Office document");
        }
        return new PreviewLinkResponse(null, MessageHelper.getMessage((String)"Wystapil_blad_podczas_odswiezania_podgladu_dokumentow") + ". " + MessageHelper.getMessage((String)"Skontaktuj_sie_z_administratorem_systemu"));
    }

    private boolean userNameHasRightsToFile(WfFile file, String processRightKey) {
        String userName = SessionUtils.getLoggedUserName();
        boolean hasRights = this.documentSearchCache.containsFileIdForUser(userName, Long.valueOf(file.getId())) || Authorization.hasRightsToReadFile((String)userName, (Long)file.getId(), (String)processRightKey);
        Long newestVersionFileId = file.getVersion().getNewestFile().getId();
        boolean hasRightsToNewestVersion = ((DocumentSearchCache)SpringContext.getBean(DocumentSearchCache.class)).containsFileIdForUser(userName, newestVersionFileId) || Authorization.hasRightsToReadFile((String)userName, (Long)newestVersionFileId, (String)processRightKey);
        return hasRights || hasRightsToNewestVersion;
    }

    @ExceptionHandler(value={ProcessNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleProcessNotFoundException(ProcessNotFoundException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    private Boolean shouldReload(Long documentClassId) {
        return (Boolean)new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager()).execute(status -> ((DocumentClass)this.documentClassService.get((Serializable)documentClassId)).getActions().stream().anyMatch(action -> action.getHandlerType() == DocumentHandlerTypes.REWRITE_IDX_FROM_DOC_TO_PROCESS));
    }

    private JsonSubmitResult buildJsonSubmitResult(String json) {
        JsonSubmitResult result = new JsonSubmitResult();
        result.setJson(json);
        result.setSuccess(true);
        return result;
    }

    private static AuditWrapper buildUploadAudit(boolean success, DocumentsUploadForm form) {
        AuditTypes auditType = AuditTypes.AUDIT_UPLOAD_FILE_FROM_ARCHIVE;
        if (StringUtils.isNotBlank((CharSequence)form.getProcessId())) {
            auditType = AuditTypes.AUDIT_UPLOAD_FILE_FROM_PROCESS;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", form.getProcessId());
        params.put("activityId", form.getActivityId());
        params.put("description", form.getDescription());
        params.put("documentClassId", form.getDocumentClassId());
        return AuditBuilder.getInstance().params(params).type(auditType).success(success).build();
    }

    private static AuditWrapper buildCheckInAudit(boolean success, CheckInDocumentForm form) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", form.getProcessId());
        params.put("activityId", form.getActivityId());
        params.put("parentFileId", form.getParentFileId());
        params.put("description", form.getDescription());
        params.put("comment", form.getComment());
        return AuditBuilder.getInstance().params(params).type(AuditTypes.AUDIT_CHECK_IN_DOCUMENT_FROM_ACTIVITY).success(success).build();
    }

    @ExceptionHandler(value={NoFilesToExportException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNoFilesToExportException(NoFilesToExportException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    private CountedResult<ArchiveDocumentDto> convertToArchiveDocumentDtoResult(CountedResult<WfDocument> input) {
        CountedResult result = new CountedResult();
        LinkedList<ArchiveDocumentDto> archiveDocumentDtos = new LinkedList<ArchiveDocumentDto>();
        for (WfDocument wfDoc : input.getData()) {
            ArchiveDocumentDto archiveDocumentDto = new ArchiveDocumentDto();
            wfDoc.getIndexes().forEach(indexInfo -> archiveDocumentDto.put((Object)("idx000" + indexInfo.getId()), (Object)(indexInfo.getValue() != null ? indexInfo.getValue().toString() : "")));
            archiveDocumentDtos.add(archiveDocumentDto);
        }
        result.setData(archiveDocumentDtos);
        result.setTotal(input.getTotal());
        return result;
    }
}

