/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action.reports;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.ReportsTable;
import com.suncode.pwfl.report.ReportService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class GetReportListAction
extends Action {
    public static Logger log = Logger.getLogger(GetReportListAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)"******************************GetReportListAction********************");
        try {
            HttpSession session = request.getSession(false);
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("welcome");
            }
            String userName = (String)session.getAttribute("username");
            String sSource = request.getParameter("source");
            DBManagement dbm = new DBManagement();
            ArrayList alPrivReports = dbm.GetAllReportsForUserWithType(userName, "private");
            ArrayList alPubReports = dbm.GetAllReportsForUserWithType(userName, "public");
            alPrivReports.addAll(alPubReports);
            ReportService reportService = ServiceFactory.getReportService();
            for (ReportsTable rep : alPrivReports) {
                rep.setReportName(reportService.getReportTranslation(rep.getId(), TranslatedFieldType.NAME));
                rep.setReportDescr(reportService.getReportTranslation(rep.getId(), TranslatedFieldType.DESCRIPTION));
            }
            for (ReportsTable rep : alPubReports) {
                rep.setReportName(reportService.getReportTranslation(rep.getId(), TranslatedFieldType.NAME));
                rep.setReportDescr(reportService.getReportTranslation(rep.getId(), TranslatedFieldType.DESCRIPTION));
            }
            request.setAttribute("alReports", (Object)alPrivReports);
            return mapping.findForward("showReportList");
        }
        catch (Exception e) {
            log.error((Object)("Exception:" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }
}

