/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.form.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.plusmpm.struts.form.AdvanceVariableForm;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.pwfl.distinction.dto.DistinctionBase64;
import com.suncode.pwfl.search.AdvanceVariableFormBuilder;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.support.form.cache.SearchFormCachedItem;
import com.suncode.pwfl.web.support.form.cache.SearchResultActions;
import com.suncode.pwfl.web.util.SessionUtils;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Provides(value={SearchFormCache.class})
public class SearchFormCache {
    @Autowired
    private AdvanceVariableFormBuilder advanceVariableFormBuilder;

    public Cache<String, SearchFormCachedItem> getCache(HttpSession session) {
        Optional<Object> cacheAttribute = Optional.ofNullable(session.getAttribute("searchFormCache"));
        Cache<Object, Object> cache = cacheAttribute.orElse(this.generateCache());
        session.setAttribute("searchFormCache", cache);
        return cache;
    }

    public boolean containsSearchId(String searchId) {
        return this.getValueFromCache(searchId).isPresent();
    }

    private Cache<Object, Object> generateCache() {
        return CacheBuilder.newBuilder().expireAfterAccess(4L, TimeUnit.HOURS).build();
    }

    public void cacheSearchForm(HttpSession session, String searchId, SearchFormCachedItem searchFormCachedItem) {
        Cache<String, SearchFormCachedItem> cache = this.getCache(session);
        cache.put((Object)searchId, (Object)searchFormCachedItem);
    }

    public Optional<SearchFormCachedItem> getValueFromCache(HttpSession session, String searchId) {
        Cache<String, SearchFormCachedItem> cache = this.getCache(session);
        return Optional.ofNullable((SearchFormCachedItem)cache.asMap().get(searchId));
    }

    public Optional<SearchFormCachedItem> getValueFromCache(String searchId) {
        HttpSession session = SessionUtils.getCurrentSession();
        Cache<String, SearchFormCachedItem> cache = this.getCache(session);
        return Optional.ofNullable((SearchFormCachedItem)cache.asMap().get(searchId));
    }

    public Optional<AdvanceVariableForm[]> getSearchVariablesFromCache(String searchId) throws IOException {
        HttpSession session = SessionUtils.getCurrentSession();
        Cache<String, SearchFormCachedItem> cache = this.getCache(session);
        Optional<SearchFormCachedItem> searchFormCachedItem = Optional.ofNullable((SearchFormCachedItem)cache.asMap().get(searchId));
        if (searchFormCachedItem.isPresent()) {
            byte[] decodedBytes = Base64.getDecoder().decode(searchFormCachedItem.get().encodedSearchForm().getBytes(StandardCharsets.UTF_8));
            String searchModelForm = new String(decodedBytes, StandardCharsets.UTF_8);
            SearchFormModelDto searchFormModelDto = (SearchFormModelDto)new ObjectMapper().readValue(searchModelForm, SearchFormModelDto.class);
            return Optional.ofNullable(this.advanceVariableFormBuilder.buildAdvanceFormVariables(searchFormModelDto));
        }
        return Optional.empty();
    }

    public Optional<AdvanceVariableForm[]> getSearchExtrasFromCache(String searchId) throws IOException {
        HttpSession session = SessionUtils.getCurrentSession();
        Cache<String, SearchFormCachedItem> cache = this.getCache(session);
        Optional<SearchFormCachedItem> searchFormCachedItem = Optional.ofNullable((SearchFormCachedItem)cache.asMap().get(searchId));
        if (searchFormCachedItem.isPresent()) {
            byte[] decodedBytes = Base64.getDecoder().decode(searchFormCachedItem.get().encodedSearchForm().getBytes(StandardCharsets.UTF_8));
            String searchModelForm = new String(decodedBytes, StandardCharsets.UTF_8);
            SearchFormModelDto searchFormModelDto = (SearchFormModelDto)new ObjectMapper().readValue(searchModelForm, SearchFormModelDto.class);
            return Optional.ofNullable(this.advanceVariableFormBuilder.buildAdvanceVariableFormExtras(searchFormModelDto.getExtrasSearchModel()));
        }
        return Optional.empty();
    }

    public Optional<SearchFormModelDto> getSearchFormFromCache(String searchId) {
        HttpSession session = SessionUtils.getCurrentSession();
        Cache<String, SearchFormCachedItem> cache = this.getCache(session);
        Optional<SearchFormCachedItem> searchFormCachedItem = Optional.ofNullable((SearchFormCachedItem)cache.asMap().get(searchId));
        if (searchFormCachedItem.isPresent()) {
            byte[] decodedBytes = Base64.getDecoder().decode(searchFormCachedItem.get().encodedSearchForm().getBytes(StandardCharsets.UTF_8));
            String searchModelForm = new String(decodedBytes, StandardCharsets.UTF_8);
            SearchFormModelDto searchFormModelDto = (SearchFormModelDto)new ObjectMapper().readValue(searchModelForm, SearchFormModelDto.class);
            return Optional.ofNullable(searchFormModelDto);
        }
        return Optional.empty();
    }

    public List<DistinctionBase64> getDistinctionsFromCache(String searchId) {
        HttpSession session = SessionUtils.getCurrentSession();
        Cache<String, SearchFormCachedItem> cache = this.getCache(session);
        Optional<SearchFormCachedItem> searchFormCachedItem = Optional.ofNullable((SearchFormCachedItem)cache.asMap().get(searchId));
        if (searchFormCachedItem.isPresent()) {
            return Optional.ofNullable(searchFormCachedItem.get().distinctions()).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    @Nullable
    public SearchResultActions getSearchResultActionsFromCache(String searchId) {
        HttpSession session = SessionUtils.getCurrentSession();
        Cache<String, SearchFormCachedItem> cache = this.getCache(session);
        return Optional.ofNullable((SearchFormCachedItem)cache.asMap().get(searchId)).map(SearchFormCachedItem::searchResultActions).orElse(null);
    }
}

