/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.filter;

import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CorsFilter
implements Filter {
    private static Logger log = Logger.getLogger(CorsFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse resp = (HttpServletResponse)response;
        HttpServletRequest req = (HttpServletRequest)request;
        String origin = req.getHeader("Origin");
        if (StringUtils.isNotBlank((CharSequence)origin)) {
            log.info((Object)"CORS request");
            log.info((Object)("Origin: " + origin));
            String corsWhitelistParam = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.CORS_WHITELIST);
            if (StringUtils.isNotBlank((CharSequence)corsWhitelistParam)) {
                List<String> corsWhitelist = Arrays.asList(corsWhitelistParam.split(";"));
                if (corsWhitelist.contains(origin)) {
                    resp.setHeader("Access-Control-Allow-Origin", origin);
                } else {
                    resp.setHeader("Access-Control-Allow-Origin", corsWhitelist.get(0));
                }
            } else {
                resp.setHeader("Access-Control-Allow-Origin", origin);
            }
            resp.setHeader("Access-Control-Allow-Credentials", "true");
            resp.setHeader("Access-Control-Allow-Methods", "OPTIONS,  GET, POST, PUT, DELETE");
            resp.setHeader("Access-Control-Allow-Headers", this.readHeaders(req));
        }
        chain.doFilter(request, response);
    }

    private String readHeaders(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        String sep = ",";
        Enumeration baseHeaders = req.getHeaderNames();
        String corsHeaders = req.getHeader("Access-Control-Request-Headers");
        while (baseHeaders.hasMoreElements()) {
            sb.append((String)baseHeaders.nextElement());
            sb.append(sep);
        }
        if (StringUtils.isBlank((CharSequence)corsHeaders)) {
            sb.setLength(sb.length() - 1);
        } else {
            sb.append(corsHeaders);
        }
        return sb.toString();
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

