/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.dashboards;

import com.suncode.plugin.dashboard.Dashboard;
import com.suncode.plugin.dashboard.DashboardService;
import com.suncode.plugin.dashboard.Gadget;
import com.suncode.plugin.dashboard.SystemDashboardService;
import com.suncode.plugin.dashboard.gadget.Errors;
import com.suncode.plugin.dashboard.gadget.GadgetDefinition;
import com.suncode.plugin.dashboard.web.support.dto.GadgetDefinitionDto;
import com.suncode.plugin.framework.Plugin;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.dashboard.exception.DashboardNotFoundException;
import com.suncode.pwfl.dashboard.exception.GadgetNotFoundException;
import com.suncode.pwfl.dashboard.exception.UnauthorizedException;
import com.suncode.pwfl.dashboard.internal.SystemDashboardGadget;
import com.suncode.pwfl.dashboard.internal.gadget.GadgetDefinitionRegistry;
import com.suncode.pwfl.dashboard.internal.support.GadgetPropertiesHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GadgetController {
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private SystemDashboardService systemDashboardService;
    @Autowired
    private GadgetDefinitionRegistry gadgetDefinitionRegistry;
    @Autowired
    private GadgetPropertiesHelper gadgetPropertiesHelper;
    @Autowired
    private UserService userService;

    @RequestMapping(value={"/gadgets/definitions"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> availableGadgets() {
        ArrayList<GadgetDefinitionDto> definitions = new ArrayList<GadgetDefinitionDto>();
        List gadgetDefinitions = this.gadgetDefinitionRegistry.getAll();
        for (GadgetDefinition gadgetDefinition : gadgetDefinitions) {
            definitions.add(GadgetDefinitionDto.create((GadgetDefinition)gadgetDefinition));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("records", definitions);
        return result;
    }

    @RequestMapping(value={"/dashboard/{dashId}/gadgets/{gadgetId}/properties"}, method={RequestMethod.POST})
    @ResponseBody
    @Transactional
    public ResponseEntity<Errors> saveGadgetProperties(@PathVariable String dashId, @PathVariable String gadgetId, @RequestParam(required=false) boolean system, @RequestParam Map<String, String> properties) throws UnauthorizedException {
        Dashboard dashboard;
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        Dashboard dashboard2 = dashboard = system ? this.systemDashboardService.getSystemDashboardForUser(dashId, user) : this.dashboardService.getDashboard(Long.valueOf(dashId));
        if (dashboard == null) {
            throw new DashboardNotFoundException();
        }
        Gadget gadget = system ? (Gadget)this.systemDashboardService.findGadgetForUser(user, gadgetId).orElseThrow(() -> new GadgetNotFoundException(gadgetId)) : dashboard.getGadget(Long.valueOf(gadgetId));
        Plugin plugin = gadget.getPlugin();
        Errors errors = new Errors(plugin);
        HashMap propertiesToUpdate = new HashMap();
        properties.entrySet().stream().filter(property -> !((String)property.getKey()).equals("system")).forEach(entry -> propertiesToUpdate.put((String)entry.getKey(), (String)entry.getValue()));
        this.gadgetPropertiesHelper.updateGadgetProperties(gadget, propertiesToUpdate, errors);
        if (errors.isSuccess()) {
            this.gadgetPropertiesHelper.validatePropertiesUsingCustomValidator(plugin, gadget, errors);
            if (errors.isSuccess()) {
                if (system) {
                    this.systemDashboardService.updateSystemGadgetProperties(user, (SystemDashboardGadget)gadget);
                } else {
                    this.dashboardService.updateDashboard(dashboard);
                }
            }
        }
        return new ResponseEntity((Object)errors, (HttpStatusCode)HttpStatus.OK);
    }
}

