/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendar.Period;
import com.suncode.pwfl.calendar.event.Event;
import com.suncode.pwfl.calendar.resource.CalendarResource;
import com.suncode.pwfl.calendar.resource.CalendarResourceAvailabilityService;
import com.suncode.pwfl.calendar.resource.CalendarResourceCheckEventExclusion;
import com.suncode.pwfl.calendar.resource.CalendarResourceService;
import com.suncode.pwfl.calendar.resource.exception.CalendarResourcePermissionException;
import com.suncode.pwfl.calendar.resource.tree.CalendarResourceTreeNode;
import com.suncode.pwfl.web.dto.calendar.CalendarResourceCheckEventExclusionDto;
import com.suncode.pwfl.web.dto.calendar.CalendarResourceOccupiedStatusDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.calendar.CalendarMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dmfs.rfc5545.recur.InvalidRecurrenceRuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calendar/resource"})
@Api(hidden=true)
public class CalendarResourceController {
    private static final Logger log = LoggerFactory.getLogger(CalendarResourceController.class);
    private final CalendarResourceService calendarResourceService;
    private final CalendarResourceAvailabilityService calendarResourceAvailabilityService;
    private final AuthorizationHelper authorizationHelper;
    private final CalendarMapper calendarMapper;
    private final UserService userService;

    @GetMapping
    public List<CalendarResource> getCalendarResources() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.calendarResourceService.getCalendarResources();
    }

    @GetMapping(value={"/{id}"})
    public CalendarResource getCalendarResource(@PathVariable Long id) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        if (!Authorization.checkIsUserAdmin((String)user.getUserName()) && !this.calendarResourceService.hasAccessToViewResource(user, id)) {
            throw new CalendarResourcePermissionException();
        }
        return this.calendarResourceService.getCalendarResource(id);
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public CalendarResource createCalendarResource(@RequestBody CalendarResource calendarResource, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().params(this.paramsFromCalendarResource(calendarResource));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_CALENDAR_RESOURCE).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            CalendarResource createdCalendarResource = this.calendarResourceService.createCalendarResource(calendarResource);
            auditParamsBuilder.param("id", (Object)createdCalendarResource.getId()).params(this.paramsFromCalendarResource(createdCalendarResource));
            auditBuilder.params(auditParamsBuilder.build());
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return createdCalendarResource;
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @PatchMapping(value={"/{id}"})
    public CalendarResource updateCalendarResource(@PathVariable Long id, @RequestBody CalendarResource calendarResource, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)id).params(this.paramsFromCalendarResource(calendarResource));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_CALENDAR_RESOURCE).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            CalendarResource oldCalendarResource = this.calendarResourceService.getCalendarResource(id);
            CalendarResource updatedCalendarResource = this.calendarResourceService.updateCalendarResource(id, calendarResource);
            auditParamsBuilder.params(this.paramsFromCalendarResource(oldCalendarResource, updatedCalendarResource));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return updatedCalendarResource;
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"/{id}"})
    public RestResult deleteCalendarResource(@PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_CALENDAR_RESOURCE).params(new AuditParamsBuilder().param("id", (Object)id).build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            this.calendarResourceService.deleteCalendarResource(id);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @GetMapping(value={"/tree"})
    public List<CalendarResourceTreeNode> getCalendarResourceTree() {
        return this.calendarResourceService.getCalendarResourceTree();
    }

    @GetMapping(value={"/user/tree"})
    public List<CalendarResourceTreeNode> getCalendarResourceTreeForUser(@RequestParam(required=false) List<Long> allowedInactiveResources) {
        String username = UserContext.current().getUser().getUserName();
        return this.calendarResourceService.getCalendarResourceTreeForUser(username, null, allowedInactiveResources);
    }

    @PostMapping(value={"/occupied"})
    public List<CalendarResourceOccupiedStatusDto> checkResourcesOccupiedStatus(@RequestParam List<Long> resourcesIds, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromDateTime, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toDateTime, @RequestParam boolean allDay, @RequestBody(required=false) CalendarResourceCheckEventExclusionDto eventExclusionDto) throws InvalidRecurrenceRuleException {
        CalendarResourceCheckEventExclusion eventExclusion = this.toCalendarResourceCheckEventExclusion(eventExclusionDto);
        Period period = new Period(allDay, fromDateTime, toDateTime);
        return resourcesIds.stream().map(resourceId -> CalendarResourceOccupiedStatusDto.builder().resourceId((Long)resourceId).occupied(this.calendarResourceAvailabilityService.isResourceOccupiedDuringInterval(resourceId.longValue(), period, eventExclusion)).build()).toList();
    }

    private CalendarResourceCheckEventExclusion toCalendarResourceCheckEventExclusion(CalendarResourceCheckEventExclusionDto eventExclusionDto) throws InvalidRecurrenceRuleException {
        if (eventExclusionDto == null) {
            return null;
        }
        Event event = this.calendarMapper.toEvent(eventExclusionDto.getEventDto());
        CalendarResourceCheckEventExclusion eventExclusion = new CalendarResourceCheckEventExclusion(event);
        eventExclusion.setAllDay(eventExclusionDto.isAllDay());
        if (eventExclusionDto.getStartDateTimeUTC() != null) {
            eventExclusion.setStartDateTimeUTC(LocalDateTime.parse(eventExclusionDto.getStartDateTimeUTC(), DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (eventExclusionDto.getEndDateTimeUTC() != null) {
            eventExclusion.setEndDateTimeUTC(LocalDateTime.parse(eventExclusionDto.getEndDateTimeUTC(), DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        return eventExclusion;
    }

    private Map<String, Object> paramsFromCalendarResource(CalendarResource calendarResource) {
        return new AuditParamsBuilder().param("name", (Object)calendarResource.getName()).param("description", (Object)calendarResource.getDescription()).param("resourceGroupId", (Object)calendarResource.getResourceGroupId()).param("allowOverlappingEvents", (Object)calendarResource.getAllowOverlappingEvents()).build();
    }

    private Map<String, Object> paramsFromCalendarResource(CalendarResource oldCalendarResource, CalendarResource newCalendarResource) {
        return new AuditParamsBuilder().param("name", (Object)oldCalendarResource.getName(), (Object)newCalendarResource.getName()).param("description", (Object)oldCalendarResource.getDescription(), (Object)newCalendarResource.getDescription()).param("resourceGroupId", (Object)oldCalendarResource.getResourceGroupId(), (Object)newCalendarResource.getResourceGroupId()).param("allowOverlappingEvents", (Object)oldCalendarResource.getAllowOverlappingEvents(), (Object)newCalendarResource.getAllowOverlappingEvents()).build();
    }

    @ConstructorProperties(value={"calendarResourceService", "calendarResourceAvailabilityService", "authorizationHelper", "calendarMapper", "userService"})
    @Autowired
    public CalendarResourceController(CalendarResourceService calendarResourceService, CalendarResourceAvailabilityService calendarResourceAvailabilityService, AuthorizationHelper authorizationHelper, CalendarMapper calendarMapper, UserService userService) {
        this.calendarResourceService = calendarResourceService;
        this.calendarResourceAvailabilityService = calendarResourceAvailabilityService;
        this.authorizationHelper = authorizationHelper;
        this.calendarMapper = calendarMapper;
        this.userService = userService;
    }
}

