/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.processActivities;

import com.suncode.pwfl.administration.processActivities.ProcessActivitiesService;
import com.suncode.pwfl.administration.processActivities.ProcessActivityDto;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.dto.administration.processActivities.ProcessActivitySettingsDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.workflow.process.ProcessDataService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/processActivities"})
public class ProcessActivitiesController {
    private static final Logger log = LoggerFactory.getLogger(ProcessActivitiesController.class);
    private final ProcessDataService processDataService;
    private final ProcessActivitiesService processActivitiesService;
    private final ExportService exportService;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    private CountedResult<ProcessActivityDto> getProcessActivities(@RequestParam String processDefId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List processActivityDtos = this.processActivitiesService.getProcessActivities(processDefId);
        if (StringUtils.isNotBlank((CharSequence)orderBy)) {
            processActivityDtos.sort(DtoComparator.of(ProcessActivityDto.class, (String)orderBy, (SortDirection)orderDirection).withIgnoreCase(true));
        }
        return Paginator.forAll((List)processActivityDtos).viewPageByOffset(start, limit);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"export/{extension}"})
    @ResponseBody
    private void exportProcessActivities(HttpServletResponse response, @RequestParam String processDefId, @PathVariable String extension, @RequestParam(required=false) String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List processActivityDtos = this.processActivitiesService.getProcessActivities(processDefId);
        if (StringUtils.isNotBlank((CharSequence)orderBy)) {
            processActivityDtos.sort(DtoComparator.of(ProcessActivityDto.class, (String)orderBy, (SortDirection)orderDirection).withIgnoreCase(true));
        }
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn("Nazwa_zadania", processActivityDtos, ProcessActivityDto::getActivityTranslatedName), this.buildExportColumn("Opis_zadania", processActivityDtos, ProcessActivityDto::getActivityDescription));
        ExportModel exportModel = ExportModel.builder().title(MessageHelper.getMessage((String)"Zadania_w_procesie")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(exportModel, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"settings"})
    @ResponseBody
    private ProcessActivitySettingsDto getActivitySettings(@RequestParam String processDefId, @RequestParam String activityId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        String taskTabSettingsVisability = this.processDataService.getProcessData(processDefId, activityId, "taskTabSettingsVisability");
        String showDocumentsPanel = this.processDataService.getProcessData(processDefId, activityId, "showDocumentsPanel");
        String showInfoPanel = this.processDataService.getProcessData(processDefId, activityId, "showInfoPanel");
        String showDescriptionPanel = this.processDataService.getProcessData(processDefId, activityId, "showDescriptionPanel");
        String showHistoryPanel = this.processDataService.getProcessData(processDefId, activityId, "showHistoryPanel");
        String showMapPanel = this.processDataService.getProcessData(processDefId, activityId, "showMapPanel");
        return ProcessActivitySettingsDto.builder().taskTabSettingsVisability(this.toBooleanWithDefaultValue(taskTabSettingsVisability, false)).showDocumentsPanel(this.toBooleanWithDefaultValue(showDocumentsPanel, true)).showInfoPanel(this.toBooleanWithDefaultValue(showInfoPanel, true)).showDescriptionPanel(this.toBooleanWithDefaultValue(showDescriptionPanel, true)).showHistoryPanel(this.toBooleanWithDefaultValue(showHistoryPanel, true)).showMapPanel(this.toBooleanWithDefaultValue(showMapPanel, true)).build();
    }

    @RequestMapping(method={RequestMethod.POST}, value={"settings"})
    @ResponseBody
    private void updateActivitySettings(@RequestParam String processDefId, @RequestParam String activityId, @RequestBody ProcessActivitySettingsDto processActivitySettingsDto) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        TransactionWrapper.get().doInHibernateTransaction(session -> {
            this.processDataService.saveProcessData(processDefId, activityId, "taskTabSettingsVisability", String.valueOf(processActivitySettingsDto.isTaskTabSettingsVisability()));
            this.processDataService.saveProcessData(processDefId, activityId, "showDocumentsPanel", String.valueOf(processActivitySettingsDto.isShowDocumentsPanel()));
            this.processDataService.saveProcessData(processDefId, activityId, "showInfoPanel", String.valueOf(processActivitySettingsDto.isShowInfoPanel()));
            this.processDataService.saveProcessData(processDefId, activityId, "showDescriptionPanel", String.valueOf(processActivitySettingsDto.isShowDescriptionPanel()));
            this.processDataService.saveProcessData(processDefId, activityId, "showHistoryPanel", String.valueOf(processActivitySettingsDto.isShowHistoryPanel()));
            this.processDataService.saveProcessData(processDefId, activityId, "showMapPanel", String.valueOf(processActivitySettingsDto.isShowMapPanel()));
        });
    }

    private boolean toBooleanWithDefaultValue(String booleanValue, boolean defaultValue) {
        return StringUtils.isBlank((CharSequence)booleanValue) ? defaultValue : Boolean.parseBoolean(booleanValue);
    }

    private ExportColumn buildExportColumn(String name, List<ProcessActivityDto> data, Function<ProcessActivityDto, String> supplier) {
        return ExportColumnBuilder.create().name(MessageHelper.getMessage((String)name)).data(data).by(supplier).build();
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"processDataService", "processActivitiesService", "exportService", "authorizationHelper", "messageHelper"})
    @Autowired
    public ProcessActivitiesController(ProcessDataService processDataService, ProcessActivitiesService processActivitiesService, ExportService exportService, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.processDataService = processDataService;
        this.processActivitiesService = processActivitiesService;
        this.exportService = exportService;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

