/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.servlet;

import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.license.LicenseAccessor;
import com.suncode.pwfl.license.LicenseData;
import com.suncode.pwfl.license.trial.TrialLicense;
import com.suncode.pwfl.license.trial.service.TrialService;
import com.suncode.pwfl.util.SpringContext;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LicenseRestrictions
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static Logger log = Logger.getLogger(LicenseRestrictions.class);
    private static TrialService trialService = (TrialService)SpringContext.getBean(TrialService.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter printWriter = null;
        JSONObject answer = null;
        TrialLicense trialLicense = trialService.readLicense();
        try {
            answer = trialLicense.isValid().booleanValue() ? LicenseRestrictions.getTrialRestrictions(trialLicense) : LicenseRestrictions.getRestrictions();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                printWriter = response.getWriter();
                printWriter.print(answer);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public static JSONObject getRestrictions() throws JSONException {
        JSONArray restrictions = new JSONArray();
        LicenseData ld = LicenseAccessor.getInstance();
        if (ld.getMaxUsers() != null) {
            JSONObject restriction = new JSONObject();
            restriction.put("type", (Object)MessageHelper.getMessage((String)"licenseType"));
            restriction.put("value", (Object)MessageHelper.getMessage((String)"fullLicense"));
            restrictions.put((Object)restriction);
            restriction = new JSONObject();
            restriction.put("type", (Object)MessageHelper.getMessage((String)"Data_wygasniecia_licencji"));
            restriction.put("value", (Object)(ld.getExpiredDateWithoutTime().equals("0") ? "N/A" : ld.getExpiredDateWithoutTime()));
            restrictions.put((Object)restriction);
            restriction = new JSONObject();
            restriction.put("type", (Object)MessageHelper.getMessage((String)"Maksymalna_liczba_uzytkownikow"));
            restriction.put("value", (Object)(ld.getMaxUsers().equals("0") ? "N/A" : ld.getMaxUsers()));
            restrictions.put((Object)restriction);
            restriction = new JSONObject();
            restriction.put("type", (Object)MessageHelper.getMessage((String)"Maksymalna_liczba_zalogowanych_uzytkownikow"));
            restriction.put("value", (Object)(ld.getMaxActiveSessions().equals("0") ? "N/A" : ld.getMaxActiveSessions()));
            restrictions.put((Object)restriction);
            restriction = new JSONObject();
            restriction.put("type", (Object)MessageHelper.getMessage((String)"Maksymalna_liczba_definicji_procesow"));
            restriction.put("value", (Object)(ld.getMaxDefProcesses().equals("0") ? "N/A" : ld.getMaxDefProcesses()));
            restrictions.put((Object)restriction);
            restriction = new JSONObject();
            restriction.put("type", (Object)MessageHelper.getMessage((String)"Id_procesow"));
            restriction.put("value", (Object)(ld.getProcessesIdAsString().equals("0") ? "N/A" : ld.getProcessesIdAsString()));
            restrictions.put((Object)restriction);
        }
        JSONObject data = new JSONObject();
        data.put("data", (Object)restrictions);
        return data;
    }

    public static JSONObject getTrialRestrictions(TrialLicense license) throws JSONException {
        JSONArray restrictions = new JSONArray();
        if (license.isValid().booleanValue()) {
            JSONObject restriction = new JSONObject();
            restriction.put("type", (Object)MessageHelper.getMessage((String)"licenseType"));
            restriction.put("value", (Object)MessageHelper.getMessage((String)"trialLicense"));
            restrictions.put((Object)restriction);
            restriction = new JSONObject();
            restriction.put("type", (Object)MessageHelper.getMessage((String)"Data_wygasniecia_licencji"));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            restriction.put("value", (Object)format.format(license.getExpireDate()));
            restrictions.put((Object)restriction);
            restriction = new JSONObject();
            restriction.put("type", (Object)MessageHelper.getMessage((String)"Maksymalna_liczba_uzytkownikow"));
            restriction.put("value", (Object)"N/A");
            restrictions.put((Object)restriction);
            restriction = new JSONObject();
            restriction.put("type", (Object)MessageHelper.getMessage((String)"Maksymalna_liczba_zalogowanych_uzytkownikow"));
            restriction.put("value", (Object)"N/A");
            restrictions.put((Object)restriction);
            restriction = new JSONObject();
            restriction.put("type", (Object)MessageHelper.getMessage((String)"Maksymalna_liczba_definicji_procesow"));
            restriction.put("value", (Object)"N/A");
            restrictions.put((Object)restriction);
            restriction = new JSONObject();
            restriction.put("type", (Object)MessageHelper.getMessage((String)"Id_procesow"));
            restriction.put("value", (Object)"N/A");
            restrictions.put((Object)restriction);
        }
        JSONObject data = new JSONObject();
        data.put("data", (Object)restrictions);
        return data;
    }
}

