/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util;

import com.plusmpm.util.sort.properties.SortProperty;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.util.ServiceFactory;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.util.ParamEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayTagUtils {
    private static final Logger log = LoggerFactory.getLogger(DisplayTagUtils.class);

    public static Integer getPageNumber(HttpServletRequest request, String paramId) {
        String pageNrPar = new ParamEncoder(paramId).encodeParameterName("p");
        String pageNr = request.getParameter(pageNrPar);
        return StringUtils.isEmpty((CharSequence)pageNr) ? 0 : Integer.parseInt(pageNr);
    }

    public static Integer getUserPageSize(String userName) {
        return ServiceFactory.getUserSettingsService().getUserPageSize(userName);
    }

    public static <T extends Enum<T>> Sorter getSorter(HttpServletRequest request, String paramId, Class<T> sortProperty) {
        Sorter sorter = new Sorter();
        Integer sortColumnNr = DisplayTagUtils.getSortColumnNumber(request, paramId);
        Enum sortColumn = ((Enum[])sortProperty.getEnumConstants())[0];
        for (Enum enumVal : (Enum[])sortProperty.getEnumConstants()) {
            if (!((SortProperty)((Object)enumVal)).getColumnNumber().equals(sortColumnNr)) continue;
            sortColumn = enumVal;
            break;
        }
        SortDirection sortDirs = DisplayTagUtils.getSortColumnDirection(request, paramId, ((SortProperty)((Object)sortColumn)).getDefaultSortOrder());
        sorter.setProperty(((SortProperty)((Object)sortColumn)).getProperty());
        sorter.setDirection(sortDirs);
        return sorter;
    }

    private static Integer getSortColumnNumber(HttpServletRequest request, String paramId) {
        String sortColumnNumberParameterName = new ParamEncoder(paramId).encodeParameterName("s");
        String sortColumnNumberParameter = request.getParameter(sortColumnNumberParameterName);
        if (StringUtils.isNotEmpty((CharSequence)sortColumnNumberParameter)) {
            return Integer.parseInt(sortColumnNumberParameter);
        }
        return -1;
    }

    private static SortDirection getSortColumnDirection(HttpServletRequest request, String paramId, SortDirection defaultOrder) {
        String orderDescParamName = new ParamEncoder(paramId).encodeParameterName("o");
        String orderDescParam = request.getParameter(orderDescParamName);
        if (StringUtils.isNotEmpty((CharSequence)orderDescParam)) {
            return !orderDescParam.equals("2") ? SortDirection.DESC : SortDirection.ASC;
        }
        return defaultOrder;
    }

    public static Integer getStartIndex(Integer pageNr, Integer pageSize) {
        return pageNr == 0 ? 0 : (pageNr - 1) * pageSize;
    }

    public static Boolean isExport(String id, HttpServletRequest request) {
        try {
            String exportType = new ParamEncoder(id).encodeParameterName("e");
            return request.getParameter(exportType) != null;
        }
        catch (Exception e) {
            log.info("Bl\u0105d eksportu. Brak parametru odpowiedzialnego oznaczaj\u0105cego eksport");
            return false;
        }
    }
}

