/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.AdvanceSearchVariableTable;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.UserSearchViewTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.struts.form.SearchAllViewsForm;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.UsersManagement;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.CollatorInstance;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.view.ViewService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class FilterViewsAction
extends Action {
    public static final Logger log = Logger.getLogger(FilterViewsAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        String sUserName = (String)session.getAttribute("username");
        ArrayList<UserSearchViewTable> alUserViews = null;
        DBManagement dbManagement = new DBManagement(request);
        String keyupFiltering = request.getParameter("keyupFiltering");
        boolean bShowAllViews = false;
        boolean bKeyupFiltering = false;
        int iRes = -1;
        try {
            iRes = Authorization.checkRight((String)"System", (String)sUserName, (boolean)false, (boolean)false);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            iRes = -1;
        }
        if (!StringUtils.isEmpty((CharSequence)keyupFiltering)) {
            bKeyupFiltering = Boolean.parseBoolean(keyupFiltering);
        }
        int pageSize = UsersManagement.getUserDefinedPageSize((String)sUserName);
        int totalCount = 0;
        SearchAllViewsForm searchAllViewsForm = (SearchAllViewsForm)form;
        if (iRes == 0) {
            alUserViews = dbManagement.FilterUserSearchViews(searchAllViewsForm.getUserViewName(), searchAllViewsForm.getUserViewDescr(), searchAllViewsForm.getUserViewOwner(), bKeyupFiltering);
            bShowAllViews = true;
        } else {
            alUserViews = this.getFilteredUserViews(sUserName, searchAllViewsForm.getUserViewName(), searchAllViewsForm.getUserViewDescr(), searchAllViewsForm.getUserViewOwner());
        }
        if (alUserViews != null) {
            totalCount = alUserViews.size();
            ViewService viewService = ServiceFactory.getViewService();
            for (UserSearchViewTable userView : alUserViews) {
                userView.setViewDescr(viewService.getViewTranslation(userView.getId(), TranslatedFieldType.DESCRIPTION));
                userView.setViewName(viewService.getViewTranslation(userView.getId(), TranslatedFieldType.NAME));
            }
            alUserViews.sort(Comparator.comparing(UserSearchViewTable::getViewName, CollatorInstance.get()));
        }
        request.setAttribute("showAllViews", (Object)bShowAllViews);
        request.setAttribute("iMaxPageSize", (Object)String.valueOf(totalCount));
        request.setAttribute("iPageSize", (Object)String.valueOf(pageSize));
        request.setAttribute("alUserViews", alUserViews);
        if (bKeyupFiltering) {
            return mapping.findForward("showFilteredViewsList");
        }
        return mapping.findForward("showFilteredViews");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<UserSearchViewTable> getFilteredUserViews(String sUserName, String userViewName, String userViewDescr, String userViewOwner) {
        DBManagement dbm = new DBManagement();
        Connection con = null;
        ArrayList alUserViews = dbm.GetAllUserSearchViewsForUserSource(sUserName, "advanceSearch");
        try {
            con = DBUtils.connectToDB();
            for (int i = alUserViews.size() - 1; i >= 0; --i) {
                UserSearchViewTable view = (UserSearchViewTable)alUserViews.get(i);
                if (!StringUtils.isEmpty((CharSequence)userViewName) && !view.getViewName().contains(userViewName)) {
                    alUserViews.remove(i);
                    continue;
                }
                if (!StringUtils.isEmpty((CharSequence)userViewDescr) && !view.getViewDescr().contains(userViewDescr)) {
                    alUserViews.remove(i);
                    continue;
                }
                if (!StringUtils.isEmpty((CharSequence)userViewOwner) && !view.getUserName().contains(userViewOwner)) {
                    alUserViews.remove(i);
                    continue;
                }
                String sViewId = view.getId().toString();
                AdvanceSearchVariableTable viewVariable = dbm.getAdvanceSearchVariableByNameAndViewId("procDefId", sViewId);
                String viewProcDefId = viewVariable.getValue();
                if (!this.hasRight(viewProcDefId, sUserName, con)) {
                    alUserViews.remove(i);
                    continue;
                }
                viewVariable = dbm.getAdvanceSearchVariableByNameAndViewId("processType", sViewId);
                viewProcDefId = viewVariable.getValue();
                if (this.hasRight(viewProcDefId, sUserName, con)) continue;
                alUserViews.remove(i);
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            DBUtils.closeConnection((Connection)con);
        }
        return alUserViews;
    }

    private boolean hasRight(String viewProcDefId, String sUserName, Connection con) throws SQLException {
        String rightLevel;
        return StringUtils.isEmpty((CharSequence)viewProcDefId) || Authorization.checkRight((Connection)con, (String)(rightLevel = RightTreeBuilder.builder().system().workflow().processes().view().custom((Object)viewProcDefId).build()), (String)sUserName, (boolean)false, (boolean)false) == 0;
    }
}

