/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.simulation.duplicated.context.activity;

import com.plusmpm.enhydra.shark.WfActivityManager;
import com.plusmpm.util.SharkFunctions;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.SharkTransactional;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.SharkUtils;
import com.suncode.pwfl.util.Sneaky;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.process.internal.InternalProcessService;
import com.suncode.pwfl.workflow.process.internal.exception.AlreadyAccepted;
import com.suncode.pwfl.workflow.process.internal.exception.AlreadyAcceptingByAnotherUser;
import com.suncode.pwfl.workflow.simulation.duplicated.SimulationUtils;
import com.suncode.pwfl.workflow.simulation.duplicated.context.activity.SimulationActivityService;
import com.suncode.pwfl.workflow.simulation.duplicated.exception.SimulationException;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfResource;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.springframework.beans.factory.annotation.Autowired;

public class SimulationActivityServiceImpl
implements SimulationActivityService {
    private final TransactionWrapper transactionWrapper;
    private final SharkTransactionManager sharkTransactionManager;
    private final InternalProcessService internalProcessService;

    public List<String> getOpenedActivities(String processId) {
        return (List)this.transactionWrapper.doInSharkTransaction(sharkTransaction -> {
            try {
                return this.getActivitiesByState(sharkTransaction, processId, ActivityState::isOpen);
            }
            catch (Exception e) {
                throw new SimulationException(String.format("Failed to get opened activities for processId [%s]", processId), (Throwable)e);
            }
        });
    }

    private List<String> getActivitiesByState(SharkTransaction sharkTransaction, String processId, Predicate<ActivityState> predicate) throws Exception {
        WfProcess wfProcess = SharkFunctions.getWfProcess((SharkTransaction)sharkTransaction, (String)processId);
        return this.streamActivitiesByState(sharkTransaction, wfProcess, predicate).map(wfActivity -> (String)Sneaky.throwing(() -> wfActivity.key(sharkTransaction))).collect(Collectors.toCollection(ArrayList::new));
    }

    public Stream<WfActivity> streamActivitiesByState(SharkTransaction sharkTransaction, WfProcess wfProcess, Predicate<ActivityState> predicate) throws Exception {
        return Arrays.stream(wfProcess.get_sequence_step(sharkTransaction, 0)).filter(wfActivity -> (Boolean)Sneaky.throwing(() -> {
            String state = wfActivity.state(sharkTransaction);
            ActivityState activityState = ActivityState.getState((String)state);
            return predicate.test(activityState);
        }));
    }

    public void claimActivity(String processId, String activityId) {
        this.transactionWrapper.doInSharkTransaction(sharkTransaction -> {
            try {
                String activityState;
                WfAssignment currentAssignment = this.internalProcessService.checkIfCanOpen(sharkTransaction, "admin", processId, activityId);
                WfActivity currentActivity = currentAssignment.activity(sharkTransaction);
                if (!currentAssignment.get_accepted_status(sharkTransaction) && (activityState = currentActivity.state(sharkTransaction)).compareToIgnoreCase("open.running") != 0) {
                    currentActivity.change_state(sharkTransaction, "open.running");
                }
                if (currentAssignment.get_accepted_status(sharkTransaction)) {
                    ExecutionAdministration executionAdministration = SharkUtils.createExecutionAdministration((String)"admin");
                    WfResource userResource = executionAdministration.getResource(sharkTransaction, "admin");
                    currentAssignment = SharkFunctions.GetWfAssignment((SharkTransaction)sharkTransaction, (ExecutionAdministration)executionAdministration, (String)processId, (String)activityId, (String)"admin");
                    if (currentAssignment == null) {
                        throw new AlreadyAccepted();
                    }
                    if (!userResource.is_member_of_work_items(sharkTransaction, currentAssignment)) {
                        throw new AlreadyAcceptingByAnotherUser();
                    }
                }
            }
            catch (Exception e) {
                throw new SimulationException(String.format("Failed to claim activity [%s]", activityId), (Throwable)e);
            }
        });
    }

    public void acceptActivity(String processId, String activityId, String actionName) {
        this.transactionWrapper.doInSharkTransaction(sharkTransaction -> {
            try {
                WfActivityManager wfActivityManager = new WfActivityManager(activityId, processId, "admin", actionName);
                wfActivityManager.acceptActivitySequentially(sharkTransaction);
            }
            catch (Throwable e) {
                throw new SimulationException(String.format("Failed to accept activity [%s]", activityId), e);
            }
        });
    }

    @SharkTransactional
    public Map<String, Object> getActivityContext(String processId, String activityId) {
        Map context = null;
        SharkTransaction st = this.sharkTransactionManager.getSharkTransaction();
        try {
            WfActivity wfActivity = SharkUtils.getExecutionAdministration().getActivity(st, processId, activityId);
            context = wfActivity.process_context(st);
        }
        catch (Exception e) {
            throw new ServiceException("Nie uda\u0142o si\u0119 pobra\u0107 kontekstu mapy zadania [" + activityId + "] z procesu [" + processId + "] : ", (Throwable)e);
        }
        return context;
    }

    @ConstructorProperties(value={"transactionWrapper", "sharkTransactionManager", "internalProcessService"})
    @Autowired
    public SimulationActivityServiceImpl(TransactionWrapper transactionWrapper, SharkTransactionManager sharkTransactionManager, InternalProcessService internalProcessService) {
        this.transactionWrapper = transactionWrapper;
        this.sharkTransactionManager = sharkTransactionManager;
        this.internalProcessService = internalProcessService;
    }

    static {
        SimulationUtils.assertIsInSimulation();
    }
}

