/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.simulation.duplicated.context;

import com.plusmpm.database.hibernate.DatabaseVendor;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.plugin.framework.web.mvc.support.DelegatingServletConfig;
import com.suncode.pwfl.persistence.support.hibernate.SpringSessionFactory;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.SharkTransactionManagerImpl;
import com.suncode.pwfl.web.util.PlusworkflowObjectMapper;
import com.suncode.pwfl.workflow.simulation.delegated.SimulationClassLoaderImpl;
import com.suncode.pwfl.workflow.simulation.duplicated.Simulation;
import com.suncode.pwfl.workflow.simulation.duplicated.SimulationUtils;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.hibernate.SessionFactory;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyJpaImpl;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBuilder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Import(value={PlusworkflowObjectMapper.class})
public class SimulationConfiguration
extends WebMvcConfigurationSupport {
    @Bean
    public SessionFactory sessionFactory() {
        Simulation simulation = Simulation.getInstance();
        LocalSessionFactoryBuilder configuration = new LocalSessionFactoryBuilder((DataSource)simulation.getDataSource(), ((Object)((Object)this)).getClass().getClassLoader());
        configuration.configure("shark-simulation/hibernate/simulation-persistence.cfg.xml");
        Properties properties = configuration.getProperties();
        properties.put("hibernate.connection.datasource", simulation.getDataSource());
        properties.put("hibernate.dialect", simulation.getDialect());
        configuration.setImplicitNamingStrategy((ImplicitNamingStrategy)new ImplicitNamingStrategyLegacyJpaImpl());
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        DatabaseVendor vendor = DatabaseVendor.getInstance((Dialect)simulation.getDialect());
        HibernateUtil.init((SessionFactory)sessionFactory, (Dialect)simulation.getDialect(), (DatabaseVendor)vendor, (Configuration)configuration);
        return SpringSessionFactory.proxy((SessionFactory)sessionFactory);
    }

    @Bean
    @Primary
    public HibernateTransactionManager transactionManager(@Autowired SessionFactory sessionFactory) {
        return new HibernateTransactionManager(sessionFactory);
    }

    @Bean
    public SharkTransactionManager sharkTransactionManager() {
        return new SharkTransactionManagerImpl();
    }

    @Bean
    public BeanPostProcessor beanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                String className = bean.getClass().getName();
                if (!SimulationClassLoaderImpl.isFromDuplicatedPackage((String)className)) {
                    return bean;
                }
                ProxyFactory proxyFactory = new ProxyFactory(bean);
                proxyFactory.addAdvice((Advice)new Simulation.ThreadContextClassLoaderInterceptor());
                return proxyFactory.getProxy(Simulation.class.getClassLoader());
            }
        };
    }

    public void configureViewResolvers(ViewResolverRegistry registry) {
        registry.jsp("/pages", "");
    }

    protected RequestMappingHandlerMapping createRequestMappingHandlerMapping() {
        RequestMappingHandlerMapping handlerMapping = new RequestMappingHandlerMapping();
        handlerMapping.setPathPrefixes(Map.of("/" + Simulation.getInstance().getId(), clazz -> true));
        return handlerMapping;
    }

    @Bean
    public DispatcherServlet dispatcherServlet(@Autowired WebApplicationContext webApplicationContext) throws ServletException {
        DispatcherServlet dispatcherServlet = new DispatcherServlet(webApplicationContext);
        dispatcherServlet.setPublishContext(false);
        dispatcherServlet.setPublishEvents(false);
        Simulation simulation = Simulation.getInstance();
        DelegatingServletConfig servletConfig = new DelegatingServletConfig(simulation.getId(), simulation.getConfig().getServletContext());
        dispatcherServlet.init((ServletConfig)servletConfig);
        return dispatcherServlet;
    }

    static {
        SimulationUtils.assertIsInSimulation();
    }
}

