/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.workflow.process.summary;

import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.dto.workflow.process.map.ActivityDto;
import com.suncode.pwfl.web.dto.workflow.process.map.ProcessDto;
import java.beans.ConstructorProperties;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessMapSummaryGenerator {
    private final MessageHelperBean messageHelperBean;
    final String BOLD_TAG_BEGIN = "<b>";
    final String BOLD_TAG_END = "</b>";
    final String NEW_LINE_TAG = "<br>";

    public String generateSummary(ProcessDto processDto) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<b>").append(this.messageHelperBean.getMessage("Podsumowanie")).append("</b>").append("<br>");
        stringBuilder.append("<b>").append(this.messageHelperBean.getMessage("Wygenerowano_proces")).append(":").append("</b>").append("<br>");
        stringBuilder.append(processDto.getName()).append("<br>");
        stringBuilder.append("<b>").append(this.messageHelperBean.getMessage("Wygenerowano_zadania")).append(":").append("</b>").append("<br>");
        stringBuilder.append(processDto.getActivities().stream().map(ActivityDto::getName).collect(Collectors.joining("<br>"))).append("<br>");
        stringBuilder.append("<b>").append(this.messageHelperBean.getMessage("Wygenerowano_zmienne")).append(":").append("</b>").append("<br>");
        stringBuilder.append(processDto.getVariables().stream().map(variableDto -> variableDto.getName() + "(" + this.messageHelperBean.getMessage("VariableType_" + variableDto.getType()) + ")").collect(Collectors.joining("<br>")));
        return stringBuilder.toString();
    }

    @ConstructorProperties(value={"messageHelperBean"})
    @Autowired
    public ProcessMapSummaryGenerator(MessageHelperBean messageHelperBean) {
        this.messageHelperBean = messageHelperBean;
    }
}

