/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.process;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.AdvanceSearchVariableTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.CoreTools;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.substitution.SubstitutionHook;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.hook.HookRegistry;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import com.suncode.pwfl.language.LanguageUtils;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.CollatorInstance;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.SharkUtils;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.view.dto.ViewDto;
import com.suncode.pwfl.web.dto.archive.ProcessTypeDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.web.support.ajax.ResponseMessageLevel;
import com.suncode.pwfl.web.support.ajax.RestResponse;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.assignment.WfParticipant;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessDataService;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import com.suncode.pwfl.workflow.process.util.CreateProcessResult;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/processes"})
@Api(tags={"processes"})
public class ProcessController {
    private static final Logger log = LoggerFactory.getLogger(ProcessController.class);
    private final AuthorizationHelper authorizationHelper;
    private final ProcessService processService;
    private final ProcessDataService processDataService;
    private final ExportService exportService;
    private final MessageHelperBean messageHelper;
    private final ViewService viewService;
    private final HookRegistry hookRegistry;
    private final Map<UUID, List<ProcessType>> exportCache = new HashMap<UUID, List<ProcessType>>();

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"{processDefId}/participants"})
    @ResponseBody
    public List<WfParticipant> getProcessParticipants(@PathVariable String processDefId) {
        return this.processService.getParticipantsFromProcess(processDefId);
    }

    @ApiOperation(value="Downloading task information for a given process definition ID", notes="Returns a list of tasks (definition and name) from the latest package")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    @GetMapping(value={"/definition/{processDefinitionId}/activities"})
    @ResponseBody
    public ResponseEntity<List<ActivityDefinitionIdAndNameDto>> getActivitiesByProcessDefinitionId(@ApiParam(value="Id of the process definition from which it should retrieve task information", required=true) @PathVariable String processDefinitionId) {
        Package pack = XpdlPackageManager.getInstance().getPackageByProcessDefinitionId(processDefinitionId);
        if (pack == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        WorkflowProcess workflowProcess = pack.getWorkflowProcess(processDefinitionId);
        ArrayList activities = workflowProcess.getActivities().toElements();
        List definitions = activities.stream().map(activity -> this.mapActivitytoDefinitionIdAndName((Activity)activity, pack, processDefinitionId)).collect(Collectors.toList());
        return new ResponseEntity(definitions, (HttpStatusCode)HttpStatus.OK);
    }

    @ApiOperation(value="Process creation", notes="The query contains a JSON object containing the acceptance parameters. The definition should include the following fields\n- **packageId** - Id of the package\n- **processDefId** - Id of the process definition\n- **variables** - Map of variable values in which the key is the id of the variable")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    @PostMapping(value={"/create"})
    @ResponseBody
    public CreateProcessResult createProcess(HttpServletRequest request, @ApiParam(value="Process creation definition", required=true) @RequestBody ProcessBuilderDefinition definition) {
        CreateProcessResult processResult;
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_PROCESS);
        HashMap<String, String> auditParameters = new HashMap<String, String>();
        if (StringUtils.isBlank((String)definition.getProcessDefId()) || StringUtils.isBlank((String)definition.getPackageId())) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Nie_podano_wymaganych_parametrow"));
        }
        ProcessDefinition processDefinition = this.processService.getProcessDefinition(definition.getProcessDefId());
        if (processDefinition == null || !processDefinition.getPackageId().equals(definition.getPackageId())) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Niepoprawne_dane_procesu"));
        }
        String rightsPath = RightTreeBuilder.builder().system().workflow().processes().create().custom((Object)definition.getProcessDefId()).build();
        this.authorizationHelper.assertFullOrPartRights(rightsPath, () -> {
            auditParameters.put("ERROR_MESSAGE", this.messageHelper.getMessage("Brak_uprawnien_aby_utworzyc_proces"));
            auditBuilder.params(auditParameters);
            auditBuilder.buildFailure(request);
        });
        definition.setCreator(SessionUtils.getLoggedUserName());
        try {
            processResult = this.processService.createProcessWithResult(definition);
        }
        catch (Exception e) {
            auditParameters.put("ERROR_MESSAGE", e.getCause().getLocalizedMessage());
            auditBuilder.params(auditParameters);
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditParameters.put("processId", definition.getProcessDefId());
        auditParameters.put("processPackageId", definition.getPackageId());
        auditParameters.put("procesName", this.processService.getProcess(processResult.getProcessId(), new String[0]).getName());
        auditBuilder.params(auditParameters);
        auditBuilder.buildSuccess(request);
        return processResult;
    }

    @ApiOperation(value="Deleting process", notes="Deletes process with given processId")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @GetMapping(value={"/delete"})
    @ResponseBody
    public RestResponse<?> deleteProcess(HttpServletRequest request, @ApiParam(value="Id of the process", required=true) @RequestParam String processId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PROCESS);
        auditBuilder.params(this.getAuditParams(processId));
        String processDefinitionId = SharkFunctions.getProcessDefId((String)processId);
        String rightsPath = RightTreeBuilder.builder().system().workflow().processes().delete().custom((Object)processDefinitionId).build();
        this.authorizationHelper.assertFullOrPartRights(rightsPath, () -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            String message = this.prepareProcessActionSuccessMessage(processId, processDefinitionId, this.messageHelper.getMessage("zostal_usuniety"), new I18Nxpdl(request));
            this.processService.deleteProcess(processId);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ApiOperation(value="Aborting process", notes="Aborts process with given processId")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @GetMapping(value={"/abort"})
    @ResponseBody
    public RestResponse<?> abortProcess(HttpServletRequest request, @ApiParam(value="Id of the process", required=true) @RequestParam String processId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ABORT_PROCESS);
        auditBuilder.params(this.getAuditParams(processId));
        String processDefinitionId = SharkFunctions.getProcessDefId((String)processId);
        String rightsPath = RightTreeBuilder.builder().system().workflow().processes().delete().custom((Object)processDefinitionId).build();
        this.authorizationHelper.assertFullOrPartRights(rightsPath, () -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            this.processService.abort(processId, false);
            String message = this.prepareProcessActionSuccessMessage(processId, processDefinitionId, this.messageHelper.getMessage("zostal_anulowany"), new I18Nxpdl(request));
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ApiOperation(value="Download available process types for the user", notes="Retrieves a list of available process types for the logged-in user")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    @GetMapping(value={"types"})
    @ResponseBody
    public List<ProcessType> getTypes(@RequestParam(required=false, defaultValue="false") boolean isMobile) {
        return this.getTypesList(isMobile);
    }

    private List<ProcessType> getTypesList(boolean isMobile) {
        List processTypesList = this.processService.getProcessTypesForUser(SessionUtils.getLoggedUserName());
        if (isMobile) {
            processTypesList.removeIf(processType -> {
                String allowMobileTextValue = this.processDataService.getProcessData(processType.getProcessDefId(), "", "allowMobile");
                boolean allowMobile = true;
                if (StringUtils.isNotBlank((String)allowMobileTextValue)) {
                    allowMobile = Boolean.parseBoolean(allowMobileTextValue);
                }
                return !allowMobile;
            });
        }
        return processTypesList.stream().sorted(DtoComparator.of(ProcessType.class, (String)"name", (SortDirection)SortDirection.ASC).withIgnoreCase(true)).collect(Collectors.toList());
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"types/export/{extension}"})
    public void typesExport(HttpServletResponse response, @RequestParam(value="query", required=false, defaultValue="") String rawQuery, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id, @PathVariable String extension) throws IOException {
        List<ProcessType> sortedProcessTypesList = id == null ? this.getProcessTypesFromQuery(rawQuery, sortBy, sortDirection) : this.getProcessTypesFromCache(id);
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_procesu")).data(sortedProcessTypesList).by(ProcessType::getName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis_procesu")).data(sortedProcessTypesList).by(ProcessType::getDescription).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Procesy")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ApiOperation(value="", hidden=true)
    @PostMapping(value={"types/export/{extension}"})
    @ResponseBody
    public URI typesExport(HttpServletRequest request, @RequestBody List<ProcessType> processTypesToExport, @PathVariable String extension, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws URISyntaxException {
        UUID id;
        while (this.exportCache.containsKey(id = UUID.randomUUID())) {
        }
        this.exportCache.put(id, processTypesToExport);
        URI redirectUri = URI.create(request.getRequestURI());
        redirectUri = redirectUri.getQuery() != null ? URI.create(request.getRequestURI() + String.format("&id=%s", id)) : URI.create(request.getRequestURI() + String.format("?id=%s", id));
        return redirectUri;
    }

    private List<ProcessType> getProcessTypesFromQuery(String rawQuery, String sortBy, SortDirection sortDirection) {
        boolean exactSearch = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.EXACT_SEARCH);
        String query = exactSearch ? rawQuery.trim() : rawQuery.trim().toLowerCase();
        List<ProcessType> processTypesList = exactSearch ? this.exactFilterTypes(this.getTypesList(false), query) : this.filterTypes(this.getTypesList(false), query);
        List<ProcessType> sortedProcessTypesList = processTypesList.stream().sorted(this.comparatorFor(sortBy, sortDirection)).collect(Collectors.toList());
        return sortedProcessTypesList;
    }

    private List<ProcessType> getProcessTypesFromCache(UUID id) {
        List<ProcessType> processTypes = this.exportCache.get(id);
        this.exportCache.remove(processTypes);
        return processTypes;
    }

    private List<ProcessType> filterTypes(List<ProcessType> types, String query) {
        return types.stream().filter(type -> type.getName().toLowerCase().contains(query) || type.getDescription().toLowerCase().contains(query)).collect(Collectors.toList());
    }

    private List<ProcessType> exactFilterTypes(List<ProcessType> types, String query) {
        return types.stream().filter(type -> type.getName().equals(query) || type.getDescription().equals(query)).collect(Collectors.toList());
    }

    private Comparator<ProcessType> comparatorFor(String sortBy, SortDirection sortDirection) {
        Collator collator = CollatorInstance.get();
        Comparator<ProcessType> comparator = switch (sortBy) {
            case "name" -> Comparator.comparing(ProcessType::getName, collator);
            case "description" -> Comparator.comparing(ProcessType::getDescription, collator);
            default -> throw new IllegalArgumentException();
        };
        if (sortDirection == SortDirection.DESC) {
            return comparator.reversed();
        }
        return comparator;
    }

    @ApiOperation(value="Downloading search process types", notes="Retrieves search process types")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @GetMapping(value={"types/search"})
    public ResponseEntity<List<ProcessType>> getSearchProcessTypes() {
        return this.authorizationHelper.ensureSearchAccess(this::getAllProcessTypes);
    }

    @ApiOperation(value="Downloading search process types for view", notes="Retrieves search process types for view with given id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @GetMapping(value={"types/search/{viewId}"})
    public ResponseEntity<List<ProcessType>> getSearchProcessTypesForView(@ApiParam(value="Id of the process", required=true) @PathVariable String viewId) {
        if (StringUtils.isNotBlank((String)viewId) && NumberUtils.isParsable((String)viewId)) {
            AdvanceSearchVariableTable processTypeVariable;
            String processTypes;
            ViewDto view = this.viewService.getView(Long.valueOf(viewId));
            if (!view.getOwnerUsername().equals(SessionUtils.getLoggedUserName()) && StringUtils.isNotBlank((String)(processTypes = (processTypeVariable = CoreTools.getAdvanceSearchVariableByNameAndViewId((String)"processType", (String)viewId)).getValue()))) {
                List<String> viewProcessTypes = Arrays.asList(processTypes.split(";"));
                List permittedProcessTypes = this.processService.getAllProcessTypes(false).stream().filter(processType -> viewProcessTypes.contains(processType.getProcessDefId())).collect(Collectors.toList());
                return new ResponseEntity(permittedProcessTypes, (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity(this.getAllProcessTypes(), (HttpStatusCode)HttpStatus.OK);
        }
        return this.authorizationHelper.ensureSearchAccess(this::getAllProcessTypes);
    }

    @ApiOperation(value="Downloading process context", notes="Retrieves process context for given processId")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @GetMapping(value={"/context"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> getContext(@ApiParam(value="Id of the process", required=true) @RequestParam String processId) {
        return this.authorizationHelper.ensureProcessAccess(processId, null, () -> this.processService.getProcessContext(processId));
    }

    private ActivityDefinitionIdAndNameDto mapActivitytoDefinitionIdAndName(Activity activity, Package pack, String processDefinitionId) {
        String activityDefinitionId = activity.getId();
        String activityName = PackageTranslationHelper.getActivityName((String)pack.getId(), (String)processDefinitionId, (String)activityDefinitionId);
        return new ActivityDefinitionIdAndNameDto(activityDefinitionId, activityName);
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"/types/all"})
    @ResponseBody
    public List<ProcessTypeDto> getAllTypes(HttpServletRequest request) {
        return this.getProcessTypeDtos(request).stream().sorted((proc1, proc2) -> proc1.getTranslatedName().compareToIgnoreCase(proc2.getTranslatedName())).collect(Collectors.toList());
    }

    private List<ProcessTypeDto> getProcessTypeDtos(HttpServletRequest request) {
        I18Nxpdl xpdlTranslator = new I18Nxpdl(request);
        return this.processService.getAllProcessTypes(false).stream().map(processType -> ProcessTypeDto.of(processType, xpdlTranslator)).collect(Collectors.toList());
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"/types/user"})
    @ResponseBody
    public List<ProcessTypeDto> getUserProcessesTypes(HttpServletRequest request) {
        return this.getProcessTypeDtos(request).stream().filter(processTypeDto -> Authorization.isProcessVisibleToUser((String)UserContext.current().getUser().getUserName(), (String)processTypeDto.getProcessDefId())).collect(Collectors.toList());
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"/types/all/counted-result"})
    @ResponseBody
    public CountedResult<ProcessTypeDto> getAllTypesCountedResult(HttpServletRequest request, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        List processTypeDtos = this.getProcessTypeDtos(request).stream().sorted(DtoComparator.of(ProcessTypeDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(processTypeDtos).pageByOffset(start, limit);
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"/types/forSubstitutions"})
    @ResponseBody
    public List<ProcessTypeDto> getProcessTypeForSubstitutions(HttpServletRequest request, @RequestParam(required=false) String username) {
        String login = StringUtils.defaultString((String)username, (String)UserContext.current().getUser().getUserName());
        I18Nxpdl xpdlTranslator = new I18Nxpdl(request);
        List processes = this.processService.getAllProcessTypes(false);
        if (!this.hookRegistry.hasHooks(SubstitutionHook.class)) {
            return processes.stream().filter(processTypeDto -> Authorization.isProcessVisibleToUser((String)username, (String)processTypeDto.getProcessDefId())).map(processType -> ProcessTypeDto.of(processType, xpdlTranslator)).sorted((Comparator<ProcessTypeDto>)DtoComparator.of(ProcessTypeDto.class, (String)"translatedName", (SortDirection)SortDirection.ASC).withIgnoreCase(true)).collect(Collectors.toList());
        }
        return ((SubstitutionHook)this.hookRegistry.invoke(SubstitutionHook.class)).filterProcesses(login, processes).stream().map(processType -> ProcessTypeDto.of(processType, xpdlTranslator)).sorted((Comparator<ProcessTypeDto>)DtoComparator.of(ProcessTypeDto.class, (String)"translatedName", (SortDirection)SortDirection.ASC).withIgnoreCase(true)).collect(Collectors.toList());
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"{processDefId}/search/access"})
    public ResponseEntity<Boolean> userHasAccessToSearchProcess(@PathVariable String processDefId) {
        return this.authorizationHelper.ensureSearchAccess(() -> this.authorizationHelper.hasSearchProcessAccess(processDefId));
    }

    private List<ProcessType> getAllProcessTypes() {
        return this.processService.getAllProcessTypes(false).stream().filter(processType -> this.authorizationHelper.hasSearchProcessAccess(processType.getProcessDefId())).sorted((proc1, proc2) -> proc1.getName().compareToIgnoreCase(proc2.getName())).collect(Collectors.toList());
    }

    private String prepareProcessActionSuccessMessage(String processId, String processDefinitionId, String suffix, I18Nxpdl xpdl) {
        String translatedProcessName;
        try {
            WfProcess wfProcess = SharkUtils.getExecutionAdministration().getProcess(processId);
            String processName = wfProcess.name();
            translatedProcessName = LanguageUtils.getProcessName((I18Nxpdl)xpdl, (String)processName, (String)processDefinitionId);
        }
        catch (Exception e) {
            translatedProcessName = processId;
        }
        StringBuilder messageBuilder = new StringBuilder();
        String EMPTY_CHAR = " ";
        return messageBuilder.append(this.messageHelper.getMessage("Proces")).append(EMPTY_CHAR).append(translatedProcessName).append(EMPTY_CHAR).append(suffix).toString();
    }

    @ExceptionHandler(value={NoRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResponse<?> handleNoRightsException(NoRightsException e) {
        log.info(this.messageHelper.getMessage("process.action.error.forbidden.message"));
        return new RestResponse(this.messageHelper.getMessage("process.action.error.forbidden.message"), ResponseMessageLevel.ERROR);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResponse<?> handleIllegalArgumentException(IllegalArgumentException e) {
        log.info(e.getMessage());
        return new RestResponse(e.getMessage(), ResponseMessageLevel.ERROR);
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public RestResponse<?> handleServiceException(ServiceException e) {
        log.info(e.getMessage());
        return new RestResponse(e.getMessage(), ResponseMessageLevel.ERROR);
    }

    private Map<String, Object> getAuditParams(String processId) {
        Process process = this.processService.getProcess(processId, new String[]{"processDefinition"});
        return ImmutableMap.builder().put((Object)"processId", (Object)processId).put((Object)"processDefId", (Object)process.getProcessDefinition().getProcessDefinitionId()).put((Object)"package_name", (Object)process.getProcessDefinition().getPackageId()).put((Object)"process_name", (Object)process.getRawName()).build();
    }

    @ConstructorProperties(value={"authorizationHelper", "processService", "processDataService", "exportService", "messageHelper", "viewService", "hookRegistry"})
    @Autowired
    public ProcessController(AuthorizationHelper authorizationHelper, ProcessService processService, ProcessDataService processDataService, ExportService exportService, MessageHelperBean messageHelper, ViewService viewService, HookRegistry hookRegistry) {
        this.authorizationHelper = authorizationHelper;
        this.processService = processService;
        this.processDataService = processDataService;
        this.exportService = exportService;
        this.messageHelper = messageHelper;
        this.viewService = viewService;
        this.hookRegistry = hookRegistry;
    }

    public static class ActivityDefinitionIdAndNameDto {
        String activityDefinitionId;
        String activityName;

        public String getActivityDefinitionId() {
            return this.activityDefinitionId;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public void setActivityDefinitionId(String activityDefinitionId) {
            this.activityDefinitionId = activityDefinitionId;
        }

        public void setActivityName(String activityName) {
            this.activityName = activityName;
        }

        @ConstructorProperties(value={"activityDefinitionId", "activityName"})
        public ActivityDefinitionIdAndNameDto(String activityDefinitionId, String activityName) {
            this.activityDefinitionId = activityDefinitionId;
            this.activityName = activityName;
        }

        public ActivityDefinitionIdAndNameDto() {
        }
    }
}

