/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.activity.finder.view.search.mapper;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.web.controller.api.workflow.activity.finder.view.search.dto.ActivityViewSearchCriteria;
import com.suncode.pwfl.web.controller.api.workflow.activity.finder.view.search.dto.ViewVariableCriteria;
import com.suncode.pwfl.web.search.model.ActivityDetailsSearchModelDto;
import com.suncode.pwfl.web.search.model.ProcessDetailsSearchModelDto;
import com.suncode.pwfl.web.search.model.ProcessVariablesSearchModelDto;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.search.model.ValueSearchModelDto;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import io.micrometer.common.util.StringUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityViewSearchModelMapper {
    @Autowired
    private ProcessService processService;

    public void applySearchFilters(SearchFormModelDto searchFormModel, ActivityViewSearchCriteria activityViewSearchCriteria) {
        this.applyVariableSearchFilters(searchFormModel.getProcessVariablesSearchModel(), activityViewSearchCriteria.getVariableCriteria());
        this.applyActivitySearchFilters(searchFormModel.getActivityDetailsSearchModel(), activityViewSearchCriteria.getActivityCriteria());
        this.applyProcessSearchFilters(searchFormModel.getProcessDetailsSearchModel(), activityViewSearchCriteria.getProcessCriteria());
    }

    private void applyVariableSearchFilters(ProcessVariablesSearchModelDto processVariablesSearchModelDto, List<ViewVariableCriteria> filters) {
        if (CollectionUtils.isEmpty(filters)) {
            return;
        }
        filters.forEach(filter -> processVariablesSearchModelDto.getVariables().stream().filter(variableSearchModelDto -> variableSearchModelDto.getId().equals(filter.getId())).findFirst().ifPresent(variableSearchModelDto -> this.mapFilterToSearchFormValue((ViewVariableCriteria)filter, variableSearchModelDto.getValue(), true, false)));
    }

    private void applyActivitySearchFilters(ActivityDetailsSearchModelDto activityDetailsSearchModelDto, List<ViewVariableCriteria> activityFilters) {
        if (CollectionUtils.isEmpty(activityFilters)) {
            return;
        }
        activityFilters.forEach(filter -> {
            Optional<ValueSearchModelDto> activityValueSearchModel = this.getActivityValueSearchModel(filter.getId(), activityDetailsSearchModelDto);
            boolean mergeValues = filter.getId().equalsIgnoreCase("activityState") || filter.getId().equalsIgnoreCase("activityPerformer");
            activityValueSearchModel.ifPresent(valueSearchModelDto -> this.mapFilterToSearchFormValue((ViewVariableCriteria)filter, (ValueSearchModelDto)valueSearchModelDto, false, mergeValues));
        });
    }

    private Optional<ValueSearchModelDto> getActivityValueSearchModel(String id, ActivityDetailsSearchModelDto activityDetailsSearchModelDto) {
        ValueSearchModelDto valueSearchModelDto = null;
        if (id.equalsIgnoreCase("activityName")) {
            valueSearchModelDto = activityDetailsSearchModelDto.getName();
        } else if (id.equalsIgnoreCase("activityState")) {
            valueSearchModelDto = activityDetailsSearchModelDto.getState();
        } else if (id.equalsIgnoreCase("activityPerformer")) {
            valueSearchModelDto = activityDetailsSearchModelDto.getPerformer();
        } else if (id.equalsIgnoreCase("activityCreatedDate")) {
            valueSearchModelDto = activityDetailsSearchModelDto.getCreatedDate();
        } else if (id.equalsIgnoreCase("activityFinishedDate")) {
            valueSearchModelDto = activityDetailsSearchModelDto.getFinishedDate();
        } else if (id.equalsIgnoreCase("activityDeadlineTimeDays")) {
            valueSearchModelDto = activityDetailsSearchModelDto.getDeadlineTimeDays();
        } else if (id.equalsIgnoreCase("activityDeadlineName")) {
            valueSearchModelDto = activityDetailsSearchModelDto.getDeadlineName();
        }
        return Optional.ofNullable(valueSearchModelDto);
    }

    private void applyProcessSearchFilters(ProcessDetailsSearchModelDto processDetailsSearchModelDto, List<ViewVariableCriteria> processFilters) {
        if (CollectionUtils.isEmpty(processFilters)) {
            return;
        }
        processFilters.forEach(filter -> {
            Optional<ValueSearchModelDto> processValueSearchModel = this.getProcessValueSearchModel(filter.getId(), processDetailsSearchModelDto);
            boolean mergeValues = filter.getId().equalsIgnoreCase("processState") || filter.getId().equalsIgnoreCase("processInitiator");
            processValueSearchModel.ifPresent(valueSearchModelDto -> this.mapProcessFilterToSearchFormValue((ViewVariableCriteria)filter, (ValueSearchModelDto)valueSearchModelDto, false, mergeValues));
        });
    }

    private Optional<ValueSearchModelDto> getProcessValueSearchModel(String id, ProcessDetailsSearchModelDto processDetailsSearchModelDto) {
        ValueSearchModelDto valueSearchModelDto = null;
        if (id.equalsIgnoreCase("processName")) {
            valueSearchModelDto = processDetailsSearchModelDto.getName();
        } else if (id.equalsIgnoreCase("processType")) {
            valueSearchModelDto = processDetailsSearchModelDto.getProcessDefinitionId();
        } else if (id.equalsIgnoreCase("processDescription")) {
            valueSearchModelDto = processDetailsSearchModelDto.getDescription();
        } else if (id.equalsIgnoreCase("processInitiator")) {
            valueSearchModelDto = processDetailsSearchModelDto.getInitiator();
        } else if (id.equalsIgnoreCase("processState")) {
            valueSearchModelDto = processDetailsSearchModelDto.getState();
        } else if (id.equalsIgnoreCase("processCreatedData")) {
            valueSearchModelDto = processDetailsSearchModelDto.getCreatedDate();
        } else if (id.equalsIgnoreCase("processFinishedDate")) {
            valueSearchModelDto = processDetailsSearchModelDto.getFinishedDate();
        } else if (id.equalsIgnoreCase("processDeadlineTimeDays")) {
            valueSearchModelDto = processDetailsSearchModelDto.getDeadlineTimeDays();
        }
        return Optional.ofNullable(valueSearchModelDto);
    }

    private List<ProcessType> getAllProcessTypes() {
        String userName = UserContext.current().getUser().getUserName();
        return this.processService.getAllProcessTypes(false).stream().filter(processType -> this.hasSearchProcessAccess(processType.getProcessDefId(), userName)).sorted((proc1, proc2) -> proc1.getName().compareToIgnoreCase(proc2.getName())).collect(Collectors.toList());
    }

    public Boolean hasSearchProcessAccess(String processDefId, String userName) {
        int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().workflow().processes().view().custom((Object)processDefId).build(), (String)userName, (boolean)false, (boolean)false);
        return rights == 0;
    }

    private void mapFilterToSearchFormValue(ViewVariableCriteria filter, ValueSearchModelDto valueSearchModelDto, boolean isVariable, boolean mergeValues) {
        if (ActivityViewSearchModelMapper.filtersEditionBlocked(valueSearchModelDto, isVariable)) {
            return;
        }
        if (filter.isRangeActive()) {
            valueSearchModelDto.setRangeActive(true);
            if (filter.getFrom() != null) {
                valueSearchModelDto.setFrom(filter.getFrom());
            }
            if (filter.getTo() != null) {
                valueSearchModelDto.setTo(filter.getTo());
            }
        } else if (mergeValues && filter.getValue() != null) {
            valueSearchModelDto.setValue(null);
            Object[] values = filter.getValues() != null ? filter.getValues() : new String[]{};
            valueSearchModelDto.setValues((String[])ArrayUtils.addAll((Object[])values, (Object[])new String[]{filter.getValue()}));
        } else {
            if (filter.getValues() != null) {
                valueSearchModelDto.setValues(filter.getValues());
            }
            if (filter.getValue() != null) {
                valueSearchModelDto.setValue(filter.getValue());
            }
        }
    }

    private static boolean filtersEditionBlocked(ValueSearchModelDto valueSearchModelDto, boolean isVariable) {
        return !isVariable && (valueSearchModelDto.getExtraValueSearchModel().isDisableFilter() || !valueSearchModelDto.getExtraValueSearchModel().isShowFilter());
    }

    private void mapProcessFilterToSearchFormValue(ViewVariableCriteria filter, ValueSearchModelDto valueSearchModelDto, boolean isVariable, boolean mergeValues) {
        if (ActivityViewSearchModelMapper.filtersEditionBlocked(valueSearchModelDto, isVariable)) {
            return;
        }
        if (!filter.getId().equalsIgnoreCase("processType")) {
            this.mapFilterToSearchFormValue(filter, valueSearchModelDto, isVariable, mergeValues);
            return;
        }
        if (filter.isRangeActive()) {
            return;
        }
        List<String> allProcessTypes = this.getAllProcessTypes().stream().map(ProcessType::getProcessDefId).collect(Collectors.toList());
        String[] values = filter.getValues();
        String value = filter.getValue();
        if (this.emptyFilterValues(value, values)) {
            valueSearchModelDto.setValues((String[])allProcessTypes.toArray(String[]::new));
            return;
        }
        HashSet<String> filteredProcesses = new HashSet<String>();
        if (values != null) {
            Collections.addAll(filteredProcesses, values);
        }
        filteredProcesses.add(value);
        allProcessTypes.forEach(filteredProcesses::remove);
        if (!filteredProcesses.isEmpty()) {
            return;
        }
        this.mapFilterToSearchFormValue(filter, valueSearchModelDto, isVariable, true);
    }

    private boolean emptyFilterValues(String value, String[] values) {
        return StringUtils.isBlank((String)value) && (values == null || values.length == 1 && StringUtils.isBlank((String)values[0]));
    }
}

