/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.authorization;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.util.exception.ServiceException;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"authorization"})
public class AuthorizationController {
    @Autowired
    private MessageHelperBean messageHelper;

    @RequestMapping(value={"adminMode"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isUserAdmin() {
        String userName = UserContext.current().getUser().getUserName();
        try {
            return Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)userName, (boolean)false, (boolean)false) == 0;
        }
        catch (SQLException e) {
            throw new ServiceException(this.messageHelper.getMessage("Blad_przy_sprawdzaniu_uprawnien_dla_uzytkownika", new Object[]{userName}), (Throwable)e);
        }
    }
}

