/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.scheduledTasks;

import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.audit.service.AuditService;
import com.suncode.pwfl.audit.util.AuditServiceFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class AuditRemover {
    public static Logger log = Logger.getLogger(AuditRemover.class);

    @AdvancedTask(name="AUDIT_SCHEDULED_TASK_REMOVE_BEFORE_DATE_NAME", description="AUDIT_SCHEDULED_TASK_REMOVE_BEFORE_DATE_DESCR", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public static void deleteAudits(@TaskParam(name="AUDIT_SCHEDULED_TASK_PARAM_BEFORE_DATE_NAME", description="AUDIT_SCHEDULED_TASK_PARAM_BEFORE_DATE_DESCR") String sDate) {
        AuditService auditService = null;
        Date dDate = null;
        int deleted = 0;
        try {
            auditService = AuditServiceFactory.getAuditService();
            dDate = AuditRemover.parseDate(sDate);
            deleted = auditService.deleteAudits(dDate);
            log.info((Object)("Usunieto " + deleted + " audytow przed data " + sDate));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @AdvancedTask(name="AUDIT_SCHEDULED_TASK_REMOVE_BETWEEN_DATES_NAME", description="AUDIT_SCHEDULED_TASK_REMOVE_BETWEEN_DATES_DESCR", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public static void deleteAudits(@TaskParam(name="AUDIT_SCHEDULED_TASK_PARAM_FROM_DATE_NAME", description="AUDIT_SCHEDULED_TASK_PARAM_FROM_DATE_DESCR") String sDateFrom, @TaskParam(name="AUDIT_SCHEDULED_TASK_PARAM_TO_DATE_NAME", description="AUDIT_SCHEDULED_TASK_PARAM_TO_DATE_DESCR") String sDateTo) {
        AuditService auditService = null;
        Date dDateFrom = null;
        Date dDateTo = null;
        int deleted = 0;
        try {
            auditService = AuditServiceFactory.getAuditService();
            dDateFrom = AuditRemover.parseDate(sDateFrom);
            dDateTo = AuditRemover.parseDate(sDateTo);
            deleted = auditService.deleteAudits(dDateFrom, dDateTo);
            log.info((Object)("Usunieto " + deleted + " audytow pomiedzy datami " + sDateFrom + " a " + sDateTo));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @AdvancedTask(name="AUDIT_SCHEDULED_TASK_REMOVE_FOR_USER_NAME", description="AUDIT_SCHEDULED_TASK_REMOVE_FOR_USER_DESCR", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public static void deleteAuditsForUser(@TaskParam(name="AUDIT_SCHEDULED_TASK_PARAM_USER_ID_NAME", description="AUDIT_SCHEDULED_TASK_PARAM_USER_ID_DESCR") String userId) {
        AuditService auditService = null;
        int deleted = 0;
        try {
            auditService = AuditServiceFactory.getAuditService();
            deleted = auditService.deleteAudits(userId);
            log.info((Object)("Usunieto " + deleted + " audytow dla uzytkownika o loginie " + userId));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static Date parseDate(String sDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.parse(sDate);
    }
}

