/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.administration.user.security.domain.UserPasswordPolicyProfile;
import com.suncode.pwfl.administration.user.security.service.PasswordPolicyService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.SpringContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordProfileAssignedFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(PasswordProfileAssignedFormatter.class);
    private final String globalProfileAssignmentsKey = "globalProfileAssignments";
    private final String customGlobalProfileAssignmentsKey = "customGlobalProfileAssignments";
    private final String groupsAssginmentsKey = "groupsAssginments";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String globalProfileAssignments = map.get("globalProfileAssignments");
            String customGlobalProfileAssignments = map.get("customGlobalProfileAssignments");
            String groupsAssignments = map.get("groupsAssginments");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            String globalProfile = "";
            if (StringUtils.isNotBlank((CharSequence)globalProfileAssignments)) {
                globalProfile = MessageHelper.getMessage((String)("password.profile." + globalProfileAssignments));
            } else if (StringUtils.isNotBlank((CharSequence)customGlobalProfileAssignments)) {
                PasswordPolicyService passwordPolicyService = (PasswordPolicyService)SpringContext.getBean(PasswordPolicyService.class);
                UserPasswordPolicyProfile passwordPolicyProfile = passwordPolicyService.get(Long.valueOf(customGlobalProfileAssignments));
                globalProfile = passwordPolicyProfile.getProfileKey();
            }
            String translatedGroupsAssginments = "";
            if (StringUtils.isNotBlank((CharSequence)groupsAssignments)) {
                translatedGroupsAssginments = Arrays.asList(groupsAssignments.split("; ")).stream().map(groupAssignment -> this.getGroupAssignment((String)groupAssignment)).collect(Collectors.joining("; "));
            }
            formattedMap.put(AuditParamsNames.GLOBALPROFILEASSIGNMENTS.toString(), globalProfile);
            formattedMap.put(AuditParamsNames.GROUPSASSGINMENTS.toString(), translatedGroupsAssginments);
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getGroupAssignment(String groupAssignment) {
        String translatedProfile;
        String[] assignmentPart = groupAssignment.split("->");
        String resource = assignmentPart[0];
        String profile = assignmentPart[1];
        String profileKey = "password.profile." + profile;
        if (profileKey.equals(translatedProfile = MessageHelper.getOptionalMessage((String)profileKey))) {
            return resource + "->" + profile;
        }
        return resource + "->" + translatedProfile;
    }
}

