/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.struts.form.ProcessDocumentClassForm;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.ProcessDocumentClass;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AddProcessDocumentClassAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(AddProcessDocumentClassAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.info("******************************AddProcessDocumentClassAction********************");
        ProcessDocumentClassForm processDocClassForm = (ProcessDocumentClassForm)form;
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("username") == null) {
            return mapping.findForward("disconnect");
        }
        String userName = (String)session.getAttribute("username");
        int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)userName, (boolean)false, (boolean)false);
        if (rights == 0) {
            String procTypeId = request.getParameter("procTypeId");
            List alProcessDocClasses = ServiceFactory.getProcessService().getProcessDefDocumentClasses(processDocClassForm.getProcessDefId());
            Boolean validate = this.validation(request, processDocClassForm, alProcessDocClasses);
            if (validate.booleanValue()) {
                DocumentClass docClass = (DocumentClass)ServiceFactory.getDocumentClassService().get((Serializable)Long.valueOf(processDocClassForm.getDocclassId()));
                ProcessDocumentClass processDocClass = ServiceFactory.getProcessService().addDocClassToProcess(processDocClassForm.getProcessDefId(), docClass);
                alProcessDocClasses.add(processDocClass);
                request.setAttribute("auditSuccess", (Object)true);
                request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Klasa_dokumentow_zostala_pomyslnie_dodana"));
                request.setAttribute("messageType", (Object)"success");
            } else {
                request.setAttribute("auditSuccess", (Object)false);
                request.setAttribute("messageType", (Object)"error");
            }
            request.setAttribute("procTypeId", (Object)procTypeId);
            request.setAttribute("alProcessDocClasses", (Object)alProcessDocClasses);
            return mapping.findForward("showNewProcessDocumentClasses");
        }
        log.info("Nie uda\u0142o si\u0119 przypisa\u0107 klasy dokumentu do procesu z powodu braku uprawnie\u0144");
        return mapping.findForward("welcome");
    }

    public Boolean validation(HttpServletRequest request, ProcessDocumentClassForm processDocumentClassForm, List<ProcessDocumentClass> alProcessDocClasses) {
        if (StringUtils.isBlank((CharSequence)processDocumentClassForm.getDocclassId())) {
            request.setAttribute("message", (Object)MessageHelper.getMessage((String)"wybierz_klase_dokumentow"));
            return false;
        }
        List docClasses = alProcessDocClasses.stream().map(d -> d.getDocclass()).collect(Collectors.toList());
        for (DocumentClass docClass : docClasses) {
            if (!docClass.getId().equals(Long.valueOf(processDocumentClassForm.getDocclassId()))) continue;
            request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Klasa_dokumentow_o_podanej_nazwie_juz_istnieje"));
            return false;
        }
        return true;
    }
}

