/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.ReportsTable;
import com.plusmpm.i18n.I18N;
import com.plusmpm.util.json.extjs.gson.GsonFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ValidateJasperReportCreation
extends HttpServlet {
    public static Logger log = Logger.getLogger(ValidateJasperReportCreation.class);
    private static final long serialVersionUID = -4479710920871418636L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter printWriter = null;
        String userName = null;
        String success = "{ success: true }";
        I18N i18n = null;
        try {
            i18n = new I18N(request);
            userName = (String)request.getSession(false).getAttribute("username");
            String reportName = request.getParameter("reportName");
            String reportDefinitionPath = request.getParameter("reportDefinitionPath");
            if (StringUtils.isBlank((CharSequence)reportName)) {
                throw new Exception(i18n.getString("Prosze_wprowadzic_nazwe_raportu"));
            }
            if (StringUtils.isBlank((CharSequence)reportDefinitionPath)) {
                throw new Exception(i18n.getString("Prosze_podac_sciezke_szablonu"));
            }
            File reportTemplateFile = new File(reportDefinitionPath);
            if (!reportTemplateFile.exists()) {
                throw new Exception(i18n.getString("Plik_szablonu_raportu_nie_istnieje_w_podanej_lokalizacji"));
            }
            DBManagement dbm = new DBManagement();
            ArrayList reportTables = dbm.GetAllReportsForUserWithType(userName, "private");
            if (reportTables != null && reportTables.size() > 0) {
                for (Object obj : reportTables) {
                    ReportsTable reportTable = (ReportsTable)obj;
                    if (reportTable.getReportName().compareToIgnoreCase(reportName) != 0) continue;
                    throw new Exception(i18n.getString("Raport_o_podanej_nazwie_juz_istnieje"));
                }
            }
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            printWriter = response.getWriter();
            printWriter.print(GsonFactory.getGson().toJson((Object)success));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            response.setStatus(400);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            try {
                printWriter = response.getWriter();
                printWriter.print(e.getMessage());
            }
            catch (IOException ioe) {
                log.error((Object)e.getMessage());
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

