/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.tomcat.proxy;

import com.suncode.pwfl.webapp.tomcat.proxy.RequestContext;
import java.util.function.Predicate;
import lombok.NonNull;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public interface RequestPredicates {
    public static Predicate<RequestContext> httpMethod(@NonNull HttpMethod method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return req -> method.matches(req.request().getMethod());
    }

    public static Predicate<RequestContext> path(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        PathPattern parsedPattern = PathPatternParser.defaultInstance.parse(pattern);
        return req -> parsedPattern.matches(PathContainer.parsePath((String)req.requestUriWithinApplication()));
    }
}

