/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.archive.AssociatedIndexes;
import com.suncode.pwfl.administration.archive.DisplayedIndex;
import com.suncode.pwfl.administration.archive.DocumentClassAssociation;
import com.suncode.pwfl.archive.DocumentClassAssociationService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.exception.DocumentClassAssociationAlreadyExistsException;
import com.suncode.pwfl.archive.exception.DocumentClassAssociationDoesNotExistException;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.AssociatedDocumentsDto;
import com.suncode.pwfl.web.dto.archive.AssociatedIndexesDto;
import com.suncode.pwfl.web.dto.archive.DisplayedIndexDto;
import com.suncode.pwfl.web.dto.archive.DocumentClassAssociationDto;
import com.suncode.pwfl.web.dto.archive.DocumentDto;
import com.suncode.pwfl.web.dto.archive.UpsertDocumentClassAssociationDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.DocumentClassAssociationMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/documents"})
@Api(tags={"document classes"})
public class DocumentClassAssociationController {
    private static final Logger log = LoggerFactory.getLogger(DocumentClassAssociationController.class);
    private final DocumentClassAssociationService documentClassAssociationService;
    private final DocumentService documentService;
    private final DocumentClassAssociationMapper documentClassAssociationMapper;
    private final ExportService exportService;
    private final MessageHelperBean messageHelper;
    private final AuthorizationHelper authorizationHelper;
    private final Experimental experimental;

    @ApiOperation(value="(Admin) Downloading document class associations", notes="Retrieves a list of document class associations")
    @GetMapping(value={"classes/{documentClassId}/associations"})
    @ResponseBody
    public CountedResult<DocumentClassAssociationDto> getDocumentClassAssociations(@ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId, @ApiParam(value="Result number from which results are to be returned", defaultValue="0") @RequestParam(defaultValue="0") Integer start, @ApiParam(value="Number of returned results", defaultValue="20") @RequestParam(defaultValue="20") Integer limit) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List documentClassAssociations = this.documentClassAssociationService.getDocClassAssociationsForParentDocClass(documentClassId).stream().map(this.documentClassAssociationMapper::toDocumentClassAssociationDto).collect(Collectors.toList());
        return Paginator.forAll(documentClassAssociations).viewPageByOffset(start, limit);
    }

    @ApiOperation(value="(Admin) Downloading document class association", notes="Retrieves document class association with given id")
    @GetMapping(value={"classes/{documentClassId}/associations/{associationId}"})
    @ResponseBody
    public DocumentClassAssociationDto getDocumentClassAssociation(@ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId, @ApiParam(value="Association id", required=true) @PathVariable Long associationId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.documentClassAssociationMapper.toDocumentClassAssociationDto((DocumentClassAssociation)this.documentClassAssociationService.get((Serializable)associationId));
    }

    @ApiOperation(value="(Admin) Adding document class association", notes="Adds new document class association")
    @PostMapping(value={"classes/associations"})
    @ResponseBody
    public RestResult addDocumentClassAssociation(HttpServletRequest request, @ApiParam(value="The executed query saves document association. The query is a JSON object with the following fields \n  - **id** - id of the association  \n  - **parentClassId** - parent class id (required) \n  - **childClassId** - child class id \n  - **separator** - separator \n  - **associateOnEmptyValues** - join on empty values \n  - **associatedIndexes** - list of indexes to associate \n    - parentIndexId - parent index identifier \n    - childIndexId - child index identifier  \n  - **displayedIndexes** - list of indexes to display\n    - indexId - id of the displayed index", required=true) @RequestBody UpsertDocumentClassAssociationDto upsertDocumentClassAssociationDto) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADMIN_ADD_DOC_CLASS_ASSOCIATION);
        DocumentClassAssociation documentClassAssociation = this.documentClassAssociationMapper.toDocumentClassAssociation(upsertDocumentClassAssociationDto);
        auditBuilder.params(this.buildAddAssociationParams(documentClassAssociation));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.documentClassAssociationService.createDocumentClassAssociation(documentClassAssociation);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Changing document class association", notes="Changes document class association with given id")
    @PutMapping(value={"classes/associations/{associationId}"})
    @ResponseBody
    public RestResult updateDocumentClassAssociation(HttpServletRequest request, @ApiParam(value="The executed query updates document association. The query is a JSON object:\n  - **id** - id of the association  \n  - **parentClassId** - parent class id (required) \n  - **childClassId** - child class id \n  - **separator** - separator \n  - **associateOnEmptyValues** - join on empty values \n  - **associatedIndexes** - list of indexes to associate \n    - parentIndexId - parent index identifier \n    - childIndexId - child index identifier  \n  - **displayedIndexes** - list of indexes to display\n      - indexId - id of the displayed index", required=true) @RequestBody UpsertDocumentClassAssociationDto upsertDocumentClassAssociationDto, @ApiParam(value="Association id", required=true) @PathVariable Long associationId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADMIN_UPDATE_DOC_CLASS_ASSOCIATION);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        DocumentClassAssociation associationToUpdate = (DocumentClassAssociation)this.documentClassAssociationService.get((Serializable)associationId);
        DocumentClassAssociation updatedDocumentClassAssociation = this.documentClassAssociationMapper.toDocumentClassAssociation(upsertDocumentClassAssociationDto);
        auditBuilder.params(this.buildUpdateAssociationParams(associationToUpdate, updatedDocumentClassAssociation));
        try {
            this.documentClassAssociationService.updateDocumentClassAssociation(associationId, updatedDocumentClassAssociation);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Deleting document class association", notes="Deletes document class association with given id")
    @DeleteMapping(value={"classes/{documentClassId}/associations/{associationId}"})
    @ResponseBody
    public RestResult deleteDocumentClassAssociation(HttpServletRequest request, @ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId, @ApiParam(value="Association id", required=true) @PathVariable Long associationId) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("association_id", associationId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADMIN_DELETE_DOC_CLASS_ASSOCIATION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        DocumentClassAssociation documentClassAssociationToDelete = (DocumentClassAssociation)this.documentClassAssociationService.get((Serializable)associationId);
        auditParams.putAll(this.buildDeleteAssociationParams(documentClassAssociationToDelete));
        auditBuilder.params(auditParams);
        try {
            this.documentClassAssociationService.deleteDocumentClassAssociationById(associationId);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Exporting document class associations", notes="Exports document class associations")
    @GetMapping(value={"classes/{documentClassId}/associations/export/{extension}"})
    @ResponseBody
    public void exportDocumentClassAssociations(HttpServletResponse response, @ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId, @ApiParam(value="Extension", required=true) @PathVariable String extension) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List documentClassAssociations = this.documentClassAssociationService.getDocClassAssociationsForParentDocClass(documentClassId).stream().map(this.documentClassAssociationMapper::toDocumentClassAssociationDto).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Powiazana_klasa")).data(documentClassAssociations).by(DocumentClassAssociationDto::getChildClassName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Powiazane_indeksy")).data(documentClassAssociations).by(documentClassAssociation -> this.getFormattedAssociatedIndexes(documentClassAssociation.getAssociatedIndexes(), "pdf")).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Wyswietlane_indeksy")).data(documentClassAssociations).by(documentClassAssociation -> this.getFormattedDisplayedIndexes(documentClassAssociation.getDisplayedIndexes(), "pdf")).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Separator")).data(documentClassAssociations).by(DocumentClassAssociationDto::getSeparator).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Klasy_powiazane")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"{documentId}/associations"})
    @ResponseBody
    public List<AssociatedDocumentsDto> getDocumentAssociations(@PathVariable Long documentId) {
        String userName = SessionUtils.getLoggedUserName();
        Long documentClassId = this.documentService.getDocument(documentId).getDocumentClassId();
        List parentAssociations = this.documentClassAssociationService.getDocClassAssociationsForParentDocClass(documentClassId);
        List parentAssociationDtos = parentAssociations.stream().map(association -> this.documentClassAssociationMapper.getParentSideAssociatedDocumentsDto((DocumentClassAssociation)association, documentId, documentClassId, userName)).collect(Collectors.toList());
        List childAssociations = this.documentClassAssociationService.getDocClassAssociationsForChildDocClass(documentClassId).stream().filter(association -> parentAssociations.stream().noneMatch(parentAssociation -> parentAssociation.getChildClass().getId().equals(association.getParentClass().getId()))).collect(Collectors.toList());
        List<AssociatedDocumentsDto> childAssociationDtos = childAssociations.stream().map(association -> this.documentClassAssociationMapper.getChildSideAssociatedDocumentsDto((DocumentClassAssociation)association, documentId, documentClassId, userName, parentAssociationDtos)).collect(Collectors.toList());
        ArrayList<AssociatedDocumentsDto> associatedDocumentsDtos = new ArrayList<AssociatedDocumentsDto>();
        associatedDocumentsDtos.addAll(parentAssociationDtos);
        childAssociationDtos.forEach(dto -> this.addChildAssociationDtoToResult(parentAssociationDtos, (List<AssociatedDocumentsDto>)associatedDocumentsDtos, (AssociatedDocumentsDto)dto));
        return associatedDocumentsDtos;
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"{documentId}/associations/classes/{childDocumentClassId}"})
    @ResponseBody
    public CountedResult<DocumentDto> getDocumentClassAssociatedDocumentsByChildClass(@PathVariable Long documentId, @PathVariable Long childDocumentClassId, @RequestParam(defaultValue="0") Integer start, @RequestParam(defaultValue="20") Integer limit, @RequestParam(defaultValue="fileId") String sortBy, @RequestParam(defaultValue="ASC") SortDirection sortDirection) {
        String userName = SessionUtils.getLoggedUserName();
        CountedResult<WfDocument> documents = this.getDocumentDtoCountedResult(documentId, childDocumentClassId, start, limit, sortBy, sortDirection, userName);
        List documentDtos = documents.getData().stream().map(doc -> this.documentClassAssociationMapper.toDocumentDto((WfDocument)doc, userName)).collect(Collectors.toList());
        return new CountedResult(documents.getTotal(), documentDtos);
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"{documentId}/associations/{associationId}/classes/{childDocumentClassId}"})
    @ResponseBody
    public CountedResult<DocumentDto> getDocumentClassAssociatedDocumentsByChildClassWithAssociationId(@PathVariable Long documentId, @PathVariable Long childDocumentClassId, @PathVariable Long associationId, @RequestParam(defaultValue="0") Integer start, @RequestParam(defaultValue="20") Integer limit, @RequestParam(defaultValue="fileId") String sortBy, @RequestParam(defaultValue="ASC") SortDirection sortDirection) {
        String userName = SessionUtils.getLoggedUserName();
        CountedResult<WfDocument> documents = this.getDocumentDtoCountedResult(documentId, childDocumentClassId, associationId, start, limit, sortBy, sortDirection, userName);
        List documentDtos = documents.getData().stream().map(doc -> this.documentClassAssociationMapper.toDocumentDto((WfDocument)doc, userName)).collect(Collectors.toList());
        return new CountedResult(documents.getTotal(), documentDtos);
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"{documentId}/associations/classes/{childDocumentClassId}/list"})
    @ResponseBody
    public List<DocumentDto> getDocumentClassAssociatedDocuments(@PathVariable Long documentId, @PathVariable Long childDocumentClassId, @RequestParam(defaultValue="0") Integer start, @RequestParam(defaultValue="20") Integer limit, @RequestParam(defaultValue="fileId") String sortBy, @RequestParam(defaultValue="ASC") SortDirection sortDirection) {
        return this.getDocumentDtoCountedResult(documentId, childDocumentClassId, start, limit, sortBy, sortDirection, SessionUtils.getLoggedUserName()).getData().stream().map(DocumentDto::fromDocument).collect(Collectors.toList());
    }

    private CountedResult<WfDocument> getDocumentDtoCountedResult(Long documentId, Long childDocumentClassId, Integer start, Integer limit, String sortBy, SortDirection sortDirection, String userName) {
        Long documentClassId = this.documentService.getDocument(documentId).getDocumentClassId();
        return this.documentClassAssociationService.getAssociatedDocumentsFromClass(documentClassId, documentId, childDocumentClassId, start, limit, sortBy, sortDirection.name(), userName);
    }

    private CountedResult<WfDocument> getDocumentDtoCountedResult(Long documentId, Long childDocumentClassId, Long associationId, Integer start, Integer limit, String sortBy, SortDirection sortDirection, String userName) {
        Long documentClassId = this.documentService.getDocument(documentId).getDocumentClassId();
        return this.documentClassAssociationService.getAssociatedDocumentsFromClass(documentClassId, documentId, childDocumentClassId, associationId, start, limit, sortBy, sortDirection.name(), userName);
    }

    private void addChildAssociationDtoToResult(List<AssociatedDocumentsDto> parentAssociations, List<AssociatedDocumentsDto> associatedDocumentsDtos, AssociatedDocumentsDto dto) {
        Optional<AssociatedDocumentsDto> associatedDocumentsDto = associatedDocumentsDtos.stream().filter(parentDto -> parentDto.getDocumentClassId().equals(dto.getDocumentClassId()) && !parentDto.getAssociationId().equals(dto.getAssociationId())).findFirst();
        if (associatedDocumentsDto.isPresent() && parentAssociations.stream().anyMatch(parentDto -> parentDto.getDocumentClassId().equals(((AssociatedDocumentsDto)associatedDocumentsDto.get()).getDocumentClassId()) && parentDto.getAssociationId().equals(((AssociatedDocumentsDto)associatedDocumentsDto.get()).getAssociationId()))) {
            AssociatedDocumentsDto existingDto = associatedDocumentsDto.get();
            existingDto.setDocumentsCount(existingDto.getDocumentsCount() + dto.getDocumentsCount());
        } else {
            associatedDocumentsDtos.add(dto);
        }
    }

    private String getFormattedAssociatedIndexes(List<AssociatedIndexesDto> associatedIndexes, String fileExtension) {
        String pattern = "%s -> %s";
        String delimiter = ";";
        if (fileExtension.equals("pdf")) {
            delimiter = ";\n";
        }
        return associatedIndexes.stream().map(index -> String.format("%s -> %s", index.getParentIndexName(), index.getChildIndexName())).collect(Collectors.joining(delimiter));
    }

    private String getFormattedDisplayedIndexes(List<DisplayedIndexDto> displayedIndexes, String fileExtension) {
        String delimiter = ",";
        if (fileExtension.equals("pdf")) {
            delimiter = ", ";
        }
        return displayedIndexes.stream().map(DisplayedIndexDto::getIndexName).collect(Collectors.joining(delimiter));
    }

    private Map<String, Object> buildAddAssociationParams(DocumentClassAssociation documentClassAssociation) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("baseClass", documentClassAssociation.getParentClass().getName());
        params.put("associatedClass", documentClassAssociation.getChildClass().getName());
        params.put("associatedIndexes", this.buildAssociatedIndexesAuditParam(documentClassAssociation.getAssociatedIndexes()));
        params.put("displayedIndexes", this.buildDisplayedIndexesAuditParam(documentClassAssociation.getDisplayedChildIndexes()));
        params.put("separator", documentClassAssociation.getSeparator());
        return params;
    }

    private Map<String, Object> buildUpdateAssociationParams(DocumentClassAssociation associationToUpdate, DocumentClassAssociation documentClassAssociation) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("baseClass", documentClassAssociation.getParentClass().getName());
        params.put("associatedClass", associationToUpdate.getChildClass().getName() + ";" + documentClassAssociation.getChildClass().getName());
        params.put("associatedIndexes", this.buildAssociatedIndexesAuditParam(documentClassAssociation.getAssociatedIndexes()));
        params.put("oldAssociatedIndexes", this.buildAssociatedIndexesAuditParam(associationToUpdate.getAssociatedIndexes()));
        params.put("displayedIndexes", this.buildDisplayedIndexesAuditParam(documentClassAssociation.getDisplayedChildIndexes()));
        params.put("oldDisplayedIndexes", this.buildDisplayedIndexesAuditParam(associationToUpdate.getDisplayedChildIndexes()));
        String separator = documentClassAssociation.getSeparator() != null ? documentClassAssociation.getSeparator() : "";
        String oldSeparator = associationToUpdate.getSeparator() != null ? associationToUpdate.getSeparator() : "";
        params.put("separator", oldSeparator + " > " + separator);
        return params;
    }

    private Map<String, Object> buildDeleteAssociationParams(DocumentClassAssociation documentClassAssociation) {
        return ImmutableMap.builder().put((Object)"baseClass", (Object)(documentClassAssociation != null ? documentClassAssociation.getParentClass().getName() : "")).put((Object)"associatedClass", (Object)(documentClassAssociation != null ? documentClassAssociation.getChildClass().getName() : "")).build();
    }

    private String buildAssociatedIndexesAuditParam(List<AssociatedIndexes> associatedIndexes) {
        return associatedIndexes.stream().map(associatedIndex -> associatedIndex.getParentIndex().getName() + "," + associatedIndex.getChildIndex().getName()).collect(Collectors.joining(";"));
    }

    private String buildDisplayedIndexesAuditParam(List<DisplayedIndex> displayedIndexes) {
        return displayedIndexes.stream().map(displayedIndex -> displayedIndex.getIndex().getName()).collect(Collectors.joining(";"));
    }

    @ExceptionHandler(value={DocumentClassAssociationDoesNotExistException.class, DocumentClassAssociationAlreadyExistsException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    public RestResult handleBadRequests(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ConstructorProperties(value={"documentClassAssociationService", "documentService", "documentClassAssociationMapper", "exportService", "messageHelper", "authorizationHelper", "experimental"})
    @Autowired
    public DocumentClassAssociationController(DocumentClassAssociationService documentClassAssociationService, DocumentService documentService, DocumentClassAssociationMapper documentClassAssociationMapper, ExportService exportService, MessageHelperBean messageHelper, AuthorizationHelper authorizationHelper, Experimental experimental) {
        this.documentClassAssociationService = documentClassAssociationService;
        this.documentService = documentService;
        this.documentClassAssociationMapper = documentClassAssociationMapper;
        this.exportService = exportService;
        this.messageHelper = messageHelper;
        this.authorizationHelper = authorizationHelper;
        this.experimental = experimental;
    }
}

