/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks;

import com.plusmpm.database.scheduledTasks.ScheduledTasksParametersTable;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskHelper;
import com.suncode.pwfl.customfile.CustomFile;
import com.suncode.pwfl.customfile.CustomFileService;
import com.suncode.pwfl.web.controller.api.scheduledtasks.FileInfo;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ParameterInfo;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ParameterValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ScheduledTaskParameterBuilder {
    @Autowired
    private CustomFileService customFileService;
    @Autowired
    private ScheduledTaskHelper scheduledTaskHelper;

    public ScheduledTaskParameterBuilder(CustomFileService customFileService, ScheduledTaskHelper scheduledTaskHelper) {
        this.customFileService = customFileService;
        this.scheduledTaskHelper = scheduledTaskHelper;
    }

    @Transactional
    public List<ScheduledTasksParametersTable> buildTaskParameters(List<ParameterInfo> dtoParamList, ScheduledTasksTable task) throws IOException, JSONException {
        boolean isComponent = this.scheduledTaskHelper.isComponent(task.getClass_name());
        LinkedList<ScheduledTasksParametersTable> paramList = new LinkedList<ScheduledTasksParametersTable>();
        for (ParameterInfo dtoParam : dtoParamList) {
            String paramValue;
            String dtoParamType = dtoParam.getType();
            if (dtoParam.getValue().isArray()) {
                ParameterValue.ArrayValue dtoValues = (ParameterValue.ArrayValue)dtoParam.getValue();
                if (this.scheduledTaskHelper.isFileTypeArray(dtoParamType)) {
                    this.saveFileArrayParameter(task, dtoParam, dtoValues);
                }
                if (isComponent) {
                    componentParamId = dtoParam.getComponentParameterId();
                    List paramValues = dtoValues.getValue().stream().map(ParameterValue.SingleValue::getValue).collect(Collectors.toList());
                    paramValue = this.scheduledTaskHelper.createArrayJsonValue(componentParamId, paramValues);
                } else {
                    paramValue = this.listToValue(dtoValues.getValue());
                }
            } else {
                ParameterValue.SingleValue dtoValue = (ParameterValue.SingleValue)dtoParam.getValue();
                if (this.scheduledTaskHelper.isFileType(dtoParamType)) {
                    this.saveFileParameter(task, dtoParam, dtoValue);
                }
                paramValue = dtoValue.getValue();
                if (isComponent) {
                    componentParamId = dtoParam.getComponentParameterId();
                    paramValue = this.scheduledTaskHelper.createSingleJsonValue(componentParamId, paramValue);
                }
            }
            paramList.add(new ScheduledTasksParametersTable(task, dtoParamType, paramValue, dtoParam.getPosition()));
        }
        return paramList;
    }

    private void saveFileParameter(ScheduledTasksTable task, ParameterInfo param, ParameterValue.SingleValue singleValue) throws IOException {
        FileInfo fileInfo = this.readFileInfo(singleValue);
        String fileName = fileInfo.getFileName();
        byte[] content = fileInfo.getContent();
        if (this.isNewTask(task)) {
            Long id = this.customFileService.createNewFile(fileName);
            CustomFile file = this.customFileService.getFile(id);
            try (OutputStream outputStream = file.openOutputStream();){
                outputStream.write(content);
            }
            singleValue.setValue(id.toString());
        } else {
            String fileId = this.scheduledTaskHelper.getParameterValue(task, param.getPosition());
            if (fileInfo.isUploaded()) {
                Long id = Long.valueOf(fileId);
                CustomFile file = this.customFileService.getFile(id);
                this.customFileService.changeFileName(id, fileName);
                try (OutputStream outputStream = file.openOutputStream();){
                    outputStream.write(content);
                }
            }
            singleValue.setValue(fileId);
        }
    }

    private void saveFileArrayParameter(ScheduledTasksTable task, ParameterInfo param, ParameterValue.ArrayValue arrayValue) throws IOException {
        List<String> values = new LinkedList<String>();
        if (!this.isNewTask(task)) {
            values = this.scheduledTaskHelper.getParameterValues(task, param.getPosition());
        }
        List<ParameterValue.SingleValue> dtoValues = arrayValue.getValue();
        this.deleteOrphanFiles(values, dtoValues);
        for (ParameterValue.SingleValue singleValue : dtoValues) {
            OutputStream outputStream;
            FileInfo fileInfo = this.readFileInfo(singleValue);
            Optional<Long> fileId = Optional.ofNullable(fileInfo.getFileId());
            String fileName = fileInfo.getFileName();
            byte[] content = fileInfo.getContent();
            if (!fileId.isPresent()) {
                Long id = this.customFileService.createNewFile(fileName);
                CustomFile newFile = this.customFileService.getFile(id);
                outputStream = newFile.openOutputStream();
                try {
                    outputStream.write(content);
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                singleValue.setValue(id.toString());
                continue;
            }
            Long fileIdValue = fileId.get();
            if (fileInfo.isUploaded()) {
                CustomFile file = this.customFileService.getFile(fileIdValue);
                this.customFileService.changeFileName(fileIdValue, fileName);
                outputStream = file.openOutputStream();
                try {
                    outputStream.write(content);
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
            singleValue.setValue(fileIdValue.toString());
        }
    }

    private void deleteOrphanFiles(List<String> values, List<ParameterValue.SingleValue> dtoValues) {
        for (String value : values) {
            Long id = Long.valueOf(value);
            boolean shouldFileBeRemoved = dtoValues.stream().noneMatch(singleValue -> {
                ParameterValue.FileMetadata metadata = singleValue.getMetadata();
                Optional<Long> fileId = Optional.ofNullable(metadata.getFileId());
                return fileId.isPresent() && fileId.get().equals(id);
            });
            if (!shouldFileBeRemoved) continue;
            this.customFileService.deleteFile(id);
        }
    }

    public FileInfo readFileInfo(ParameterValue.SingleValue fileValue) {
        ParameterValue.FileMetadata metadata = fileValue.getMetadata();
        Long fileId = metadata.getFileId();
        String fileName = metadata.getFileName();
        String data = fileValue.getValue();
        int headerIndex = data.indexOf("base64,");
        boolean isFileUploaded = headerIndex != -1;
        byte[] content = new byte[]{};
        if (isFileUploaded) {
            String encodedContent = data.substring(headerIndex + 7);
            content = Base64.getDecoder().decode(encodedContent);
        }
        return new FileInfo(fileId, fileName, content, isFileUploaded);
    }

    private boolean isNewTask(ScheduledTasksTable task) {
        return task.getId() == null;
    }

    private String listToValue(List<ParameterValue.SingleValue> values) {
        List valuesTokens = values.stream().map(ParameterValue.SingleValue::getValue).collect(Collectors.toList());
        return new JSONArray(valuesTokens).toString();
    }

    public ScheduledTaskParameterBuilder() {
    }
}

