/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.dashboards;

import com.google.common.collect.ImmutableMap;
import com.suncode.plugin.dashboard.Dashboard;
import com.suncode.plugin.dashboard.DashboardService;
import com.suncode.plugin.dashboard.Gadget;
import com.suncode.plugin.dashboard.SystemDashboardService;
import com.suncode.plugin.dashboard.gadget.Layout;
import com.suncode.plugin.dashboard.web.support.AddGadgetResult;
import com.suncode.plugin.dashboard.web.support.GadgetLayout;
import com.suncode.plugin.dashboard.web.support.RestResult;
import com.suncode.plugin.dashboard.web.support.Share;
import com.suncode.plugin.dashboard.web.support.UpdateForm;
import com.suncode.plugin.dashboard.web.support.dto.DashboardDto;
import com.suncode.plugin.dashboard.web.support.dto.GadgetAppendDto;
import com.suncode.plugin.dashboard.web.support.dto.GadgetDashboardDto;
import com.suncode.plugin.dashboard.web.support.dto.GadgetDto;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.GroupNotFoundException;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.dashboard.DashboardSharingService;
import com.suncode.pwfl.dashboard.exception.DashboardAlreadyExistsException;
import com.suncode.pwfl.dashboard.exception.DashboardNotFoundException;
import com.suncode.pwfl.dashboard.exception.GadgetNotFoundException;
import com.suncode.pwfl.dashboard.exception.UnauthorizedException;
import com.suncode.pwfl.dashboard.internal.SystemDashboard;
import com.suncode.pwfl.dashboard.internal.UserDashboard;
import com.suncode.pwfl.dashboard.internal.sharing.DashboardShare;
import com.suncode.pwfl.dashboard.internal.sharing.EveryoneShare;
import com.suncode.pwfl.dashboard.internal.sharing.GroupShare;
import com.suncode.pwfl.dashboard.internal.sharing.UserShare;
import com.suncode.pwfl.dashboard.internal.support.DashboardMapper;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.translation.ConfigElementTranslationsCache;
import com.suncode.pwfl.translation.TranslatedConfigElementType;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.GadgetDashboardMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.castor.core.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dashboards"})
@Api(value="Dashboard Administration", tags={"dashboard"})
public class DashboardController {
    private static final Logger log = LoggerFactory.getLogger(DashboardController.class);
    private final DashboardService dashboardService;
    private final SystemDashboardService systemDashboardService;
    private final DashboardSharingService sharingService;
    private final UserService userService;
    private final DashboardMapper dashboardMapper;
    private final GadgetDashboardMapper gadgetDashboardMapper;
    private final MessageHelperBean messageHelper;
    private final ConfigElementTranslationsCache configElementTranslationsCache;
    private final AuthorizationHelper authorizationHelper;

    @ApiOperation(value="Downloading dashboard", notes="Retrieves a dashboard with given id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Dashboard not found")})
    @GetMapping(value={"{id}"})
    @ResponseBody
    public GadgetDashboardDto getDashboard(@ApiParam(value="Dashboard id", required=true) @PathVariable String id, @ApiParam(value="Is system dashboard", required=false) @RequestParam(required=false) boolean system) {
        Dashboard dashboard;
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        Dashboard dashboard2 = dashboard = system ? this.systemDashboardService.getSystemDashboardForUser(id, user) : this.dashboardService.getDashboard(Long.valueOf(id));
        if (dashboard == null) {
            throw new DashboardNotFoundException(id);
        }
        return this.gadgetDashboardMapper.fromDashboard(dashboard);
    }

    @PostMapping
    @ResponseBody
    @ApiOperation(value="", hidden=true)
    public RestResult createDashboard(@RequestParam String name, @RequestParam String description, @RequestParam(required=false) String importDashboard, @RequestParam(required=false) boolean system, @RequestParam(required=false) Long userId, @RequestParam(required=false) String abbreviation, @RequestParam(required=false) String color) {
        return (RestResult)TransactionWrapper.get().doInHibernateTransaction(transaction -> {
            Dashboard dashboard;
            Dashboard baseDashboard;
            Date started = new Date();
            User user = userId != null ? Optional.ofNullable(this.userService.getUser(userId, new String[]{"groups"})).orElseThrow(() -> new UserNotFoundException(this.messageHelper.getMessage("Uzytkownik_o_podanym_id_nie_istnieje", new Object[]{userId}))) : this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("DASHBOARD_NAME", name);
            params.put("DASHBOARD_DESCR", description);
            if (StringUtils.isNotBlank((CharSequence)importDashboard)) {
                baseDashboard = system ? this.systemDashboardService.getSystemDashboardForUser(importDashboard, user) : this.dashboardService.getDashboard(Long.valueOf(importDashboard));
                params.put("DASHBOARD_IMPORT_GADGETS_FROM", baseDashboard.getName());
            }
            try {
                dashboard = user != null ? this.dashboardService.createDashboard(user, name, description, abbreviation, color) : this.dashboardService.createDashboard(name, description, abbreviation, color);
            }
            catch (DashboardAlreadyExistsException e) {
                this.audit(AuditTypes.AUDIT_DASHBOARD_CREATED, false, started, params);
                throw e;
            }
            if (StringUtils.isNotBlank((CharSequence)importDashboard)) {
                baseDashboard = system ? this.systemDashboardService.getSystemDashboardForUser(importDashboard, user) : this.dashboardService.getDashboard(Long.valueOf(importDashboard));
                this.dashboardService.importGadgets(dashboard, baseDashboard);
            } else {
                Gadget gadget = this.dashboardService.addGadget(dashboard, "com.suncode.plugin-dashboard:introduction-gadget");
                gadget.getLayout().setWidth(Integer.valueOf(4));
                this.dashboardService.updateDashboard(dashboard);
            }
            if (dashboard instanceof UserDashboard) {
                params.put("DASHBOARD_ABBREVIATION", ((UserDashboard)dashboard).getAbbreviation());
                params.put("DASHBOARD_COLOR", ((UserDashboard)dashboard).getColor());
            }
            this.audit(AuditTypes.AUDIT_DASHBOARD_CREATED, true, started, params);
            String id = this.dashboardMapper.fromDashboard(dashboard).getId();
            return new RestResult(true, id);
        });
    }

    @ApiOperation(value="Updating dashboard", notes="Updates dashboard with given id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=404, message="Not found")})
    @PostMapping(value={"{id}"})
    @ResponseBody
    public RestResult updateDashboard(@ApiParam(value="Dashboard id", required=true) @PathVariable Long id, @ApiParam(value="The query contains a JSON object containing definition of dashboard to update. The definition should include the following fields\n            - **name** - name of the dashboard (required)\n            - **description** - description of the dashboard\n            - **abbreviation** - abbreviation of the dashboard(max 3 letters)\n            - **color** - color of the dashboard\n            - **share** - list of share objects \n              - type - USER/ GROUP\n              - resource - id of the user/group or list of one share with type - ALL", required=true) UpdateForm updateForm) throws UnauthorizedException {
        return (RestResult)TransactionWrapper.get().doInHibernateTransaction(transaction -> {
            Date started = new Date();
            Dashboard dashboard = this.dashboardService.getDashboard(id);
            if (dashboard == null) {
                throw new DashboardNotFoundException(id);
            }
            if (dashboard instanceof SystemDashboard) {
                throw new IllegalArgumentException(this.messageHelper.getMessage("System_dashboard_update_error"));
            }
            UserDashboard userDashboard = (UserDashboard)dashboard;
            Map<String, Object> auditParams = this.updateDashboardAuditParams(userDashboard, updateForm);
            Assert.notEmpty((String)updateForm.getName(), (String)this.messageHelper.getMessage("Nie_zdefiniowano_wymaganego_pola", new Object[]{"name"}));
            userDashboard.setName(updateForm.getName());
            userDashboard.setDescription(updateForm.getDescription());
            userDashboard.setAbbreviation(updateForm.getAbbreviation() != null ? updateForm.getAbbreviation().toUpperCase() : null);
            userDashboard.setColor(updateForm.getColor().name());
            this.sharingService.stopSharing(dashboard);
            if (updateForm.getShares() != null) {
                for (Share share : updateForm.getShares()) {
                    if ("USER".equals(share.getType())) {
                        this.sharingService.shareToUser(this.userService.getUser(share.getResource(), new String[0]), dashboard);
                        continue;
                    }
                    if ("GROUP".equals(share.getType())) {
                        this.sharingService.shareToGroup(this.userService.getGroup(share.getResource(), new String[0]), dashboard);
                        continue;
                    }
                    if (!"ALL".equals(share.getType())) continue;
                    this.sharingService.shareToEveryone(dashboard);
                }
            }
            this.configElementTranslationsCache.invalidateTranslations(TranslatedConfigElementType.USER_DASHBOARD, userDashboard.getId().longValue());
            this.audit(AuditTypes.AUDIT_DASHBOARD_CHANGED, true, started, auditParams);
            return RestResult.success();
        });
    }

    private Map<String, Object> updateDashboardAuditParams(UserDashboard oldDashboard, UpdateForm newDashboard) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("DASHBOARD_NAME", oldDashboard.getName() + " > " + newDashboard.getName());
        if (StringUtils.isNotBlank((CharSequence)oldDashboard.getDescription()) || StringUtils.isNotBlank((CharSequence)newDashboard.getDescription())) {
            params.put("DASHBOARD_DESCR", oldDashboard.getDescription() + " > " + newDashboard.getDescription());
        }
        params.put("DASHBOARD_ABBREVIATION", oldDashboard.getAbbreviation() + " > " + newDashboard.getAbbreviation());
        params.put("DASHBOARD_COLOR", oldDashboard.getColor() + " > " + newDashboard.getColor().getCode());
        Map<String, List<Long>> oldShares = this.getOldShares(oldDashboard);
        Map<String, List<Long>> newShares = this.getNewShares(newDashboard);
        if (this.sharesNotChanged(oldShares, newShares)) {
            return params;
        }
        this.prepareOldSharesParams(params, oldShares, newShares);
        this.prepareNewSharesParams(params, oldShares, newShares);
        return params;
    }

    private void prepareNewSharesParams(Map<String, Object> params, Map<String, List<Long>> oldShares, Map<String, List<Long>> newShares) {
        boolean newSharesAll = newShares.containsKey("ALL");
        if (newSharesAll) {
            params.put("DASHBOARD_SHARES_ADDED", this.messageHelper.getMessage("AUDIT_PARAM_DASHBOARD_SHARES_ALL"));
        } else {
            String addedGroupShares;
            String addedUserShares = this.prepareDifferencesInShares(newShares, oldShares, "USER");
            if (StringUtils.isNotBlank((CharSequence)addedUserShares)) {
                params.put("DASHBOARD_SHARES_ADDED_USERS", addedUserShares);
            }
            if (StringUtils.isNotBlank((CharSequence)(addedGroupShares = this.prepareDifferencesInShares(newShares, oldShares, "GROUP")))) {
                params.put("DASHBOARD_SHARES_ADDED_GROUPS", addedGroupShares);
            }
        }
    }

    private void prepareOldSharesParams(Map<String, Object> params, Map<String, List<Long>> oldShares, Map<String, List<Long>> newShares) {
        boolean oldSharesAll = oldShares.containsKey("ALL");
        if (oldSharesAll) {
            params.put("DASHBOARD_SHARES_REMOVED", this.messageHelper.getMessage("AUDIT_PARAM_DASHBOARD_SHARES_ALL"));
        } else {
            String removedGroupShares;
            String removedUserShares = this.prepareDifferencesInShares(oldShares, newShares, "USER");
            if (StringUtils.isNotBlank((CharSequence)removedUserShares)) {
                params.put("DASHBOARD_SHARES_REMOVED_USERS", removedUserShares);
            }
            if (StringUtils.isNotBlank((CharSequence)(removedGroupShares = this.prepareDifferencesInShares(oldShares, newShares, "GROUP")))) {
                params.put("DASHBOARD_SHARES_REMOVED_GROUPS", removedGroupShares);
            }
        }
    }

    private String prepareDifferencesInShares(Map<String, List<Long>> firstShares, Map<String, List<Long>> secondShares, String dashboardShareType) {
        List<Long> diffResources = firstShares.get(dashboardShareType).stream().filter(oldUser -> !((List)secondShares.get(dashboardShareType)).contains(oldUser)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(diffResources)) {
            StringBuilder diffResourcesStringBuilder = new StringBuilder();
            diffResources.forEach(resource -> {
                Object resourceName = "";
                if ("USER".equals(dashboardShareType)) {
                    User user = this.userService.getUser(resource, new String[0]);
                    resourceName = user.getFullName() + " (" + user.getUserName() + ")";
                } else if ("GROUP".equals(dashboardShareType)) {
                    UserGroup group = this.userService.getGroup(resource, new String[0]);
                    resourceName = group.getName();
                }
                if (diffResourcesStringBuilder.length() > 0) {
                    diffResourcesStringBuilder.append("\n");
                }
                diffResourcesStringBuilder.append((String)resourceName);
            });
            return diffResourcesStringBuilder.toString();
        }
        return "";
    }

    private boolean sharesNotChanged(Map<String, List<Long>> oldShares, Map<String, List<Long>> newShares) {
        if (oldShares.isEmpty() && newShares.isEmpty()) {
            return true;
        }
        if (oldShares.containsKey("ALL") && newShares.containsKey("ALL")) {
            return true;
        }
        if (oldShares.containsKey("ALL") || newShares.containsKey("ALL")) {
            return false;
        }
        List<Long> oldUserShares = oldShares.get("USER");
        List<Long> newUserShares = newShares.get("USER");
        List<Long> oldGroupShares = oldShares.get("GROUP");
        List<Long> newGroupShares = newShares.get("GROUP");
        return oldUserShares.equals(newUserShares) && oldGroupShares.equals(newGroupShares);
    }

    private Map<String, List<Long>> getOldShares(UserDashboard oldDashboard) {
        HashMap<String, List<Long>> oldShares = new HashMap<String, List<Long>>();
        oldShares.put("USER", new ArrayList());
        oldShares.put("GROUP", new ArrayList());
        if (oldDashboard.getDashboardShares() != null) {
            for (DashboardShare dashboardShare : oldDashboard.getDashboardShares()) {
                if (dashboardShare instanceof UserShare) {
                    ((List)oldShares.get("USER")).add(((UserShare)dashboardShare).getUser().getObjectId());
                    continue;
                }
                if (dashboardShare instanceof GroupShare) {
                    ((List)oldShares.get("GROUP")).add(((GroupShare)dashboardShare).getGroup().getObjectId());
                    continue;
                }
                if (dashboardShare instanceof EveryoneShare) {
                    oldShares.computeIfAbsent("ALL", shareType -> new ArrayList());
                    continue;
                }
                log.error("Unknown DashboardShare object type " + dashboardShare.getClass());
            }
        }
        return oldShares;
    }

    private Map<String, List<Long>> getNewShares(UpdateForm newDashboard) {
        HashMap<String, List<Long>> newShares = new HashMap<String, List<Long>>();
        newShares.put("USER", new ArrayList());
        newShares.put("GROUP", new ArrayList());
        if (newDashboard.getShares() != null) {
            for (Share dashboardShare : newDashboard.getShares()) {
                if (dashboardShare.getType().equals("USER")) {
                    ((List)newShares.get("USER")).add(dashboardShare.getResource());
                    continue;
                }
                if (dashboardShare.getType().equals("GROUP")) {
                    ((List)newShares.get("GROUP")).add(dashboardShare.getResource());
                    continue;
                }
                if (dashboardShare.getType().equals("ALL")) {
                    newShares.computeIfAbsent("ALL", shareType -> new ArrayList());
                    continue;
                }
                log.error("Unknown DashboardShare object type " + dashboardShare.getClass());
            }
        }
        return newShares;
    }

    @ApiOperation(value="Deleting dashboard", notes="Deletes dashboard with given id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Dashboard not found")})
    @DeleteMapping(value={"{id}"})
    @ResponseBody
    public RestResult deleteDashboard(@ApiParam(value="Dashboard id", required=true) @PathVariable Long id) {
        Date started = new Date();
        Dashboard dashboard = Optional.ofNullable(this.dashboardService.getDashboard(id)).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Pulpit_nie_istnieje", new Object[]{id})));
        this.dashboardService.deleteDashboard(id);
        ImmutableMap params = ImmutableMap.of((Object)"DASHBOARD_NAME", (Object)dashboard.getName());
        this.audit(AuditTypes.AUDIT_DASHBOARD_REMOVED, true, started, (Map<String, Object>)params);
        return new RestResult(true);
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"primary", "default"})
    @ResponseBody
    public DashboardDto getDefaultDashboard(@RequestParam(value="user", required=false) Long userId, @RequestParam(value="group", required=false) Long groupId) throws GroupNotFoundException {
        User user = null;
        UserGroup userGroup = null;
        if (userId != null) {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            user = Optional.ofNullable(this.userService.getUser(userId, new String[]{"groups"})).orElseThrow(() -> new UserNotFoundException(this.messageHelper.getMessage("Uzytkownik_o_podanym_id_nie_istnieje", new Object[]{userId})));
        } else if (groupId != null) {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            userGroup = Optional.ofNullable(this.userService.getGroup(groupId, new String[0])).orElseThrow(() -> new GroupNotFoundException(this.messageHelper.getMessage("Grupa_o_podanym_id_nie_istnieje", new Object[]{groupId})));
        } else {
            user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        }
        Dashboard dashboard = userGroup != null ? this.dashboardService.getDefaultDashboard(userGroup) : this.dashboardService.getDefaultDashboard(user);
        return dashboard != null ? this.dashboardMapper.fromDashboard(dashboard) : null;
    }

    @ApiOperation(value="", hidden=true)
    @PostMapping(value={"{id}/primary", "{id}/default"})
    @ResponseBody
    public RestResult setUserDefaultDashboard(@PathVariable String id, @RequestParam(value="user", required=false) Long userId, @RequestParam(value="group", required=false) Long groupId, @RequestParam(required=false) boolean system) throws UnauthorizedException, GroupNotFoundException {
        return (RestResult)TransactionWrapper.get().doInSneakyHibernateTransaction(transaction -> {
            DashboardDto previousDefaultDashboard;
            String resourceName;
            Dashboard dashboard;
            Date started = new Date();
            User currentUser = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
            Dashboard dashboard2 = dashboard = system ? this.systemDashboardService.getSystemDashboardForUser(id, currentUser) : this.dashboardService.getRequiredDashboard(Long.valueOf(id));
            if (userId != null) {
                User user = Optional.ofNullable(this.userService.getUser(userId, new String[]{"groups"})).orElseThrow(() -> new UserNotFoundException(this.messageHelper.getMessage("Uzytkownik_o_podanym_id_nie_istnieje", new Object[]{userId})));
                resourceName = user.getUserName();
                previousDefaultDashboard = this.getDefaultDashboard(user.getObjectId(), null);
                this.dashboardService.setUserDefaultDashboard(user, dashboard);
            } else if (groupId != null) {
                UserGroup userGroup = Optional.ofNullable(this.userService.getGroup(groupId, new String[0])).orElseThrow(() -> new GroupNotFoundException(this.messageHelper.getMessage("Grupa_o_podanym_id_nie_istnieje", new Object[]{groupId})));
                resourceName = userGroup.getName();
                previousDefaultDashboard = this.getDefaultDashboard(null, userGroup.getObjectId());
                this.dashboardService.setGroupDefaultDashboard(userGroup, dashboard);
            } else {
                resourceName = currentUser.getUserName();
                previousDefaultDashboard = this.getDefaultDashboard(null, null);
                this.dashboardService.setUserDefaultDashboard(currentUser, dashboard);
            }
            String previousDefaultDashboardName = previousDefaultDashboard != null && previousDefaultDashboard.getName() != null ? previousDefaultDashboard.getName() : this.messageHelper.getMessage("brak");
            ImmutableMap params = ImmutableMap.of((Object)"USER_NAME", (Object)resourceName, (Object)"PREVIOUS_DEFAULT_DASHBOARD_NAME", (Object)previousDefaultDashboardName, (Object)"NEW_DEFAULT_DASHBOARD_NAME", (Object)dashboard.getName());
            this.audit(AuditTypes.AUDIT_DASHBOARD_DEFAULT_CHANGED, true, started, (Map<String, Object>)params);
            return new RestResult(true);
        });
    }

    @ApiOperation(value="", hidden=true)
    @PostMapping(value={"{id}/gadgets"})
    @ResponseBody
    public GadgetDto addGadget(@PathVariable Long id, @RequestParam String gadget, @RequestParam(required=false) Integer positionY) throws UnauthorizedException {
        return (GadgetDto)TransactionWrapper.get().doInHibernateTransaction(transaction -> {
            Dashboard dashboard = Optional.ofNullable(this.dashboardService.getDashboard(id)).orElseThrow(() -> new DashboardNotFoundException(id));
            Gadget addedGadget = this.dashboardService.addGadget(dashboard, gadget);
            if (positionY != null) {
                addedGadget.getLayout().setPositionY(positionY.intValue());
            }
            this.dashboardService.updateDashboard(dashboard);
            return GadgetDto.create((Gadget)addedGadget);
        });
    }

    @ApiOperation(value="", hidden=true)
    @DeleteMapping(value={"{id}/gadgets/{gadgetId}"})
    @ResponseBody
    public void removeGadget(@PathVariable Long id, @PathVariable Long gadgetId) throws UnauthorizedException {
        Dashboard dashboard = Optional.ofNullable(this.dashboardService.getDashboard(id)).orElseThrow(() -> new DashboardNotFoundException(id));
        this.dashboardService.removeGadget(dashboard, gadgetId);
    }

    @ApiOperation(value="", hidden=true)
    @PutMapping(value={"{id}/save"})
    @ResponseBody
    public void saveLayout(@PathVariable Long id, @RequestBody List<GadgetLayout> layouts) throws UnauthorizedException {
        TransactionWrapper.get().doInHibernateTransaction(transaction -> {
            Dashboard dashboard = Optional.ofNullable(this.dashboardService.getDashboard(id)).orElseThrow(() -> new DashboardNotFoundException(id));
            for (GadgetLayout newLayout : layouts) {
                Gadget gadget = dashboard.getGadget(newLayout.getGadgetId());
                Layout layout = gadget.getLayout();
                layout.setPositionY(newLayout.getPositionY());
                layout.setCollapsed(newLayout.isCollapsed());
                layout.setHeight(newLayout.getHeight());
                layout.setWidth(newLayout.getWidth());
                layout.setPositionX(newLayout.getPositionX());
                layout.setFitHeight(newLayout.isFitHeight());
            }
            this.dashboardService.updateDashboard(dashboard);
        });
    }

    @ApiOperation(value="Appending gadget to existing dashboard. Allows adding gadget next to already existing gadget. Requires write permission to dashboard.", notes="Appends a gadget to an existing dashboard")
    @ApiResponses(value={@ApiResponse(code=200, message="Gadget added. If there were any errors on setting gadget properties, list of errors is returned."), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=404, message="Not found")})
    @PostMapping(value={"{id}/appendGadget"})
    @ResponseBody
    public AddGadgetResult appendGadgetToDashboard(@ApiParam(value="Dashboard id", required=true) @PathVariable Long id, @ApiParam(value="The query contains a JSON object containing definition of gadget to add. The definition should include the following fields\n            - **key** - gadget key\n            - **properties** - object with key/value pairs of gadget properties\n            - **layout** - object defining layout of added gadget\n            <br>\n            - **layout** - should include the following fields\n            - **appendType** - add gadget to end of the dashboard (END) or next to existing gadget (APPEND_TO_GADGET)\n            - **width** (not required) - gadget width (must be less or equal dashboard resolution - 24)\n            - **height** (not required) - gadget height in pixels\n            - **targetGadgetId** (required only if appendType = APPEND_TO_GADGET) - gadget id next to which it is to be appended\n            <br>\n            <br>\n            > You can use `/api/dashboards/<dashboard_id>` endpoint to access gadget properties of existing gadgets.", required=true) @RequestBody GadgetAppendDto gadget) {
        return this.dashboardService.appendGadgetToDashboard(id, gadget.key(), gadget.properties(), gadget.layout());
    }

    private void audit(AuditTypes type, boolean success, Date started, Map<String, Object> params) {
        ManualAuditBuilder.getInstance().type(type).username(UserContext.current().getUser().getUserName()).params(params).success(success).started(started).stopped(new Date()).build().log();
    }

    @ExceptionHandler(value={DashboardNotFoundException.class, UserNotFoundException.class, GroupNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFoundException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class, NumberFormatException.class, DashboardAlreadyExistsException.class, GadgetNotFoundException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequestException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleUnauthorizedException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"dashboardService", "systemDashboardService", "sharingService", "userService", "dashboardMapper", "gadgetDashboardMapper", "messageHelper", "configElementTranslationsCache", "authorizationHelper"})
    @Autowired
    public DashboardController(DashboardService dashboardService, SystemDashboardService systemDashboardService, DashboardSharingService sharingService, UserService userService, DashboardMapper dashboardMapper, GadgetDashboardMapper gadgetDashboardMapper, MessageHelperBean messageHelper, ConfigElementTranslationsCache configElementTranslationsCache, AuthorizationHelper authorizationHelper) {
        this.dashboardService = dashboardService;
        this.systemDashboardService = systemDashboardService;
        this.sharingService = sharingService;
        this.userService = userService;
        this.dashboardMapper = dashboardMapper;
        this.gadgetDashboardMapper = gadgetDashboardMapper;
        this.messageHelper = messageHelper;
        this.configElementTranslationsCache = configElementTranslationsCache;
        this.authorizationHelper = authorizationHelper;
    }
}

