/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendar.Calendar;
import com.suncode.pwfl.calendar.UserCalendar;
import com.suncode.pwfl.calendar.api.CalendarFacade;
import com.suncode.pwfl.calendar.defaultCalendar.api.DefaultCalendarService;
import com.suncode.pwfl.calendar.event.EventInvitationStatus;
import com.suncode.pwfl.calendar.event.EventRruleHelper;
import com.suncode.pwfl.calendar.event.RecurrenceDefinition;
import com.suncode.pwfl.calendar.event.RecurrenceEventExclusion;
import com.suncode.pwfl.calendar.event.RecurrenceEventExclusionService;
import com.suncode.pwfl.calendar.event.UserCalendarEvent;
import com.suncode.pwfl.calendar.event.UserCalendarEventInvitation;
import com.suncode.pwfl.calendar.resource.CalendarResource;
import com.suncode.pwfl.calendar.resource.CalendarResourceService;
import com.suncode.pwfl.calendar.resource.tree.CalendarResourceTreeNode;
import com.suncode.pwfl.calendar.support.CalendarDateConverter;
import com.suncode.pwfl.calendar.user.DeleteUserEventResult;
import com.suncode.pwfl.calendar.user.UserCalendarEventParticipant;
import com.suncode.pwfl.calendar.user.api.UserCalendarAvailabilityService;
import com.suncode.pwfl.calendar.user.api.UserCalendarService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.controller.api.calendar.ModifyRecurrenceEventType;
import com.suncode.pwfl.web.dto.calendar.CalendarDto;
import com.suncode.pwfl.web.dto.calendar.EventInvitationDto;
import com.suncode.pwfl.web.dto.calendar.EventParticipantDto;
import com.suncode.pwfl.web.dto.calendar.ModifyRecurrenceEventDto;
import com.suncode.pwfl.web.dto.calendar.UserCalendarDto;
import com.suncode.pwfl.web.dto.calendar.event.UserCalendarEventDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.calendar.CalendarMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.fortuna.ical4j.data.CalendarOutputter;
import org.dmfs.rfc5545.recur.InvalidRecurrenceRuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"calendar/user"})
@Api(hidden=true)
public class UserCalendarController {
    private static final Logger log = LoggerFactory.getLogger(UserCalendarController.class);
    private final CalendarFacade calendarFacade;
    private final UserCalendarService userCalendarService;
    private final DefaultCalendarService defaultCalendarService;
    private final UserService userService;
    private final CalendarMapper calendarMapper;
    private final RecurrenceEventExclusionService recurrenceEventExclusionService;
    private final CalendarDateConverter calendarDateConverter;
    private final MessageHelperBean messageHelper;
    private final EventRruleHelper eventRruleHelper;
    private final UserCalendarAvailabilityService userCalendarAvailabilityService;
    private final CalendarResourceService calendarResourceService;

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public CalendarDto createUserCalendar(@RequestBody UserCalendarDto userCalendarDto, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_USER_CALENDAR);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            UserCalendar userCalendar = this.calendarMapper.toUserCalendar(userCalendarDto);
            userCalendar.setOwner(user);
            auditParamsBuilder.params(this.paramsFromUserCalendar(userCalendar));
            UserCalendar createdCalendar = (UserCalendar)this.userCalendarService.createCalendar((Calendar)userCalendar);
            auditParamsBuilder.params(this.paramsFromUserCalendar(createdCalendar));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarMapper.toCalendarDto((Calendar)createdCalendar);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @PatchMapping(value={"{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public CalendarDto updateUserCalendar(@PathVariable Long id, @RequestBody UserCalendarDto userCalendarDto, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_USER_CALENDAR);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            UserCalendar userCalendar = this.calendarMapper.toUserCalendar(userCalendarDto);
            userCalendar.setOwner(user);
            auditParamsBuilder.params(this.paramsFromUserCalendar(userCalendar));
            UserCalendar oldUserCalendar = (UserCalendar)this.userCalendarService.getCalendar(id, user);
            UserCalendar updatedCalendar = (UserCalendar)this.userCalendarService.updateCalendar(id.longValue(), (Calendar)userCalendar);
            auditParamsBuilder.params(this.paramsFromUserCalendar(oldUserCalendar, userCalendar));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarMapper.toCalendarDto((Calendar)updatedCalendar);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{id}"})
    public RestResult deleteUserCalendar(@PathVariable Long id, @RequestParam(required=false) Long newCalendarId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)id);
        if (newCalendarId != null) {
            auditParamsBuilder.param("newCalendarId", (Object)newCalendarId);
        }
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_USER_CALENDAR).params(auditParamsBuilder.build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
            this.userCalendarService.deleteCalendar(id, user, newCalendarId);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @GetMapping(value={"{calendarId}/events"})
    public List<UserCalendarEventDto> getEventsForUserCalendar(@PathVariable(required=false) Long calendarId, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromDateTime, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toDateTime) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        List events = calendarId != null ? this.userCalendarService.getEventsForCalendarByInterval(calendarId, user, fromDateTime, toDateTime) : this.defaultCalendarService.getEventsForCalendarByInterval(user, fromDateTime, toDateTime);
        return events.stream().map(event -> this.calendarMapper.toUserCalendarEventDto((UserCalendarEvent)event, user)).toList();
    }

    @GetMapping(value={"{calendarId}/events/recurrence/first/{eventId}", "events/recurrence/first/{eventId}"})
    public UserCalendarEventDto getFirstRecurrenceEvent(@PathVariable(required=false) Long calendarId, @PathVariable Long eventId) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        UserCalendarEvent userCalendarEvent = this.userCalendarService.getUserCalendarEvent(eventId.longValue(), user);
        List recurrenceEvents = this.eventRruleHelper.handleRecurrenceEvents(List.of(userCalendarEvent), null, null);
        return this.calendarMapper.toUserCalendarEventDto((UserCalendarEvent)recurrenceEvents.get(0), user);
    }

    @PostMapping(value={"{calendarId}/events"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public UserCalendarEventDto createEventForUserCalendar(@PathVariable Long calendarId, @RequestBody UserCalendarEventDto userCalendarEventDto, HttpServletRequest request) throws InvalidRecurrenceRuleException {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_USER_CALENDAR_EVENT);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
            UserCalendarEvent userCalendarEvent = this.calendarMapper.toUserCalendarEvent(userCalendarEventDto);
            auditParamsBuilder.params(this.paramsFromUserCalendarEvent(userCalendarEvent, user));
            UserCalendarEvent createdUserCalendarEvent = this.userCalendarService.createEvent(calendarId, user, userCalendarEvent);
            auditParamsBuilder.params(this.paramsFromUserCalendarEvent(createdUserCalendarEvent, user));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarMapper.toUserCalendarEventDto(createdUserCalendarEvent, user);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @PatchMapping(value={"{calendarId}/events/{eventId}", "events/{eventId}"})
    public UserCalendarEventDto updateUserEvent(@PathVariable(required=false) Long calendarId, @PathVariable Long eventId, @RequestBody UserCalendarEventDto userCalendarEventDto, HttpServletRequest request) throws InvalidRecurrenceRuleException {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)eventId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_USER_CALENDAR_EVENT).params(auditParamsBuilder.build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
            UserCalendarEvent userCalendarEvent = this.calendarMapper.toUserCalendarEvent(userCalendarEventDto);
            auditParamsBuilder.params(this.paramsFromUserCalendarEvent(userCalendarEvent, user));
            UserCalendarEvent oldUserCalendarEvent = this.userCalendarService.getUserCalendarEvent(eventId.longValue(), user);
            UserCalendarEvent updatedEvent = this.userCalendarService.updateEvent(eventId, user, userCalendarEvent);
            auditParamsBuilder.params(this.paramsFromUserCalendarEvent(oldUserCalendarEvent, updatedEvent, user));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarMapper.toUserCalendarEventDto(updatedEvent, user);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @PatchMapping(value={"{calendarId}/events/recurrence/{eventId}", "events/recurrence/{eventId}"})
    public UserCalendarEventDto updateRecurrenceUserEvent(@PathVariable(required=false) Long calendarId, @PathVariable Long eventId, @RequestBody UpdateRecurrenceUserEventDto updateRecurrenceUserEventDto, HttpServletRequest request) throws InvalidRecurrenceRuleException {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)eventId).param("modifyRecurrenceStartDateTime", (Object)updateRecurrenceUserEventDto.modifyRecurrenceEventDto.startDateTime()).param("modifyRecurrenceEndDateTime", (Object)updateRecurrenceUserEventDto.modifyRecurrenceEventDto.endDateTime()).param("modifyRecurrenceAllDay", (Object)updateRecurrenceUserEventDto.modifyRecurrenceEventDto.allDay()).param("modifyType", (Object)updateRecurrenceUserEventDto.modifyRecurrenceEventDto.modifyType().name());
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_USER_CALENDAR_EVENT);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
            UserCalendarEventDto userCalendarEventDto = updateRecurrenceUserEventDto.userCalendarEventDto;
            ModifyRecurrenceEventDto modifyRecurrenceEventDto = updateRecurrenceUserEventDto.modifyRecurrenceEventDto;
            UserCalendarEvent userCalendarEvent = this.calendarMapper.toUserCalendarEvent(userCalendarEventDto);
            auditParamsBuilder.params(this.paramsFromUserCalendarEvent(userCalendarEvent, user));
            UserCalendarEvent oldUserCalendarEvent = this.userCalendarService.getUserCalendarEvent(eventId.longValue(), user);
            UserCalendarEvent updatedUserCalendarEvent = switch (modifyRecurrenceEventDto.modifyType()) {
                default -> throw new IncompatibleClassChangeError();
                case ModifyRecurrenceEventType.SINGLE -> this.userCalendarService.updateSingleRecurrenceEvent(calendarId, user, userCalendarEvent, this.buildRecurrenceEventExclusion(modifyRecurrenceEventDto.startDateTime(), modifyRecurrenceEventDto.endDateTime(), modifyRecurrenceEventDto.allDay(), eventId));
                case ModifyRecurrenceEventType.ALL_FROM -> this.userCalendarService.updateAllFromRecurrenceEvent(calendarId, eventId, user, this.calendarDateConverter.toLocalDateTime(userCalendarEventDto.getStartDateTime(), userCalendarEventDto.isAllDay()), userCalendarEvent);
            };
            auditParamsBuilder.params(this.paramsFromUserCalendarEvent(oldUserCalendarEvent, updatedUserCalendarEvent, user));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarMapper.toUserCalendarEventDto(updatedUserCalendarEvent, user);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{calendarId}/events/{eventId}", "events/{eventId}"})
    public RestResult deleteUserEvent(@PathVariable(required=false) Long calendarId, @PathVariable Long eventId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)eventId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_USER_CALENDAR_EVENT).params(auditParamsBuilder.build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            DeleteUserEventResult status = this.userCalendarService.deleteUserEvent(eventId, user);
            String message = switch (status) {
                default -> throw new IncompatibleClassChangeError();
                case DeleteUserEventResult.DELETED -> this.messageHelper.getMessage("Wydarzenie_zostalo_usuniete");
                case DeleteUserEventResult.CANCELLED -> this.messageHelper.getMessage("Wydarzenie_zostalo_anulowane");
            };
            auditParamsBuilder.param("deleteStatus", (Object)status.name());
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true, message);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{calendarId}/events/recurrence/{eventId}", "events/recurrence/{eventId}"})
    public RestResult deleteRecurrenceUserEvent(@PathVariable(required=false) Long calendarId, @PathVariable Long eventId, @RequestBody ModifyRecurrenceEventDto modifyRecurrenceEventDto, HttpServletRequest request) throws InvalidRecurrenceRuleException {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)eventId).param("modifyRecurrenceStartDateTime", (Object)modifyRecurrenceEventDto.startDateTime()).param("modifyRecurrenceEndDateTime", (Object)modifyRecurrenceEventDto.endDateTime()).param("modifyRecurrenceAllDay", (Object)modifyRecurrenceEventDto.allDay()).param("modifyType", (Object)modifyRecurrenceEventDto.modifyType().name());
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_USER_CALENDAR_EVENT).params(auditParamsBuilder.build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
            switch (modifyRecurrenceEventDto.modifyType()) {
                case SINGLE: {
                    this.recurrenceEventExclusionService.createRecurrenceEventExclusion(user, this.buildRecurrenceEventExclusion(modifyRecurrenceEventDto.startDateTime(), modifyRecurrenceEventDto.endDateTime(), modifyRecurrenceEventDto.allDay(), eventId));
                    this.userCalendarService.createCancelledEventForDeletedSingleRecurrenceEvent(calendarId, eventId, user, modifyRecurrenceEventDto.startDateTime(), modifyRecurrenceEventDto.endDateTime(), modifyRecurrenceEventDto.allDay());
                    break;
                }
                case ALL_FROM: {
                    UserCalendarEvent userCalendarEvent = this.userCalendarService.getUserCalendarEvent(eventId.longValue(), user);
                    if (this.isFirstOccurranceOfRecurrenceEvent(userCalendarEvent, modifyRecurrenceEventDto)) {
                        this.deleteUserEvent(userCalendarEvent.getCalendar().getId(), userCalendarEvent.getId(), request);
                        break;
                    }
                    LocalDateTime toDateTime = this.calendarDateConverter.toLocalDateTime(modifyRecurrenceEventDto.endDateTime(), modifyRecurrenceEventDto.allDay());
                    this.userCalendarService.changeRecurrenceEventToUntilDate(eventId, user, modifyRecurrenceEventDto.allDay() ? toDateTime : toDateTime.minusDays(1L));
                }
            }
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    private boolean isFirstOccurranceOfRecurrenceEvent(UserCalendarEvent userCalendarEvent, ModifyRecurrenceEventDto modifyRecurrenceEventDto) {
        LocalDateTime recurrenceEventStartDateTime = this.calendarDateConverter.toLocalDateTime(modifyRecurrenceEventDto.startDateTime(), modifyRecurrenceEventDto.allDay());
        return userCalendarEvent.getStartDateTimeUTC().equals(recurrenceEventStartDateTime);
    }

    @Nullable
    @GetMapping(value={"{calendarId}/share/link"})
    public String getCalendarShareLink(@PathVariable Long calendarId) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        Calendar calendar = this.calendarFacade.getCalendarForUser((Calendar)new UserCalendar(calendarId), user);
        return calendar.getShareLinkId() != null ? this.buildShareCalendarUrl(calendar.getShareLinkId()) : null;
    }

    @GetMapping(value={"{calendarId}/share/link/generate"})
    public String generateCalendarShareLink(@PathVariable Long calendarId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)calendarId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_GENERATE_USER_CALENDAR_SHARE_LINK);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            UserCalendar userCalendar = (UserCalendar)this.userCalendarService.getCalendar(calendarId, user);
            auditParamsBuilder.param("calendarName", (Object)userCalendar.getName());
            String shareLinkId = this.calendarFacade.generateCalendarShareLink((Calendar)new UserCalendar(calendarId), user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.buildShareCalendarUrl(shareLinkId);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{calendarId}/share/link"})
    public RestResult deleteCalendarShareLink(@PathVariable Long calendarId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)calendarId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_USER_CALENDAR_SHARE_LINK);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            UserCalendar userCalendar = (UserCalendar)this.userCalendarService.getCalendar(calendarId, user);
            auditParamsBuilder.param("calendarName", (Object)userCalendar.getName());
            this.calendarFacade.deleteCalendarShareLink((Calendar)new UserCalendar(calendarId), user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @GetMapping(value={"share/link/{shareLinkId}"})
    public ResponseEntity<byte[]> getCalendarIcalResource(@PathVariable String shareLinkId) {
        net.fortuna.ical4j.model.Calendar icalCalendar = this.calendarFacade.buildIcalCalendar((Calendar)new UserCalendar(shareLinkId));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CalendarOutputter outputter = new CalendarOutputter();
        try {
            outputter.output(icalCalendar, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            log.error("Error on creating ICS file for resource " + shareLinkId, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        byte[] icalBytes = byteArrayOutputStream.toByteArray();
        String fileFormat = ".ics";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"text/calendar"));
        headers.setContentDispositionFormData("attachment", shareLinkId + ".ics");
        return new ResponseEntity((Object)icalBytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"invitations/status/unknown"})
    public List<EventInvitationDto> getInvitationsWithUnknownStatus() {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        return this.userCalendarService.getInvitationsByStatusForUser(user, EventInvitationStatus.UNKNOWN).stream().map(invitation -> this.calendarMapper.toEventInvitationDto((UserCalendarEventInvitation)invitation, user)).toList();
    }

    @PatchMapping(value={"invitations/{invitationId}/accept"})
    public EventParticipantDto acceptEventInvitation(@PathVariable Long invitationId, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ACCEPT_USER_CALENDAR_EVENT_INVITATION).params(new AuditParamsBuilder().param("id", (Object)invitationId).build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            UserCalendarEventParticipant userCalendarEventInvitation = this.userCalendarService.acceptUserCalendarEventInvitation(new UserCalendarEventParticipant(invitationId), user);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return this.calendarMapper.toEventParticipantDto(userCalendarEventInvitation);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @PatchMapping(value={"invitations/{invitationId}/decline"})
    public EventParticipantDto declineEventInvitation(@PathVariable Long invitationId, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DECLINE_USER_CALENDAR_EVENT_INVITATION).params(new AuditParamsBuilder().param("id", (Object)invitationId).build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            UserCalendarEventParticipant userCalendarEventInvitation = this.userCalendarService.declineUserCalendarEventInvitation(new UserCalendarEventParticipant(invitationId), user);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return this.calendarMapper.toEventParticipantDto(userCalendarEventInvitation);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @GetMapping(value={"isUserAvailable"})
    public boolean isUserAvailableDuringInterval(@RequestParam String userId, @RequestParam String fromDateTime, @RequestParam String toDateTime, @RequestParam boolean allDay, @RequestParam(required=false) Long excludedEventId) {
        User user = this.userService.getUser(userId, new String[0]);
        return this.userCalendarAvailabilityService.isUserAvailableDuringInterval(user, this.calendarDateConverter.toLocalDateTime(fromDateTime, allDay), this.calendarDateConverter.toLocalDateTime(toDateTime, allDay), allDay, excludedEventId);
    }

    @GetMapping(value={"{calendarId}/resource/tree"})
    public List<CalendarResourceTreeNode> getCalendarResourceTree(@PathVariable Long calendarId, @RequestParam(required=false) List<Long> allowedInactiveResources) {
        String username = UserContext.current().getUser().getUserName();
        return this.userCalendarService.getResourceTreeForCalendar(calendarId, username, allowedInactiveResources);
    }

    @GetMapping(value={"{calendarId}/events/count"})
    public long countEventsOwnedByUser(@PathVariable Long calendarId) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        return this.userCalendarService.countCalendarEventsOwnedByUser(calendarId, user);
    }

    @PatchMapping(value={"{calendarId}/events/{eventId}/hide", "events/{eventId}/hide"})
    public void hideUserCalendarEvent(@PathVariable(required=false) Long calendarId, @PathVariable Long eventId, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_HIDE_USER_CALENDAR_EVENT).params(new AuditParamsBuilder().param("id", (Object)eventId).build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            this.userCalendarService.hideUserCalendarEvent(eventId.longValue(), user);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @GetMapping(value={"/events/countByResource"})
    public long countEventsUsedByResource(@RequestParam long resourceId, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromDateTime, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toDateTime) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        return this.userCalendarService.countEventsUsedByResourceInPeriod(resourceId, user, fromDateTime, toDateTime);
    }

    @PostMapping(value={"/events/cancelByResource"})
    public void cancelEventsUsedByResource(@RequestParam long resourceId, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromDateTime, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toDateTime, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CANCEL_USER_CALENDAR_EVENTS_BY_RESOURCE).params(new AuditParamsBuilder().param("resourceId", (Object)resourceId).param("fromDateTime", (Object)fromDateTime).param("toDateTime", (Object)toDateTime).build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            this.userCalendarService.cancelUserEventsUsingResourceInPeriod(resourceId, user, fromDateTime, toDateTime);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    private String buildShareCalendarUrl(String shareLinkId) {
        return ServletUriComponentsBuilder.fromCurrentContextPath().path("/api/calendar/user/share/link/{shareLinkId}").buildAndExpand(new Object[]{shareLinkId}).toUriString();
    }

    private RecurrenceEventExclusion buildRecurrenceEventExclusion(String startDateTime, String endDateTime, boolean allDay, Long eventId) {
        return RecurrenceEventExclusion.builder().startDateTimeUTC(this.calendarDateConverter.toLocalDateTime(startDateTime, allDay)).endDateTimeUTC(this.calendarDateConverter.toLocalDateTime(endDateTime, allDay)).allDay(allDay).eventId(eventId.longValue()).build();
    }

    private Map<String, Object> paramsFromUserCalendar(UserCalendar userCalendar) {
        return new AuditParamsBuilder().param("name", (Object)userCalendar.getName()).param("color", (Object)userCalendar.getColor()).param("resourceGroupsIds", (Object)userCalendar.getResourceGroupsIds()).build();
    }

    private Map<String, Object> paramsFromUserCalendar(UserCalendar oldUserCalendar, UserCalendar newUserCalendar) {
        return new AuditParamsBuilder().param("name", (Object)oldUserCalendar.getName(), (Object)newUserCalendar.getName()).param("color", (Object)oldUserCalendar.getColor(), (Object)newUserCalendar.getColor()).param("resourceGroupsIds", (Object)oldUserCalendar.getResourceGroupsIds(), (Object)newUserCalendar.getResourceGroupsIds()).build();
    }

    private Map<String, Object> paramsFromUserCalendarEvent(UserCalendarEvent userCalendarEvent, User user) {
        String recurrencePattern;
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("calendar", (Object)this.getCalendar(userCalendarEvent, user)).param("title", (Object)userCalendarEvent.getTitle()).param("description", (Object)userCalendarEvent.getDescription()).param("allDay", (Object)userCalendarEvent.isAllDay()).param("startDateTimeUTC", (Object)userCalendarEvent.getStartDateTimeUTC()).param("endDateTimeUTC", (Object)userCalendarEvent.getEndDateTimeUTC()).param("recurrent", (Object)(userCalendarEvent.getRecurrenceDefinition() != null ? 1 : 0)).param("participants", this.getParticipants(userCalendarEvent)).param("resources", (Object)this.getResources(userCalendarEvent)).param("timeZone", (Object)userCalendarEvent.getTimeZone());
        Integer durationMinutes = this.getDurationMinutes(userCalendarEvent);
        if (durationMinutes != null) {
            auditParamsBuilder.param("durationMinutes", (Object)durationMinutes);
        }
        if ((recurrencePattern = this.getRecurrencePattern(userCalendarEvent)) != null) {
            auditParamsBuilder.param("recurrencePattern", (Object)recurrencePattern);
        }
        return auditParamsBuilder.build();
    }

    private Map<String, Object> paramsFromUserCalendarEvent(UserCalendarEvent oldUserCalendarEvent, UserCalendarEvent newUserCalendarEvent, User user) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("calendar", (Object)this.getCalendar(oldUserCalendarEvent, user), (Object)this.getCalendar(newUserCalendarEvent, user)).param("title", (Object)oldUserCalendarEvent.getTitle(), (Object)newUserCalendarEvent.getTitle()).param("description", (Object)oldUserCalendarEvent.getDescription(), (Object)newUserCalendarEvent.getDescription()).param("allDay", (Object)oldUserCalendarEvent.isAllDay(), (Object)newUserCalendarEvent.isAllDay()).param("startDateTimeUTC", (Object)oldUserCalendarEvent.getStartDateTimeUTC(), (Object)newUserCalendarEvent.getStartDateTimeUTC()).param("endDateTimeUTC", (Object)oldUserCalendarEvent.getEndDateTimeUTC(), (Object)newUserCalendarEvent.getEndDateTimeUTC()).param("recurrent", (Object)(oldUserCalendarEvent.getRecurrenceDefinition() != null ? 1 : 0), (Object)(newUserCalendarEvent.getRecurrenceDefinition() != null ? 1 : 0)).param("durationMinutes", (Object)this.getDurationMinutes(oldUserCalendarEvent), (Object)this.getDurationMinutes(newUserCalendarEvent)).param("recurrencePattern", (Object)this.getRecurrencePattern(oldUserCalendarEvent), (Object)this.getRecurrencePattern(newUserCalendarEvent), "\n").param("participants", this.getParticipants(oldUserCalendarEvent), this.getParticipants(newUserCalendarEvent)).param("resources", (Object)this.getResources(oldUserCalendarEvent), (Object)this.getResources(newUserCalendarEvent)).param("timeZone", (Object)oldUserCalendarEvent.getTimeZone(), (Object)newUserCalendarEvent.getTimeZone());
        return auditParamsBuilder.build();
    }

    private String getCalendar(UserCalendarEvent userCalendarEvent, User user) {
        Long calendarId = userCalendarEvent.getCalendar().getId();
        if (calendarId == null) {
            return "";
        }
        UserCalendar userCalendar = (UserCalendar)this.userCalendarService.getCalendar(userCalendarEvent.getCalendar().getId(), user);
        return calendarId + ":" + userCalendar.getName();
    }

    private Integer getDurationMinutes(UserCalendarEvent userCalendarEvent) {
        return Optional.ofNullable(userCalendarEvent.getRecurrenceDefinition()).map(RecurrenceDefinition::durationMinutes).orElse(null);
    }

    private String getRecurrencePattern(UserCalendarEvent userCalendarEvent) {
        return Optional.ofNullable(userCalendarEvent.getRecurrenceDefinition()).map(RecurrenceDefinition::recurrencePattern).orElse(null);
    }

    private List<String> getParticipants(UserCalendarEvent userCalendarEvent) {
        return Optional.ofNullable(userCalendarEvent.getParticipants()).stream().flatMap(Collection::stream).map(UserCalendarEventParticipant::getUser).map(User::getUserName).toList();
    }

    private String getResources(UserCalendarEvent userCalendarEvent) {
        return ((List)Optional.ofNullable(userCalendarEvent.getResourceIds()).orElse(new ArrayList())).stream().map(resourceId -> {
            CalendarResource calendarResource = this.calendarResourceService.getCalendarResource(resourceId);
            return resourceId + ":" + calendarResource.getName();
        }).collect(Collectors.joining(","));
    }

    @ConstructorProperties(value={"calendarFacade", "userCalendarService", "defaultCalendarService", "userService", "calendarMapper", "recurrenceEventExclusionService", "calendarDateConverter", "messageHelper", "eventRruleHelper", "userCalendarAvailabilityService", "calendarResourceService"})
    @Autowired
    public UserCalendarController(CalendarFacade calendarFacade, UserCalendarService userCalendarService, DefaultCalendarService defaultCalendarService, UserService userService, CalendarMapper calendarMapper, RecurrenceEventExclusionService recurrenceEventExclusionService, CalendarDateConverter calendarDateConverter, MessageHelperBean messageHelper, EventRruleHelper eventRruleHelper, UserCalendarAvailabilityService userCalendarAvailabilityService, CalendarResourceService calendarResourceService) {
        this.calendarFacade = calendarFacade;
        this.userCalendarService = userCalendarService;
        this.defaultCalendarService = defaultCalendarService;
        this.userService = userService;
        this.calendarMapper = calendarMapper;
        this.recurrenceEventExclusionService = recurrenceEventExclusionService;
        this.calendarDateConverter = calendarDateConverter;
        this.messageHelper = messageHelper;
        this.eventRruleHelper = eventRruleHelper;
        this.userCalendarAvailabilityService = userCalendarAvailabilityService;
        this.calendarResourceService = calendarResourceService;
    }

    private record UpdateRecurrenceUserEventDto(UserCalendarEventDto userCalendarEventDto, ModifyRecurrenceEventDto modifyRecurrenceEventDto) {
    }
}

