/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.UsersManagement;
import com.suncode.pwfl.administration.scheduledtask.info.ScheduledTaskInfoService;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.structure.role.RoleFilter;
import com.suncode.pwfl.administration.user.Domain;
import com.suncode.pwfl.administration.user.DomainService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.administration.user.UserInfoCache;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.UserValidator;
import com.suncode.pwfl.administration.user.exception.EmptyUserNameException;
import com.suncode.pwfl.administration.user.exception.GroupNotFoundException;
import com.suncode.pwfl.administration.user.exception.InvalidUserException;
import com.suncode.pwfl.administration.user.exception.UserAlreadyExistException;
import com.suncode.pwfl.administration.user.search.SimpleHibernateUserFilter;
import com.suncode.pwfl.administration.user.search.UserPropertyFilter;
import com.suncode.pwfl.administration.user.search.UserSortProperty;
import com.suncode.pwfl.administration.user.search.UserSorter;
import com.suncode.pwfl.administration.user.security.exception.EmailConfigurationException;
import com.suncode.pwfl.administration.user.security.exception.MissingEmailAddressException;
import com.suncode.pwfl.administration.user.security.service.SelfPasswordAssignService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.datasource.rest.SortDto;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.license.LicenseAccessor;
import com.suncode.pwfl.license.LicenseVerificator;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.LogicOperator;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.search.hibernate.GroupHibernateFilter;
import com.suncode.pwfl.search.hibernate.HibernateFilter;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.CollatorInstance;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.controller.api.administration.user.ChangePasswordCommand;
import com.suncode.pwfl.web.controller.api.administration.user.ChangeUserDto;
import com.suncode.pwfl.web.controller.api.administration.user.NewUserDto;
import com.suncode.pwfl.web.controller.api.administration.user.SubstituteFinder;
import com.suncode.pwfl.web.controller.api.administration.user.UserQueryParameters;
import com.suncode.pwfl.web.controller.api.administration.user.UserSearchFilters;
import com.suncode.pwfl.web.dto.administration.GroupDto;
import com.suncode.pwfl.web.dto.administration.structure.position.PositionDto;
import com.suncode.pwfl.web.dto.administration.user.BasicUserInfoDto;
import com.suncode.pwfl.web.dto.administration.user.UserDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.UserCriteriaHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.util.JsonMessage;
import com.suncode.pwfl.web.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"users"})
@Api(value="User Administration", tags={"users"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    private final UserFinder userFinder;
    private final UserService userService;
    private final DomainService domainService;
    private final AuthorizationHelper authorizationHelper;
    private final TransactionWrapper transactionWrapper;
    private final ExportService exportService;
    private final StructureService structureService;
    private final ScheduledTaskInfoService scheduledTaskInfoService;
    private final UserCriteriaHelper userCriteriaHelper;
    private final SubstituteFinder substituteFinder;
    private final MessageHelperBean messageHelper;
    private final SelfPasswordAssignService selfPasswordAssignService;

    @ApiOperation(value="Downloading the list of users", notes="The answer contains an object storing the total number of results in the total field, and a list of users in the data field.")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    @ResponseBody
    @GetMapping(value={"query"})
    public CountedResult<BasicUserInfoDto> getUsers(@ApiParam(value="A phrase on the basis of which the results will be filtered. Filtering applies to the login, first and last name of users", required=false) @RequestParam(required=false) String query, @ApiParam(value="First name filter", required=false) @RequestParam(required=false) String firstNameQuery, @ApiParam(value="Last name filter", required=false) @RequestParam(required=false) String lastNameQuery, @ApiParam(value="The offset in the result set", required=false) @RequestParam(required=false) Integer start, @ApiParam(value="The maximum number of returned results", required=false) @RequestParam(required=false) Integer limit, @ApiParam(value="Field to sort by", required=false) @RequestParam(required=false) String sortBy, @ApiParam(value="Include inactive users", required=false) @RequestParam(required=false) boolean inactive) {
        start = (Integer)ObjectUtils.defaultIfNull((Object)start, (Object)0);
        limit = (Integer)ObjectUtils.defaultIfNull((Object)limit, (Object)Integer.MAX_VALUE);
        DetachedCriteria criteria = this.userCriteriaHelper.createQueryCriteria(query, firstNameQuery, lastNameQuery);
        long total = this.userFinder.count(criteria, inactive);
        try {
            if (StringUtils.isNotBlank((String)sortBy)) {
                SortDto[] sorters = this.parseJson(sortBy);
                this.addOrders(sorters, criteria);
            }
        }
        catch (Exception ex) {
            log.error("Couldn't add order to user list - error while parsing json.");
        }
        criteria.setProjection(null);
        List users = this.userFinder.findByCriteria(criteria, start, limit, !inactive).stream().map(BasicUserInfoDto::fromEntity).collect(Collectors.toList());
        return new CountedResult(total, users);
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"filter"})
    public CountedResult<UserDto> getUsersFiltered(HttpServletRequest request, UserSearchFilters userSearchFilters, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false, defaultValue="username") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("username", (Object)StringUtils.defaultString((String)userSearchFilters.username())).param("firstName", (Object)StringUtils.defaultString((String)userSearchFilters.firstName())).param("lastName", (Object)StringUtils.defaultString((String)userSearchFilters.lastName())).param("groupName", (Object)StringUtils.defaultString((String)userSearchFilters.groupName())).param("position", (Object)StringUtils.defaultString((String)userSearchFilters.position())).param("positionSymbol", (Object)StringUtils.defaultString((String)userSearchFilters.positionSymbol())).param("email", (Object)StringUtils.defaultString((String)userSearchFilters.email())).param("number", (Object)StringUtils.defaultString((String)userSearchFilters.number())).param("active", (Object)(userSearchFilters.active() != null ? String.valueOf(userSearchFilters.active()) : ""));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SEARCH_USERS).params(auditParamsBuilder.build());
        auditBuilder.buildSuccess(request);
        return this.getFilteredUserCountedResult(userSearchFilters, start, limit, sortBy, sortDirection);
    }

    @ApiOperation(value="Getting information about the currently logged in user", notes="The response returns a UserInfo object with information about the logged in user")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    @ResponseBody
    @GetMapping(value={"current"})
    public ResponseEntity<UserInfo> getCurrentUser() {
        UserInfo userInfo = UserContext.current().getUser();
        return new ResponseEntity((Object)userInfo, (HttpStatusCode)HttpStatus.OK);
    }

    @ApiOperation(value="Downloading a list of possible user substitutions", notes="Downloads a list of possible user substitutions")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @GetMapping(value={"substitutions"})
    public CountedResult<BasicUserInfoDto> getUsersForDelegation(@ApiParam(value="User query parameters") UserQueryParameters userQueryParameters, @ApiParam(value="Username of the user to be substituted", required=true) @RequestParam String substitutedLogin, @ApiParam(value="The offset in the result set") @RequestParam(required=false, defaultValue="0") Integer start, @ApiParam(value="The maximum number of returned results") @RequestParam(required=false, defaultValue="20") Integer limit, @ApiParam(value="Sort by") @RequestParam(required=false, defaultValue="userName") String sortBy, @ApiParam(value="Sort direction") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        return this.substituteFinder.findSubstitutesForUser(userQueryParameters, UserContext.current().getUser().getUserName(), substitutedLogin, start, limit, sortBy, sortDirection);
    }

    @ApiOperation(value="Getting user information by login", notes="The response returns a UserInfo object with information about the user")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    @ResponseBody
    @GetMapping(value={"by/login"})
    public ResponseEntity<UserInfo> getUserByLogin(@ApiParam(value="Login of the requested user", required=true) @RequestParam String username) {
        boolean hasNoAdminRights;
        UserInfo userInfo = UserInfo.of((User)this.userService.getUser(username, new String[0]), (boolean)false);
        if (userInfo == null) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        boolean bl = hasNoAdminRights = Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)SessionUtils.getLoggedUserName(), (boolean)false, (boolean)false) != 0;
        if (hasNoAdminRights) {
            return new ResponseEntity((Object)new UserInfo(userInfo.getUserName(), userInfo.getFirstName(), userInfo.getLastName()), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)userInfo, (HttpStatusCode)HttpStatus.OK);
    }

    @ApiOperation(value="Downloading the list of users by roles", notes="JSON object list containing role search parameters")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=403, message="Not full rights")})
    @ResponseBody
    @PostMapping(value={"by/roles"})
    public List<User> getUsersByRoles(@ApiParam(value="List of role filters", required=true) @RequestBody List<RoleFilter> filters) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.userFinder.findByRoles(filters);
    }

    @ResponseBody
    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"by/group"})
    public CountedResult<BasicUserInfoDto> getUsers(@RequestParam Long groupId, @RequestParam(required=false, defaultValue="0") Integer start, @RequestParam(required=false, defaultValue="20") Integer limit, @RequestParam(required=false, defaultValue="userName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        UserGroup group = Optional.ofNullable(this.userService.getGroup(groupId, new String[0])).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Grupa_o_podanym_id_nie_istnieje", new Object[]{groupId})));
        CountedResult usersByGroup = this.userFinder.findByGroups(Collections.singletonList(group.getName()), new Sorter(sortBy, sortDirection), start.intValue(), limit.intValue());
        List userInfoDtos = usersByGroup.getData().stream().map(BasicUserInfoDto::fromEntity).collect(Collectors.toList());
        return new CountedResult(usersByGroup.getTotal(), userInfoDtos);
    }

    @ApiOperation(value="(Admin) Adding user to group", notes="Adds user with given id to the group")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"group/attach"})
    public void attachToGroup(HttpServletRequest request, @ApiParam(value="Id of the group", required=true) @RequestParam Long groupId, @ApiParam(value="Id of the user", required=true) @RequestParam Long userId) throws GroupNotFoundException {
        String groupName = Optional.ofNullable(this.userService.getGroup(groupId, new String[0])).map(UserGroup::getName).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Grupa_o_podanym_id_nie_istnieje", new Object[]{groupId})));
        String userName = Optional.ofNullable(this.userService.getUser(userId, new String[0])).map(User::getUserName).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Uzytkownik_o_podanym_id_nie_istnieje", new Object[]{userId})));
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_USER_TO_GROUP).params((Map)ImmutableMap.of((Object)"groupId", (Object)groupName, (Object)"userId", (Object)userName));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        try {
            this.userService.addUserToGroup(userName, groupName);
            UserInfoCache.get().clear(new String[]{userName});
            builder.buildSuccess(request);
        }
        catch (Throwable ex) {
            builder.buildFailure(request);
            throw ex;
        }
    }

    @ApiOperation(value="(Admin) Detaching user from the group", notes="Detaches user with given id from the group")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @PostMapping(value={"group/detach"})
    public JsonMessage detachFromGroup(HttpServletRequest request, @ApiParam(value="Id of the group", required=true) @RequestParam Long groupId, @ApiParam(value="Id of the user", required=true) @RequestParam Long userId) {
        String groupName = Optional.ofNullable(this.userService.getGroup(groupId, new String[0])).map(UserGroup::getName).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Grupa_o_podanym_id_nie_istnieje", new Object[]{groupId})));
        String userName = Optional.ofNullable(this.userService.getUser(userId, new String[0])).map(User::getUserName).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Uzytkownik_o_podanym_id_nie_istnieje", new Object[]{userId})));
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_USER_FROM_GROUP).params((Map)ImmutableMap.of((Object)"groupId", (Object)groupName, (Object)"userId", (Object)userName));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        try {
            JsonMessage result = (JsonMessage)this.transactionWrapper.doInHibernateTransaction(session -> {
                if (this.userService.getUser(userId, new String[0]).getGroups().size() <= 1) {
                    return new JsonMessage(false, this.messageHelper.getMessage("user.detachlastgroup"));
                }
                this.userService.removeUserFromGroup(userName, groupName);
                UserInfoCache.get().clear(new String[]{userName});
                return new JsonMessage();
            });
            request.setAttribute("audit", (Object)builder.buildSuccess());
            return result;
        }
        catch (Throwable ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            return new JsonMessage(false, ex.getMessage());
        }
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"export/fromGroup/{extension}"})
    public void exportFromGroup(HttpServletResponse response, @PathVariable String extension, @RequestParam Long groupId, @RequestParam(required=false, defaultValue="userName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        String groupName = Optional.ofNullable(this.userService.getGroup(groupId, new String[0])).map(UserGroup::getName).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Grupa_o_podanym_id_nie_istnieje", new Object[]{groupId})));
        List users = this.userFinder.findByGroups(Collections.singletonList(groupName), new Sorter(sortBy, sortDirection), 0, Integer.MAX_VALUE).getData();
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa")).data(users).by(User::getUserName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Imie")).data(users).by(User::getFirstName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwisko")).data(users).by(User::getLastName).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Uzytkownicy")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ApiOperation(value="(Admin) Adding new user", notes="Adds new user to the system")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @Transactional
    @PostMapping
    public RestResult create(HttpServletRequest request, @ApiParam(value="The executed query adds new user. The query is a JSON object with the following fields: \n          - **domainId** - id of the domain (null, if none)\n          - **username** - username of the user\n          - **firstName** - first name of the user\n          - **lastName** - last name of the user\n          - **email** - user's email\n          - **number** - user's number\n          - **password** - user's password\n          - **groupIds** - ids of the user groups \n          - **positionIds** - ids of the user positions\n          - **waitingForPasswordAssign** - should send activation link\n          - **language** - language\n          - **onlySsoLogin** - only log in with sso", required=true) @RequestBody NewUserDto newUserDto) {
        String password;
        List groupNames = newUserDto.groupIds().stream().map(id -> Optional.ofNullable(this.userService.getGroup(id, new String[0])).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Grupa_o_podanym_id_nie_istnieje", new Object[]{id})))).map(UserGroup::getName).collect(Collectors.toList());
        List<Position> positions = newUserDto.positionIds().stream().map(id -> Optional.ofNullable(this.structureService.getPosition(id, new String[]{"user"})).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Stanowisko_o_podanym_id_nie_istnieje", new Object[]{id})))).toList();
        List positionNames = positions.stream().map(Position::getName).collect(Collectors.toList());
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("userId", (Object)newUserDto.username()).param("userFirstName", (Object)newUserDto.firstName()).param("userLastName", (Object)newUserDto.lastName()).param("userEmail", (Object)newUserDto.email()).param("userNumber", (Object)newUserDto.number()).param("userGroupName", groupNames).param("userPositionsName", positionNames).param("selfPasswordAssign", (Object)newUserDto.waitingForPasswordAssign()).param("onlySsoLogin", (Object)newUserDto.onlySsoLogin()).param("anonymous", (Object)newUserDto.anonymous());
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_USER).params(auditParamsBuilder.build());
        request.setAttribute("audit", (Object)builder.buildFailure());
        for (Position position : positions) {
            if (position.getUser() == null) continue;
            throw new ServiceException(this.messageHelper.getMessage("Stanowisko_o_podanym_id_jest_zajete", new Object[]{position.getId()}));
        }
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        if (!LicenseVerificator.isNextUserAllowed()) {
            return new RestResult(false, this.messageHelper.getMessage("Licencja_systemu_nie_pozwala_na_liczbe_uzytkownikow_powyzej") + " " + LicenseAccessor.getInstance().getMaxUsers() + ".");
        }
        Object username = newUserDto.username().trim().toLowerCase();
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)username), (String)this.messageHelper.getMessage("Nazwa_uzytkownika_nie_moze_byc_pusta"));
        if (!UserValidator.isUserNameValid((String)username)) {
            return new RestResult(false, this.messageHelper.getMessage("Nazwa_uzytkownika_zawiera_nieodpowiednie_znaki").replace("\"/\" , ", ""));
        }
        boolean isDomainUser = newUserDto.domainId() != null;
        String string = password = newUserDto.waitingForPasswordAssign() || isDomainUser ? "" : newUserDto.password();
        if (isDomainUser) {
            Domain domain = this.domainService.getDomain(newUserDto.domainId());
            username = domain.getDomainName() + "/" + (String)username;
        }
        User newUserDomain = new User((String)username, password);
        newUserDomain.setFirstName(newUserDto.firstName().trim());
        newUserDomain.setLastName(newUserDto.lastName().trim());
        newUserDomain.setEmail(newUserDto.email().trim());
        newUserDomain.setNumber(newUserDto.number().trim());
        newUserDomain.setWaitingForPasswordAssign(newUserDto.waitingForPasswordAssign());
        newUserDomain.setLanguage(newUserDto.language());
        newUserDomain.setOnlySsoLogin(newUserDto.onlySsoLogin());
        newUserDomain.setAnonymous(newUserDto.anonymous());
        try {
            this.userService.createUser(newUserDomain, newUserDto.groupIds(), newUserDto.positionIds());
            request.setAttribute("audit", (Object)builder.buildSuccess());
            return new RestResult(true, this.messageHelper.getMessage("Uzytkownik") + " " + newUserDto.username() + " " + this.messageHelper.getMessage("zostal_dodany") + ".");
        }
        catch (UserAlreadyExistException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return new RestResult(false, ex.getMessageTranslated());
        }
        catch (InvalidUserException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return new RestResult(false, ex.getMessageTranslated());
        }
        catch (EmailConfigurationException ex) {
            return new RestResult(false, this.messageHelper.getMessage("Niepoprawna_konfiguracja_wysylania_powiadomien"));
        }
        catch (MissingEmailAddressException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return new RestResult(false, this.messageHelper.getMessage("Uzytkownik_nie_ma_nadanego_adresu_email"));
        }
        catch (IllegalArgumentException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            EmptyUserNameException emptyException = new EmptyUserNameException("Nazwa u\u017cytkownika nie mo\u017ce by\u0107 pusta.");
            return new RestResult(false, emptyException.getMessageTranslated());
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return new RestResult(false, this.messageHelper.getMessage("Wystapil_nieoczekiwany_blad"));
        }
    }

    @ApiOperation(value="(Admin) Editing user", notes="Edits user data")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @PostMapping(value={"{userId}"})
    public Object change(HttpServletRequest request, @ApiParam(value="id of the user", required=true) @PathVariable Long userId, @ApiParam(value="The executed query changes the user with given id. The query is a JSON object with the following fields:\n          - **domainId** - id of the domain (null, if none)\n          - **username** - username of the user\n          - **firstName** - first name of the user\n          - **lastName** - last name of the user\n          - **email** - user's email\n          - **number** - user's number\n          - **password** - user's password (if deletePassword -> false)\n          - **deletePassword** - deletes password for user\n          - **onlySsoLogin** - only log in with sso", required=true) @RequestBody ChangeUserDto changeUserDto) {
        String fullUsername;
        User userEntity = Optional.ofNullable(this.userService.getUser(userId, new String[0])).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Uzytkownik_o_podanym_id_nie_istnieje", new Object[]{userId})));
        String oldUserFirstName = Optional.ofNullable(userEntity.getFirstName()).orElse("");
        String oldUserLastName = Optional.ofNullable(userEntity.getLastName()).orElse("");
        String oldUserEmail = Optional.ofNullable(userEntity.getEmail()).orElse("");
        String oldUserNumber = Optional.ofNullable(userEntity.getNumber()).orElse("");
        boolean oldOnlySsoLogin = userEntity.isOnlySsoLogin();
        boolean oldAnonymous = userEntity.isAnonymous();
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_USER).params((Map)new ImmutableMap.Builder().put((Object)"userId", (Object)userEntity.getUserName()).put((Object)"userNewName", (Object)changeUserDto.username()).put((Object)"userFirstName", (Object)(oldUserFirstName + " > " + changeUserDto.firstName())).put((Object)"userLastName", (Object)(oldUserLastName + " > " + changeUserDto.lastName())).put((Object)"userEmail", (Object)(oldUserEmail + " > " + changeUserDto.email())).put((Object)"userNumber", (Object)(oldUserNumber + " > " + changeUserDto.number())).put((Object)"onlySsoLogin", (Object)(oldOnlySsoLogin + " > " + changeUserDto.onlySsoLogin())).put((Object)"anonymous", (Object)(oldAnonymous + " > " + changeUserDto.anonymous())).build());
        request.setAttribute("audit", (Object)builder.buildFailure());
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        String username = fullUsername = userEntity.getUserName();
        if (fullUsername.contains("/")) {
            username = fullUsername.split("/")[1];
        }
        String currentLoggedUsername = UserContext.current().getUser().getUserName();
        boolean isDomainUser = changeUserDto.domainId() != null;
        String newUsername = changeUserDto.username().trim().toLowerCase();
        if (StringUtils.isEmpty((String)newUsername)) {
            newUsername = username;
        }
        Object newFullUsername = newUsername;
        if (isDomainUser) {
            String domainName = this.domainService.getDomain(changeUserDto.domainId()).getDomainName();
            newFullUsername = domainName + "/" + newUsername;
        }
        String newEmail = changeUserDto.email().trim();
        String newFirstName = changeUserDto.firstName().trim();
        String newLastName = changeUserDto.lastName().trim();
        String newNumber = changeUserDto.number().trim();
        String newPassword = changeUserDto.password();
        boolean newOnlySsoLogin = changeUserDto.onlySsoLogin();
        boolean newAnonymous = changeUserDto.anonymous();
        Assert.isTrue((boolean)UserValidator.isEmailValid((String)newEmail), (String)"Email is not valid");
        Assert.isTrue((boolean)UserValidator.isUserFirstNameValid((String)newFirstName), (String)"First name is not valid");
        Assert.isTrue((boolean)UserValidator.isUserLastNameValid((String)newLastName), (String)"Last name is not valid");
        if (!fullUsername.equals(newFullUsername)) {
            Assert.isTrue((boolean)UserValidator.isUserNameValid((String)newUsername), (String)"User name is not valid");
            if (UserValidator.doesUserExists((User)this.userService.getUser((String)newFullUsername, new String[0]))) {
                return new RestResult(false, this.messageHelper.getMessage("Uzytkownik_juz_istnieje", new Object[]{newFullUsername}) + ".");
            }
            this.createChangeUsernameScheduledTask(currentLoggedUsername, fullUsername, (String)newFullUsername);
        }
        if (isDomainUser || changeUserDto.deletePassword()) {
            newPassword = "";
        }
        boolean needsPageReload = false;
        boolean isPasswordChanged = false;
        if (StringUtils.isNotBlank((String)newPassword) || changeUserDto.deletePassword()) {
            log.info("Changing password for user {}", (Object)fullUsername);
            try {
                this.userService.changeUserPassword(fullUsername, newPassword);
                isPasswordChanged = true;
            }
            catch (IllegalArgumentException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                return new RestResult(false, ex.getMessage());
            }
            if (currentLoggedUsername.equals(fullUsername)) {
                needsPageReload = true;
            }
        }
        User changedUser = this.userService.getUser(userId, new String[0]);
        changedUser.setNumber(newNumber);
        changedUser.setFirstName(newFirstName);
        changedUser.setLastName(newLastName);
        changedUser.setEmail(newEmail);
        changedUser.setOnlySsoLogin(newOnlySsoLogin);
        changedUser.setAnonymous(newAnonymous);
        if (isPasswordChanged && changedUser.isWaitingForPasswordAssign()) {
            changedUser.setWaitingForPasswordAssign(false);
        }
        log.info("Updating user {}", (Object)changedUser.getUserName());
        this.userService.updateUser(changedUser);
        log.info("User {} updated", (Object)changedUser.getUserName());
        request.setAttribute("audit", (Object)builder.buildSuccess());
        return ImmutableMap.builder().put((Object)"success", (Object)true).put((Object)"needsPageReload", (Object)needsPageReload).put((Object)"message", (Object)this.messageHelper.getMessage("Dane_uzytkownika_zostaly_zmienione")).build();
    }

    @ApiOperation(value="(Admin) Editing user's password", notes="Edits user's password")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @PatchMapping(value={"{userId}/username"})
    public RestResult changeUsername(@ApiParam(value="Id of the user", required=true) @PathVariable Long userId, @ApiParam(value="The executed query changes the user's username. The query is a JSON object with the following fields:\n          - **username** - changed username\n          - **confirmedUsername** - confirmed username\n", required=true) @RequestBody ChangePasswordCommand changePasswordCommand) {
        String fullUsername;
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        User userEntity = Optional.ofNullable(this.userService.getUser(userId, new String[0])).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Uzytkownik_o_podanym_id_nie_istnieje", new Object[]{userId})));
        String username = fullUsername = userEntity.getUserName();
        String domainName = null;
        if (fullUsername.contains("/")) {
            username = fullUsername.split("/")[1];
            domainName = fullUsername.split("/")[0];
        }
        String currentLoggedUsername = UserContext.current().getUser().getUserName();
        boolean isDomainUser = domainName != null;
        String newUsername = changePasswordCommand.username();
        if (StringUtils.isEmpty((String)newUsername)) {
            newUsername = username;
        }
        Object newFullUsername = newUsername;
        if (isDomainUser) {
            newFullUsername = domainName + "/" + newUsername;
        }
        if (!fullUsername.equals(newFullUsername)) {
            Assert.isTrue((boolean)UserValidator.isUserNameValid((String)newUsername), (String)"User name is not valid");
            if (UserValidator.doesUserExists((User)this.userService.getUser((String)newFullUsername, new String[0]))) {
                return new RestResult(false, this.messageHelper.getMessage("Uzytkownik_juz_istnieje", new Object[]{newFullUsername}));
            }
            this.createChangeUsernameScheduledTask(currentLoggedUsername, fullUsername, (String)newFullUsername);
            log.info("Change username scheduled task created for username: {}", newFullUsername);
        }
        return new RestResult(true, this.messageHelper.getMessage("Nazwa_uzytkownika_zostanie_zmieniona_w_godzinach_nocnych"));
    }

    public void createChangeUsernameScheduledTask(String loggedUsername, String fullName, String newFullName) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        this.scheduledTaskInfoService.beginTaskCreation().fromMethod(UsersManagement.class, "ChangeUserLogin", new Class[]{String.class, String.class, String.class}).withFirstRun(calendar.getTime()).withPeriodDays(360L).withName(this.messageHelper.getMessage("Zmiana_loginu_uzytkownika")).withDescription(this.messageHelper.getMessage("Zaplanowana_zmiana_nazwy_uzytkownika")).withActive(true).withRunOnce(true).withCategory("System").withParameter(0).withValue(fullName).withParameter(1).withValue(newFullName).withParameter(2).withValue(loggedUsername).createTask();
    }

    @ApiOperation(value="(Admin) Deleting user", notes="Deletes user with given id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseStatus(value=HttpStatus.OK)
    @DeleteMapping(value={"{userId}"})
    public void delete(HttpServletRequest request, @ApiParam(value="Id of the user to delete", required=true) @PathVariable Long userId) {
        String userName = Optional.ofNullable(this.userService.getUser(userId, new String[0])).map(User::getUserName).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Uzytkownik_o_podanym_id_nie_istnieje", new Object[]{userId})));
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_USER).params((Map)ImmutableMap.of((Object)"userId", (Object)userName));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        try {
            this.userService.deleteUser(userName);
            request.setAttribute("audit", (Object)builder.buildSuccess());
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            throw ex;
        }
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"filter/export/{extension}"})
    public void exportByFilters(HttpServletResponse response, @PathVariable String extension, UserSearchFilters userSearchFilters, @RequestParam(required=false, defaultValue="username") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        CountedResult<UserDto> users = this.getFilteredUserCountedResult(userSearchFilters, 0, Integer.MAX_VALUE, sortBy, sortDirection);
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa")).data(users.getData()).by(UserDto::getUserName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Imie")).data(users.getData()).by(UserDto::getFirstName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwisko")).data(users.getData()).by(UserDto::getLastName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Numer")).data(users.getData()).by(UserDto::getNumber).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Email")).data(users.getData()).by(UserDto::getEmail).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Grupy")).data(users.getData()).by(item -> item.getGroups().stream().map(GroupDto::getName).collect(Collectors.joining(", "))).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Stanowiska")).data(users.getData()).by(item -> item.getPositions().stream().map(positionDto -> positionDto.getSymbol() + " - " + positionDto.getName()).collect(Collectors.joining(", "))).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Uzytkownicy")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private CountedResult<UserDto> getFilteredUserCountedResult(UserSearchFilters userSearchFilters, Integer start, Integer limit, String sortBy, SortDirection sortDirection) {
        ArrayList<HibernateFilter> filters = new ArrayList<HibernateFilter>();
        UserController.addFilter(filters, UserPropertyFilter.USERNAME, userSearchFilters.username());
        UserController.addFilter(filters, UserPropertyFilter.FIRSTNAME, userSearchFilters.firstName());
        UserController.addFilter(filters, UserPropertyFilter.LASTNAME, userSearchFilters.lastName());
        UserController.addFilter(filters, UserPropertyFilter.GROUP_NAME, userSearchFilters.groupName());
        UserController.addFilter(filters, UserPropertyFilter.POSITION_NAME, userSearchFilters.position());
        UserController.addFilter(filters, UserPropertyFilter.POSITION_SYMBOL, userSearchFilters.positionSymbol());
        UserController.addFilter(filters, UserPropertyFilter.EMAIL, userSearchFilters.email());
        UserController.addFilter(filters, UserPropertyFilter.NUMBER, userSearchFilters.number());
        UserController.addFilter(filters, UserPropertyFilter.ACTIVE, userSearchFilters.active());
        UserSorter sorter = new UserSorter(UserSortProperty.valueOf((String)sortBy.toUpperCase()), sortDirection);
        return (CountedResult)this.transactionWrapper.doInHibernateTransaction(session -> {
            CountedResult result = this.userFinder.findByFilters(filters, sorter, start.intValue(), limit.intValue());
            List userDtos = result.getData().stream().map(user -> UserDto.builder().objectId(user.getObjectId()).userName(user.getUserName()).email(user.getEmail()).firstName(user.getFirstName()).lastName(user.getLastName()).number(user.getNumber()).active(user.isActive()).onlySsoLogin(user.isOnlySsoLogin()).anonymous(user.isAnonymous()).waitingForPasswordAssign(user.isWaitingForPasswordAssign()).groups(user.getGroups().stream().map(GroupDto::fromDomain).sorted(Comparator.comparing(GroupDto::getName, CollatorInstance.get())).collect(Collectors.toList())).positions(user.getPositions().stream().map(PositionDto::fromDomain).sorted(Comparator.comparing(PositionDto::getName, CollatorInstance.get())).collect(Collectors.toList())).build()).collect(Collectors.toList());
            return new CountedResult(result.getTotal(), userDtos);
        });
    }

    private SortDto[] parseJson(String sortBy) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        return (SortDto[])objectMapper.readValue(sortBy, SortDto[].class);
    }

    private void addOrders(SortDto[] sorters, DetachedCriteria dc) {
        for (SortDto sorter : sorters) {
            if (StringUtils.isBlank((String)sorter.getProperty())) {
                return;
            }
            if (sorter.getDirection().equalsIgnoreCase("DESC")) {
                dc.addOrder(Order.desc((String)sorter.getProperty()));
                return;
            }
            dc.addOrder(Order.asc((String)sorter.getProperty()));
        }
    }

    private static void addFilter(List<HibernateFilter> filters, UserPropertyFilter property, Object value) {
        if (!(value instanceof String) && value != null) {
            filters.add((HibernateFilter)new SimpleHibernateUserFilter(property, value, FilterOperator.EQ));
            return;
        }
        String sValue = (String)value;
        if (StringUtils.isBlank((String)sValue)) {
            return;
        }
        if (DBUtils.isExactQuery((String)sValue)) {
            filters.add((HibernateFilter)new SimpleHibernateUserFilter(property, (Object)DBUtils.getExactQueryValue((String)sValue), FilterOperator.EQ));
            return;
        }
        if (DBUtils.isConjunctionSearch((String)sValue)) {
            GroupHibernateFilter conjunctionFilter = new GroupHibernateFilter(LogicOperator.AND);
            List searchValues = DBUtils.searchCriteriaForConjunctionLike((List)DBUtils.conjunctionValuesForLike((String)sValue));
            List searchFilters = searchValues.stream().map(filterValue -> new SimpleHibernateUserFilter(property, filterValue, FilterOperator.ILIKE)).collect(Collectors.toList());
            conjunctionFilter.setFilters(searchFilters);
            filters.add((HibernateFilter)conjunctionFilter);
            return;
        }
        filters.add((HibernateFilter)new SimpleHibernateUserFilter(property, (Object)DBUtils.searchCriteriaForLike((String)sValue), FilterOperator.ILIKE));
    }

    @ApiOperation(value="(Admin) Sending activation link", notes="Sends activation link to user")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Not full rights"), @ApiResponse(code=400, message="Bad request - user does not exist or already has a password assigned")})
    @ResponseBody
    @PostMapping(value={"/sendActivationLink/{userId}"})
    public void sendActivationLink(@ApiParam(value="Id of the user", required=true) @PathVariable Long userId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        User user = Optional.ofNullable(this.userService.getUser(userId, new String[0])).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Uzytkownik_o_podanym_id_nie_istnieje", new Object[]{userId})));
        if (!user.isWaitingForPasswordAssign()) {
            throw new ServiceException(this.messageHelper.getMessage("Haslo_zostalo_juz_przypisane"));
        }
        this.selfPasswordAssignService.sendEmailWithActivationLink(user);
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"userFinder", "userService", "domainService", "authorizationHelper", "transactionWrapper", "exportService", "structureService", "scheduledTaskInfoService", "userCriteriaHelper", "substituteFinder", "messageHelper", "selfPasswordAssignService"})
    @Autowired
    public UserController(UserFinder userFinder, UserService userService, DomainService domainService, AuthorizationHelper authorizationHelper, TransactionWrapper transactionWrapper, ExportService exportService, StructureService structureService, ScheduledTaskInfoService scheduledTaskInfoService, UserCriteriaHelper userCriteriaHelper, SubstituteFinder substituteFinder, MessageHelperBean messageHelper, SelfPasswordAssignService selfPasswordAssignService) {
        this.userFinder = userFinder;
        this.userService = userService;
        this.domainService = domainService;
        this.authorizationHelper = authorizationHelper;
        this.transactionWrapper = transactionWrapper;
        this.exportService = exportService;
        this.structureService = structureService;
        this.scheduledTaskInfoService = scheduledTaskInfoService;
        this.userCriteriaHelper = userCriteriaHelper;
        this.substituteFinder = substituteFinder;
        this.messageHelper = messageHelper;
        this.selfPasswordAssignService = selfPasswordAssignService;
    }
}

