/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.position;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.structure.exception.PositionAlreadyExistException;
import com.suncode.pwfl.administration.structure.exception.PositionNotFoundException;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.CollatorInstance;
import com.suncode.pwfl.util.exception.EmptyPropertyException;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.administration.RoleDto;
import com.suncode.pwfl.web.dto.administration.structure.position.AddPositionDto;
import com.suncode.pwfl.web.dto.administration.structure.position.PositionDto;
import com.suncode.pwfl.web.dto.administration.structure.position.StructurePositionDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"positions"})
@Api(tags={"positions"})
public class PositionController {
    private static final Logger log = LoggerFactory.getLogger(PositionController.class);
    private final PositionFinder positionFinder;
    private final StructureService structureService;
    private final UserService userService;
    private final AuthorizationHelper authorizationHelper;
    private final ExportService exportService;
    private final RoleService roleService;
    private final MessageHelperBean messageHelper;

    @ApiOperation(value="(Admin) Downloading a list of positions", notes="Retrieves a list of system positions")
    @GetMapping
    @ResponseBody
    public CountedResult<StructurePositionDto> getPositions(HttpServletRequest request, @ApiParam(value="Name of the position") PositionSearchFilters positionSearchFilters, @ApiParam(value="Result number from which results are to be returned", defaultValue="0") @RequestParam(required=false) Integer start, @ApiParam(value="Number of returned results", defaultValue="20") @RequestParam(required=false) Integer limit, @ApiParam(value="Sort by", defaultValue="name") @RequestParam(required=false, defaultValue="name") String sortBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SEARCH_POSITION).params(this.createSearchAudit(positionSearchFilters));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        CountedResult positions = this.structureService.getPositions(positionSearchFilters.name(), positionSearchFilters.symbol(), positionSearchFilters.overName(), positionSearchFilters.overSymbol(), positionSearchFilters.orgName(), positionSearchFilters.orgSymbol(), positionSearchFilters.role(), positionSearchFilters.userName(), Pagination.create((Sorter)new Sorter(sortBy, sortDirection), (Integer)start, (Integer)limit));
        List positionDtos = positions.getData().stream().map(StructurePositionDto::from).collect(Collectors.toList());
        auditBuilder.buildSuccess(request);
        return new CountedResult(positions.getTotal(), positionDtos);
    }

    @ApiOperation(value="(Admin) Adding new position", notes="Adds new position to the system")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public RestResult addPosition(HttpServletRequest request, @ApiParam(value="The executed query saves new position. The query is a JSON object with the following fields\n- **positionName** - name of the position\n- **positionSymbol** - symbol of the position\n- **higherPositionId** - id of the higher position\n- **organizationalUnitId** - id of the organizational unit\n- **rolesId** - ids of the roles", required=true) @RequestBody AddPositionDto position) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().params(this.initAddPositionAuditParams(position));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_POSITION).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            Long positionId;
            Position newPosition = new Position(position.getPositionName(), position.getPositionSymbol());
            this.addDirectorAndOrganizationalUnit(position, newPosition);
            this.structureService.validatePosition(newPosition);
            if (position.getRolesId() != null && !position.getRolesId().isEmpty()) {
                positionId = this.structureService.createPosition(newPosition, position.getRolesId());
                auditParamsBuilder.param("positionRoles", (Object)position.getRolesId().stream().map(String::valueOf).collect(Collectors.joining(";")));
                auditParamsBuilder.param("positionRolesName", (Object)position.getRolesId().stream().map(arg_0 -> ((RoleService)this.roleService).getRole(arg_0)).map(Role::getRoleName).collect(Collectors.joining(", ")));
            } else {
                positionId = this.structureService.createPosition(newPosition);
            }
            auditParamsBuilder.param("positionId", (Object)positionId);
            auditBuilder.params(auditParamsBuilder.build());
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException((Throwable)e);
        }
    }

    @ApiOperation(value="(Admin) Editing position", notes="Edits position with given id")
    @PatchMapping(value={"/{id}"})
    @ResponseBody
    public RestResult changePosition(HttpServletRequest request, @ApiParam(value="Id of the position", required=true) @PathVariable Long id, @ApiParam(value="The executed query edits position. The query is a JSON object with the following fields\n- **positionName** - name of the position\n- **positionSymbol** - symbol of the position\n- **higherPositionId** - id of the higher position\n- **organizationalUnitId** - id of the organizational unit", required=true) @RequestBody AddPositionDto positionDto) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("positionId", (Object)StringUtils.defaultString((String)String.valueOf(id)));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_POSITION).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        Position position = this.structureService.getPosition(id, new String[]{"organizationalUnit", "higherPosition"});
        if (Objects.isNull(position)) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(this.messageHelper.getMessage("Stanowisko_o_podanym_id_nie_istnieje", new Object[]{id}));
        }
        auditParamsBuilder.params(this.updatePositionAuditParams(positionDto, position));
        try {
            position.setName(positionDto.getPositionName());
            position.setSymbol(positionDto.getPositionSymbol());
            this.addDirectorAndOrganizationalUnit(positionDto, position);
            this.structureService.validatePosition(position);
            this.structureService.changePosition(position);
            auditBuilder.params(auditParamsBuilder.build());
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException((Throwable)e);
        }
    }

    private Map<String, Object> updatePositionAuditParams(AddPositionDto positionDto, Position oldPosition) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Optional<OrganizationalUnit> organizationalUnit = Optional.ofNullable(positionDto.getOrganizationalUnitId()).map(x$0 -> this.structureService.getOrganizationalUnit(x$0, new String[0]));
        Optional<Position> higherPosition = Optional.ofNullable(positionDto.getHigherPositionId()).map(x$0 -> this.structureService.getPosition(x$0, new String[0]));
        String oldOrgUnitName = Optional.ofNullable(oldPosition.getOrganizationalUnit()).map(this::formatOrganizationalUnitNameAndSymbol).orElse("");
        String oldHigherPositionName = Optional.ofNullable(oldPosition.getHigherPosition()).map(this::formatPositionNameAndSymbol).orElse("");
        String higherPositionName = higherPosition.map(this::formatPositionNameAndSymbol).orElse("");
        String orgUnitName = organizationalUnit.map(this::formatOrganizationalUnitNameAndSymbol).orElse("");
        params.put("positionName", oldPosition.getName() + ";" + positionDto.getPositionName());
        params.put("positionSymbol", oldPosition.getSymbol() + " > " + positionDto.getPositionSymbol());
        params.put("positionHigherPosition", oldHigherPositionName + ";" + higherPositionName);
        params.put("positionOrganizationalUnit", oldOrgUnitName + ";" + orgUnitName);
        return params;
    }

    private void addDirectorAndOrganizationalUnit(AddPositionDto positionDto, Position position) {
        if (positionDto.getHigherPositionId() != null) {
            position.setHigherPosition(Optional.ofNullable(positionDto.getHigherPositionId()).map(x$0 -> this.structureService.getPosition(x$0, new String[0])).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Stanowisko_o_podanym_id_nie_istnieje", new Object[]{positionDto.getHigherPositionId()}))));
        } else {
            position.setHigherPosition(null);
        }
        if (positionDto.getOrganizationalUnitId() != null) {
            position.setOrganizationalUnit(Optional.ofNullable(positionDto.getOrganizationalUnitId()).map(x$0 -> this.structureService.getOrganizationalUnit(x$0, new String[0])).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Jednostka_organizacyjna_nie_istnieje", new Object[]{positionDto.getOrganizationalUnitId()}))));
        } else {
            position.setOrganizationalUnit(null);
        }
    }

    @ApiOperation(value="(Admin) Deleting position", notes="Deletes position with given id")
    @DeleteMapping(value={"/{id}"})
    @ResponseBody
    public RestResult deletePosition(HttpServletRequest request, @ApiParam(value="Id of the position", required=true) @PathVariable Long id) throws PositionNotFoundException {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("positionId", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_POSITION).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        Position positionToDelete = this.structureService.getPosition(id, new String[0]);
        if (Objects.isNull(positionToDelete)) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new PositionNotFoundException(this.messageHelper.getMessage("Stanowisko_o_podanym_id_nie_istnieje", new Object[]{id}));
        }
        auditParamsBuilder.param("positionName", (Object)this.structureService.getPositionTranslation(positionToDelete.getId(), TranslatedFieldType.NAME));
        auditParamsBuilder.param("positionSymbol", (Object)positionToDelete.getSymbol());
        auditBuilder.params(auditParamsBuilder.build());
        try {
            this.structureService.deletePosition(id);
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @ApiOperation(value="(Admin) Exporting a list of positions", notes="Exports a list of system positions")
    @GetMapping(value={"export/{extension}"})
    public void export(HttpServletResponse response, @ApiParam(value="Extension", required=true) @PathVariable String extension, @ApiParam(value="Name of the position") @RequestParam(required=false) String name, @ApiParam(value="Symbol of the position") @RequestParam(required=false) String symbol, @ApiParam(value="Name of the overriding position") @RequestParam(required=false) String overName, @ApiParam(value="Symbol of the overriding position") @RequestParam(required=false) String overSymbol, @ApiParam(value="Name of the organizational unit") @RequestParam(required=false) String orgName, @ApiParam(value="Symbol of the organizational unit") @RequestParam(required=false) String orgSymbol, @ApiParam(value="Id of the role") @RequestParam(required=false) Long role, @ApiParam(value="Login of the user") @RequestParam(required=false) String userName, @ApiParam(value="Sort by", defaultValue="name") @RequestParam(required=false, defaultValue="name") String sortBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<StructurePositionDto> positionDtos = this.structureService.getPositions(name, symbol, overName, overSymbol, orgName, orgSymbol, role, userName, Pagination.create((Sorter)new Sorter(sortBy, sortDirection), null, null)).getData().stream().map(StructurePositionDto::from).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn(this.messageHelper.getMessage("Nazwa"), positionDtos, StructurePositionDto::getPositionName), this.buildExportColumn(this.messageHelper.getMessage("Symbol"), positionDtos, StructurePositionDto::getPositionSymbol), this.buildExportColumn(this.messageHelper.getMessage("Stanowisko_nadrzedne"), positionDtos, structurePositionDto -> !Objects.isNull(structurePositionDto.getHigherPosition()) ? structurePositionDto.getHigherPosition().getSymbol() + " - " + structurePositionDto.getHigherPosition().getName() : ""), this.buildExportColumn(this.messageHelper.getMessage("Jednostka_organizacyjna"), positionDtos, structurePositionDto -> !Objects.isNull(structurePositionDto.getOrganizationalUnit()) ? structurePositionDto.getOrganizationalUnit().getSymbol() + " - " + structurePositionDto.getOrganizationalUnit().getName() : ""), this.buildExportColumn(this.messageHelper.getMessage("Role"), positionDtos, structurePositionDto -> structurePositionDto.getRoles().size() != 0 ? structurePositionDto.getRoles().stream().map(RoleDto::getRoleId).collect(Collectors.joining(",")) : ""), this.buildExportColumn(this.messageHelper.getMessage("Uzytkownik"), positionDtos, structurePositionDto -> !Objects.isNull(structurePositionDto.getUser()) ? structurePositionDto.getUser().getUserName() : ""));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Positions")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"available"})
    @ResponseBody
    public CountedResult<PositionDto> getAllIlike(@RequestParam(required=false, defaultValue="") String nameQuery, @RequestParam(required=false, defaultValue="") String symbolQuery, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        CountedResult foundPositions = this.structureService.getAvailablePositions(nameQuery, symbolQuery, Pagination.create((Sorter)new Sorter(sortBy, sortDirection), (Integer)start, (Integer)limit));
        List positions = foundPositions.getData().stream().map(position -> PositionDto.builder().id(position.getId()).name(this.structureService.getPositionTranslation(position.getId(), TranslatedFieldType.NAME)).symbol(position.getSymbol()).build()).collect(Collectors.toList());
        return new CountedResult(foundPositions.getTotal(), positions);
    }

    @ApiOperation(value="(Admin) Assigning position", notes="Assigns position to the user")
    @PostMapping(value={"assign"})
    @ResponseStatus(value=HttpStatus.OK)
    public void assignUserToPosition(HttpServletRequest request, @ApiParam(value="Id of the user") @RequestParam Long userId, @ApiParam(value="Id of the position") @RequestParam Long positionId) {
        User user = Optional.ofNullable(this.userService.getUser(userId, new String[]{"groups"})).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Uzytkownik_o_podanym_id_nie_istnieje", new Object[]{userId})));
        Position position = Optional.ofNullable(this.structureService.getPosition(positionId, new String[]{"user"})).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Stanowisko_o_podanym_id_nie_istnieje", new Object[]{positionId})));
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ASSIGN_POSITION_TO_USER).params((Map)ImmutableMap.of((Object)"userId", (Object)user.getUserName(), (Object)"positionName", (Object)position.getName()));
        this.authorizationHelper.assertFullAdministrationRights(() -> builder.buildFailure(request));
        User positionUser = position.getUser();
        if (positionUser != null) {
            if (positionUser.getUserName().equals(user.getUserName())) {
                builder.buildFailure(request);
                throw new ServiceException(this.messageHelper.getMessage("Stanowisko_jest_zajete_przez_tego_uzytkownika"));
            }
            builder.buildFailure(request);
            throw new ServiceException(this.messageHelper.getMessage("Stanowisko_jest_zajete"));
        }
        try {
            this.structureService.addPositionToUser(user.getUserName(), positionId);
            builder.buildSuccess(request);
        }
        catch (Exception ex) {
            builder.buildFailure(request);
            throw ex;
        }
    }

    @ApiOperation(value="(Admin) Detaching position", notes="Detaches position from the user")
    @PostMapping(value={"detach"})
    @ResponseStatus(value=HttpStatus.OK)
    public void detachUserFromPosition(HttpServletRequest request, @ApiParam(value="Id of the position") @RequestParam Long positionId) {
        Position position = Optional.ofNullable(this.structureService.getPosition(positionId, new String[]{"user"})).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Stanowisko_o_podanym_id_nie_istnieje", new Object[]{positionId})));
        User user = Optional.ofNullable(position.getUser()).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Nie_znaleziono_uzytkownika_dla_stanowiska", new Object[]{positionId})));
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DETACH_POSITION).params((Map)ImmutableMap.of((Object)"positionName", (Object)position.getName(), (Object)"userId", (Object)user.getUserName()));
        this.authorizationHelper.assertFullAdministrationRights(() -> builder.buildFailure(request));
        try {
            this.structureService.detachPositionFromUser(positionId);
            builder.buildSuccess(request);
        }
        catch (Exception ex) {
            builder.buildFailure(request);
            throw ex;
        }
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"user"})
    @ResponseBody
    public List<PositionDto> getPositionsFromUser(@RequestParam Long userId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.userService.getUser(userId, new String[]{"positions"}).getPositions().stream().map(PositionDto::fromDomain).sorted(Comparator.comparing(PositionDto::getName, CollatorInstance.get())).collect(Collectors.toList());
    }

    private Map<String, Object> createSearchAudit(PositionSearchFilters filters) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        Object higherPosition = StringUtils.defaultString((String)filters.overName());
        higherPosition = ((String)higherPosition).isEmpty() ? (String)higherPosition + StringUtils.defaultString((String)filters.overSymbol()) : (String)higherPosition + " - " + StringUtils.defaultString((String)filters.overSymbol());
        Object organizationalUnit = StringUtils.defaultString((String)filters.orgName());
        organizationalUnit = ((String)organizationalUnit).isEmpty() ? StringUtils.defaultString((String)filters.orgSymbol()) : (String)organizationalUnit + " - " + StringUtils.defaultString((String)filters.orgSymbol());
        auditParams.put("positionName", StringUtils.defaultString((String)filters.name()));
        auditParams.put("positionSymbol", StringUtils.defaultString((String)filters.symbol()));
        auditParams.put("positionHigherPosition", higherPosition);
        auditParams.put("positionOrganizationalUnit", organizationalUnit);
        return auditParams;
    }

    private ExportColumn buildExportColumn(String name, List<StructurePositionDto> data, Function<StructurePositionDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    private Map<String, Object> initAddPositionAuditParams(AddPositionDto position) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Optional<Position> higherPosition = Optional.ofNullable(position.getHigherPositionId()).map(x$0 -> this.structureService.getPosition(x$0, new String[0]));
        params.put("positionHigherPosition", higherPosition.map(Position::getId).map(String::valueOf).orElse(""));
        params.put("positionHigherPositionName", higherPosition.map(this::formatPositionNameAndSymbol).orElse(""));
        Optional<OrganizationalUnit> organizationalUnit = Optional.ofNullable(position.getOrganizationalUnitId()).map(x$0 -> this.structureService.getOrganizationalUnit(x$0, new String[0]));
        params.put("positionOrganizationalUnit", organizationalUnit.map(OrganizationalUnit::getId).map(String::valueOf).orElse(""));
        params.put("positionOrganizationalUnitName", organizationalUnit.map(this::formatOrganizationalUnitNameAndSymbol).orElse(""));
        params.put("positionName", Optional.ofNullable(position.getPositionName()).map(String::trim).orElse(""));
        params.put("positionSymbol", Optional.ofNullable(position.getPositionSymbol()).map(String::trim).orElse(""));
        return params;
    }

    private String formatOrganizationalUnitNameAndSymbol(OrganizationalUnit organizationalUnit) {
        return organizationalUnit.getSymbol() + " - " + organizationalUnit.getName();
    }

    private String formatPositionNameAndSymbol(Position position) {
        return position.getSymbol() + " - " + position.getName();
    }

    @ExceptionHandler(value={PositionAlreadyExistException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequest(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={EmptyPropertyException.class})
    @ResponseStatus(value=HttpStatus.PARTIAL_CONTENT)
    @ResponseBody
    public RestResult handleEmptyPropertyException(EmptyPropertyException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={PositionNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handlePositionNotFoundException(PositionNotFoundException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"positionFinder", "structureService", "userService", "authorizationHelper", "exportService", "roleService", "messageHelper"})
    @Autowired
    public PositionController(PositionFinder positionFinder, StructureService structureService, UserService userService, AuthorizationHelper authorizationHelper, ExportService exportService, RoleService roleService, MessageHelperBean messageHelper) {
        this.positionFinder = positionFinder;
        this.structureService = structureService;
        this.userService = userService;
        this.authorizationHelper = authorizationHelper;
        this.exportService = exportService;
        this.roleService = roleService;
        this.messageHelper = messageHelper;
    }

    record PositionSearchFilters(String name, String symbol, String overName, String overSymbol, String orgName, String orgSymbol, Long role, String userName) {
    }
}

